/*
 * Decompiled with CFR 0.152.
 */
package akka.management.cluster.bootstrap;

import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.discovery.ServiceDiscovery;
import akka.management.cluster.bootstrap.ClusterBootstrapSettings;
import akka.management.cluster.bootstrap.JoinDecision;
import akka.management.cluster.bootstrap.JoinOtherSeedNodes;
import akka.management.cluster.bootstrap.JoinSelf$;
import akka.management.cluster.bootstrap.KeepProbing$;
import akka.management.cluster.bootstrap.SeedNodesInformation;
import akka.management.cluster.bootstrap.SeedNodesObservation;
import akka.management.cluster.bootstrap.SelfAwareJoinDecider;
import java.time.Duration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.GenTraversableOnce;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001-4A!\u0001\u0002\u0001\u0017\tABj\\<fgR\fE\r\u001a:fgNTu.\u001b8EK\u000eLG-\u001a:\u000b\u0005\r!\u0011!\u00032p_R\u001cHO]1q\u0015\t)a!A\u0004dYV\u001cH/\u001a:\u000b\u0005\u001dA\u0011AC7b]\u0006<W-\\3oi*\t\u0011\"\u0001\u0003bW.\f7\u0001A\n\u0003\u00011\u0001\"!\u0004\b\u000e\u0003\tI!a\u0004\u0002\u0003)M+GNZ!xCJ,'j\\5o\t\u0016\u001c\u0017\u000eZ3s\u0011!\t\u0002A!A!\u0002\u0013\u0011\u0012AB:zgR,W\u000e\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\u0011\u0005)\u0011m\u0019;pe&\u0011q\u0003\u0006\u0002\f\u0003\u000e$xN]*zgR,W\u000e\u0003\u0005\u001a\u0001\t\u0005\t\u0015!\u0003\u001b\u0003!\u0019X\r\u001e;j]\u001e\u001c\bCA\u0007\u001c\u0013\ta\"A\u0001\rDYV\u001cH/\u001a:C_>$8\u000f\u001e:baN+G\u000f^5oONDQA\b\u0001\u0005\u0002}\ta\u0001P5oSRtDc\u0001\u0011\"EA\u0011Q\u0002\u0001\u0005\u0006#u\u0001\rA\u0005\u0005\u00063u\u0001\rA\u0007\u0005\u0006I\u0001!\t%J\u0001\u0007I\u0016\u001c\u0017\u000eZ3\u0015\u0005\u0019\n\u0004cA\u0014-]5\t\u0001F\u0003\u0002*U\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0003-\nQa]2bY\u0006L!!\f\u0015\u0003\r\u0019+H/\u001e:f!\tiq&\u0003\u00021\u0005\ta!j\\5o\t\u0016\u001c\u0017n]5p]\")!g\ta\u0001g\u0005!\u0011N\u001c4p!\tiA'\u0003\u00026\u0005\t!2+Z3e\u001d>$Wm]%oM>\u0014X.\u0019;j_:DQa\u000e\u0001\u0005\u0012a\n!C[8j]>#\b.\u001a:TK\u0016$gj\u001c3fgR\u0011\u0011\b\u0012\t\u0004uy\neBA\u001e=\u001b\u0005Q\u0013BA\u001f+\u0003\u0019\u0001&/\u001a3fM&\u0011q\b\u0011\u0002\u0004'\u0016$(BA\u001f+!\t\u0019\")\u0003\u0002D)\t9\u0011\t\u001a3sKN\u001c\b\"\u0002\u001a7\u0001\u0004\u0019\u0004\"\u0002$\u0001\t#9\u0015A\u00065bg\u0016sw.^4i\u0007>tG/Y2u!>Lg\u000e^:\u0015\u0005![\u0005CA\u001eJ\u0013\tQ%FA\u0004C_>dW-\u00198\t\u000bI*\u0005\u0019A\u001a\t\u000b5\u0003A\u0011\u0003(\u0002%%\u001c\b+Y:u'R\f'\r\\3NCJ<\u0017N\u001c\u000b\u0003\u0011>CQA\r'A\u0002MBQ!\u0015\u0001\u0005\u0012I\u000bA'[:D_:4\u0017N]7fI\u000e{W.\\;oS\u000e\fG/[8o/&$\b.\u00117m\u0007>tG/Y2u!>Lg\u000e^:SKF,\u0018N]3e)\tA5\u000bC\u00033!\u0002\u00071\u0007C\u0003V\u0001\u0011Ea+A\rm_^,7\u000f^!eIJ,7o]\"p]R\f7\r\u001e)pS:$HCA,k!\rY\u0004LW\u0005\u00033*\u0012aa\u00149uS>t\u0007CA.h\u001d\taFM\u0004\u0002^E:\u0011a,Y\u0007\u0002?*\u0011\u0001MC\u0001\u0007yI|w\u000e\u001e \n\u0003%I!a\u0019\u0005\u0002\u0013\u0011L7oY8wKJL\u0018BA3g\u0003A\u0019VM\u001d<jG\u0016$\u0015n]2pm\u0016\u0014\u0018P\u0003\u0002d\u0011%\u0011\u0001.\u001b\u0002\u000f%\u0016\u001cx\u000e\u001c<fIR\u000b'oZ3u\u0015\t)g\rC\u00033)\u0002\u00071\u0007")
public class LowestAddressJoinDecider
extends SelfAwareJoinDecider {
    private final ClusterBootstrapSettings settings;

    @Override
    public Future<JoinDecision> decide(SeedNodesInformation info) {
        Future<JoinDecision> future;
        if (info.hasSeedNodes()) {
            Set<Address> seeds = this.joinOtherSeedNodes(info);
            future = seeds.isEmpty() ? KeepProbing$.MODULE$.asCompletedFuture() : new JoinOtherSeedNodes(seeds).asCompletedFuture();
        } else if (this.hasEnoughContactPoints(info)) {
            if (this.isPastStableMargin(info)) {
                Set contactPointsWithoutSeedNodesObservations;
                Set set = contactPointsWithoutSeedNodesObservations = this.isConfirmedCommunicationWithAllContactPointsRequired(info) ? (Set)info.contactPoints().$minus$minus((GenTraversableOnce)info.seedNodesObservations().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ServiceDiscovery.ResolvedTarget apply(SeedNodesObservation x$1) {
                        return x$1.contactPoint();
                    }
                }, Set$.MODULE$.canBuildFrom())) : Predef$.MODULE$.Set().empty();
                if (contactPointsWithoutSeedNodesObservations.isEmpty()) {
                    Option<ServiceDiscovery.ResolvedTarget> lowestAddress = this.lowestAddressContactPoint(info);
                    boolean isJoinSelfAble = lowestAddress.exists((Function1)new Serializable(this, info){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ LowestAddressJoinDecider $outer;
                        private final SeedNodesInformation info$1;

                        public final boolean apply(ServiceDiscovery.ResolvedTarget x$2) {
                            return this.$outer.canJoinSelf(x$2, this.info$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.info$1 = info$1;
                        }
                    });
                    if (isJoinSelfAble && this.settings.newClusterEnabled()) {
                        future = JoinSelf$.MODULE$.asCompletedFuture();
                    } else {
                        if (this.log().isInfoEnabled()) {
                            if (this.settings.newClusterEnabled()) {
                                this.log().info("Exceeded stable margins without locating seed-nodes, however this node {} is NOT the lowest address out of the discovered endpoints in this deployment, thus NOT joining self. Expecting node [{}] (out of [{}]) to perform the self-join and initiate the cluster.", (Object)this.contactPointString(this.selfContactPoint()), lowestAddress.getOrElse((Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "";
                                    }
                                }), (Object)info.contactPoints().mkString(", "));
                            } else {
                                this.log().warning("Exceeded stable margins without locating seed-nodes, however this node {} is configured with new-cluster-enabled=off, thus NOT joining self. Expecting existing cluster or node [{}] (out of [{}]) to perform the self-join and initiate the cluster.", (Object)this.contactPointString(this.selfContactPoint()), lowestAddress.getOrElse((Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "";
                                    }
                                }), (Object)info.contactPoints().mkString(", "));
                            }
                        }
                        future = KeepProbing$.MODULE$.asCompletedFuture();
                    }
                } else {
                    if (this.log().isInfoEnabled()) {
                        this.log().info("Exceeded stable margins but missing seed node information from some contact points [{}] (out of [{}])", (Object)contactPointsWithoutSeedNodesObservations.mkString(", "), (Object)info.contactPoints().mkString(", "));
                    }
                    future = KeepProbing$.MODULE$.asCompletedFuture();
                }
            } else {
                this.log().debug("Contact points observations have changed more recently than the stable-margin [{}], changed at [{}], not joining myself. This process will be retried.", (Object)this.settings.contactPointDiscovery().stableMargin(), (Object)info.contactPointsChangedAt());
                future = KeepProbing$.MODULE$.asCompletedFuture();
            }
        } else {
            this.log().info("Discovered [{}] contact points, confirmed [{}], which is less than the required [{}], retrying", (Object)BoxesRunTime.boxToInteger((int)info.contactPoints().size()), (Object)BoxesRunTime.boxToInteger((int)info.seedNodesObservations().size()), (Object)BoxesRunTime.boxToInteger((int)this.settings.contactPointDiscovery().requiredContactPointsNr()));
            future = KeepProbing$.MODULE$.asCompletedFuture();
        }
        return future;
    }

    public Set<Address> joinOtherSeedNodes(SeedNodesInformation info) {
        return (Set)info.allSeedNodes().take(5);
    }

    public boolean hasEnoughContactPoints(SeedNodesInformation info) {
        return info.seedNodesObservations().size() >= this.settings.contactPointDiscovery().requiredContactPointsNr();
    }

    public boolean isPastStableMargin(SeedNodesInformation info) {
        Duration contactPointsChanged = Duration.between(info.contactPointsChangedAt(), info.currentTime());
        return contactPointsChanged.toMillis() >= this.settings.contactPointDiscovery().stableMargin().toMillis();
    }

    public boolean isConfirmedCommunicationWithAllContactPointsRequired(SeedNodesInformation info) {
        return true;
    }

    public Option<ServiceDiscovery.ResolvedTarget> lowestAddressContactPoint(SeedNodesInformation info) {
        return ((TraversableLike)((SeqLike)info.seedNodesObservations().toList().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ServiceDiscovery.ResolvedTarget apply(SeedNodesObservation x$3) {
                return x$3.contactPoint();
            }
        }, List$.MODULE$.canBuildFrom())).sorted(ServiceDiscovery.ResolvedTarget$.MODULE$.addressOrdering())).headOption();
    }

    public LowestAddressJoinDecider(ActorSystem system, ClusterBootstrapSettings settings) {
        this.settings = settings;
        super(system, settings);
    }
}

