/*
 * Decompiled with CFR 0.152.
 */
package akka.management.cluster.bootstrap;

import akka.AkkaVersion$;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.actor.Props;
import akka.actor.ScalaActorRef;
import akka.actor.package$;
import akka.annotation.InternalApi;
import akka.cluster.Cluster;
import akka.cluster.Cluster$;
import akka.discovery.Discovery$;
import akka.discovery.ServiceDiscovery;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.http.scaladsl.model.Uri;
import akka.http.scaladsl.server.RequestContext;
import akka.http.scaladsl.server.RouteResult;
import akka.management.cluster.bootstrap.ClusterBootstrap;
import akka.management.cluster.bootstrap.ClusterBootstrap$;
import akka.management.cluster.bootstrap.ClusterBootstrap$Internal$Initializing$;
import akka.management.cluster.bootstrap.ClusterBootstrap$Internal$NotRunning$;
import akka.management.cluster.bootstrap.ClusterBootstrapSettings;
import akka.management.cluster.bootstrap.ClusterBootstrapSettings$;
import akka.management.cluster.bootstrap.JoinDecider;
import akka.management.cluster.bootstrap.contactpoint.HttpClusterBootstrapRoutes;
import akka.management.cluster.bootstrap.internal.BootstrapCoordinator$;
import akka.management.cluster.bootstrap.internal.BootstrapCoordinator$Protocol$InitiateBootstrapping$;
import akka.management.scaladsl.ManagementRouteProvider;
import akka.management.scaladsl.ManagementRouteProviderSettings;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function1;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\rd\u0001\u0002\u001a4\u0005qB\u0001b\u0014\u0001\u0003\u0002\u0003\u0006Y\u0001\u0015\u0005\u0006'\u0002!\t\u0001\u0016\u0005\b3\u0002\u0011\r\u0011\"\u0003[\u0011\u0019\t\u0007\u0001)A\u00057\"9!\r\u0001b\u0001\n\u001b\u0019\u0007bBAS\u0001\u0001\u0006i\u0001\u001a\u0005\n\u0003O\u0003!\u0019!C\u0001\u0003SC\u0001\"!-\u0001A\u0003%\u00111\u0016\u0005\n\u0003g\u0003!\u0019!C\u0001\u0003kC\u0001\"!1\u0001A\u0003%\u0011q\u0017\u0005\n\u0003\u0007\u0004!\u0019!C\u0005\u0003\u000bD\u0001\"!4\u0001A\u0003%\u0011q\u0019\u0005\t\u0003\u001f\u0004\u0001\u0015!\u0003\u0002R\"9\u0011Q\u001e\u0001\u0005B\u0005=\bb\u0002B\u0012\u0001\u0011\u0005!Q\u0005\u0005\t\u0005[\u0001A\u0011A\u001d\u00030!A!1\t\u0001\u0005\u0002e\u0012)eB\u0003tg!\u0005AOB\u00033g!\u0005Q\u000fC\u0003T'\u0011\u0005A\u0010C\u0003~'\u0011\u0005c\u0010\u0003\u0004\u0000'\u0011\u0005\u0013\u0011\u0001\u0005\b\u0003\u0017\u0019B\u0011IA\u0007\u000f!\t\tb\u0005E\u0001g\u0005Ma\u0001CA\f'!\u00051'!\u0007\t\rMKB\u0011AA\u000e\r%\ti\"\u0007I\u0001$C\tybB\u0004\u0002\"fA\t)a&\u0007\u000f\u0005E\u0015\u0004#!\u0002\u0014\"11+\bC\u0001\u0003+C\u0011\"a\u000f\u001e\u0003\u0003%\t%!\u0010\t\u0013\u0005-S$!A\u0005\u0002\u00055\u0003\"CA+;\u0005\u0005I\u0011AAM\u0011%\t\u0019'HA\u0001\n\u0003\n)\u0007C\u0005\u0002tu\t\t\u0011\"\u0001\u0002\u001e\"I\u0011qP\u000f\u0002\u0002\u0013\u0005\u0013\u0011\u0011\u0005\n\u0003\u0007k\u0012\u0011!C!\u0003\u000bC\u0011\"a\"\u001e\u0003\u0003%I!!#\b\u000f\u0005\r\u0016\u0004#!\u0002:\u00199\u00111E\r\t\u0002\u0006\u0015\u0002BB*)\t\u0003\t9\u0004C\u0005\u0002<!\n\t\u0011\"\u0011\u0002>!I\u00111\n\u0015\u0002\u0002\u0013\u0005\u0011Q\n\u0005\n\u0003+B\u0013\u0011!C\u0001\u0003/B\u0011\"a\u0019)\u0003\u0003%\t%!\u001a\t\u0013\u0005M\u0004&!A\u0005\u0002\u0005U\u0004\"CA@Q\u0005\u0005I\u0011IAA\u0011%\t\u0019\tKA\u0001\n\u0003\n)\tC\u0005\u0002\b\"\n\t\u0011\"\u0003\u0002\n\n\u00012\t\\;ti\u0016\u0014(i\\8ugR\u0014\u0018\r\u001d\u0006\u0003iU\n\u0011BY8piN$(/\u00199\u000b\u0005Y:\u0014aB2mkN$XM\u001d\u0006\u0003qe\n!\"\\1oC\u001e,W.\u001a8u\u0015\u0005Q\u0014\u0001B1lW\u0006\u001c\u0001a\u0005\u0003\u0001{\rK\u0005C\u0001 B\u001b\u0005y$\"\u0001!\u0002\u000bM\u001c\u0017\r\\1\n\u0005\t{$AB!osJ+g\r\u0005\u0002E\u000f6\tQI\u0003\u0002Gs\u0005)\u0011m\u0019;pe&\u0011\u0001*\u0012\u0002\n\u000bb$XM\\:j_:\u0004\"AS'\u000e\u0003-S!\u0001T\u001c\u0002\u0011M\u001c\u0017\r\\1eg2L!AT&\u0003/5\u000bg.Y4f[\u0016tGOU8vi\u0016\u0004&o\u001c<jI\u0016\u0014\u0018AB:zgR,W\u000e\u0005\u0002E#&\u0011!+\u0012\u0002\u0014\u000bb$XM\u001c3fI\u0006\u001bGo\u001c:TsN$X-\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U#\"A\u0016-\u0011\u0005]\u0003Q\"A\u001a\t\u000b=\u0013\u00019\u0001)\u0002\u00071|w-F\u0001\\!\tav,D\u0001^\u0015\tq\u0016(A\u0003fm\u0016tG/\u0003\u0002a;\nqAj\\4hS:<\u0017\tZ1qi\u0016\u0014\u0018\u0001\u00027pO\u0002\nQBY8piN$(/\u00199Ti\u0016\u0004X#\u00013\u0011\u0007\u0015t\u0007/D\u0001g\u0015\t9\u0007.\u0001\u0004bi>l\u0017n\u0019\u0006\u0003S*\f!bY8oGV\u0014(/\u001a8u\u0015\tYG.\u0001\u0003vi&d'\"A7\u0002\t)\fg/Y\u0005\u0003_\u001a\u0014q\"\u0011;p[&\u001c'+\u001a4fe\u0016t7-\u001a\t\u0003cnq!A\u001d\r\u000f\u0005]\u0013\u0012\u0001E\"mkN$XM\u001d\"p_R\u001cHO]1q!\t96c\u0005\u0003\u0014{YL\bc\u0001#x-&\u0011\u00010\u0012\u0002\f\u000bb$XM\\:j_:LE\r\u0005\u0002Eu&\u001110\u0012\u0002\u0014\u000bb$XM\\:j_:LE\r\u0015:pm&$WM\u001d\u000b\u0002i\u00061An\\8lkB$\u0012A]\u0001\u0004O\u0016$Hc\u0001,\u0002\u0004!1qJ\u0006a\u0001\u0003\u000b\u00012\u0001RA\u0004\u0013\r\tI!\u0012\u0002\f\u0003\u000e$xN]*zgR,W.A\bde\u0016\fG/Z#yi\u0016t7/[8o)\r1\u0016q\u0002\u0005\u0006\u001f^\u0001\r\u0001U\u0001\t\u0013:$XM\u001d8bYB\u0019\u0011QC\r\u000e\u0003M\u0011\u0001\"\u00138uKJt\u0017\r\\\n\u00033u\"\"!a\u0005\u0003\u001b\t{w\u000e^:ue\u0006\u00048\u000b^3q'\tYR(K\u0002\u001cQu\u0011A\"\u00138ji&\fG.\u001b>j]\u001e\u001c\u0002\u0002K\u001f\u0002(\u0005-\u0012\u0011\u0007\t\u0004\u0003SYR\"A\r\u0011\u0007y\ni#C\u0002\u00020}\u0012q\u0001\u0015:pIV\u001cG\u000fE\u0002?\u0003gI1!!\u000e@\u00051\u0019VM]5bY&T\u0018M\u00197f)\t\tI\u0004E\u0002\u0002*!\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA !\u0011\t\t%a\u0012\u000e\u0005\u0005\r#bAA#Y\u0006!A.\u00198h\u0013\u0011\tI%a\u0011\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ty\u0005E\u0002?\u0003#J1!a\u0015@\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tI&a\u0018\u0011\u0007y\nY&C\u0002\u0002^}\u00121!\u00118z\u0011%\t\t\u0007LA\u0001\u0002\u0004\ty%A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003O\u0002b!!\u001b\u0002p\u0005eSBAA6\u0015\r\tigP\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA9\u0003W\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011qOA?!\rq\u0014\u0011P\u0005\u0004\u0003wz$a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003Cr\u0013\u0011!a\u0001\u00033\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003\u001f\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u007f\t1B]3bIJ+7o\u001c7wKR\u0011\u00111\u0012\t\u0005\u0003\u0003\ni)\u0003\u0003\u0002\u0010\u0006\r#AB(cU\u0016\u001cGO\u0001\u0006O_R\u0014VO\u001c8j]\u001e\u001c\u0002\"H\u001f\u0002(\u0005-\u0012\u0011\u0007\u000b\u0003\u0003/\u00032!!\u000b\u001e)\u0011\tI&a'\t\u0013\u0005\u0005\u0014%!AA\u0002\u0005=C\u0003BA<\u0003?C\u0011\"!\u0019$\u0003\u0003\u0005\r!!\u0017\u0002\u00159{GOU;o]&tw-\u0001\u0007J]&$\u0018.\u00197ju&tw-\u0001\bc_>$8\u000f\u001e:baN#X\r\u001d\u0011\u0002\u0011M,G\u000f^5oON,\"!a+\u0011\u0007]\u000bi+C\u0002\u00020N\u0012\u0001d\u00117vgR,'OQ8piN$(/\u00199TKR$\u0018N\\4t\u0003%\u0019X\r\u001e;j]\u001e\u001c\b%A\u0005eSN\u001cwN^3ssV\u0011\u0011q\u0017\t\u0005\u0003s\u000bi,\u0004\u0002\u0002<*\u0019\u00111W\u001d\n\t\u0005}\u00161\u0018\u0002\u0011'\u0016\u0014h/[2f\t&\u001c8m\u001c<fef\f!\u0002Z5tG>4XM]=!\u0003-Qw.\u001b8EK\u000eLG-\u001a:\u0016\u0005\u0005\u001d\u0007cA,\u0002J&\u0019\u00111Z\u001a\u0003\u0017){\u0017N\u001c#fG&$WM]\u0001\rU>Lg\u000eR3dS\u0012,'\u000fI\u0001\u0015?N,GNZ\"p]R\f7\r\u001e)pS:$XK]5\u0011\r\u0005M\u0017q[An\u001b\t\t)N\u0003\u0002j\u007f%!\u0011\u0011\\Ak\u0005\u001d\u0001&o\\7jg\u0016\u0004B!!8\u0002j6\u0011\u0011q\u001c\u0006\u0005\u0003C\f\u0019/A\u0003n_\u0012,GNC\u0002M\u0003KT1!a::\u0003\u0011AG\u000f\u001e9\n\t\u0005-\u0018q\u001c\u0002\u0004+JL\u0017A\u0002:pkR,7\u000f\u0006\u0003\u0002r\ne\u0001\u0003BAz\u0005'qA!!>\u0003\u000e9!\u0011q\u001fB\u0005\u001d\u0011\tIPa\u0002\u000f\t\u0005m(Q\u0001\b\u0005\u0003{\u0014\u0019!\u0004\u0002\u0002\u0000*\u0019!\u0011A\u001e\u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0014bAAts%\u0019A*!:\n\t\t-\u00111]\u0001\u0007g\u0016\u0014h/\u001a:\n\t\t=!\u0011C\u0001\ba\u0006\u001c7.Y4f\u0015\u0011\u0011Y!a9\n\t\tU!q\u0003\u0002\u0006%>,H/\u001a\u0006\u0005\u0005\u001f\u0011\t\u0002C\u0004\u0003\u001c9\u0001\rA!\b\u0002+I|W\u000f^3Qe>4\u0018\u000eZ3s'\u0016$H/\u001b8hgB\u0019!Ja\b\n\u0007\t\u00052JA\u0010NC:\fw-Z7f]R\u0014v.\u001e;f!J|g/\u001b3feN+G\u000f^5oON\fQa\u001d;beR$\"Aa\n\u0011\u0007y\u0012I#C\u0002\u0003,}\u0012A!\u00168ji\u0006\u00192/\u001a;TK247i\u001c8uC\u000e$\bk\\5oiR!!q\u0005B\u0019\u0011\u001d\u0011\u0019\u0004\u0005a\u0001\u00037\fqAY1tKV\u0013\u0018\u000eK\u0002\u0011\u0005o\u0001BA!\u000f\u0003@5\u0011!1\b\u0006\u0004\u0005{I\u0014AC1o]>$\u0018\r^5p]&!!\u0011\tB\u001e\u0005-Ie\u000e^3s]\u0006d\u0017\t]5\u0002!M,GNZ\"p]R\f7\r\u001e)pS:$XC\u0001B$!\u0019\t\u0019N!\u0013\u0003N%!!1JAk\u0005\u00191U\u000f^;sKB9aHa\u0014\u0003T\u0005=\u0013b\u0001B)\u007f\t1A+\u001e9mKJ\u0002BA!\u0016\u0003^9!!q\u000bB-!\r\tipP\u0005\u0004\u00057z\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002J\t}#b\u0001B.\u007f!\u001a\u0011Ca\u000e")
public final class ClusterBootstrap
implements ManagementRouteProvider {
    private final ExtendedActorSystem system;
    private final LoggingAdapter log;
    private final AtomicReference<Internal.BootstrapStep> bootstrapStep;
    private final ClusterBootstrapSettings settings;
    private final ServiceDiscovery discovery;
    private final JoinDecider joinDecider;
    private final Promise<Uri> _selfContactPointUri;

    public static ClusterBootstrap createExtension(ExtendedActorSystem extendedActorSystem) {
        return ClusterBootstrap$.MODULE$.createExtension(extendedActorSystem);
    }

    public static ClusterBootstrap get(ActorSystem actorSystem) {
        return ClusterBootstrap$.MODULE$.get(actorSystem);
    }

    public static ClusterBootstrap$ lookup() {
        return ClusterBootstrap$.MODULE$.lookup();
    }

    public static Extension apply(ActorSystem actorSystem) {
        return ClusterBootstrap$.MODULE$.apply(actorSystem);
    }

    private LoggingAdapter log() {
        return this.log;
    }

    private final AtomicReference<Internal.BootstrapStep> bootstrapStep() {
        return this.bootstrapStep;
    }

    public ClusterBootstrapSettings settings() {
        return this.settings;
    }

    public ServiceDiscovery discovery() {
        return this.discovery;
    }

    private JoinDecider joinDecider() {
        return this.joinDecider;
    }

    public Function1<RequestContext, Future<RouteResult>> routes(ManagementRouteProviderSettings routeProviderSettings) {
        this.log().info(new StringBuilder(34).append("Using self contact point address: ").append(routeProviderSettings.selfBaseUri()).toString());
        this.setSelfContactPoint(routeProviderSettings.selfBaseUri());
        return new HttpClusterBootstrapRoutes(this.settings()).routes();
    }

    public void start() {
        if (((Cluster)Cluster$.MODULE$.apply((ActorSystem)this.system)).settings().SeedNodes().nonEmpty()) {
            this.log().warning("Application is configured with specific `akka.cluster.seed-nodes`: {}, bailing out of the bootstrap process! If you want to use the automatic bootstrap mechanism, make sure to NOT set explicit seed nodes in the configuration. This node will attempt to join the configured seed nodes.", (Object)((Cluster)Cluster$.MODULE$.apply((ActorSystem)this.system)).settings().SeedNodes().mkString("[", ", ", "]"));
        } else if (this.bootstrapStep().compareAndSet(ClusterBootstrap$Internal$NotRunning$.MODULE$, ClusterBootstrap$Internal$Initializing$.MODULE$)) {
            this.log().info("Initiating bootstrap procedure using {} method...", (Object)this.settings().contactPointDiscovery().discoveryMethod());
            Props bootstrapProps = BootstrapCoordinator$.MODULE$.props(this.discovery(), this.joinDecider(), this.settings());
            ActorRef bootstrap = this.system.systemActorOf(bootstrapProps, "bootstrapCoordinator");
            ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(bootstrap);
            BootstrapCoordinator$Protocol$InitiateBootstrapping$ x$1 = BootstrapCoordinator$Protocol$InitiateBootstrapping$.MODULE$;
            ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
            qual$1.$bang((Object)x$1, x$2);
        } else {
            this.log().warning("Bootstrap already initiated, yet start() method was called again. Ignoring.");
        }
    }

    @InternalApi
    public void setSelfContactPoint(Uri baseUri) {
        this._selfContactPointUri.success((Object)baseUri);
    }

    @InternalApi
    public Future<Tuple2<String, Object>> selfContactPoint() {
        return this._selfContactPointUri.future().map((Function1 & Serializable & scala.Serializable)uri -> new Tuple2((Object)uri.authority().host().toString(), (Object)BoxesRunTime.boxToInteger((int)uri.authority().port())), (ExecutionContext)this.system.dispatcher());
    }

    public ClusterBootstrap(ExtendedActorSystem system) {
        ServiceDiscovery serviceDiscovery;
        this.system = system;
        this.log = Logging$.MODULE$.apply((ActorSystem)system, ClusterBootstrap.class, LogSource$.MODULE$.fromAnyClass());
        this.bootstrapStep = new AtomicReference<ClusterBootstrap$Internal$NotRunning$>(ClusterBootstrap$Internal$NotRunning$.MODULE$);
        AkkaVersion$.MODULE$.require("cluster-bootstrap", "2.5.19");
        this.settings = ClusterBootstrapSettings$.MODULE$.apply(system.settings().config(), this.log());
        String string = this.settings().contactPointDiscovery().discoveryMethod();
        if ("akka.discovery".equals(string)) {
            ServiceDiscovery discovery = Discovery$.MODULE$.apply((ActorSystem)system).discovery();
            this.log().info("Bootstrap using default `akka.discovery` method: {}", (Object)Logging$.MODULE$.simpleName((Object)discovery));
            serviceDiscovery = discovery;
        } else {
            this.log().info("Bootstrap using `akka.discovery` method: {}", (Object)string);
            serviceDiscovery = Discovery$.MODULE$.apply((ActorSystem)system).loadServiceDiscovery(string);
        }
        this.discovery = serviceDiscovery;
        this.joinDecider = (JoinDecider)system.dynamicAccess().createInstanceFor(this.settings().joinDecider().implClass(), (Seq)new .colon.colon((Object)new Tuple2(ActorSystem.class, (Object)system), (List)new .colon.colon((Object)new Tuple2(ClusterBootstrapSettings.class, (Object)this.settings()), (List)Nil$.MODULE$)), ClassTag$.MODULE$.apply(JoinDecider.class)).get();
        this._selfContactPointUri = Promise$.MODULE$.apply();
    }
}

