/*
 * Decompiled with CFR 0.152.
 */
package akka.management.cluster.bootstrap;

import akka.actor.ActorSystem;
import akka.annotation.InternalApi;
import akka.discovery.ServiceDiscovery;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.management.cluster.bootstrap.ClusterBootstrap;
import akka.management.cluster.bootstrap.ClusterBootstrap$;
import akka.management.cluster.bootstrap.ClusterBootstrapSettings;
import akka.management.cluster.bootstrap.JoinDecider;
import akka.management.cluster.bootstrap.SeedNodesInformation;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.concurrent.Await$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001e4aa\u0003\u0007\u0002\u00021!\u0002\u0002C\u0010\u0001\u0005\u0003\u0005\u000b\u0011B\u0011\t\u0011\u001d\u0002!\u0011!Q\u0001\n!BQa\u000b\u0001\u0005\u00021Bq\u0001\r\u0001C\u0002\u0013E\u0011\u0007\u0003\u00049\u0001\u0001\u0006IA\r\u0005\u0006s\u0001!\tB\u000f\u0005\u0007\u001d\u0002!\t\u0001D(\t\rA\u0003A\u0011\u0001\u0007R\u0011\u0019I\u0007\u0001\"\u0001\rU\")Q\u000e\u0001C\t]\n!2+\u001a7g\u0003^\f'/\u001a&pS:$UmY5eKJT!!\u0004\b\u0002\u0013\t|w\u000e^:ue\u0006\u0004(BA\b\u0011\u0003\u001d\u0019G.^:uKJT!!\u0005\n\u0002\u00155\fg.Y4f[\u0016tGOC\u0001\u0014\u0003\u0011\t7n[1\u0014\u0007\u0001)2\u0004\u0005\u0002\u001735\tqCC\u0001\u0019\u0003\u0015\u00198-\u00197b\u0013\tQrC\u0001\u0004B]f\u0014VM\u001a\t\u00039ui\u0011\u0001D\u0005\u0003=1\u00111BS8j]\u0012+7-\u001b3fe\u000611/_:uK6\u001c\u0001\u0001\u0005\u0002#K5\t1E\u0003\u0002%%\u0005)\u0011m\u0019;pe&\u0011ae\t\u0002\f\u0003\u000e$xN]*zgR,W.\u0001\u0005tKR$\u0018N\\4t!\ta\u0012&\u0003\u0002+\u0019\tA2\t\\;ti\u0016\u0014(i\\8ugR\u0014\u0018\r]*fiRLgnZ:\u0002\rqJg.\u001b;?)\ricf\f\t\u00039\u0001AQaH\u0002A\u0002\u0005BQaJ\u0002A\u0002!\n1\u0001\\8h+\u0005\u0011\u0004CA\u001a7\u001b\u0005!$BA\u001b\u0013\u0003\u0015)g/\u001a8u\u0013\t9DG\u0001\bM_\u001e<\u0017N\\4BI\u0006\u0004H/\u001a:\u0002\t1|w\rI\u0001\u0013G>tG/Y2u!>Lg\u000e^*ue&tw\r\u0006\u0002<\rB\u0011Ah\u0011\b\u0003{\u0005\u0003\"AP\f\u000e\u0003}R!\u0001\u0011\u0011\u0002\rq\u0012xn\u001c;?\u0013\t\u0011u#\u0001\u0004Qe\u0016$WMZ\u0005\u0003\t\u0016\u0013aa\u0015;sS:<'B\u0001\"\u0018\u0011\u00159e\u00011\u0001I\u00031\u0019wN\u001c;bGR\u0004v.\u001b8u!\u00111\u0012jO&\n\u0005);\"A\u0002+va2,'\u0007\u0005\u0002\u0017\u0019&\u0011Qj\u0006\u0002\u0004\u0013:$\u0018\u0001E:fY\u001a\u001cuN\u001c;bGR\u0004v.\u001b8u+\u0005A\u0015aC2b]*{\u0017N\\*fY\u001a$2AU+e!\t12+\u0003\u0002U/\t9!i\\8mK\u0006t\u0007\"\u0002,\t\u0001\u00049\u0016A\u0002;be\u001e,G\u000f\u0005\u0002YC:\u0011\u0011L\u0018\b\u00035rs!AP.\n\u0003MI!!\u0018\n\u0002\u0013\u0011L7oY8wKJL\u0018BA0a\u0003A\u0019VM\u001d<jG\u0016$\u0015n]2pm\u0016\u0014\u0018P\u0003\u0002^%%\u0011!m\u0019\u0002\u000f%\u0016\u001cx\u000e\u001c<fIR\u000b'oZ3u\u0015\ty\u0006\rC\u0003f\u0011\u0001\u0007a-\u0001\u0003j]\u001a|\u0007C\u0001\u000fh\u0013\tAGB\u0001\u000bTK\u0016$gj\u001c3fg&sgm\u001c:nCRLwN\\\u0001\f[\u0006$8\r[3t'\u0016dg\rF\u0002SW2DQAV\u0005A\u0002]CQaR\u0005A\u0002!\u000b1\u0002[8ti6\u000bGo\u00195fgR\u0019!k\\9\t\u000bAT\u0001\u0019A\u001e\u0002\t!|7\u000f\u001e\u0005\u0006-*\u0001\ra\u0016\u0015\u0003\u0001M\u0004\"\u0001^<\u000e\u0003UT!A\u001e\n\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002yk\nY\u0011J\u001c;fe:\fG.\u00119j\u0001")
@InternalApi
public abstract class SelfAwareJoinDecider
implements JoinDecider {
    private final ActorSystem system;
    private final LoggingAdapter log;

    public LoggingAdapter log() {
        return this.log;
    }

    public String contactPointString(Tuple2<String, Object> contactPoint) {
        return contactPoint.productIterator().mkString(":");
    }

    public Tuple2<String, Object> selfContactPoint() {
        return (Tuple2)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Tuple2)Await$.MODULE$.result(((ClusterBootstrap)ClusterBootstrap$.MODULE$.apply($this.system)).selfContactPoint(), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException("'Bootstrap.selfContactPoint' was NOT set, but is required for the bootstrap to work if binding bootstrap routes manually and not via akka-management.");
        });
    }

    public boolean canJoinSelf(ServiceDiscovery.ResolvedTarget target, SeedNodesInformation info) {
        boolean bl;
        Tuple2<String, Object> self = this.selfContactPoint();
        if (this.matchesSelf(target, self)) {
            bl = true;
        } else {
            if (!info.contactPoints().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)this.matchesSelf(x$1, (Tuple2<String, Object>)self)))) {
                this.log().warning("Self contact point [{}] not found in targets {}", (Object)this.contactPointString(this.selfContactPoint()), (Object)info.contactPoints().mkString(", "));
            }
            bl = false;
        }
        return bl;
    }

    public boolean matchesSelf(ServiceDiscovery.ResolvedTarget target, Tuple2<String, Object> contactPoint) {
        boolean bl;
        Tuple2<String, Object> tuple2 = contactPoint;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String host = (String)tuple2._1();
        int port = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)host, (Object)BoxesRunTime.boxToInteger((int)port));
        Tuple2 tuple23 = tuple22;
        String host2 = (String)tuple23._1();
        int port2 = tuple23._2$mcI$sp();
        Option option = target.port();
        if (None$.MODULE$.equals(option)) {
            bl = this.hostMatches(host2, target);
        } else if (option instanceof Some) {
            Some some = (Some)option;
            int lowestPort = BoxesRunTime.unboxToInt((Object)some.value());
            bl = this.hostMatches(host2, target) && port2 == lowestPort;
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public boolean hostMatches(String host, ServiceDiscovery.ResolvedTarget target) {
        String string = host;
        String string2 = target.host();
        return !(string == null ? string2 != null : !string.equals(string2)) || target.address().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getHostAddress()).contains((Object)host);
    }

    public SelfAwareJoinDecider(ActorSystem system, ClusterBootstrapSettings settings) {
        this.system = system;
        this.log = Logging$.MODULE$.apply(system, this.getClass(), LogSource$.MODULE$.fromAnyClass());
    }
}

