/*
 * Decompiled with CFR 0.152.
 */
package akka.management.cluster.bootstrap;

import akka.AkkaVersion$;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.actor.Props;
import akka.actor.ScalaActorRef;
import akka.actor.package$;
import akka.annotation.InternalApi;
import akka.cluster.Cluster;
import akka.cluster.Cluster$;
import akka.discovery.Discovery$;
import akka.discovery.ServiceDiscovery;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.http.scaladsl.model.Uri;
import akka.http.scaladsl.server.RequestContext;
import akka.http.scaladsl.server.RouteResult;
import akka.management.cluster.bootstrap.ClusterBootstrap;
import akka.management.cluster.bootstrap.ClusterBootstrap$;
import akka.management.cluster.bootstrap.ClusterBootstrap$Internal$Initializing$;
import akka.management.cluster.bootstrap.ClusterBootstrap$Internal$NotRunning$;
import akka.management.cluster.bootstrap.ClusterBootstrapSettings;
import akka.management.cluster.bootstrap.ClusterBootstrapSettings$;
import akka.management.cluster.bootstrap.JoinDecider;
import akka.management.cluster.bootstrap.contactpoint.HttpClusterBootstrapRoutes;
import akka.management.cluster.bootstrap.internal.BootstrapCoordinator;
import akka.management.cluster.bootstrap.internal.BootstrapCoordinator$;
import akka.management.scaladsl.ManagementRouteProvider;
import akka.management.scaladsl.ManagementRouteProviderSettings;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function0;
import scala.Function1;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.package;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\tmc\u0001\u0002\u001a4\u0005qB\u0001b\u0014\u0001\u0003\u0002\u0003\u0006Y\u0001\u0015\u0005\u0006'\u0002!\t\u0001\u0016\u0005\b3\u0002\u0011\r\u0011\"\u0003[\u0011\u0019\t\u0007\u0001)A\u00057\"9!\r\u0001b\u0001\n\u001b\u0019\u0007bBA\\\u0001\u0001\u0006i\u0001\u001a\u0005\n\u0003s\u0003!\u0019!C\u0001\u0003wC\u0001\"a1\u0001A\u0003%\u0011Q\u0018\u0005\u000b\u0003\u000b\u0004\u0001R1A\u0005\u0002\u0005\u001d\u0007\"CAj\u0001\t\u0007I\u0011BAk\u0011!\ti\u000e\u0001Q\u0001\n\u0005]\u0007\u0002CAp\u0001\u0001\u0006I!!9\t\u000f\u0005u\b\u0001\"\u0011\u0002\u0000\"9!1\u0006\u0001\u0005\u0002\t5\u0002\u0002\u0003B\u001b\u0001\u0011\u00051G!\f\t\u0011\t\u0015\u0003\u0001\"\u0001:\u0005\u000fB\u0001Ba\u0014\u0001\t\u0003I$\u0011K\u0004\u0006gNB\t\u0001\u001e\u0004\u0006eMB\t!\u001e\u0005\u0006'N!\t\u0001 \u0005\u0006{N!\tE \u0005\u0007\u007fN!\t%!\u0001\t\u000f\u0005-1\u0003\"\u0011\u0002\u000e\u001dA\u0011\u0011C\n\t\u0002M\n\u0019B\u0002\u0005\u0002\u0018MA\taMA\r\u0011\u0019\u0019\u0016\u0004\"\u0001\u0002\u001c\u0019I\u0011QD\r\u0011\u0002G\u0005\u0012qD\u0004\b\u0003gK\u0002\u0012QAU\r\u001d\t\u0019+\u0007EA\u0003KCaaU\u000f\u0005\u0002\u0005\u001d\u0006\"CA';\u0005\u0005I\u0011IA(\u0011%\ti&HA\u0001\n\u0003\ty\u0006C\u0005\u0002hu\t\t\u0011\"\u0001\u0002,\"I\u0011QO\u000f\u0002\u0002\u0013\u0005\u0013q\u000f\u0005\n\u0003\u000bk\u0012\u0011!C\u0001\u0003_C\u0011\"!%\u001e\u0003\u0003%\t%a%\t\u0013\u0005UU$!A\u0005B\u0005]\u0005\"CAM;\u0005\u0005I\u0011BAN\u000f\u001d\t),\u0007EA\u0003\u00172q!a\t\u001a\u0011\u0003\u000b)\u0003\u0003\u0004TQ\u0011\u0005\u0011\u0011\n\u0005\n\u0003\u001bB\u0013\u0011!C!\u0003\u001fB\u0011\"!\u0018)\u0003\u0003%\t!a\u0018\t\u0013\u0005\u001d\u0004&!A\u0005\u0002\u0005%\u0004\"CA;Q\u0005\u0005I\u0011IA<\u0011%\t)\tKA\u0001\n\u0003\t9\tC\u0005\u0002\u0012\"\n\t\u0011\"\u0011\u0002\u0014\"I\u0011Q\u0013\u0015\u0002\u0002\u0013\u0005\u0013q\u0013\u0005\n\u00033C\u0013\u0011!C\u0005\u00037\u0013\u0001c\u00117vgR,'OQ8piN$(/\u00199\u000b\u0005Q*\u0014!\u00032p_R\u001cHO]1q\u0015\t1t'A\u0004dYV\u001cH/\u001a:\u000b\u0005aJ\u0014AC7b]\u0006<W-\\3oi*\t!(\u0001\u0003bW.\f7\u0001A\n\u0005\u0001u\u001a\u0015\n\u0005\u0002?\u00036\tqHC\u0001A\u0003\u0015\u00198-\u00197b\u0013\t\u0011uH\u0001\u0004B]f\u0014VM\u001a\t\u0003\t\u001ek\u0011!\u0012\u0006\u0003\rf\nQ!Y2u_JL!\u0001S#\u0003\u0013\u0015CH/\u001a8tS>t\u0007C\u0001&N\u001b\u0005Y%B\u0001'8\u0003!\u00198-\u00197bINd\u0017B\u0001(L\u0005]i\u0015M\\1hK6,g\u000e\u001e*pkR,\u0007K]8wS\u0012,'/\u0001\u0004tsN$X-\u001c\t\u0003\tFK!AU#\u0003'\u0015CH/\u001a8eK\u0012\f5\r^8s'f\u001cH/Z7\u0002\rqJg.\u001b;?)\u0005)FC\u0001,Y!\t9\u0006!D\u00014\u0011\u0015y%\u0001q\u0001Q\u0003\rawnZ\u000b\u00027B\u0011AlX\u0007\u0002;*\u0011a,O\u0001\u0006KZ,g\u000e^\u0005\u0003Av\u0013a\u0002T8hO&tw-\u00113baR,'/\u0001\u0003m_\u001e\u0004\u0013!\u00042p_R\u001cHO]1q'R,\u0007/F\u0001e!\r)g\u000e]\u0007\u0002M*\u0011q\r[\u0001\u0007CR|W.[2\u000b\u0005%T\u0017AC2p]\u000e,(O]3oi*\u00111\u000e\\\u0001\u0005kRLGNC\u0001n\u0003\u0011Q\u0017M^1\n\u0005=4'aD!u_6L7MU3gKJ,gnY3\u0011\u0005E\\bB\u0001:\u0019\u001d\t9&#\u0001\tDYV\u001cH/\u001a:C_>$8\u000f\u001e:baB\u0011qkE\n\u0005'u2\u0018\u0010E\u0002EoZK!\u0001_#\u0003\u0017\u0015CH/\u001a8tS>t\u0017\n\u001a\t\u0003\tjL!a_#\u0003'\u0015CH/\u001a8tS>t\u0017\n\u001a)s_ZLG-\u001a:\u0015\u0003Q\fa\u0001\\8pWV\u0004H#\u0001:\u0002\u0007\u001d,G\u000fF\u0002W\u0003\u0007Aaa\u0014\fA\u0002\u0005\u0015\u0001c\u0001#\u0002\b%\u0019\u0011\u0011B#\u0003\u0017\u0005\u001bGo\u001c:TsN$X-\\\u0001\u0010GJ,\u0017\r^3FqR,gn]5p]R\u0019a+a\u0004\t\u000b=;\u0002\u0019\u0001)\u0002\u0011%sG/\u001a:oC2\u00042!!\u0006\u001a\u001b\u0005\u0019\"\u0001C%oi\u0016\u0014h.\u00197\u0014\u0005eiDCAA\n\u00055\u0011un\u001c;tiJ\f\u0007o\u0015;faN\u00111$P\u0015\u00047!j\"\u0001D%oSRL\u0017\r\\5{S:<7\u0003\u0003\u0015>\u0003O\tY#!\r\u0011\u0007\u0005%2$D\u0001\u001a!\rq\u0014QF\u0005\u0004\u0003_y$a\u0002)s_\u0012,8\r\u001e\t\u0005\u0003g\t\u0019E\u0004\u0003\u00026\u0005}b\u0002BA\u001c\u0003{i!!!\u000f\u000b\u0007\u0005m2(\u0001\u0004=e>|GOP\u0005\u0002\u0001&\u0019\u0011\u0011I \u0002\u000fA\f7m[1hK&!\u0011QIA$\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\r\t\te\u0010\u000b\u0003\u0003\u0017\u00022!!\u000b)\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011\u0011\u000b\t\u0005\u0003'\nI&\u0004\u0002\u0002V)\u0019\u0011q\u000b7\u0002\t1\fgnZ\u0005\u0005\u00037\n)F\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003C\u00022APA2\u0013\r\t)g\u0010\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003W\n\t\bE\u0002?\u0003[J1!a\u001c@\u0005\r\te.\u001f\u0005\n\u0003gb\u0013\u0011!a\u0001\u0003C\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA=!\u0019\tY(!!\u0002l5\u0011\u0011Q\u0010\u0006\u0004\u0003\u007fz\u0014AC2pY2,7\r^5p]&!\u00111QA?\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005%\u0015q\u0012\t\u0004}\u0005-\u0015bAAG\u007f\t9!i\\8mK\u0006t\u0007\"CA:]\u0005\u0005\t\u0019AA6\u0003!A\u0017m\u001d5D_\u0012,GCAA1\u0003!!xn\u0015;sS:<GCAA)\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\ti\n\u0005\u0003\u0002T\u0005}\u0015\u0002BAQ\u0003+\u0012aa\u00142kK\u000e$(A\u0003(piJ+hN\\5oONAQ$PA\u0014\u0003W\t\t\u0004\u0006\u0002\u0002*B\u0019\u0011\u0011F\u000f\u0015\t\u0005-\u0014Q\u0016\u0005\n\u0003g\n\u0013\u0011!a\u0001\u0003C\"B!!#\u00022\"I\u00111O\u0012\u0002\u0002\u0003\u0007\u00111N\u0001\u000b\u001d>$(+\u001e8oS:<\u0017\u0001D%oSRL\u0017\r\\5{S:<\u0017A\u00042p_R\u001cHO]1q'R,\u0007\u000fI\u0001\tg\u0016$H/\u001b8hgV\u0011\u0011Q\u0018\t\u0004/\u0006}\u0016bAAag\tA2\t\\;ti\u0016\u0014(i\\8ugR\u0014\u0018\r]*fiRLgnZ:\u0002\u0013M,G\u000f^5oON\u0004\u0013!\u00033jg\u000e|g/\u001a:z+\t\tI\r\u0005\u0003\u0002L\u0006=WBAAg\u0015\r\t)-O\u0005\u0005\u0003#\fiM\u0001\tTKJ4\u0018nY3ESN\u001cwN^3ss\u0006Y!n\\5o\t\u0016\u001c\u0017\u000eZ3s+\t\t9\u000eE\u0002X\u00033L1!a74\u0005-Qu.\u001b8EK\u000eLG-\u001a:\u0002\u0019)|\u0017N\u001c#fG&$WM\u001d\u0011\u0002)}\u001bX\r\u001c4D_:$\u0018m\u0019;Q_&tG/\u0016:j!\u0019\t\u0019/a:\u0002l6\u0011\u0011Q\u001d\u0006\u0003S~JA!!;\u0002f\n9\u0001K]8nSN,\u0007\u0003BAw\u0003sl!!a<\u000b\t\u0005E\u00181_\u0001\u0006[>$W\r\u001c\u0006\u0004\u0019\u0006U(bAA|s\u0005!\u0001\u000e\u001e;q\u0013\u0011\tY0a<\u0003\u0007U\u0013\u0018.\u0001\u0004s_V$Xm\u001d\u000b\u0005\u0005\u0003\u0011\t\u0003\u0005\u0003\u0003\u0004\tma\u0002\u0002B\u0003\u0005/qAAa\u0002\u0003\u00149!!\u0011\u0002B\t\u001d\u0011\u0011YAa\u0004\u000f\t\u0005]\"QB\u0005\u0002u%\u0019\u0011q_\u001d\n\u00071\u000b)0\u0003\u0003\u0003\u0016\u0005M\u0018AB:feZ,'/\u0003\u0003\u0002B\te!\u0002\u0002B\u000b\u0003gLAA!\b\u0003 \t)!k\\;uK*!\u0011\u0011\tB\r\u0011\u001d\u0011\u0019#\u0004a\u0001\u0005K\tQC]8vi\u0016\u0004&o\u001c<jI\u0016\u00148+\u001a;uS:<7\u000fE\u0002K\u0005OI1A!\u000bL\u0005}i\u0015M\\1hK6,g\u000e\u001e*pkR,\u0007K]8wS\u0012,'oU3ui&twm]\u0001\u0006gR\f'\u000f\u001e\u000b\u0003\u0005_\u00012A\u0010B\u0019\u0013\r\u0011\u0019d\u0010\u0002\u0005+:LG/\u0001\ff]N,(/Z*fY\u001a\u001cuN\u001c;bGR\u0004v.\u001b8uQ\ry!\u0011\b\t\u0005\u0005w\u0011\t%\u0004\u0002\u0003>)\u0019!qH\u001d\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003D\tu\"aC%oi\u0016\u0014h.\u00197Ba&\f1c]3u'\u0016dgmQ8oi\u0006\u001cG\u000fU8j]R$BAa\f\u0003J!9!1\n\tA\u0002\u0005-\u0018a\u00022bg\u0016,&/\u001b\u0015\u0004!\te\u0012\u0001E:fY\u001a\u001cuN\u001c;bGR\u0004v.\u001b8u+\t\u0011\u0019\u0006\u0005\u0004\u0002d\nU\u00131^\u0005\u0005\u0005/\n)O\u0001\u0004GkR,(/\u001a\u0015\u0004#\te\u0002")
public final class ClusterBootstrap
implements ManagementRouteProvider {
    private ServiceDiscovery discovery;
    private final ExtendedActorSystem system;
    private final LoggingAdapter log;
    private final AtomicReference<Internal.BootstrapStep> bootstrapStep;
    private final ClusterBootstrapSettings settings;
    private final JoinDecider joinDecider;
    private final Promise<Uri> _selfContactPointUri;
    private volatile boolean bitmap$0;

    public static ClusterBootstrap createExtension(ExtendedActorSystem extendedActorSystem) {
        return ClusterBootstrap$.MODULE$.createExtension(extendedActorSystem);
    }

    public static ClusterBootstrap get(ActorSystem actorSystem) {
        return ClusterBootstrap$.MODULE$.get(actorSystem);
    }

    public static ClusterBootstrap$ lookup() {
        return ClusterBootstrap$.MODULE$.lookup();
    }

    public static Extension apply(ActorSystem actorSystem) {
        return ClusterBootstrap$.MODULE$.apply(actorSystem);
    }

    private LoggingAdapter log() {
        return this.log;
    }

    private final AtomicReference<Internal.BootstrapStep> bootstrapStep() {
        return this.bootstrapStep;
    }

    public ClusterBootstrapSettings settings() {
        return this.settings;
    }

    private ServiceDiscovery discovery$lzycompute() {
        ClusterBootstrap clusterBootstrap = this;
        synchronized (clusterBootstrap) {
            if (!this.bitmap$0) {
                ServiceDiscovery serviceDiscovery;
                String string = this.settings().contactPointDiscovery().discoveryMethod();
                if ("akka.discovery".equals(string)) {
                    ServiceDiscovery discovery = Discovery$.MODULE$.apply((ActorSystem)this.system).discovery();
                    this.log().info("Bootstrap using default `akka.discovery` method: {}", (Object)Logging$.MODULE$.simpleName((Object)discovery));
                    serviceDiscovery = discovery;
                } else {
                    this.log().info("Bootstrap using `akka.discovery` method: {}", (Object)string);
                    serviceDiscovery = Discovery$.MODULE$.apply((ActorSystem)this.system).loadServiceDiscovery(string);
                }
                this.discovery = serviceDiscovery;
                this.bitmap$0 = true;
            }
        }
        return this.discovery;
    }

    public ServiceDiscovery discovery() {
        return !this.bitmap$0 ? this.discovery$lzycompute() : this.discovery;
    }

    private JoinDecider joinDecider() {
        return this.joinDecider;
    }

    public Function1<RequestContext, Future<RouteResult>> routes(ManagementRouteProviderSettings routeProviderSettings) {
        this.log().info(new StringBuilder(34).append("Using self contact point address: ").append(routeProviderSettings.selfBaseUri()).toString());
        this.setSelfContactPoint(routeProviderSettings.selfBaseUri());
        return new HttpClusterBootstrapRoutes(this.settings()).routes();
    }

    public void start() {
        if (((Cluster)Cluster$.MODULE$.apply((ActorSystem)this.system)).settings().SeedNodes().nonEmpty()) {
            this.log().warning("Application is configured with specific `akka.cluster.seed-nodes`: {}, bailing out of the bootstrap process! If you want to use the automatic bootstrap mechanism, make sure to NOT set explicit seed nodes in the configuration. This node will attempt to join the configured seed nodes.", (Object)((Cluster)Cluster$.MODULE$.apply((ActorSystem)this.system)).settings().SeedNodes().mkString("[", ", ", "]"));
        } else if (this.bootstrapStep().compareAndSet(ClusterBootstrap$Internal$NotRunning$.MODULE$, ClusterBootstrap$Internal$Initializing$.MODULE$)) {
            this.log().info("Initiating bootstrap procedure using {} method...", (Object)this.settings().contactPointDiscovery().discoveryMethod());
            this.ensureSelfContactPoint();
            Props bootstrapProps = BootstrapCoordinator$.MODULE$.props(this.discovery(), this.joinDecider(), this.settings());
            ActorRef bootstrap = this.system.systemActorOf(bootstrapProps, "bootstrapCoordinator");
            this.selfContactPoint().foreach((Function1 & Serializable)uri -> {
                ClusterBootstrap.$anonfun$start$1(bootstrap, uri);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)this.system.dispatcher());
        } else {
            this.log().warning("Bootstrap already initiated, yet start() method was called again. Ignoring.");
        }
    }

    @InternalApi
    public void ensureSelfContactPoint() {
        this.system.scheduler().scheduleOnce(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds(), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            block0: {
                if (this.selfContactPoint().isCompleted()) break block0;
                $this._selfContactPointUri.failure((Throwable)new TimeoutException("Awaiting Bootstrap.selfContactPoint timed out."));
                this.log().error("'Bootstrap.selfContactPoint' was NOT set, but is required for the bootstrap to work if binding bootstrap routes manually and not via akka-management.");
            }
        }, (ExecutionContext)this.system.dispatcher());
    }

    @InternalApi
    public void setSelfContactPoint(Uri baseUri) {
        this._selfContactPointUri.success((Object)baseUri);
    }

    @InternalApi
    public Future<Uri> selfContactPoint() {
        return this._selfContactPointUri.future();
    }

    public static final /* synthetic */ void $anonfun$start$1(ActorRef bootstrap$1, Uri uri) {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(bootstrap$1);
        BootstrapCoordinator.Protocol.InitiateBootstrapping x$1 = new BootstrapCoordinator.Protocol.InitiateBootstrapping(uri);
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    public ClusterBootstrap(ExtendedActorSystem system) {
        this.system = system;
        this.log = Logging$.MODULE$.apply((ActorSystem)system, ClusterBootstrap.class, LogSource$.MODULE$.fromAnyClass());
        this.bootstrapStep = new AtomicReference<ClusterBootstrap$Internal$NotRunning$>(ClusterBootstrap$Internal$NotRunning$.MODULE$);
        AkkaVersion$.MODULE$.require("cluster-bootstrap", "2.5.27");
        this.settings = ClusterBootstrapSettings$.MODULE$.apply(system.settings().config(), this.log());
        this.joinDecider = (JoinDecider)system.dynamicAccess().createInstanceFor(this.settings().joinDecider().implClass(), (Seq)new .colon.colon((Object)new Tuple2(ActorSystem.class, (Object)system), (List)new .colon.colon((Object)new Tuple2(ClusterBootstrapSettings.class, (Object)this.settings()), (List)Nil$.MODULE$)), ClassTag$.MODULE$.apply(JoinDecider.class)).get();
        this._selfContactPointUri = Promise$.MODULE$.apply();
    }
}

