/*
 * Decompiled with CFR 0.152.
 */
package akka.management.cluster.bootstrap;

import akka.AkkaVersion$;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ClassicActorSystemProvider;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.actor.Props;
import akka.actor.ScalaActorRef;
import akka.actor.package$;
import akka.annotation.InternalApi;
import akka.cluster.Cluster;
import akka.cluster.Cluster$;
import akka.discovery.Discovery$;
import akka.discovery.ServiceDiscovery;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.http.scaladsl.model.Uri;
import akka.http.scaladsl.server.RequestContext;
import akka.http.scaladsl.server.RouteResult;
import akka.management.cluster.bootstrap.ClusterBootstrap;
import akka.management.cluster.bootstrap.ClusterBootstrap$;
import akka.management.cluster.bootstrap.ClusterBootstrap$Internal$Initializing$;
import akka.management.cluster.bootstrap.ClusterBootstrap$Internal$NotRunning$;
import akka.management.cluster.bootstrap.ClusterBootstrapSettings;
import akka.management.cluster.bootstrap.ClusterBootstrapSettings$;
import akka.management.cluster.bootstrap.JoinDecider;
import akka.management.cluster.bootstrap.contactpoint.HttpClusterBootstrapRoutes;
import akka.management.cluster.bootstrap.internal.BootstrapCoordinator;
import akka.management.cluster.bootstrap.internal.BootstrapCoordinator$;
import akka.management.scaladsl.ManagementRouteProvider;
import akka.management.scaladsl.ManagementRouteProviderSettings;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function0;
import scala.Function1;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.package;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t\u001dd\u0001B\u001a5\u0005uB\u0001\u0002\u0015\u0001\u0003\u0002\u0003\u0006Y!\u0015\u0005\u0006)\u0002!\t!\u0016\u0005\b5\u0002\u0011\r\u0011\"\u0003\\\u0011\u0019\u0011\u0007\u0001)A\u00059\"91\r\u0001b\u0001\n\u001b!\u0007bBAb\u0001\u0001\u0006i!\u001a\u0005\n\u0003\u000b\u0004!\u0019!C\u0001\u0003\u000fD\u0001\"a4\u0001A\u0003%\u0011\u0011\u001a\u0005\u000b\u0003#\u0004\u0001R1A\u0005\u0002\u0005M\u0007\"CAp\u0001\t\u0007I\u0011BAq\u0011!\tI\u000f\u0001Q\u0001\n\u0005\r\b\u0002CAv\u0001\u0001\u0006I!!<\t\u000f\t%\u0001\u0001\"\u0011\u0003\f!9!q\u0007\u0001\u0005\u0002\te\u0002\u0002\u0003B!\u0001\u0011\u0005AG!\u000f\t\u0011\tE\u0003\u0001\"\u0001;\u0005'B\u0001Ba\u0017\u0001\t\u0003Q$QL\u0004\u0006iRB\t!\u001e\u0004\u0006gQB\tA\u001e\u0005\u0006)N!\t! \u0005\u0006}N!\te \u0005\b\u0003\u0003\u0019B\u0011IA\u0002\u0011\u001d\t\ta\u0005C!\u0003\u001bAq!a\u0006\u0014\t\u0003\nIb\u0002\u0005\u0002\u001eMA\t\u0001NA\u0010\r!\t\u0019c\u0005E\u0001i\u0005\u0015\u0002B\u0002+\u001b\t\u0003\t9CB\u0005\u0002*i\u0001\n1%\t\u0002,\u001d9\u0011q\u0018\u000e\t\u0002\u0006UfaBAX5!\u0005\u0015\u0011\u0017\u0005\u0007)z!\t!a-\t\u0013\u0005ec$!A\u0005B\u0005m\u0003\"CA5=\u0005\u0005I\u0011AA6\u0011%\t\u0019HHA\u0001\n\u0003\t9\fC\u0005\u0002\u0002z\t\t\u0011\"\u0011\u0002\u0004\"I\u0011\u0011\u0013\u0010\u0002\u0002\u0013\u0005\u00111\u0018\u0005\n\u0003;s\u0012\u0011!C!\u0003?C\u0011\"!)\u001f\u0003\u0003%\t%a)\t\u0013\u0005\u0015f$!A\u0005\n\u0005\u001dvaBAa5!\u0005\u0015q\u000b\u0004\b\u0003_Q\u0002\u0012QA\u0019\u0011\u0019!\u0016\u0006\"\u0001\u0002V!I\u0011\u0011L\u0015\u0002\u0002\u0013\u0005\u00131\f\u0005\n\u0003SJ\u0013\u0011!C\u0001\u0003WB\u0011\"a\u001d*\u0003\u0003%\t!!\u001e\t\u0013\u0005\u0005\u0015&!A\u0005B\u0005\r\u0005\"CAIS\u0005\u0005I\u0011AAJ\u0011%\ti*KA\u0001\n\u0003\ny\nC\u0005\u0002\"&\n\t\u0011\"\u0011\u0002$\"I\u0011QU\u0015\u0002\u0002\u0013%\u0011q\u0015\u0002\u0011\u00072,8\u000f^3s\u0005>|Go\u001d;sCBT!!\u000e\u001c\u0002\u0013\t|w\u000e^:ue\u0006\u0004(BA\u001c9\u0003\u001d\u0019G.^:uKJT!!\u000f\u001e\u0002\u00155\fg.Y4f[\u0016tGOC\u0001<\u0003\u0011\t7n[1\u0004\u0001M!\u0001A\u0010#K!\ty$)D\u0001A\u0015\u0005\t\u0015!B:dC2\f\u0017BA\"A\u0005\u0019\te.\u001f*fMB\u0011Q\tS\u0007\u0002\r*\u0011qIO\u0001\u0006C\u000e$xN]\u0005\u0003\u0013\u001a\u0013\u0011\"\u0012=uK:\u001c\u0018n\u001c8\u0011\u0005-sU\"\u0001'\u000b\u00055C\u0014\u0001C:dC2\fGm\u001d7\n\u0005=c%aF'b]\u0006<W-\\3oiJ{W\u000f^3Qe>4\u0018\u000eZ3s\u0003\u0019\u0019\u0018p\u001d;f[B\u0011QIU\u0005\u0003'\u001a\u00131#\u0012=uK:$W\rZ!di>\u00148+_:uK6\fa\u0001P5oSRtD#\u0001,\u0015\u0005]K\u0006C\u0001-\u0001\u001b\u0005!\u0004\"\u0002)\u0003\u0001\b\t\u0016a\u00017pOV\tA\f\u0005\u0002^A6\taL\u0003\u0002`u\u0005)QM^3oi&\u0011\u0011M\u0018\u0002\u000f\u0019><w-\u001b8h\u0003\u0012\f\u0007\u000f^3s\u0003\u0011awn\u001a\u0011\u0002\u001b\t|w\u000e^:ue\u0006\u00048\u000b^3q+\u0005)\u0007c\u00014pc6\tqM\u0003\u0002iS\u00061\u0011\r^8nS\u000eT!A[6\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002m[\u0006!Q\u000f^5m\u0015\u0005q\u0017\u0001\u00026bm\u0006L!\u0001]4\u0003\u001f\u0005#x.\\5d%\u00164WM]3oG\u0016\u0004\"A\u001d\u000f\u000f\u0005MLbB\u0001-\u0013\u0003A\u0019E.^:uKJ\u0014un\u001c;tiJ\f\u0007\u000f\u0005\u0002Y'M!1CP<{!\r)\u0005pV\u0005\u0003s\u001a\u00131\"\u0012=uK:\u001c\u0018n\u001c8JIB\u0011Qi_\u0005\u0003y\u001a\u00131#\u0012=uK:\u001c\u0018n\u001c8JIB\u0013xN^5eKJ$\u0012!^\u0001\u0007Y>|7.\u001e9\u0015\u0003M\f1aZ3u)\r9\u0016Q\u0001\u0005\u0007!Z\u0001\r!a\u0002\u0011\u0007\u0015\u000bI!C\u0002\u0002\f\u0019\u00131\"Q2u_J\u001c\u0016p\u001d;f[R\u0019q+a\u0004\t\rA;\u0002\u0019AA\t!\r)\u00151C\u0005\u0004\u0003+1%AG\"mCN\u001c\u0018nY!di>\u00148+_:uK6\u0004&o\u001c<jI\u0016\u0014\u0018aD2sK\u0006$X-\u0012=uK:\u001c\u0018n\u001c8\u0015\u0007]\u000bY\u0002C\u0003Q1\u0001\u0007\u0011+\u0001\u0005J]R,'O\\1m!\r\t\tCG\u0007\u0002'\tA\u0011J\u001c;fe:\fGn\u0005\u0002\u001b}Q\u0011\u0011q\u0004\u0002\u000e\u0005>|Go\u001d;sCB\u001cF/\u001a9\u0014\u0005qq\u0014f\u0001\u000f*=\ta\u0011J\\5uS\u0006d\u0017N_5oONA\u0011FPA\u001a\u0003o\ti\u0004E\u0002\u00026qi\u0011A\u0007\t\u0004\u007f\u0005e\u0012bAA\u001e\u0001\n9\u0001K]8ek\u000e$\b\u0003BA \u0003\u001frA!!\u0011\u0002L9!\u00111IA%\u001b\t\t)EC\u0002\u0002Hq\na\u0001\u0010:p_Rt\u0014\"A!\n\u0007\u00055\u0003)A\u0004qC\u000e\\\u0017mZ3\n\t\u0005E\u00131\u000b\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0004\u0003\u001b\u0002ECAA,!\r\t)$K\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005u\u0003\u0003BA0\u0003Kj!!!\u0019\u000b\u0007\u0005\rT.\u0001\u0003mC:<\u0017\u0002BA4\u0003C\u0012aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAA7!\ry\u0014qN\u0005\u0004\u0003c\u0002%aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA<\u0003{\u00022aPA=\u0013\r\tY\b\u0011\u0002\u0004\u0003:L\b\"CA@[\u0005\u0005\t\u0019AA7\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\u0011\t\u0007\u0003\u000f\u000bi)a\u001e\u000e\u0005\u0005%%bAAF\u0001\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005=\u0015\u0011\u0012\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\u0016\u0006m\u0005cA \u0002\u0018&\u0019\u0011\u0011\u0014!\u0003\u000f\t{w\u000e\\3b]\"I\u0011qP\u0018\u0002\u0002\u0003\u0007\u0011qO\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011QN\u0001\ti>\u001cFO]5oOR\u0011\u0011QL\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0003S\u0003B!a\u0018\u0002,&!\u0011QVA1\u0005\u0019y%M[3di\nQaj\u001c;Sk:t\u0017N\\4\u0014\u0011yq\u00141GA\u001c\u0003{!\"!!.\u0011\u0007\u0005Ub\u0004\u0006\u0003\u0002x\u0005e\u0006\"CA@E\u0005\u0005\t\u0019AA7)\u0011\t)*!0\t\u0013\u0005}D%!AA\u0002\u0005]\u0014A\u0003(piJ+hN\\5oO\u0006a\u0011J\\5uS\u0006d\u0017N_5oO\u0006q!m\\8ugR\u0014\u0018\r]*uKB\u0004\u0013\u0001C:fiRLgnZ:\u0016\u0005\u0005%\u0007c\u0001-\u0002L&\u0019\u0011Q\u001a\u001b\u00031\rcWo\u001d;fe\n{w\u000e^:ue\u0006\u00048+\u001a;uS:<7/A\u0005tKR$\u0018N\\4tA\u0005IA-[:d_Z,'/_\u000b\u0003\u0003+\u0004B!a6\u0002\\6\u0011\u0011\u0011\u001c\u0006\u0004\u0003#T\u0014\u0002BAo\u00033\u0014\u0001cU3sm&\u001cW\rR5tG>4XM]=\u0002\u0017)|\u0017N\u001c#fG&$WM]\u000b\u0003\u0003G\u00042\u0001WAs\u0013\r\t9\u000f\u000e\u0002\f\u0015>Lg\u000eR3dS\u0012,'/\u0001\u0007k_&tG)Z2jI\u0016\u0014\b%\u0001\u000b`g\u0016dgmQ8oi\u0006\u001cG\u000fU8j]R,&/\u001b\t\u0007\u0003_\f\u00190a>\u000e\u0005\u0005E(B\u00016A\u0013\u0011\t)0!=\u0003\u000fA\u0013x.\\5tKB!\u0011\u0011 B\u0003\u001b\t\tYP\u0003\u0003\u0002~\u0006}\u0018!B7pI\u0016d'bA'\u0003\u0002)\u0019!1\u0001\u001e\u0002\t!$H\u000f]\u0005\u0005\u0005\u000f\tYPA\u0002Ve&\faA]8vi\u0016\u001cH\u0003\u0002B\u0007\u0005[\u0001BAa\u0004\u0003(9!!\u0011\u0003B\u0012\u001d\u0011\u0011\u0019Ba\b\u000f\t\tU!Q\u0004\b\u0005\u0005/\u0011YB\u0004\u0003\u0002D\te\u0011\"A\u001e\n\u0007\t\r!(C\u0002N\u0005\u0003IAA!\t\u0002\u0000\u000611/\u001a:wKJLA!!\u0014\u0003&)!!\u0011EA\u0000\u0013\u0011\u0011ICa\u000b\u0003\u000bI{W\u000f^3\u000b\t\u00055#Q\u0005\u0005\b\u0005_i\u0001\u0019\u0001B\u0019\u0003U\u0011x.\u001e;f!J|g/\u001b3feN+G\u000f^5oON\u00042a\u0013B\u001a\u0013\r\u0011)\u0004\u0014\u0002 \u001b\u0006t\u0017mZ3nK:$(k\\;uKB\u0013xN^5eKJ\u001cV\r\u001e;j]\u001e\u001c\u0018!B:uCJ$HC\u0001B\u001e!\ry$QH\u0005\u0004\u0005\u007f\u0001%\u0001B+oSR\fa#\u001a8tkJ,7+\u001a7g\u0007>tG/Y2u!>Lg\u000e\u001e\u0015\u0004\u001f\t\u0015\u0003\u0003\u0002B$\u0005\u001bj!A!\u0013\u000b\u0007\t-#(\u0001\u0006b]:|G/\u0019;j_:LAAa\u0014\u0003J\tY\u0011J\u001c;fe:\fG.\u00119j\u0003M\u0019X\r^*fY\u001a\u001cuN\u001c;bGR\u0004v.\u001b8u)\u0011\u0011YD!\u0016\t\u000f\t]\u0003\u00031\u0001\u0002x\u00069!-Y:f+JL\u0007f\u0001\t\u0003F\u0005\u00012/\u001a7g\u0007>tG/Y2u!>Lg\u000e^\u000b\u0003\u0005?\u0002b!a<\u0003b\u0005]\u0018\u0002\u0002B2\u0003c\u0014aAR;ukJ,\u0007fA\t\u0003F\u0001")
public final class ClusterBootstrap
implements ManagementRouteProvider {
    private ServiceDiscovery discovery;
    private final ExtendedActorSystem system;
    private final LoggingAdapter log;
    private final AtomicReference<Internal.BootstrapStep> bootstrapStep;
    private final ClusterBootstrapSettings settings;
    private final JoinDecider joinDecider;
    private final Promise<Uri> _selfContactPointUri;
    private volatile boolean bitmap$0;

    public static ClusterBootstrap createExtension(ExtendedActorSystem extendedActorSystem) {
        return ClusterBootstrap$.MODULE$.createExtension(extendedActorSystem);
    }

    public static ClusterBootstrap get(ClassicActorSystemProvider classicActorSystemProvider) {
        return ClusterBootstrap$.MODULE$.get(classicActorSystemProvider);
    }

    public static ClusterBootstrap get(ActorSystem actorSystem) {
        return ClusterBootstrap$.MODULE$.get(actorSystem);
    }

    public static ClusterBootstrap$ lookup() {
        return ClusterBootstrap$.MODULE$.lookup();
    }

    public static Extension apply(ClassicActorSystemProvider classicActorSystemProvider) {
        return ClusterBootstrap$.MODULE$.apply(classicActorSystemProvider);
    }

    public static Extension apply(ActorSystem actorSystem) {
        return ClusterBootstrap$.MODULE$.apply(actorSystem);
    }

    private LoggingAdapter log() {
        return this.log;
    }

    private final AtomicReference<Internal.BootstrapStep> bootstrapStep() {
        return this.bootstrapStep;
    }

    public ClusterBootstrapSettings settings() {
        return this.settings;
    }

    private ServiceDiscovery discovery$lzycompute() {
        block7: {
            ClusterBootstrap clusterBootstrap = this;
            synchronized (clusterBootstrap) {
                ServiceDiscovery serviceDiscovery;
                block9: {
                    String string;
                    block8: {
                        if (this.bitmap$0) break block7;
                        string = this.settings().contactPointDiscovery().discoveryMethod();
                        switch (string == null ? 0 : string.hashCode()) {
                            case -978464702: {
                                if ("akka.discovery".equals(string)) {
                                    break;
                                }
                                break block8;
                            }
                            default: {
                                break block8;
                            }
                        }
                        ServiceDiscovery discovery = Discovery$.MODULE$.apply((ActorSystem)this.system).discovery();
                        this.log().info("Bootstrap using default `akka.discovery` method: {}", (Object)Logging$.MODULE$.simpleName((Object)discovery));
                        serviceDiscovery = discovery;
                        break block9;
                    }
                    this.log().info("Bootstrap using `akka.discovery` method: {}", (Object)string);
                    serviceDiscovery = Discovery$.MODULE$.apply((ActorSystem)this.system).loadServiceDiscovery(string);
                }
                this.discovery = serviceDiscovery;
                this.bitmap$0 = true;
            }
        }
        return this.discovery;
    }

    public ServiceDiscovery discovery() {
        return !this.bitmap$0 ? this.discovery$lzycompute() : this.discovery;
    }

    private JoinDecider joinDecider() {
        return this.joinDecider;
    }

    public Function1<RequestContext, Future<RouteResult>> routes(ManagementRouteProviderSettings routeProviderSettings) {
        this.log().info(new StringBuilder(34).append("Using self contact point address: ").append(routeProviderSettings.selfBaseUri()).toString());
        this.setSelfContactPoint(routeProviderSettings.selfBaseUri());
        return new HttpClusterBootstrapRoutes(this.settings()).routes();
    }

    public void start() {
        if (((Cluster)Cluster$.MODULE$.apply((ActorSystem)this.system)).settings().SeedNodes().nonEmpty()) {
            this.log().warning("Application is configured with specific `akka.cluster.seed-nodes`: {}, bailing out of the bootstrap process! If you want to use the automatic bootstrap mechanism, make sure to NOT set explicit seed nodes in the configuration. This node will attempt to join the configured seed nodes.", (Object)((Cluster)Cluster$.MODULE$.apply((ActorSystem)this.system)).settings().SeedNodes().mkString("[", ", ", "]"));
        } else if (this.bootstrapStep().compareAndSet(ClusterBootstrap$Internal$NotRunning$.MODULE$, ClusterBootstrap$Internal$Initializing$.MODULE$)) {
            this.log().info("Initiating bootstrap procedure using {} method...", (Object)this.settings().contactPointDiscovery().discoveryMethod());
            this.ensureSelfContactPoint();
            Props bootstrapProps = BootstrapCoordinator$.MODULE$.props(this.discovery(), this.joinDecider(), this.settings());
            ActorRef bootstrap = this.system.systemActorOf(bootstrapProps, "bootstrapCoordinator");
            this.selfContactPoint().foreach((Function1 & Serializable)uri -> {
                ClusterBootstrap.$anonfun$start$1(bootstrap, uri);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)this.system.dispatcher());
        } else {
            this.log().warning("Bootstrap already initiated, yet start() method was called again. Ignoring.");
        }
    }

    @InternalApi
    public void ensureSelfContactPoint() {
        this.system.scheduler().scheduleOnce(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds(), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            block0: {
                if (this.selfContactPoint().isCompleted()) break block0;
                $this._selfContactPointUri.failure((Throwable)new TimeoutException("Awaiting Bootstrap.selfContactPoint timed out."));
                this.log().error("'Bootstrap.selfContactPoint' was NOT set, but is required for the bootstrap to work if binding bootstrap routes manually and not via akka-management.");
            }
        }, (ExecutionContext)this.system.dispatcher());
    }

    @InternalApi
    public void setSelfContactPoint(Uri baseUri) {
        this._selfContactPointUri.success((Object)baseUri);
    }

    @InternalApi
    public Future<Uri> selfContactPoint() {
        return this._selfContactPointUri.future();
    }

    public static final /* synthetic */ void $anonfun$start$1(ActorRef bootstrap$1, Uri uri) {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(bootstrap$1);
        BootstrapCoordinator.Protocol.InitiateBootstrapping x$1 = new BootstrapCoordinator.Protocol.InitiateBootstrapping(uri);
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    public ClusterBootstrap(ExtendedActorSystem system) {
        this.system = system;
        this.log = Logging$.MODULE$.apply((ActorSystem)system, ClusterBootstrap.class, LogSource$.MODULE$.fromAnyClass());
        this.bootstrapStep = new AtomicReference<ClusterBootstrap$Internal$NotRunning$>(ClusterBootstrap$Internal$NotRunning$.MODULE$);
        AkkaVersion$.MODULE$.require("cluster-bootstrap", "2.5.27");
        this.settings = ClusterBootstrapSettings$.MODULE$.apply(system.settings().config(), this.log());
        this.joinDecider = (JoinDecider)system.dynamicAccess().createInstanceFor(this.settings().joinDecider().implClass(), (Seq)new .colon.colon((Object)new Tuple2(ActorSystem.class, (Object)system), (List)new .colon.colon((Object)new Tuple2(ClusterBootstrapSettings.class, (Object)this.settings()), (List)Nil$.MODULE$)), ClassTag$.MODULE$.apply(JoinDecider.class)).get();
        this._selfContactPointUri = Promise$.MODULE$.apply();
    }
}

