/*
 * Decompiled with CFR 0.152.
 */
package akka.management.cluster.bootstrap;

import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.discovery.ServiceDiscovery;
import akka.management.cluster.bootstrap.BootstrapLogMarker$;
import akka.management.cluster.bootstrap.ClusterBootstrapSettings;
import akka.management.cluster.bootstrap.JoinDecision;
import akka.management.cluster.bootstrap.JoinOtherSeedNodes;
import akka.management.cluster.bootstrap.JoinSelf$;
import akka.management.cluster.bootstrap.KeepProbing$;
import akka.management.cluster.bootstrap.SeedNodesInformation;
import akka.management.cluster.bootstrap.SelfAwareJoinDecider;
import java.io.Serializable;
import java.time.Duration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.LinearSeqOps;
import scala.collection.immutable.Set;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005M4AAC\u0006\u0001)!A\u0011\u0004\u0001B\u0001B\u0003%!\u0004\u0003\u0005!\u0001\t\u0005\t\u0015!\u0003\"\u0011\u0015!\u0003\u0001\"\u0001&\u0011\u0015I\u0003\u0001\"\u0011+\u0011\u0015Y\u0004\u0001\"\u0005=\u0011\u0015a\u0005\u0001\"\u0005N\u0011\u0015\u0019\u0006\u0001\"\u0005U\u0011\u00151\u0006\u0001\"\u0005X\u0011\u0015\u0001\u0007\u0001\"\u0005b\u0005aaun^3ti\u0006#GM]3tg*{\u0017N\u001c#fG&$WM\u001d\u0006\u0003\u00195\t\u0011BY8piN$(/\u00199\u000b\u00059y\u0011aB2mkN$XM\u001d\u0006\u0003!E\t!\"\\1oC\u001e,W.\u001a8u\u0015\u0005\u0011\u0012\u0001B1lW\u0006\u001c\u0001a\u0005\u0002\u0001+A\u0011acF\u0007\u0002\u0017%\u0011\u0001d\u0003\u0002\u0015'\u0016dg-Q<be\u0016Tu.\u001b8EK\u000eLG-\u001a:\u0002\rML8\u000f^3n!\tYb$D\u0001\u001d\u0015\ti\u0012#A\u0003bGR|'/\u0003\u0002 9\tY\u0011i\u0019;peNK8\u000f^3n\u0003!\u0019X\r\u001e;j]\u001e\u001c\bC\u0001\f#\u0013\t\u00193B\u0001\rDYV\u001cH/\u001a:C_>$8\u000f\u001e:baN+G\u000f^5oON\fa\u0001P5oSRtDc\u0001\u0014(QA\u0011a\u0003\u0001\u0005\u00063\r\u0001\rA\u0007\u0005\u0006A\r\u0001\r!I\u0001\u0007I\u0016\u001c\u0017\u000eZ3\u0015\u0005-2\u0004c\u0001\u00172g5\tQF\u0003\u0002/_\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0003A\nQa]2bY\u0006L!AM\u0017\u0003\r\u0019+H/\u001e:f!\t1B'\u0003\u00026\u0017\ta!j\\5o\t\u0016\u001c\u0017n]5p]\")q\u0007\u0002a\u0001q\u0005!\u0011N\u001c4p!\t1\u0012(\u0003\u0002;\u0017\t!2+Z3e\u001d>$Wm]%oM>\u0014X.\u0019;j_:\f!C[8j]>#\b.\u001a:TK\u0016$gj\u001c3fgR\u0011Qh\u0013\t\u0004}\u0015CeBA D!\t\u0001u&D\u0001B\u0015\t\u00115#\u0001\u0004=e>|GOP\u0005\u0003\t>\na\u0001\u0015:fI\u00164\u0017B\u0001$H\u0005\r\u0019V\r\u001e\u0006\u0003\t>\u0002\"aG%\n\u0005)c\"aB!eIJ,7o\u001d\u0005\u0006o\u0015\u0001\r\u0001O\u0001\u0017Q\u0006\u001cXI\\8vO\"\u001cuN\u001c;bGR\u0004v.\u001b8ugR\u0011aJ\u0015\t\u0003\u001fBk\u0011aL\u0005\u0003#>\u0012qAQ8pY\u0016\fg\u000eC\u00038\r\u0001\u0007\u0001(\u0001\njgB\u000b7\u000f^*uC\ndW-T1sO&tGC\u0001(V\u0011\u00159t\u00011\u00019\u0003QJ7oQ8oM&\u0014X.\u001a3D_6lWO\\5dCRLwN\\,ji\"\fE\u000e\\\"p]R\f7\r\u001e)pS:$8OU3rk&\u0014X\r\u001a\u000b\u0003\u001dbCQa\u000e\u0005A\u0002aB#\u0001\u0017.\u0011\u0005msV\"\u0001/\u000b\u0005u\u000b\u0012\u0001B;uS2L!a\u0018/\u0003\rUtWo]3e\u0003eawn^3ti\u0006#GM]3tg\u000e{g\u000e^1diB{\u0017N\u001c;\u0015\u0005\t\u0014\bcA(dK&\u0011Am\f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\u0019|gBA4m\u001d\tA'N\u0004\u0002AS&\t!#\u0003\u0002l#\u0005IA-[:d_Z,'/_\u0005\u0003[:\f\u0001cU3sm&\u001cW\rR5tG>4XM]=\u000b\u0005-\f\u0012B\u00019r\u00059\u0011Vm]8mm\u0016$G+\u0019:hKRT!!\u001c8\t\u000b]J\u0001\u0019\u0001\u001d")
public class LowestAddressJoinDecider
extends SelfAwareJoinDecider {
    private final ClusterBootstrapSettings settings;

    @Override
    public Future<JoinDecision> decide(SeedNodesInformation info) {
        block10: {
            Set contactPointsWithoutSeedNodesObservations;
            if (info.hasSeedNodes()) {
                Set<Address> seeds = this.joinOtherSeedNodes(info);
                if (seeds.isEmpty()) {
                    return KeepProbing$.MODULE$.asCompletedFuture();
                }
                return new JoinOtherSeedNodes(seeds).asCompletedFuture();
            }
            if (!this.hasEnoughContactPoints(info)) {
                this.log().info(BootstrapLogMarker$.MODULE$.inProgress((Set<String>)((Set)info.contactPoints().map((Function1 & Serializable)contactPoint -> this.contactPointString((ServiceDiscovery.ResolvedTarget)contactPoint))), info.allSeedNodes()), "Discovered [{}] contact points, confirmed [{}], which is less than the required [{}], retrying", (Object)BoxesRunTime.boxToInteger((int)info.contactPoints().size()), (Object)BoxesRunTime.boxToInteger((int)info.seedNodesObservations().size()), (Object)BoxesRunTime.boxToInteger((int)this.settings.contactPointDiscovery().requiredContactPointsNr()));
                return KeepProbing$.MODULE$.asCompletedFuture();
            }
            if (!this.isPastStableMargin(info)) {
                this.log().debug(BootstrapLogMarker$.MODULE$.inProgress((Set<String>)((Set)info.contactPoints().map((Function1 & Serializable)contactPoint -> this.contactPointString((ServiceDiscovery.ResolvedTarget)contactPoint))), info.allSeedNodes()), "Contact points observations have changed more recently than the stable-margin [{}], changed at [{}], not joining myself. This process will be retried.", (Object)this.settings.contactPointDiscovery().stableMargin(), (Object)info.contactPointsChangedAt());
                return KeepProbing$.MODULE$.asCompletedFuture();
            }
            Set set = contactPointsWithoutSeedNodesObservations = this.isConfirmedCommunicationWithAllContactPointsRequired(info) ? (Set)info.contactPoints().$minus$minus((IterableOnce)info.seedNodesObservations().map((Function1 & Serializable)x$1 -> x$1.contactPoint())) : Predef$.MODULE$.Set().empty();
            if (contactPointsWithoutSeedNodesObservations.isEmpty()) {
                Option<ServiceDiscovery.ResolvedTarget> lowestAddress = this.lowestAddressContactPoint(info);
                boolean isJoinSelfAble = lowestAddress.exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)this.canJoinSelf(x$2, info)));
                if (isJoinSelfAble && this.settings.newClusterEnabled()) {
                    return JoinSelf$.MODULE$.asCompletedFuture();
                }
                if (this.settings.newClusterEnabled()) {
                    if (this.log().isInfoEnabled()) {
                        this.log().info(BootstrapLogMarker$.MODULE$.inProgress((Set<String>)((Set)info.contactPoints().map((Function1 & Serializable)contactPoint -> this.contactPointString((ServiceDiscovery.ResolvedTarget)contactPoint))), info.allSeedNodes()), "Exceeded stable margins without locating seed-nodes, however this node {} is NOT the lowest address out of the discovered endpoints in this deployment, thus NOT joining self. Expecting node [{}] (out of [{}]) to perform the self-join and initiate the cluster.", (Object)this.contactPointString(this.selfContactPoint()), lowestAddress.map((Function1 & Serializable)contactPoint -> this.contactPointString((ServiceDiscovery.ResolvedTarget)contactPoint)).getOrElse((Function0 & Serializable)() -> ""), (Object)((IterableOnceOps)info.contactPoints().map((Function1 & Serializable)contactPoint -> this.contactPointString((ServiceDiscovery.ResolvedTarget)contactPoint))).mkString(", "));
                    }
                } else if (this.log().isWarningEnabled()) {
                    this.log().warning(BootstrapLogMarker$.MODULE$.inProgress((Set<String>)((Set)info.contactPoints().map((Function1 & Serializable)contactPoint -> this.contactPointString((ServiceDiscovery.ResolvedTarget)contactPoint))), info.allSeedNodes()), "Exceeded stable margins without locating seed-nodes, however this node {} is configured with new-cluster-enabled=off, thus NOT joining self. Expecting existing cluster or node [{}] (out of [{}]) to perform the self-join and initiate the cluster.", (Object)this.contactPointString(this.selfContactPoint()), lowestAddress.map((Function1 & Serializable)contactPoint -> this.contactPointString((ServiceDiscovery.ResolvedTarget)contactPoint)).getOrElse((Function0 & Serializable)() -> ""), (Object)((IterableOnceOps)info.contactPoints().map((Function1 & Serializable)contactPoint -> this.contactPointString((ServiceDiscovery.ResolvedTarget)contactPoint))).mkString(", "));
                }
                return KeepProbing$.MODULE$.asCompletedFuture();
            }
            if (!this.log().isInfoEnabled()) break block10;
            this.log().info(BootstrapLogMarker$.MODULE$.inProgress((Set<String>)((Set)info.contactPoints().map((Function1 & Serializable)contactPoint -> this.contactPointString((ServiceDiscovery.ResolvedTarget)contactPoint))), info.allSeedNodes()), "Exceeded stable margins but missing seed node information from some contact points [{}] (out of [{}])", (Object)((IterableOnceOps)contactPointsWithoutSeedNodesObservations.map((Function1 & Serializable)contactPoint -> this.contactPointString((ServiceDiscovery.ResolvedTarget)contactPoint))).mkString(", "), (Object)((IterableOnceOps)info.contactPoints().map((Function1 & Serializable)contactPoint -> this.contactPointString((ServiceDiscovery.ResolvedTarget)contactPoint))).mkString(", "));
        }
        return KeepProbing$.MODULE$.asCompletedFuture();
    }

    public Set<Address> joinOtherSeedNodes(SeedNodesInformation info) {
        return (Set)info.allSeedNodes().take(5);
    }

    public boolean hasEnoughContactPoints(SeedNodesInformation info) {
        return info.seedNodesObservations().size() >= this.settings.contactPointDiscovery().requiredContactPointsNr();
    }

    public boolean isPastStableMargin(SeedNodesInformation info) {
        Duration contactPointsChanged = Duration.between(info.contactPointsChangedAt(), info.currentTime());
        return contactPointsChanged.toMillis() >= this.settings.contactPointDiscovery().stableMargin().toMillis();
    }

    public boolean isConfirmedCommunicationWithAllContactPointsRequired(SeedNodesInformation info) {
        return this.settings.contactPointDiscovery().contactWithAllContactPoints();
    }

    public Option<ServiceDiscovery.ResolvedTarget> lowestAddressContactPoint(SeedNodesInformation info) {
        return ((LinearSeqOps)info.seedNodesObservations().toList().map((Function1 & Serializable)x$3 -> x$3.contactPoint()).sorted(ServiceDiscovery.ResolvedTarget$.MODULE$.addressOrdering())).headOption();
    }

    public LowestAddressJoinDecider(ActorSystem system, ClusterBootstrapSettings settings) {
        this.settings = settings;
        super(system, settings);
    }
}

