/*
 * Decompiled with CFR 0.152.
 */
package akka.management.scaladsl;

import akka.Done;
import akka.Done$;
import akka.actor.ActorSystem;
import akka.actor.ClassicActorSystemProvider;
import akka.actor.DynamicAccess;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.actor.ExtensionIdProvider;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.MarkerLoggingAdapter;
import akka.http.javadsl.server.directives.SecurityDirectives;
import akka.http.scaladsl.Http;
import akka.http.scaladsl.Http$;
import akka.http.scaladsl.HttpsConnectionContext;
import akka.http.scaladsl.ServerBuilder;
import akka.http.scaladsl.model.Uri;
import akka.http.scaladsl.model.Uri$;
import akka.http.scaladsl.server.Directive;
import akka.http.scaladsl.server.Directive$;
import akka.http.scaladsl.server.Directives$;
import akka.http.scaladsl.server.PathMatcher$;
import akka.http.scaladsl.server.PathMatchers$;
import akka.http.scaladsl.server.RequestContext;
import akka.http.scaladsl.server.RouteResult;
import akka.http.scaladsl.server.RouteResult$;
import akka.http.scaladsl.server.directives.Credentials;
import akka.http.scaladsl.server.util.ApplyConverter$;
import akka.http.scaladsl.settings.ServerSettings;
import akka.http.scaladsl.settings.ServerSettings$;
import akka.management.AkkaManagementSettings;
import akka.management.ManagementLogMarker$;
import akka.management.NamedRouteProvider;
import akka.management.scaladsl.AkkaManagement$;
import akka.management.scaladsl.ManagementRouteProvider;
import akka.management.scaladsl.ManagementRouteProviderAdapter;
import akka.management.scaladsl.ManagementRouteProviderSettings;
import akka.management.scaladsl.ManagementRouteProviderSettings$;
import akka.management.scaladsl.ManagementRouteProviderSettingsImpl;
import akka.util.ManifestInfo;
import akka.util.ManifestInfo$;
import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.compat.java8.FutureConverters;
import scala.compat.java8.FutureConverters$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005%v!B\u000f\u001f\u0011\u0003)c!B\u0014\u001f\u0011\u0003A\u0003B\u0002!\u0002\t\u0003\t)\tC\u0004\u0002\b\u0006!\t%!#\t\u000f\u00055\u0015\u0001\"\u0011\u0002\u0010\"9\u0011QR\u0001\u0005B\u0005e\u0005bBAR\u0003\u0011\u0005\u0013Q\u0015\u0004\u0005Oy\u0011a\u0007C\u0005;\u000f\t\u0015\r\u0011b\u0001#w!Aqh\u0002B\u0001B\u0003%A\bC\u0003A\u000f\u0011\u0005\u0011\tC\u0004E\u000f\t\u0007I\u0011B#\t\r1;\u0001\u0015!\u0003G\u0011\u001diuA1A\u0005\u00029CaaU\u0004!\u0002\u0013y\u0005b\u0002+\b\u0005\u0004%I!\u0016\u0005\u0007C\u001e\u0001\u000b\u0011\u0002,\t\u000f\t<!\u0019!C\u0005G\"9\u0011\u0011A\u0004!\u0002\u0013!\u0007\"CA\u0002\u000f\t\u0007I\u0011BA\u0003\u0011!\tIb\u0002Q\u0001\n\u0005\u001d\u0001bBA\u000e\u000f\u0011%\u0011Q\u0004\u0005\b\u0003K9A\u0011AA\u0014\u0011\u001d\t)c\u0002C\u0001\u0003#Bq!!\u0018\b\t\u0003\ty\u0006C\u0004\u0002^\u001d!\t!a\u0019\t\u000f\u0005\u001dt\u0001\"\u0003\u0002j!9\u0011QN\u0004\u0005\u0002\u0005=\u0004bBA>\u000f\u0011%\u0011QP\u0001\u000f\u0003.\\\u0017-T1oC\u001e,W.\u001a8u\u0015\ty\u0002%\u0001\u0005tG\u0006d\u0017\rZ:m\u0015\t\t#%\u0001\u0006nC:\fw-Z7f]RT\u0011aI\u0001\u0005C.\\\u0017m\u0001\u0001\u0011\u0005\u0019\nQ\"\u0001\u0010\u0003\u001d\u0005[7.Y'b]\u0006<W-\\3oiN)\u0011!K\u0018\u0002\u0000A\u0011!&L\u0007\u0002W)\tA&A\u0003tG\u0006d\u0017-\u0003\u0002/W\t1\u0011I\\=SK\u001a\u00042\u0001M\u001a6\u001b\u0005\t$B\u0001\u001a#\u0003\u0015\t7\r^8s\u0013\t!\u0014GA\u0006FqR,gn]5p]&#\u0007C\u0001\u0014\b'\r9\u0011f\u000e\t\u0003aaJ!!O\u0019\u0003\u0013\u0015CH/\u001a8tS>t\u0017AB:zgR,W.F\u0001=!\t\u0001T(\u0003\u0002?c\t\u0019R\t\u001f;f]\u0012,G-Q2u_J\u001c\u0016p\u001d;f[\u000691/_:uK6\u0004\u0013A\u0002\u001fj]&$h\bF\u0001C)\t)4\tC\u0003;\u0015\u0001\u000fA(A\u0002m_\u001e,\u0012A\u0012\t\u0003\u000f*k\u0011\u0001\u0013\u0006\u0003\u0013\n\nQ!\u001a<f]RL!a\u0013%\u0003)5\u000b'o[3s\u0019><w-\u001b8h\u0003\u0012\f\u0007\u000f^3s\u0003\u0011awn\u001a\u0011\u0002\u0011M,G\u000f^5oON,\u0012a\u0014\t\u0003!Fk\u0011\u0001I\u0005\u0003%\u0002\u0012a#Q6lC6\u000bg.Y4f[\u0016tGoU3ui&twm]\u0001\ng\u0016$H/\u001b8hg\u0002\naB]8vi\u0016\u0004&o\u001c<jI\u0016\u00148/F\u0001W!\r9FLX\u0007\u00021*\u0011\u0011LW\u0001\nS6lW\u000f^1cY\u0016T!aW\u0016\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002^1\n\u00191+Z9\u0011\u0005\u0019z\u0016B\u00011\u001f\u0005]i\u0015M\\1hK6,g\u000e\u001e*pkR,\u0007K]8wS\u0012,'/A\bs_V$X\r\u0015:pm&$WM]:!\u00035\u0011\u0017N\u001c3j]\u001e4U\u000f^;sKV\tA\rE\u0002f]Bl\u0011A\u001a\u0006\u0003O\"\fa!\u0019;p[&\u001c'BA5k\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003W2\fA!\u001e;jY*\tQ.\u0001\u0003kCZ\f\u0017BA8g\u0005=\tEo\\7jGJ+g-\u001a:f]\u000e,\u0007cA9tk6\t!O\u0003\u0002jW%\u0011AO\u001d\u0002\u0007\rV$XO]3\u0011\u0005YlhBA<|\u001b\u0005A(BA\u0010z\u0015\tQ(%\u0001\u0003iiR\u0004\u0018B\u0001?y\u0003\u0011AE\u000f\u001e9\n\u0005y|(!D*feZ,'OQ5oI&twM\u0003\u0002}q\u0006q!-\u001b8eS:<g)\u001e;ve\u0016\u0004\u0013AD:fY\u001a,&/\u001b)s_6L7/Z\u000b\u0003\u0003\u000f\u0001R!]A\u0005\u0003\u001bI1!a\u0003s\u0005\u001d\u0001&o\\7jg\u0016\u0004B!a\u0004\u0002\u00165\u0011\u0011\u0011\u0003\u0006\u0004\u0003'A\u0018!B7pI\u0016d\u0017\u0002BA\f\u0003#\u00111!\u0016:j\u0003=\u0019X\r\u001c4Ve&\u0004&o\\7jg\u0016\u0004\u0013\u0001\u00059s_ZLG-\u001a:TKR$\u0018N\\4t+\t\ty\u0002E\u0002'\u0003CI1!a\t\u001f\u0005}i\u0015M\\1hK6,g\u000e\u001e*pkR,\u0007K]8wS\u0012,'oU3ui&twm]\u0001\u0007e>,H/Z:\u0016\u0005\u0005%\u0002\u0003BA\u0016\u0003\u0017rA!!\f\u0002F9!\u0011qFA!\u001d\u0011\t\t$a\u0010\u000f\t\u0005M\u0012Q\b\b\u0005\u0003k\tY$\u0004\u0002\u00028)\u0019\u0011\u0011\b\u0013\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0013B\u0001>#\u0013\ty\u00120C\u0002\u0002Da\faa]3sm\u0016\u0014\u0018\u0002BA$\u0003\u0013\nq\u0001]1dW\u0006<WMC\u0002\u0002DaLA!!\u0014\u0002P\t)!k\\;uK*!\u0011qIA%)\u0011\tI#a\u0015\t\u000f\u0005Us\u00031\u0001\u0002X\u0005\tBO]1og\u001a|'/\\*fiRLgnZ:\u0011\u000f)\nI&a\b\u0002 %\u0019\u00111L\u0016\u0003\u0013\u0019+hn\u0019;j_:\f\u0014!B:uCJ$HCAA1!\u0011\t8/!\u0004\u0015\t\u0005\u0005\u0014Q\r\u0005\b\u0003+J\u0002\u0019AA,\u0003U\u0001(/\u001a9be\u0016\u001cu.\u001c2j]\u0016$'k\\;uKN$B!!\u000b\u0002l!9\u00111\u0004\u000eA\u0002\u0005}\u0011\u0001B:u_B$\"!!\u001d\u0011\tE\u001c\u00181\u000f\t\u0005\u0003k\n9(D\u0001#\u0013\r\tIH\t\u0002\u0005\t>tW-\u0001\nm_\u0006$'k\\;uKB\u0013xN^5eKJ\u001cH#\u0001,\u0011\u0007A\n\t)C\u0002\u0002\u0004F\u00121#\u0012=uK:\u001c\u0018n\u001c8JIB\u0013xN^5eKJ$\u0012!J\u0001\u0007Y>|7.\u001e9\u0016\u0005\u0005-eB\u0001\u0014\u0001\u0003\r9W\r\u001e\u000b\u0004k\u0005E\u0005B\u0002\u001e\u0005\u0001\u0004\t\u0019\nE\u00021\u0003+K1!a&2\u0005-\t5\r^8s'f\u001cH/Z7\u0015\u0007U\nY\n\u0003\u0004;\u000b\u0001\u0007\u0011Q\u0014\t\u0004a\u0005}\u0015bAAQc\tQ2\t\\1tg&\u001c\u0017i\u0019;peNK8\u000f^3n!J|g/\u001b3fe\u0006y1M]3bi\u0016,\u0005\u0010^3og&|g\u000eF\u00026\u0003OCQA\u000f\u0004A\u0002q\u0002")
public final class AkkaManagement
implements Extension {
    private final ExtendedActorSystem system;
    private final MarkerLoggingAdapter log;
    private final AkkaManagementSettings settings;
    private final Seq<ManagementRouteProvider> routeProviders;
    private final AtomicReference<Future<Http.ServerBinding>> bindingFuture;
    private final Promise<Uri> selfUriPromise;

    public static AkkaManagement createExtension(ExtendedActorSystem system) {
        return AkkaManagement$.MODULE$.createExtension(system);
    }

    public static AkkaManagement get(ClassicActorSystemProvider system) {
        return AkkaManagement$.MODULE$.get(system);
    }

    public static AkkaManagement get(ActorSystem system) {
        return AkkaManagement$.MODULE$.get(system);
    }

    public static AkkaManagement$ lookup() {
        return AkkaManagement$.MODULE$.lookup();
    }

    public static Extension apply(ClassicActorSystemProvider system) {
        return AkkaManagement$.MODULE$.apply(system);
    }

    public static Extension apply(ActorSystem system) {
        return AkkaManagement$.MODULE$.apply(system);
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    private MarkerLoggingAdapter log() {
        return this.log;
    }

    public AkkaManagementSettings settings() {
        return this.settings;
    }

    private Seq<ManagementRouteProvider> routeProviders() {
        return this.routeProviders;
    }

    private AtomicReference<Future<Http.ServerBinding>> bindingFuture() {
        return this.bindingFuture;
    }

    private Promise<Uri> selfUriPromise() {
        return this.selfUriPromise;
    }

    private ManagementRouteProviderSettings providerSettings() {
        String protocol = "http";
        String host = this.settings().Http().Hostname();
        int port = this.settings().Http().Port();
        String path = (String)this.settings().Http().BasePath().fold((Function0 & Serializable)() -> "", (Function1 & Serializable)x$1 -> new StringBuilder(1).append("/").append((String)x$1).toString());
        String x$12 = protocol;
        String x$2 = host;
        int x$3 = port;
        String x$4 = path;
        String x$5 = Uri$.MODULE$.from$default$2();
        Option x$6 = Uri$.MODULE$.from$default$6();
        Option x$7 = Uri$.MODULE$.from$default$7();
        Uri.ParsingMode x$8 = Uri$.MODULE$.from$default$8();
        Uri selfBaseUri = Uri$.MODULE$.from(x$12, x$5, x$2, x$3, x$4, x$6, x$7, x$8);
        return ManagementRouteProviderSettings$.MODULE$.apply(selfBaseUri, this.settings().Http().RouteProvidersReadOnly());
    }

    public Function1<RequestContext, Future<RouteResult>> routes() {
        return this.prepareCombinedRoutes(this.providerSettings());
    }

    public Function1<RequestContext, Future<RouteResult>> routes(Function1<ManagementRouteProviderSettings, ManagementRouteProviderSettings> transformSettings) {
        return this.prepareCombinedRoutes((ManagementRouteProviderSettings)transformSettings.apply((Object)this.providerSettings()));
    }

    public Future<Uri> start() {
        return this.start((Function1<ManagementRouteProviderSettings, ManagementRouteProviderSettings>)(Function1 & Serializable)x -> (ManagementRouteProviderSettings)Predef$.MODULE$.identity(x));
    }

    public Future<Uri> start(Function1<ManagementRouteProviderSettings, ManagementRouteProviderSettings> transformSettings) {
        Promise serverBindingPromise = Promise$.MODULE$.apply();
        if (this.bindingFuture().compareAndSet(null, (Future<Http.ServerBinding>)serverBindingPromise.future())) {
            Future future;
            try {
                ServerBuilder serverBuilder;
                String effectiveBindHostname = this.settings().Http().EffectiveBindHostname();
                int effectiveBindPort = this.settings().Http().EffectiveBindPort();
                ManagementRouteProviderSettings effectiveProviderSettings = (ManagementRouteProviderSettings)transformSettings.apply((Object)this.providerSettings());
                this.log().info("Binding Akka Management (HTTP) endpoint to: {}:{}", (Object)effectiveBindHostname, (Object)BoxesRunTime.boxToInteger((int)effectiveBindPort));
                Function1<RequestContext, Future<RouteResult>> combinedRoutes = this.prepareCombinedRoutes(effectiveProviderSettings);
                ServerBuilder baseBuilder = Http$.MODULE$.apply((ClassicActorSystemProvider)this.system()).newServerAt(effectiveBindHostname, effectiveBindPort).withSettings(((ServerSettings)ServerSettings$.MODULE$.apply((ActorSystem)this.system())).withRemoteAddressHeader(true));
                Option<HttpsConnectionContext> option = effectiveProviderSettings.httpsConnectionContext();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    HttpsConnectionContext httpsContext = (HttpsConnectionContext)some.value();
                    serverBuilder = baseBuilder.enableHttps(httpsContext);
                } else if (None$.MODULE$.equals(option)) {
                    serverBuilder = baseBuilder;
                } else {
                    throw new MatchError(option);
                }
                ServerBuilder securedBuilder = serverBuilder;
                Future serverFutureBinding = securedBuilder.bind(RouteResult$.MODULE$.routeToFunction(combinedRoutes, (ClassicActorSystemProvider)this.system()));
                future = serverBindingPromise.completeWith(serverFutureBinding).future().flatMap((Function1 & Serializable)binding -> {
                    int boundPort = binding.localAddress().getPort();
                    this.log().info(ManagementLogMarker$.MODULE$.boundHttp(new StringBuilder(1).append(effectiveBindHostname).append(":").append(boundPort).toString()), "Bound Akka Management (HTTP) endpoint to: {}:{}", (Object)effectiveBindHostname, (Object)BoxesRunTime.boxToInteger((int)boundPort));
                    return this.selfUriPromise().success((Object)effectiveProviderSettings.selfBaseUri().withPort(boundPort)).future();
                }, (ExecutionContext)this.system().dispatcher());
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable ex = (Throwable)option.get();
                    this.log().warning(ex.getMessage());
                    future = Future$.MODULE$.failed((Throwable)new IllegalArgumentException("Failed to start Akka Management HTTP endpoint.", ex));
                }
                throw throwable;
            }
            return future;
        }
        return this.selfUriPromise().future();
    }

    private Function1<RequestContext, Future<RouteResult>> prepareCombinedRoutes(ManagementRouteProviderSettings providerSettings) {
        String pathPrefixName = (String)this.settings().Http().BasePath().getOrElse((Function0 & Serializable)() -> "");
        Directive basePath = pathPrefixName.isEmpty() ? Directives$.MODULE$.rawPathPrefix(PathMatcher$.MODULE$._segmentStringToPathMatcher(pathPrefixName)) : Directives$.MODULE$.pathPrefix(PathMatchers$.MODULE$.separateOnSlashes(pathPrefixName));
        Seq combinedRoutes = (Seq)this.routeProviders().map((Function1 & Serializable)provider -> {
            this.log().info("Including HTTP management routes for {}", (Object)Logging$.MODULE$.simpleName(provider));
            return provider.routes(providerSettings);
        });
        if (combinedRoutes.nonEmpty()) {
            return (Function1)Directive$.MODULE$.addByNameNullaryApply(basePath).apply((Function0 & Serializable)() -> this.wrapWithAuthenticatorIfPresent$1(Directives$.MODULE$.concat(combinedRoutes), providerSettings));
        }
        throw new IllegalArgumentException("No routes configured for akka management! Double check your `akka.management.http.routes` config.");
    }

    public Future<Done> stop() {
        Future<Http.ServerBinding> binding;
        do {
            if ((binding = this.bindingFuture().get()) != null) continue;
            return Future$.MODULE$.successful((Object)Done$.MODULE$);
        } while (!this.bindingFuture().compareAndSet(binding, null));
        return binding.flatMap((Function1 & Serializable)x$5 -> x$5.unbind(), (ExecutionContext)this.system().dispatcher()).map((Function1 & Serializable)x$6 -> Done$.MODULE$, (ExecutionContext)this.system().dispatcher());
    }

    private Seq<ManagementRouteProvider> loadRouteProviders() {
        DynamicAccess dynamicAccess = this.system().dynamicAccess();
        return (Seq)this.settings().Http().RouteProviders().map((Function1 & Serializable)x0$1 -> {
            NamedRouteProvider namedRouteProvider = x0$1;
            if (namedRouteProvider != null) {
                Object provider;
                Object provider2;
                String name = namedRouteProvider.name();
                String fqcn = namedRouteProvider.fullyQualifiedClassName();
                boolean bl = false;
                Success success = null;
                Try try_ = dynamicAccess.getObjectFor(fqcn, ClassTag$.MODULE$.apply(ExtensionIdProvider.class)).recoverWith((PartialFunction)new Serializable(null, dynamicAccess, fqcn){
                    private static final long serialVersionUID = 0L;
                    private final DynamicAccess dynamicAccess$1;
                    private final String fqcn$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        return (B1)this.dynamicAccess$1.createInstanceFor(this.fqcn$1, (Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ExtensionIdProvider.class));
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        return true;
                    }
                    {
                        this.dynamicAccess$1 = dynamicAccess$1;
                        this.fqcn$1 = fqcn$1;
                    }
                }).recoverWith((PartialFunction)new Serializable(this, dynamicAccess, fqcn){
                    private static final long serialVersionUID = 0L;
                    private final /* synthetic */ AkkaManagement $outer;
                    private final DynamicAccess dynamicAccess$1;
                    private final String fqcn$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                        A1 A1 = x2;
                        if (A1 instanceof ClassCastException ? true : A1 instanceof NoSuchMethodException) {
                            Tuple2 tuple2 = new Tuple2(ExtendedActorSystem.class, (Object)this.$outer.system());
                            return (B1)this.dynamicAccess$1.createInstanceFor(this.fqcn$1, (Seq)Nil$.MODULE$.$colon$colon((Object)tuple2), ClassTag$.MODULE$.apply(ExtensionIdProvider.class));
                        }
                        return (B1)function1.apply(x2);
                    }

                    public final boolean isDefinedAt(Throwable x2) {
                        Throwable throwable = x2;
                        return throwable instanceof ClassCastException ? true : throwable instanceof NoSuchMethodException;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.dynamicAccess$1 = dynamicAccess$1;
                        this.fqcn$1 = fqcn$1;
                    }
                }).recoverWith((PartialFunction)new Serializable(null, dynamicAccess, fqcn){
                    private static final long serialVersionUID = 0L;
                    private final DynamicAccess dynamicAccess$1;
                    private final String fqcn$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                        A1 A1 = x3;
                        if (A1 instanceof ClassCastException ? true : A1 instanceof NoSuchMethodException) {
                            return (B1)this.dynamicAccess$1.createInstanceFor(this.fqcn$1, (Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ManagementRouteProvider.class));
                        }
                        return (B1)function1.apply(x3);
                    }

                    public final boolean isDefinedAt(Throwable x3) {
                        Throwable throwable = x3;
                        return throwable instanceof ClassCastException ? true : throwable instanceof NoSuchMethodException;
                    }
                    {
                        this.dynamicAccess$1 = dynamicAccess$1;
                        this.fqcn$1 = fqcn$1;
                    }
                }).recoverWith((PartialFunction)new Serializable(this, dynamicAccess, fqcn){
                    private static final long serialVersionUID = 0L;
                    private final /* synthetic */ AkkaManagement $outer;
                    private final DynamicAccess dynamicAccess$1;
                    private final String fqcn$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                        A1 A1 = x4;
                        if (A1 instanceof ClassCastException ? true : A1 instanceof NoSuchMethodException) {
                            Tuple2 tuple2 = new Tuple2(ExtendedActorSystem.class, (Object)this.$outer.system());
                            return (B1)this.dynamicAccess$1.createInstanceFor(this.fqcn$1, (Seq)Nil$.MODULE$.$colon$colon((Object)tuple2), ClassTag$.MODULE$.apply(ManagementRouteProvider.class));
                        }
                        return (B1)function1.apply(x4);
                    }

                    public final boolean isDefinedAt(Throwable x4) {
                        Throwable throwable = x4;
                        return throwable instanceof ClassCastException ? true : throwable instanceof NoSuchMethodException;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.dynamicAccess$1 = dynamicAccess$1;
                        this.fqcn$1 = fqcn$1;
                    }
                }).recoverWith((PartialFunction)new Serializable(null, dynamicAccess, fqcn){
                    private static final long serialVersionUID = 0L;
                    private final DynamicAccess dynamicAccess$1;
                    private final String fqcn$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                        A1 A1 = x5;
                        if (A1 instanceof ClassCastException ? true : A1 instanceof NoSuchMethodException) {
                            return (B1)this.dynamicAccess$1.createInstanceFor(this.fqcn$1, (Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(akka.management.javadsl.ManagementRouteProvider.class));
                        }
                        return (B1)function1.apply(x5);
                    }

                    public final boolean isDefinedAt(Throwable x5) {
                        Throwable throwable = x5;
                        return throwable instanceof ClassCastException ? true : throwable instanceof NoSuchMethodException;
                    }
                    {
                        this.dynamicAccess$1 = dynamicAccess$1;
                        this.fqcn$1 = fqcn$1;
                    }
                }).recoverWith((PartialFunction)new Serializable(this, dynamicAccess, fqcn){
                    private static final long serialVersionUID = 0L;
                    private final /* synthetic */ AkkaManagement $outer;
                    private final DynamicAccess dynamicAccess$1;
                    private final String fqcn$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
                        A1 A1 = x6;
                        if (A1 instanceof ClassCastException ? true : A1 instanceof NoSuchMethodException) {
                            Tuple2 tuple2 = new Tuple2(ExtendedActorSystem.class, (Object)this.$outer.system());
                            return (B1)this.dynamicAccess$1.createInstanceFor(this.fqcn$1, (Seq)Nil$.MODULE$.$colon$colon((Object)tuple2), ClassTag$.MODULE$.apply(akka.management.javadsl.ManagementRouteProvider.class));
                        }
                        return (B1)function1.apply(x6);
                    }

                    public final boolean isDefinedAt(Throwable x6) {
                        Throwable throwable = x6;
                        return throwable instanceof ClassCastException ? true : throwable instanceof NoSuchMethodException;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.dynamicAccess$1 = dynamicAccess$1;
                        this.fqcn$1 = fqcn$1;
                    }
                });
                if (try_ instanceof Success) {
                    bl = true;
                    success = (Success)try_;
                    Object p = success.value();
                    if (p instanceof ExtensionIdProvider) {
                        ExtensionIdProvider extensionIdProvider = (ExtensionIdProvider)p;
                        Extension extension = this.system().registerExtension(extensionIdProvider.lookup());
                        if (extension instanceof ManagementRouteProvider) {
                            Extension extension2 = extension;
                            return (ManagementRouteProvider)extension2;
                        }
                        if (extension instanceof akka.management.javadsl.ManagementRouteProvider) {
                            Extension extension3 = extension;
                            return new ManagementRouteProviderAdapter((akka.management.javadsl.ManagementRouteProvider)extension3);
                        }
                        throw new RuntimeException(new StringBuilder(65).append("Extension [").append(fqcn).append("] should create a 'ManagementRouteProvider' but was ").append("[").append(extension.getClass().getName()).append("]").toString());
                    }
                }
                if (bl && (provider2 = success.value()) instanceof ManagementRouteProvider) {
                    ManagementRouteProvider managementRouteProvider = (ManagementRouteProvider)provider2;
                    return managementRouteProvider;
                }
                if (bl && (provider = success.value()) instanceof akka.management.javadsl.ManagementRouteProvider) {
                    akka.management.javadsl.ManagementRouteProvider managementRouteProvider = (akka.management.javadsl.ManagementRouteProvider)provider;
                    return new ManagementRouteProviderAdapter(managementRouteProvider);
                }
                if (bl) {
                    throw new RuntimeException(new StringBuilder(78).append("[").append(fqcn).append("] is not an 'ExtensionIdProvider', 'ExtensionId' or 'ManagementRouteProvider'").toString());
                }
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable problem = failure.exception();
                    throw new RuntimeException(new StringBuilder(51).append("While trying to load route provider extension [").append(name).append(" = ").append(fqcn).append("]").toString(), problem);
                }
                throw new MatchError((Object)try_);
            }
            throw new MatchError((Object)namedRouteProvider);
        });
    }

    private static final Optional credsToJava$1(Credentials cred) {
        Credentials credentials = cred;
        if (credentials instanceof Credentials.Provided) {
            Credentials.Provided provided = (Credentials.Provided)credentials;
            return Optional.of(new SecurityDirectives.ProvidedCredentials(provided));
        }
        return Optional.empty();
    }

    private final Function1 wrapWithAuthenticatorIfPresent$1(Function1 inner, ManagementRouteProviderSettings providerSettings$1) {
        ManagementRouteProviderSettingsImpl providerSettingsImpl = (ManagementRouteProviderSettingsImpl)providerSettings$1;
        Tuple2 tuple2 = new Tuple2(providerSettingsImpl.scaladslAuth(), providerSettingsImpl.javadslAuth());
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option2)) {
                return inner;
            }
        }
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option3 = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                Function1 asyncAuthenticator = (Function1)some.value();
                if (None$.MODULE$.equals(option3)) {
                    return (Function1)Directive$.MODULE$.addDirectiveApply((Directive)Directives$.MODULE$.authenticateBasicAsync("secured", asyncAuthenticator), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)x$2 -> inner);
                }
            }
        }
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option4 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && option4 instanceof Some) {
                Some some = (Some)option4;
                Function auth = (Function)some.value();
                return (Function1)Directive$.MODULE$.addDirectiveApply(Directives$.MODULE$.authenticateBasicAsync("secured", (Function1 & Serializable)c -> FutureConverters.CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps((CompletionStage)auth.apply(AkkaManagement.credsToJava$1(c)))).map((Function1 & Serializable)x$3 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$3)), (ExecutionContext)this.system().dispatcher())).optional(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)x$4 -> inner);
            }
        }
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option5 = (Option)tuple2._2();
            if (option instanceof Some && option5 instanceof Some) {
                throw new IllegalStateException("Unexpected that both scaladsl and javadsl auth were defined");
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public AkkaManagement(ExtendedActorSystem system) {
        this.system = system;
        ((ManifestInfo)ManifestInfo$.MODULE$.apply((ActorSystem)system)).checkSameVersion("Akka Management", (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"akka-discovery-consul", "akka-discovery-aws-api", "akka-discovery-marathon-api", "akka-discovery-aws-api-async", "akka-discovery-kubernetes-api", "akka-management", "akka-management-cluster-bootstrap", "akka-management-cluster-http"})), true);
        this.log = Logging$.MODULE$.withMarker((ActorSystem)system, this.getClass(), LogSource$.MODULE$.fromAnyClass());
        this.settings = new AkkaManagementSettings(system.settings().config());
        this.routeProviders = this.loadRouteProviders();
        this.bindingFuture = new AtomicReference();
        this.selfUriPromise = Promise$.MODULE$.apply();
    }
}

