/*
 * Decompiled with CFR 0.152.
 */
package ujson;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.TraversableOnce;
import scala.collection.TraversableOnce$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.runtime.BoxesRunTime;
import ujson.Arr;
import ujson.Arr$;
import ujson.AstTransformer;
import ujson.Bool;
import ujson.Bool$;
import ujson.False$;
import ujson.JsVisitor;
import ujson.Null$;
import ujson.Num;
import ujson.Num$;
import ujson.Obj;
import ujson.Obj$;
import ujson.Readable;
import ujson.Str;
import ujson.Str$;
import ujson.Transformer;
import ujson.True$;
import ujson.Value;
import upickle.core.Util$;
import upickle.core.Visitor;

public final class Value$
implements AstTransformer<Value> {
    public static Value$ MODULE$;
    private final Str$ Str;
    private final Obj$ Obj;
    private final Arr$ Arr;
    private final Num$ Num;
    private final Bool$ Bool;
    private final True$ True;
    private final False$ False;
    private final Null$ Null;

    static {
        new Value$();
    }

    @Override
    public Object apply(Readable t) {
        return AstTransformer.apply$(this, t);
    }

    @Override
    public <T> T transformArray(Visitor<?, T> f, Iterable<Value> items) {
        return (T)AstTransformer.transformArray$(this, f, items);
    }

    @Override
    public <T> T transformObject(Visitor<?, T> f, Iterable<Tuple2<String, Value>> items) {
        return (T)AstTransformer.transformObject$(this, f, items);
    }

    @Override
    public Object visitFloat32(float d, int index) {
        return JsVisitor.visitFloat32$(this, d, index);
    }

    @Override
    public Object visitInt32(int i, int index) {
        return JsVisitor.visitInt32$(this, i, index);
    }

    @Override
    public Object visitInt64(long i, int index) {
        return JsVisitor.visitInt64$(this, i, index);
    }

    @Override
    public Object visitUInt64(long i, int index) {
        return JsVisitor.visitUInt64$(this, i, index);
    }

    @Override
    public Object visitFloat64String(String s, int index) {
        return JsVisitor.visitFloat64String$(this, s, index);
    }

    @Override
    public Object visitBinary(byte[] bytes, int offset, int len, int index) {
        return JsVisitor.visitBinary$(this, bytes, offset, len, index);
    }

    @Override
    public Object visitFloat64StringParts(CharSequence s, int decIndex, int expIndex) {
        return JsVisitor.visitFloat64StringParts$(this, s, decIndex, expIndex);
    }

    @Override
    public Object visitExt(byte tag, byte[] bytes, int offset, int len, int index) {
        return JsVisitor.visitExt$(this, tag, bytes, offset, len, index);
    }

    @Override
    public Object visitChar(char s, int index) {
        return JsVisitor.visitChar$(this, s, index);
    }

    public <Z> Visitor<Value, Z> map(Function1<Value, Z> f) {
        return Visitor.map$((Visitor)this, f);
    }

    public <Z> Visitor<Value, Z> mapNulls(Function1<Value, Z> f) {
        return Visitor.mapNulls$((Visitor)this, f);
    }

    @Override
    public Readable.fromTransformer transformable(Object j) {
        return Transformer.transformable$(this, j);
    }

    public Str$ Str() {
        return this.Str;
    }

    public Obj$ Obj() {
        return this.Obj;
    }

    public Arr$ Arr() {
        return this.Arr;
    }

    public Num$ Num() {
        return this.Num;
    }

    public Bool$ Bool() {
        return this.Bool;
    }

    public True$ True() {
        return this.True;
    }

    public False$ False() {
        return this.False;
    }

    public Null$ Null() {
        return this.Null;
    }

    public <T> Arr JsonableSeq(TraversableOnce<T> items, Function1<T, Value> f) {
        return this.Arr().from(TraversableOnce$.MODULE$.MonadOps(items).map(f), Predef$.MODULE$.$conforms());
    }

    public <T> Obj JsonableDict(TraversableOnce<Tuple2<String, T>> items, Function1<T, Value> f) {
        return this.Obj().from((TraversableOnce<Tuple2<String, Value>>)TraversableOnce$.MODULE$.MonadOps(items).map((Function1 & Serializable & scala.Serializable)x -> new Tuple2(x._1(), f.apply(x._2()))));
    }

    public Bool JsonableBoolean(boolean i) {
        if (i) {
            return this.True();
        }
        return this.False();
    }

    public Num JsonableByte(byte i) {
        return this.Num().apply(i);
    }

    public Num JsonableShort(short i) {
        return this.Num().apply(i);
    }

    public Num JsonableInt(int i) {
        return this.Num().apply(i);
    }

    public Str JsonableLong(long i) {
        return this.Str().apply(((Object)BoxesRunTime.boxToLong((long)i)).toString());
    }

    public Num JsonableFloat(float i) {
        return this.Num().apply(i);
    }

    public Num JsonableDouble(double i) {
        return this.Num().apply(i);
    }

    public Null$ JsonableNull(scala.runtime.Null$ i) {
        return this.Null();
    }

    public Str JsonableString(CharSequence s) {
        return this.Str().apply(((Object)s).toString());
    }

    @Override
    public <T> T transform(Value j, Visitor<?, T> f) {
        Object object;
        Null$ null$ = this.Null();
        if (!(null$ != null ? !null$.equals(j) : j != null)) {
            object = f.visitNull(-1);
        } else {
            True$ true$ = this.True();
            if (!(true$ != null ? !true$.equals(j) : j != null)) {
                object = f.visitTrue(-1);
            } else {
                False$ false$ = this.False();
                if (!(false$ != null ? !false$.equals(j) : j != null)) {
                    object = f.visitFalse(-1);
                } else if (j instanceof Str) {
                    String s = ((Str)j).value();
                    object = f.visitString((CharSequence)s, -1);
                } else if (j instanceof Num) {
                    double d = ((Num)j).value();
                    object = f.visitFloat64(d, -1);
                } else if (j instanceof Arr) {
                    ArrayBuffer<Value> items = ((Arr)j).value();
                    object = this.transformArray(f, (Iterable<Value>)items);
                } else if (j instanceof Obj) {
                    LinkedHashMap<String, Value> items = ((Obj)j).value();
                    object = this.transformObject(f, (Iterable<Tuple2<String, Value>>)items);
                } else {
                    throw new MatchError((Object)j);
                }
            }
        }
        return (T)object;
    }

    public AstTransformer.AstArrVisitor<ArrayBuffer> visitArray(int length, int index) {
        return new AstTransformer.AstArrVisitor<ArrayBuffer>(this, (Function1 & Serializable & scala.Serializable)xs -> MODULE$.Arr().apply((ArrayBuffer<Value>)xs), ArrayBuffer$.MODULE$.canBuildFrom());
    }

    public AstTransformer.AstObjVisitor<LinkedHashMap<String, Value>> visitObject(int length, int index) {
        return new AstTransformer.AstObjVisitor<LinkedHashMap<String, Value>>(this, (Function1 & Serializable & scala.Serializable)xs -> MODULE$.Obj().apply((LinkedHashMap<String, Value>)xs), LinkedHashMap$.MODULE$.canBuildFrom());
    }

    public Null$ visitNull(int index) {
        return this.Null();
    }

    public False$ visitFalse(int index) {
        return this.False();
    }

    public True$ visitTrue(int index) {
        return this.True();
    }

    public Num visitFloat64StringParts(CharSequence s, int decIndex, int expIndex, int index) {
        return this.Num().apply(decIndex != -1 || expIndex != -1 ? new StringOps(Predef$.MODULE$.augmentString(((Object)s).toString())).toDouble() : (double)Util$.MODULE$.parseIntegralNum(s, decIndex, expIndex, index));
    }

    @Override
    public Num visitFloat64(double d, int index) {
        return this.Num().apply(d);
    }

    public Str visitString(CharSequence s, int index) {
        return this.Str().apply(((Object)s).toString());
    }

    private Value$() {
        MODULE$ = this;
        Transformer.$init$(this);
        Visitor.$init$((Visitor)this);
        JsVisitor.$init$(this);
        AstTransformer.$init$(this);
        this.Str = Str$.MODULE$;
        this.Obj = Obj$.MODULE$;
        this.Arr = Arr$.MODULE$;
        this.Num = Num$.MODULE$;
        this.Bool = Bool$.MODULE$;
        this.True = True$.MODULE$;
        this.False = False$.MODULE$;
        this.Null = Null$.MODULE$;
    }
}

