/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.graphql;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.websocket.WebSocketFrame;
import com.linecorp.armeria.common.websocket.WebSocketWriter;
import com.linecorp.armeria.server.graphql.GraphqlWSSubProtocol;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GraphqlWebSocketSubscriber
implements Subscriber<WebSocketFrame> {
    private static final Logger logger = LoggerFactory.getLogger(GraphqlWebSocketSubscriber.class);
    private final GraphqlWSSubProtocol graphqlWSSubProtocol;
    private final WebSocketWriter outgoing;
    @Nullable
    private Subscription subscription;

    GraphqlWebSocketSubscriber(GraphqlWSSubProtocol graphqlWSSubProtocol, WebSocketWriter outgoing) {
        this.graphqlWSSubProtocol = graphqlWSSubProtocol;
        this.outgoing = outgoing;
    }

    public void onSubscribe(Subscription s) {
        this.subscription = s;
        s.request(1L);
    }

    public void onNext(WebSocketFrame webSocketFrame) {
        logger.trace("onNext: {}", (Object)webSocketFrame);
        assert (this.subscription != null);
        switch (webSocketFrame.type()) {
            case BINARY: {
                this.graphqlWSSubProtocol.handleBinary(this.outgoing);
                break;
            }
            case TEXT: {
                this.graphqlWSSubProtocol.handleText(webSocketFrame.text(), this.outgoing);
                this.subscription.request(1L);
                break;
            }
            case PING: {
                this.outgoing.writePong();
                this.subscription.request(1L);
                break;
            }
            case CLOSE: {
                this.outgoing.close();
                break;
            }
            case PONG: {
                this.subscription.request(1L);
                break;
            }
            case CONTINUATION: {
                logger.trace("Ignoring frame type: {}", (Object)webSocketFrame.type());
                this.subscription.request(1L);
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    public void onError(Throwable t) {
        logger.trace("onError", t);
        this.graphqlWSSubProtocol.cancel();
        this.subscription = null;
    }

    public void onComplete() {
        logger.trace("onComplete");
        this.graphqlWSSubProtocol.cancel();
        this.subscription = null;
    }
}

