/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.demo.neo4j;

import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ReturnableEvaluator;
import org.neo4j.graphdb.StopEvaluator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.Traverser;
import org.neo4j.tooling.GlobalGraphOperations;

public class MatrixManager {
    private GraphDatabaseService graphDb;

    public MatrixManager(GraphDatabaseService graphDatabaseService) {
        this.graphDb = graphDatabaseService;
    }

    public int countNeoFriends() {
        Node neoNode = this.getNeoNode();
        Traverser friendsTraverser = this.getFriends(neoNode);
        return friendsTraverser.getAllNodes().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNeoFriend(String name, int age) {
        Transaction tx = this.graphDb.beginTx();
        try {
            Node friend = this.graphDb.createNode();
            friend.setProperty("name", (Object)name);
            Relationship relationship = this.getNeoNode().createRelationshipTo(friend, (RelationshipType)RelTypes.KNOWS);
            relationship.setProperty("age", (Object)age);
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    private Traverser getFriends(Node person) {
        return person.traverse(Traverser.Order.BREADTH_FIRST, StopEvaluator.END_OF_GRAPH, ReturnableEvaluator.ALL_BUT_START_NODE, (RelationshipType)RelTypes.KNOWS, Direction.OUTGOING);
    }

    public Node getNeoNode() {
        ResourceIterable allNodes = GlobalGraphOperations.at((GraphDatabaseService)this.graphDb).getAllNodes();
        for (Node node : allNodes) {
            if (!"Thomas Anderson".equals(node.getProperty("name"))) continue;
            return node;
        }
        return null;
    }

    public static enum RelTypes implements RelationshipType
    {
        NEO_NODE,
        KNOWS,
        CODED_BY;

    }
}

