/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.elasticsearch;

import com.lordofthejars.nosqlunit.core.AbstractLifecycleManager;
import com.lordofthejars.nosqlunit.elasticsearch.EmbeddedElasticsearchInstancesFactory;
import java.io.File;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedElasticsearchLifecycleManager
extends AbstractLifecycleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmbeddedElasticsearchLifecycleManager.class);
    private static final String LOCALHOST = "127.0.0.1";
    private static final int DEFAULT_PORT = 9300;
    private static final String DATA_PATH_PROPERTY = "path.data";
    public static final String EMBEDDED_ELASTICSEARCH_TARGET_PATH = "target" + File.separatorChar + "elasticsearch-test-data" + File.separatorChar + "impermanent-db";
    private String targetPath = EMBEDDED_ELASTICSEARCH_TARGET_PATH;
    private NodeBuilder nodeBuilder = NodeBuilder.nodeBuilder().local(true);

    public String getHost() {
        return LOCALHOST + this.targetPath;
    }

    public int getPort() {
        return 9300;
    }

    public void doStart() throws Throwable {
        LOGGER.info("Starting Embedded Elasticsearch instance.");
        this.nodeBuilder.getSettings().put(DATA_PATH_PROPERTY, this.targetPath);
        Node node = this.elasticsearchNode();
        EmbeddedElasticsearchInstancesFactory.getInstance().addEmbeddedInstance((Object)node, this.targetPath);
        LOGGER.info("Started Embedded Elasticsearch instance.");
    }

    private Node elasticsearchNode() {
        return this.nodeBuilder.node();
    }

    public void doStop() {
        LOGGER.info("Stopping Embedded Elasticsearch instance.");
        Node node = (Node)EmbeddedElasticsearchInstancesFactory.getInstance().getEmbeddedByTargetPath(this.targetPath);
        if (node != null) {
            node.close();
        }
        EmbeddedElasticsearchInstancesFactory.getInstance().removeEmbeddedInstance(this.targetPath);
        LOGGER.info("Stopped Embedded Elasticsearch instance.");
    }

    public void setSettings(Settings settings) {
        this.nodeBuilder.settings(settings);
    }

    public void setLoadConfigSettings(boolean loadConfigSettings) {
        this.nodeBuilder.loadConfigSettings(loadConfigSettings);
    }

    public void setClient(boolean client) {
        this.nodeBuilder.client(client);
    }

    public void setClusterName(String clusterName) {
        this.nodeBuilder.clusterName(clusterName);
    }

    public void setData(boolean data) {
        this.nodeBuilder.data(data);
    }

    public void setLocal(boolean local) {
        this.nodeBuilder.local(local);
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public void setTargetPath(String targetPath) {
        this.targetPath = targetPath;
    }
}

