/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.infinispan;

import com.lordofthejars.nosqlunit.core.AbstractCustomizableDatabaseOperation;
import com.lordofthejars.nosqlunit.core.NoSqlAssertionError;
import com.lordofthejars.nosqlunit.infinispan.DefaultInfinispanComparisonStrategy;
import com.lordofthejars.nosqlunit.infinispan.DefaultInfinispanInsertionStrategy;
import com.lordofthejars.nosqlunit.infinispan.InfinispanConnectionCallback;
import java.io.InputStream;
import org.infinispan.api.BasicCache;

public class InfinispanOperation
extends AbstractCustomizableDatabaseOperation<InfinispanConnectionCallback, BasicCache<Object, Object>> {
    private BasicCache<Object, Object> cache;

    public InfinispanOperation(BasicCache<Object, Object> cache) {
        this.cache = cache;
        this.setInsertionStrategy(new DefaultInfinispanInsertionStrategy());
        this.setComparisonStrategy(new DefaultInfinispanComparisonStrategy());
    }

    public void insert(InputStream dataScript) {
        this.insertData(dataScript);
    }

    private void insertData(InputStream dataScript) {
        try {
            this.executeInsertion(new InfinispanConnectionCallback(){

                @Override
                public BasicCache<Object, Object> basicCache() {
                    return InfinispanOperation.this.cache;
                }
            }, dataScript);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void deleteAll() {
        this.cache.clear();
    }

    public boolean databaseIs(InputStream expectedData) {
        return this.compareData(expectedData);
    }

    private boolean compareData(InputStream expectedData) throws NoSqlAssertionError {
        try {
            return this.executeComparison(new InfinispanConnectionCallback(){

                @Override
                public BasicCache<Object, Object> basicCache() {
                    return InfinispanOperation.this.cache;
                }
            }, expectedData);
        }
        catch (NoSqlAssertionError e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    public BasicCache connectionManager() {
        return this.cache;
    }
}

