/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.mongodb;

import com.lordofthejars.nosqlunit.core.FailureHandler;
import com.lordofthejars.nosqlunit.mongodb.EmbeddedMongoInstancesFactory;
import com.lordofthejars.nosqlunit.mongodb.MongoDbConfiguration;
import com.mongodb.Mongo;

public class InMemoryMongoDbConfigurationBuilder {
    private MongoDbConfiguration mongoDbConfiguration = new MongoDbConfiguration();

    public static InMemoryMongoDbConfigurationBuilder inMemoryMongoDb() {
        return new InMemoryMongoDbConfigurationBuilder();
    }

    private InMemoryMongoDbConfigurationBuilder() {
    }

    public InMemoryMongoDbConfigurationBuilder databaseName(String databaseName) {
        this.mongoDbConfiguration.setDatabaseName(databaseName);
        return this;
    }

    public InMemoryMongoDbConfigurationBuilder connectionIdentifier(String connectionIdentifier) {
        this.mongoDbConfiguration.setConnectionIdentifier(connectionIdentifier);
        return this;
    }

    public MongoDbConfiguration build() {
        Mongo embeddedMongo = (Mongo)EmbeddedMongoInstancesFactory.getInstance().getDefaultEmbeddedInstance();
        if (embeddedMongo == null) {
            throw FailureHandler.createIllegalStateFailure((String)"There is no EmbeddedMongo rule with default target defined during test execution. Please create one using @Rule or @ClassRule before executing these tests.", (Object[])new Object[0]);
        }
        if (this.mongoDbConfiguration.getDatabaseName() == null) {
            throw FailureHandler.createIllegalStateFailure((String)"There is no database defined.", (Object[])new Object[0]);
        }
        this.mongoDbConfiguration.setMongo(embeddedMongo);
        return this.mongoDbConfiguration;
    }

    public MongoDbConfiguration buildFromTargetPath(String targetPath) {
        Mongo embeddedMongo = (Mongo)EmbeddedMongoInstancesFactory.getInstance().getEmbeddedByTargetPath(targetPath);
        if (embeddedMongo == null) {
            throw FailureHandler.createIllegalStateFailure((String)"There is no EmbeddedMongo rule with default target defined during test execution. Please create one using @Rule or @ClassRule before executing these tests.", (Object[])new Object[0]);
        }
        if (this.mongoDbConfiguration.getDatabaseName() == null) {
            throw FailureHandler.createIllegalStateFailure((String)"There is no database defined.", (Object[])new Object[0]);
        }
        this.mongoDbConfiguration.setMongo(embeddedMongo);
        return this.mongoDbConfiguration;
    }
}

