/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.graph.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class Edge {
    private String id;
    private String sourceNodeId;
    private String targetNodeId;
    private String label;
    private Map<String, Object> props = new HashMap<String, Object>();
    private List<ManualIndex> manualIndexes = new ArrayList<ManualIndex>();

    public Edge(String id, String sourceNodeId, String targetNodeId, String label) {
        this.id = id;
        this.sourceNodeId = sourceNodeId;
        this.targetNodeId = targetNodeId;
        this.label = label;
    }

    public Relationship createLink(Map<String, Node> nodes) {
        Node sourceNode = nodes.get(this.sourceNodeId);
        Node targetNode = nodes.get(this.targetNodeId);
        Relationship relationship = sourceNode.createRelationshipTo(targetNode, (RelationshipType)DynamicRelationshipType.withName((String)this.label));
        Set<String> keys = this.props.keySet();
        for (String key : keys) {
            relationship.setProperty(key, this.props.get(key));
        }
        return relationship;
    }

    public void createManualIndexes(GraphDatabaseService graphDatabaseService, Relationship relationship) {
        for (ManualIndex manualIndex : this.manualIndexes) {
            if (manualIndex.getConfiguration() == null) {
                graphDatabaseService.index().forRelationships(manualIndex.getIndexName()).add((PropertyContainer)relationship, manualIndex.getKey(), (Object)manualIndex.getValue());
                continue;
            }
            graphDatabaseService.index().forRelationships(manualIndex.getIndexName(), manualIndex.getConfiguration()).add((PropertyContainer)relationship, manualIndex.getKey(), (Object)manualIndex.getValue());
        }
    }

    public void putManualIndex(String indexName, String indexKey, String indexValue) {
        this.putManualIndex(indexName, indexKey, indexValue, null);
    }

    public void putManualIndex(String indexName, String indexKey, String indexValue, Map<String, String> configuration) {
        this.manualIndexes.add(new ManualIndex(indexName, indexKey, indexValue, configuration));
    }

    public void putData(String key, Object data) {
        this.props.put(key, data);
    }

    public String getLabel() {
        return this.label;
    }

    public String getId() {
        return this.id;
    }

    public String getSourceNodeId() {
        return this.sourceNodeId;
    }

    public String getTargetNodeId() {
        return this.targetNodeId;
    }

    public Map<String, Object> getProps() {
        return this.props;
    }

    public String toString() {
        return "Edge [id=" + this.id + ", sourceNodeId=" + this.sourceNodeId + ", targetNodeId=" + this.targetNodeId + ", label=" + this.label + "]";
    }

    private class ManualIndex {
        private String indexName;
        private String key;
        private String value;
        private Map<String, String> configuration;

        public ManualIndex(String indexName, String key, String value) {
            this.indexName = indexName;
            this.key = key;
            this.value = value;
        }

        public ManualIndex(String indexName, String key, String value, Map<String, String> configuration) {
            this.indexName = indexName;
            this.key = key;
            this.value = value;
            this.configuration = configuration;
        }

        public String getIndexName() {
            return this.indexName;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public Map<String, String> getConfiguration() {
            return this.configuration;
        }
    }
}

