/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.graph.parser;

import com.google.common.base.Strings;
import com.lordofthejars.nosqlunit.graph.parser.Edge;
import com.lordofthejars.nosqlunit.graph.parser.TypeCaster;
import java.io.IOError;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.helpers.collection.MapUtil;

public class GraphMLReader {
    private GraphDatabaseService graphDatabaseService;

    public GraphMLReader(GraphDatabaseService graphDatabaseService) {
        this.graphDatabaseService = graphDatabaseService;
    }

    public void read(InputStream stream) {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        try {
            XMLStreamReader reader = inputFactory.createXMLStreamReader(stream);
            HashMap<String, String> keyIdMap = new HashMap<String, String>();
            HashMap<String, String> keyTypesForNodes = new HashMap<String, String>();
            HashMap<String, String> keyTypesForEdges = new HashMap<String, String>();
            HashMap<String, String> keyAutoindexesForNodes = new HashMap<String, String>();
            HashMap<String, String> keyAutoindexesForEdges = new HashMap<String, String>();
            HashMap<String, Node> nodes = new HashMap<String, Node>();
            ArrayList<Edge> orphanEdges = new ArrayList<Edge>();
            Node currentNode = null;
            Edge currentEdge = null;
            String currentVertexId = null;
            String currentEdgeId = null;
            boolean inVertex = false;
            boolean inEdge = false;
            int graphDepth = 0;
            while (reader.hasNext()) {
                String elementName;
                Integer eventType = reader.next();
                if (eventType.equals(1)) {
                    elementName = reader.getName().getLocalPart();
                    if (elementName.equals("key")) {
                        String id = reader.getAttributeValue(null, "id");
                        String attributeName = reader.getAttributeValue(null, "attr.name");
                        String attributeType = reader.getAttributeValue(null, "attr.type");
                        String attributeAutoindexName = reader.getAttributeValue(null, "attr.autoindexName");
                        String attributeFor = reader.getAttributeValue(null, "for");
                        keyIdMap.put(id, attributeName);
                        if ("node".equalsIgnoreCase(attributeFor)) {
                            keyTypesForNodes.put(attributeName, attributeType);
                            if (attributeAutoindexName == null) continue;
                            keyAutoindexesForNodes.put(attributeName, attributeAutoindexName);
                            continue;
                        }
                        if (!"edge".equalsIgnoreCase(attributeFor)) continue;
                        keyTypesForEdges.put(attributeName, attributeType);
                        if (attributeAutoindexName == null) continue;
                        keyAutoindexesForEdges.put(attributeName, attributeAutoindexName);
                        continue;
                    }
                    if (elementName.equals("node") && this.isRootGraph(graphDepth)) {
                        currentVertexId = reader.getAttributeValue(null, "id");
                        if (currentVertexId != null) {
                            Node node;
                            currentNode = node = this.graphDatabaseService.createNode();
                            nodes.put(currentVertexId, node);
                        }
                        inVertex = true;
                        continue;
                    }
                    if (elementName.equals("edge") && this.isRootGraph(graphDepth)) {
                        currentEdgeId = reader.getAttributeValue(null, "id");
                        String edgeLabel = reader.getAttributeValue(null, "label");
                        edgeLabel = edgeLabel == null ? "_default" : edgeLabel;
                        String sourceId = reader.getAttributeValue(null, "source");
                        String targetId = reader.getAttributeValue(null, "target");
                        currentEdge = new Edge(currentEdgeId, sourceId, targetId, edgeLabel);
                        inEdge = true;
                        continue;
                    }
                    if (elementName.equals("data") && this.isRootGraph(graphDepth)) {
                        Object typeCastValue;
                        String value;
                        String attributeName = reader.getAttributeValue(null, "key");
                        if (this.isInsideNodeTag(inVertex)) {
                            if (keyTypesForNodes.containsKey(attributeName)) {
                                value = reader.getElementText();
                                typeCastValue = TypeCaster.typeCastValue(attributeName, value, keyTypesForNodes);
                                if ("id".equals(attributeName)) {
                                    throw new IllegalArgumentException("id key is reserved for node. Node with errorneous data: " + currentVertexId);
                                }
                                if (currentNode == null) continue;
                                currentNode.setProperty(attributeName, typeCastValue);
                                if (!keyAutoindexesForNodes.containsKey(attributeName)) continue;
                                String autoindexName = (String)keyAutoindexesForNodes.get(attributeName);
                                this.graphDatabaseService.index().forNodes(autoindexName).add((PropertyContainer)currentNode, attributeName, typeCastValue);
                                continue;
                            }
                            throw new IllegalArgumentException("Attribute key: " + attributeName + " is not declared.");
                        }
                        if (!this.isInsideEdgeTag(inEdge)) continue;
                        if (keyTypesForEdges.containsKey(attributeName)) {
                            value = reader.getElementText();
                            typeCastValue = TypeCaster.typeCastValue(attributeName, value, keyTypesForEdges);
                            if ("label".equals(attributeName)) {
                                throw new IllegalArgumentException("label key is reserved for edge. Edge with errorneous data:  " + currentEdgeId);
                            }
                            if (currentEdge == null) continue;
                            currentEdge.putData(attributeName, typeCastValue);
                            continue;
                        }
                        throw new IllegalArgumentException("Attribute key: " + attributeName + " is not declared.");
                    }
                    if (elementName.equals("index") && this.isRootGraph(graphDepth)) {
                        String[] indexConfigurationTokens;
                        String indexData;
                        String indexConfiguration;
                        String indexKey;
                        String indexName;
                        if (this.isInsideNodeTag(inVertex)) {
                            indexName = reader.getAttributeValue(null, "name");
                            indexKey = reader.getAttributeValue(null, "key");
                            indexConfiguration = reader.getAttributeValue(null, "configuration");
                            indexData = reader.getElementText();
                            if (Strings.isNullOrEmpty((String)indexConfiguration)) {
                                this.graphDatabaseService.index().forNodes(indexName).add((PropertyContainer)currentNode, indexKey, (Object)indexData);
                                continue;
                            }
                            indexConfigurationTokens = indexConfiguration.split(",");
                            this.graphDatabaseService.index().forNodes(indexName, MapUtil.stringMap((String[])indexConfigurationTokens)).add((PropertyContainer)currentNode, indexKey, (Object)indexData);
                            continue;
                        }
                        if (!this.isInsideEdgeTag(inEdge)) continue;
                        indexName = reader.getAttributeValue(null, "name");
                        indexKey = reader.getAttributeValue(null, "key");
                        indexConfiguration = reader.getAttributeValue(null, "configuration");
                        indexData = reader.getElementText();
                        if (Strings.isNullOrEmpty((String)indexConfiguration)) {
                            currentEdge.putManualIndex(indexName, indexKey, indexData);
                            continue;
                        }
                        indexConfigurationTokens = indexConfiguration.split(",");
                        currentEdge.putManualIndex(indexName, indexKey, indexData, MapUtil.stringMap((String[])indexConfigurationTokens));
                        continue;
                    }
                    if (!elementName.equals("graph")) continue;
                    ++graphDepth;
                    continue;
                }
                if (!eventType.equals(2)) continue;
                elementName = reader.getName().getLocalPart();
                if (elementName.equals("node") && this.isRootGraph(graphDepth)) {
                    currentNode = null;
                    currentVertexId = null;
                    inVertex = false;
                    continue;
                }
                if (elementName.equals("edge") && this.isRootGraph(graphDepth)) {
                    this.addEdge(nodes, orphanEdges, currentEdge, keyAutoindexesForEdges);
                    currentEdge = null;
                    currentEdgeId = null;
                    inEdge = false;
                    continue;
                }
                if (elementName.equals("graphml")) {
                    this.addOrphanEdgesWithNewParents(nodes, orphanEdges, keyAutoindexesForEdges);
                    continue;
                }
                if (!elementName.equals("graph")) continue;
                --graphDepth;
            }
            reader.close();
        }
        catch (XMLStreamException e) {
            throw new IOError(e);
        }
    }

    private boolean isRootGraph(int graphDepth) {
        return graphDepth == 1;
    }

    private void addOrphanEdgesWithNewParents(Map<String, Node> nodes, List<Edge> edgesWithoutNodeDefined, Map<String, String> indexes) {
        for (Edge edge : edgesWithoutNodeDefined) {
            if (this.isEdgeInsertable(edge, nodes)) {
                Relationship relationship = edge.createLink(nodes);
                edge.createManualIndexes(this.graphDatabaseService, relationship);
                this.createRelationshipAutoIndexes(relationship, edge.getProps(), indexes);
                continue;
            }
            throw new IllegalArgumentException("Next edge's nodes has not been declared. " + edge);
        }
    }

    private void addEdge(Map<String, Node> nodes, List<Edge> edgesWithoutNodeDefinedPreviously, Edge currentEdge, Map<String, String> indexes) {
        if (currentEdge != null && this.isEdgeInsertable(currentEdge, nodes)) {
            Relationship relationship = currentEdge.createLink(nodes);
            currentEdge.createManualIndexes(this.graphDatabaseService, relationship);
            this.createRelationshipAutoIndexes(relationship, currentEdge.getProps(), indexes);
        } else if (currentEdge != null) {
            edgesWithoutNodeDefinedPreviously.add(currentEdge);
        }
    }

    private void createRelationshipAutoIndexes(Relationship relationship, Map<String, Object> props, Map<String, String> indexes) {
        for (String prop : props.keySet()) {
            if (!indexes.containsKey(prop)) continue;
            String indexName = indexes.get(prop);
            this.graphDatabaseService.index().forRelationships(indexName).add((PropertyContainer)relationship, prop, props.get(prop));
        }
    }

    private boolean isEdgeInsertable(Edge edge, Map<String, Node> nodes) {
        return nodes.containsKey(edge.getSourceNodeId()) && nodes.containsKey(edge.getTargetNodeId());
    }

    private boolean isInsideEdgeTag(boolean inEdge) {
        return inEdge;
    }

    private boolean isInsideNodeTag(boolean inVertex) {
        return this.isInsideEdgeTag(inVertex);
    }
}

