/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.graph.parser;

import com.lordofthejars.nosqlunit.graph.parser.TypeCaster;
import com.lordofthejars.nosqlunit.neo4j.Neo4jLowLevelOps;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;

public class GraphMLWriter {
    private GraphDatabaseService graphDatabaseService;
    private String xmlSchemaLocation;

    public GraphMLWriter(GraphDatabaseService graphDatabaseService) {
        this.graphDatabaseService = graphDatabaseService;
    }

    public void write(OutputStream os) throws XMLStreamException {
        Map<String, String> vertexKeyTypes = Collections.EMPTY_MAP;
        Map<String, String> edgeKeyTypes = Collections.EMPTY_MAP;
        List<Node> nodes = this.loadAllNodes();
        vertexKeyTypes = this.findNodeKeys(nodes);
        List<Relationship> relationships = this.loadAllRelationships();
        edgeKeyTypes = this.findRelationshipKeys(relationships);
        XMLOutputFactory inputFactory = XMLOutputFactory.newInstance();
        XMLStreamWriter writer = inputFactory.createXMLStreamWriter(os, "UTF8");
        writer.writeStartDocument();
        this.writeRootNode(writer);
        this.writeKeysForEdges(edgeKeyTypes, writer);
        this.writeKeysForNodes(vertexKeyTypes, writer);
        this.writeGraphElement(writer);
        this.writeNodes(nodes, writer);
        this.writeRelationships(relationships, writer);
        this.writeEndGraphs(writer);
        writer.writeEndDocument();
        writer.flush();
        writer.close();
    }

    private List<Relationship> loadAllRelationships() {
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        Iterator<Relationship> relationshipIterator = Neo4jLowLevelOps.getAllRelationships(this.graphDatabaseService);
        while (relationshipIterator.hasNext()) {
            relationships.add(relationshipIterator.next());
        }
        return relationships;
    }

    private List<Node> loadAllNodes() {
        ArrayList<Node> nodes = new ArrayList<Node>();
        Iterator<Node> nodeIterator = Neo4jLowLevelOps.getAllNodes(this.graphDatabaseService);
        while (nodeIterator.hasNext()) {
            nodes.add(nodeIterator.next());
        }
        return nodes;
    }

    private Map<String, String> findRelationshipKeys(Iterable<Relationship> relationships) {
        HashMap<String, String> edgeKeyTypes = new HashMap<String, String>();
        for (Relationship relationship : relationships) {
            Iterable keys = relationship.getPropertyKeys();
            for (String key : keys) {
                if (edgeKeyTypes.containsKey(key)) continue;
                edgeKeyTypes.put(key, TypeCaster.getStringType(relationship.getProperty(key)));
            }
        }
        return edgeKeyTypes;
    }

    private Map<String, String> findNodeKeys(Iterable<Node> nodes) {
        HashMap<String, String> vertexKeyTypes = new HashMap<String, String>();
        for (Node node : nodes) {
            Iterable keys = node.getPropertyKeys();
            for (String key : keys) {
                if (vertexKeyTypes.containsKey(key)) continue;
                vertexKeyTypes.put(key, TypeCaster.getStringType(node.getProperty(key)));
            }
        }
        return vertexKeyTypes;
    }

    private void writeEndGraphs(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private void writeRelationships(List<Relationship> relationships, XMLStreamWriter writer) throws XMLStreamException {
        for (Relationship edge : relationships) {
            writer.writeStartElement("edge");
            writer.writeAttribute("id", Long.toString(edge.getId()));
            writer.writeAttribute("source", Long.toString(edge.getStartNode().getId()));
            writer.writeAttribute("target", Long.toString(edge.getEndNode().getId()));
            writer.writeAttribute("label", edge.getType().name());
            for (String key : edge.getPropertyKeys()) {
                writer.writeStartElement("data");
                writer.writeAttribute("key", key);
                Object value = edge.getProperty(key);
                if (null != value) {
                    if (TypeCaster.isArray(value)) {
                        this.writeArray(value, writer);
                    } else {
                        writer.writeCharacters(value.toString());
                    }
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writeArray(Object array, XMLStreamWriter writer) throws XMLStreamException {
        int length = Array.getLength(array);
        for (int i = 0; i < length - 1; ++i) {
            Object arrayElement = Array.get(array, i);
            writer.writeCharacters(arrayElement.toString());
            writer.writeCharacters(", ");
        }
        if (length > 0) {
            writer.writeCharacters(Array.get(array, length - 1).toString());
        }
    }

    private void writeNodes(List<Node> nodes, XMLStreamWriter writer) throws XMLStreamException {
        for (Node node : nodes) {
            writer.writeStartElement("node");
            writer.writeAttribute("id", Long.toString(node.getId()));
            Iterable keys = node.getPropertyKeys();
            for (String key : keys) {
                writer.writeStartElement("data");
                writer.writeAttribute("key", key);
                Object value = node.getProperty(key);
                if (null != value) {
                    writer.writeCharacters(value.toString());
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writeGraphElement(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("graph");
        writer.writeAttribute("id", "G");
        writer.writeAttribute("edgedefault", "directed");
    }

    private void writeRootNode(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("graphml");
        writer.writeAttribute("xmlns", "http://graphml.graphdrawing.org/xmlns");
        writer.writeAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        writer.writeAttribute("xsi:schemaLocation", "http://graphml.graphdrawing.org/xmlns " + (this.xmlSchemaLocation == null ? "http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd" : this.xmlSchemaLocation));
    }

    private void writeKeysForNodes(Map<String, String> vertexKeyTypes, XMLStreamWriter writer) throws XMLStreamException {
        for (String key : vertexKeyTypes.keySet()) {
            writer.writeStartElement("key");
            writer.writeAttribute("id", key);
            writer.writeAttribute("for", "node");
            writer.writeAttribute("attr.name", key);
            writer.writeAttribute("attr.type", vertexKeyTypes.get(key));
            writer.writeEndElement();
        }
    }

    private void writeKeysForEdges(Map<String, String> edgeKeyTypes, XMLStreamWriter writer) throws XMLStreamException {
        for (String key : edgeKeyTypes.keySet()) {
            writer.writeStartElement("key");
            writer.writeAttribute("id", key);
            writer.writeAttribute("for", "edge");
            writer.writeAttribute("attr.name", key);
            writer.writeAttribute("attr.type", edgeKeyTypes.get(key));
            writer.writeEndElement();
        }
    }
}

