/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.neo4j;

import com.lordofthejars.nosqlunit.core.FailureHandler;
import com.lordofthejars.nosqlunit.core.NoSqlAssertionError;
import com.lordofthejars.nosqlunit.graph.parser.GraphMLWriter;
import com.lordofthejars.nosqlunit.neo4j.Neo4jComparisonStrategy;
import com.lordofthejars.nosqlunit.neo4j.Neo4jConnectionCallback;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.custommonkey.xmlunit.DetailedDiff;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.Difference;
import org.custommonkey.xmlunit.ElementNameAndAttributeQualifier;
import org.custommonkey.xmlunit.ElementQualifier;
import org.custommonkey.xmlunit.XMLUnit;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DefaultNeo4jComparisonStrategy
implements Neo4jComparisonStrategy {
    private static String EOL = System.getProperty("line.separator");

    public boolean compare(Neo4jConnectionCallback connection, InputStream dataset) throws NoSqlAssertionError, Throwable {
        ByteArrayInputStream neo4jGraphMlRepresentation = this.getNeo4jContent(connection.graphDatabaseService());
        return this.compareContents(dataset, neo4jGraphMlRepresentation);
    }

    public void setIgnoreProperties(String[] ignoreProperties) {
    }

    private boolean compareContents(InputStream expectedData, ByteArrayInputStream neo4jGraphMlRepresentation) {
        try {
            this.configureXmlUnit();
            Diff diff = new Diff(new InputSource(neo4jGraphMlRepresentation), new InputSource(expectedData));
            diff.overrideElementQualifier((ElementQualifier)new ElementNameAndAttributeQualifier());
            if (diff.similar()) {
                return true;
            }
            String differenceMessage = this.buildDifferenceMessage(diff);
            throw FailureHandler.createFailure((String)differenceMessage, (Object[])new Object[0]);
        }
        catch (SAXException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteArrayInputStream getNeo4jContent(GraphDatabaseService graphDatabaseService) {
        Transaction tx = graphDatabaseService.beginTx();
        ByteArrayInputStream neo4jGraphMlRepresentation = null;
        try {
            GraphMLWriter graphMLWriter = new GraphMLWriter(graphDatabaseService);
            neo4jGraphMlRepresentation = this.readNeo4jData(graphMLWriter);
            tx.success();
        }
        finally {
            tx.finish();
        }
        return neo4jGraphMlRepresentation;
    }

    private String buildDifferenceMessage(Diff diff) {
        DetailedDiff detailedDiff = new DetailedDiff(diff);
        List differences = detailedDiff.getAllDifferences();
        StringBuilder message = new StringBuilder("Some differences has been found between database data and expected data:");
        message.append(EOL);
        for (Difference difference : differences) {
            message.append("************************");
            message.append(difference);
            message.append("************************");
        }
        String differenceMessage = message.toString();
        return differenceMessage;
    }

    private void configureXmlUnit() {
        XMLUnit.setIgnoreComments((boolean)true);
        XMLUnit.setIgnoreWhitespace((boolean)true);
        XMLUnit.setNormalizeWhitespace((boolean)true);
        XMLUnit.setIgnoreDiffBetweenTextAndCDATA((boolean)true);
        XMLUnit.setCompareUnmatched((boolean)false);
        XMLUnit.setIgnoreAttributeOrder((boolean)true);
    }

    private ByteArrayInputStream readNeo4jData(GraphMLWriter graphMLWriter) {
        ByteArrayInputStream neo4jGraphMlRepresentation;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            graphMLWriter.write(byteArrayOutputStream);
            neo4jGraphMlRepresentation = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        }
        catch (XMLStreamException e) {
            throw new IllegalArgumentException(e);
        }
        return neo4jGraphMlRepresentation;
    }
}

