/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.neo4j;

import com.lordofthejars.nosqlunit.core.AbstractCustomizableDatabaseOperation;
import com.lordofthejars.nosqlunit.core.NoSqlAssertionError;
import com.lordofthejars.nosqlunit.neo4j.DefaultNeo4jComparisonStrategy;
import com.lordofthejars.nosqlunit.neo4j.DefaultNeo4jInsertionStrategy;
import com.lordofthejars.nosqlunit.neo4j.Neo4jConnectionCallback;
import com.lordofthejars.nosqlunit.neo4j.Neo4jLowLevelOps;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.IndexManager;

public class Neo4jOperation
extends AbstractCustomizableDatabaseOperation<Neo4jConnectionCallback, GraphDatabaseService> {
    private GraphDatabaseService graphDatabaseService;

    public Neo4jOperation(GraphDatabaseService graphDatabaseService) {
        this.graphDatabaseService = graphDatabaseService;
        this.setInsertionStrategy(new DefaultNeo4jInsertionStrategy());
        this.setComparisonStrategy(new DefaultNeo4jComparisonStrategy());
    }

    public void insert(InputStream dataScript) {
        this.insertData(dataScript);
    }

    private void insertData(InputStream dataScript) {
        try {
            this.executeInsertion(new Neo4jConnectionCallback(){

                @Override
                public GraphDatabaseService graphDatabaseService() {
                    return Neo4jOperation.this.graphDatabaseService;
                }
            }, dataScript);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll() {
        try (Transaction tx = this.beginTx();){
            Iterator<Node> allNodes = Neo4jLowLevelOps.getAllNodes(this.graphDatabaseService);
            Iterator<Relationship> allRelationships = Neo4jLowLevelOps.getAllRelationships(this.graphDatabaseService);
            this.removeAllRelationships(allRelationships);
            this.removeAllNodes(allNodes);
            this.removeAllIndexes();
            tx.success();
        }
    }

    private Transaction beginTx() {
        return this.graphDatabaseService.beginTx();
    }

    private void removeAllIndexes() {
        IndexManager indexManager = this.graphDatabaseService.index();
        this.deleteNodeIndexes(indexManager);
        this.deleteRelationshipIndexes(indexManager);
    }

    private void deleteRelationshipIndexes(IndexManager indexManager) {
        String[] relationshipIndexNames;
        for (String relationshipIndexName : relationshipIndexNames = indexManager.relationshipIndexNames()) {
            indexManager.forRelationships(relationshipIndexName).delete();
        }
    }

    private void deleteNodeIndexes(IndexManager indexManager) {
        String[] nodeIndexNames;
        for (String nodeIndexName : nodeIndexNames = indexManager.nodeIndexNames()) {
            indexManager.forNodes(nodeIndexName).delete();
        }
    }

    private void removeAllNodes(Iterator<Node> allNodes) {
        while (allNodes.hasNext()) {
            Node node = allNodes.next();
            node.delete();
        }
    }

    private void removeAllRelationships(Iterator<Relationship> allRelationships) {
        while (allRelationships.hasNext()) {
            allRelationships.next().delete();
        }
    }

    public boolean databaseIs(InputStream expectedData) {
        return this.compareData(expectedData);
    }

    private boolean compareData(InputStream expectedData) throws NoSqlAssertionError {
        try {
            return this.executeComparison(new Neo4jConnectionCallback(){

                @Override
                public GraphDatabaseService graphDatabaseService() {
                    return Neo4jOperation.this.graphDatabaseService;
                }
            }, expectedData);
        }
        catch (NoSqlAssertionError e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    public GraphDatabaseService connectionManager() {
        return this.graphDatabaseService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Node> getAllNodes() {
        try (Transaction tx = this.beginTx();){
            ArrayList<Node> result = new ArrayList<Node>(1000);
            Iterator<Node> it = Neo4jLowLevelOps.getAllNodes(this.graphDatabaseService);
            while (it.hasNext()) {
                result.add(it.next());
            }
            tx.success();
            ArrayList<Node> arrayList = result;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Relationship> getAllRelationships() {
        try (Transaction tx = this.beginTx();){
            ArrayList<Relationship> result = new ArrayList<Relationship>(1000);
            Iterator<Relationship> it = Neo4jLowLevelOps.getAllRelationships(this.graphDatabaseService);
            while (it.hasNext()) {
                result.add(it.next());
            }
            tx.success();
            ArrayList<Relationship> arrayList = result;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] nodeIndexNames() {
        try (Transaction tx = this.beginTx();){
            String[] names = this.graphDatabaseService.index().nodeIndexNames();
            tx.success();
            String[] stringArray = names;
            return stringArray;
        }
    }
}

