/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.neo4j.extension.springtemplate;

import ch.lambdaj.Lambda;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.lordofthejars.nosqlunit.core.NoSqlAssertionError;
import com.lordofthejars.nosqlunit.neo4j.Neo4jComparisonStrategy;
import com.lordofthejars.nosqlunit.neo4j.Neo4jConnectionCallback;
import com.lordofthejars.nosqlunit.neo4j.extension.springtemplate.DataParser;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.neo4j.graphdb.GraphDatabaseService;
import org.springframework.data.neo4j.config.JtaTransactionManagerFactoryBean;
import org.springframework.data.neo4j.conversion.Result;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class SpringTemplateComparisonStrategy
implements Neo4jComparisonStrategy {
    public boolean compare(Neo4jConnectionCallback connection, InputStream dataset) throws NoSqlAssertionError, Throwable {
        DataParser dataParser = new DataParser();
        List<Object> expectedObjects = dataParser.readValues(dataset);
        Multimap<Class<?>, Object> expectedGroupByClass = this.groupByClass(expectedObjects);
        Set expectedClasses = expectedGroupByClass.keySet();
        for (Class expectedClass : expectedClasses) {
            Collection expectedObjectsByClass = expectedGroupByClass.get((Object)expectedClass);
            List<Object> insertedObjects = this.findAndFetchAllEntitiesByClass(this.neo4jTemplate(connection), expectedClass);
            for (Object expectedObject : expectedObjectsByClass) {
                Object selectFirst = Lambda.selectFirst(insertedObjects, (Matcher)CoreMatchers.equalTo(expectedObject));
                if (selectFirst != null) continue;
                throw new NoSqlAssertionError(String.format("Object %s is not found in graph.", expectedObject.toString()));
            }
        }
        return true;
    }

    public void setIgnoreProperties(String[] ignoreProperties) {
    }

    private List<Object> findAndFetchAllEntitiesByClass(final Neo4jTemplate neo4jTemplate, final Class<?> entityClass) {
        TransactionTemplate transactionalTemplate = this.transactionalTemplate(neo4jTemplate.getGraphDatabaseService());
        return (List)transactionalTemplate.execute((TransactionCallback)new TransactionCallback<List<Object>>(){

            public List<Object> doInTransaction(TransactionStatus status) {
                Result allEntities = neo4jTemplate.findAll(entityClass);
                List<Object> fetchedData = this.fetchData(neo4jTemplate, allEntities);
                return fetchedData;
            }

            private List<Object> fetchData(Neo4jTemplate neo4jTemplate2, Result<?> allEntities) {
                ArrayList<Object> fetchedData = new ArrayList<Object>();
                for (Object entity : allEntities) {
                    fetchedData.add(neo4jTemplate2.fetch(entity));
                }
                return fetchedData;
            }
        });
    }

    private TransactionTemplate transactionalTemplate(GraphDatabaseService graphDatabaseService) {
        try {
            JtaTransactionManagerFactoryBean jtaTransactionManagerFactoryBean = new JtaTransactionManagerFactoryBean(graphDatabaseService);
            return new TransactionTemplate((PlatformTransactionManager)jtaTransactionManagerFactoryBean.getObject());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Multimap<Class<?>, Object> groupByClass(List<Object> objects) {
        ArrayListMultimap groupByClass = ArrayListMultimap.create();
        for (Object object : objects) {
            groupByClass.put(object.getClass(), object);
        }
        return groupByClass;
    }

    private Neo4jTemplate neo4jTemplate(Neo4jConnectionCallback connection) {
        GraphDatabaseService graphDatabaseService = connection.graphDatabaseService();
        return new Neo4jTemplate(graphDatabaseService);
    }
}

