/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.redis;

import com.lordofthejars.nosqlunit.core.AbstractLifecycleManager;
import com.lordofthejars.nosqlunit.core.CommandLineExecutor;
import com.lordofthejars.nosqlunit.core.IOUtils;
import com.lordofthejars.nosqlunit.core.OperatingSystem;
import com.lordofthejars.nosqlunit.core.OperatingSystemFamily;
import com.lordofthejars.nosqlunit.core.OperatingSystemResolver;
import com.lordofthejars.nosqlunit.core.OsNameSystemPropertyOperatingSystemResolver;
import com.lordofthejars.nosqlunit.env.SystemEnvironmentVariables;
import com.lordofthejars.nosqlunit.redis.ManagedRedis;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedRedisLifecycleManager
extends AbstractLifecycleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagedRedis.class);
    Process pwd;
    private static final String LOCALHOST = "127.0.0.1";
    public static final int DEFAULT_PORT = 6379;
    private static final int NO_MASTER_PORT = -1;
    protected static final String DEFAULT_REDIS_TARGET_PATH = "target" + File.separatorChar + "redis-temp";
    protected static final String REDIS_BINARY_DIRECTORY = "src";
    protected static final String REDIS_EXECUTABLE_X = "redis-server";
    protected static final String SLAVE_OF_ARGUMENT = "--slaveof";
    private String targetPath = DEFAULT_REDIS_TARGET_PATH;
    private String redisPath = SystemEnvironmentVariables.getEnvironmentOrPropertyVariable((String)"REDIS_HOME");
    private String configurationFilepath = null;
    private int port = 6379;
    private String masterHost;
    private int masterPort = -1;
    private Map<String, String> extraCommandArguments = new HashMap<String, String>();
    private List<String> singleCommandArguments = new ArrayList<String>();
    private CommandLineExecutor commandLineExecutor = new CommandLineExecutor();
    private OperatingSystemResolver operatingSystemResolver = new OsNameSystemPropertyOperatingSystemResolver();

    public String getHost() {
        return LOCALHOST;
    }

    public int getPort() {
        return this.port;
    }

    public void doStart() throws Throwable {
        LOGGER.info("Starting {} Redis instance.", (Object)this.redisPath);
        if (this.isWindowsSystem()) {
            throw new IllegalArgumentException("Windows System is not supported, because there is no official Redis server for Windows.");
        }
        File targetPathDirectory = this.ensureTargetPathDoesNotExitsAndReturnCompositePath();
        if (!targetPathDirectory.mkdirs()) {
            throw new IllegalStateException("Target Path " + targetPathDirectory + " could not be created.");
        }
        this.startRedisAsDaemon();
        LOGGER.info("Started {} Redis instance.", (Object)this.redisPath);
    }

    private void startRedisAsDaemon() throws AssertionError {
        final CountDownLatch startupLatch = new CountDownLatch(1);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ManagedRedisLifecycleManager.this.startRedisProcess();
                    startupLatch.countDown();
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException(e);
                }
            }
        }).start();
        try {
            startupLatch.await(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    private boolean isWindowsSystem() {
        return this.operatingSystemResolver.currentOperatingSystem().getFamily() == OperatingSystemFamily.WINDOWS;
    }

    private List<String> startRedisProcess() throws InterruptedException {
        try {
            this.pwd = this.startProcess();
            this.pwd.waitFor();
            if (this.pwd.exitValue() != 0) {
                List<String> consoleOutput = this.getConsoleOutput(this.pwd);
                throw new IllegalStateException("Redis [" + this.redisPath + " at port " + this.port + "] could not be started. Next console message was thrown: " + consoleOutput);
            }
            return null;
        }
        catch (IOException e) {
            throw new IllegalStateException("Redis [" + this.redisPath + " at port " + this.port + "] could not be started. Next console message was thrown: " + e.getMessage());
        }
    }

    private File ensureTargetPathDoesNotExitsAndReturnCompositePath() {
        File dbPath = new File(this.targetPath);
        if (dbPath.exists()) {
            IOUtils.deleteDir((File)dbPath);
        }
        return dbPath;
    }

    private Process startProcess() throws IOException {
        return this.commandLineExecutor.startProcessInDirectoryAndArguments(this.targetPath, this.buildOperationSystemProgramAndArguments());
    }

    private List<String> getConsoleOutput(Process pwd) throws IOException {
        return this.commandLineExecutor.getConsoleOutput(pwd);
    }

    private List<String> buildOperationSystemProgramAndArguments() {
        ArrayList<String> programAndArguments = new ArrayList<String>();
        programAndArguments.add(this.getExecutablePath());
        this.addConfigurationPath(programAndArguments);
        this.addSlaveOfParameter(programAndArguments);
        for (String argument : this.singleCommandArguments) {
            programAndArguments.add(argument);
        }
        for (String argumentName : this.extraCommandArguments.keySet()) {
            programAndArguments.add(argumentName);
            programAndArguments.add(this.extraCommandArguments.get(argumentName));
        }
        return programAndArguments;
    }

    private String getExecutablePath() {
        return this.redisPath + File.separatorChar + REDIS_BINARY_DIRECTORY + File.separatorChar + this.redisExecutable();
    }

    private String redisExecutable() {
        OperatingSystem operatingSystem = this.operatingSystemResolver.currentOperatingSystem();
        switch (operatingSystem.getFamily()) {
            case WINDOWS: {
                throw new IllegalArgumentException("Windows System is not supported, because there is no official Redis server for Windows.");
            }
        }
        return REDIS_EXECUTABLE_X;
    }

    private List<String> addSlaveOfParameter(List<String> programAndArguments) {
        if (this.isMasterDefined()) {
            programAndArguments.add("--slaveof " + this.masterHost + " " + Integer.toString(this.masterPort));
        }
        return programAndArguments;
    }

    private List<String> addConfigurationPath(List<String> programAndArguments) {
        if (this.configurationFilepath != null) {
            programAndArguments.add(this.configurationFilepath);
        }
        return programAndArguments;
    }

    public void doStop() {
        LOGGER.info("Stopping {} Redis instance.", (Object)this.redisPath);
        try {
            this.stopRedis();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        finally {
            this.ensureTargetPathDoesNotExitsAndReturnCompositePath();
        }
        LOGGER.info("Stopped {} Redis instance.", (Object)this.redisPath);
    }

    private void stopRedis() throws InterruptedException {
        if (this.isProcessAlive()) {
            this.pwd.destroy();
            TimeUnit.SECONDS.sleep(2L);
        }
    }

    private boolean isProcessAlive() {
        return this.pwd != null;
    }

    private boolean isMasterDefined() {
        return this.masterHost != null && this.masterPort != -1;
    }

    public void setTargetPath(String targetPath) {
        this.targetPath = targetPath;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setRedisPath(String redisPath) {
        this.redisPath = redisPath;
    }

    public void setMasterHost(String host) {
        this.masterHost = host;
    }

    public void setMasterPort(int port) {
        this.masterPort = port;
    }

    public void addExtraCommandLineArgument(String argumentName, String argumentValue) {
        this.extraCommandArguments.put(argumentName, argumentValue);
    }

    public void addSingleCommandLineArgument(String argument) {
        this.singleCommandArguments.add(argument);
    }

    public String getRedisPath() {
        return this.redisPath;
    }

    public void setConfigurationFilepath(String configurationFilepath) {
        this.configurationFilepath = configurationFilepath;
    }

    public void setOperatingSystemResolver(OperatingSystemResolver operatingSystemResolver) {
        this.operatingSystemResolver = operatingSystemResolver;
    }

    public void setCommandLineExecutor(CommandLineExecutor commandLineExecutor) {
        this.commandLineExecutor = commandLineExecutor;
    }
}

