/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.redis;

import ch.lambdaj.Lambda;
import com.lordofthejars.nosqlunit.core.AbstractCustomizableDatabaseOperation;
import com.lordofthejars.nosqlunit.core.NoSqlAssertionError;
import com.lordofthejars.nosqlunit.redis.DefaultRedisComparisonStrategy;
import com.lordofthejars.nosqlunit.redis.DefaultRedisInsertionStrategy;
import com.lordofthejars.nosqlunit.redis.RedisConnectionCallback;
import java.io.InputStream;
import java.util.Collection;
import redis.clients.jedis.BinaryJedisCommands;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.ShardedJedis;

public class ShardedRedisOperation
extends AbstractCustomizableDatabaseOperation<RedisConnectionCallback, ShardedJedis> {
    private ShardedJedis shardedJedis;

    public ShardedRedisOperation(ShardedJedis shardedJedis) {
        this.shardedJedis = shardedJedis;
        this.setInsertionStrategy(new DefaultRedisInsertionStrategy());
        this.setComparisonStrategy(new DefaultRedisComparisonStrategy());
    }

    public void insert(InputStream dataScript) {
        this.insertData(dataScript);
    }

    private void insertData(InputStream dataScript) {
        try {
            this.executeInsertion(new RedisConnectionCallback(){

                @Override
                public Collection<Jedis> getAllJedis() {
                    return ShardedRedisOperation.this.shardedJedis.getAllShards();
                }

                @Override
                public Jedis getActiveJedis(byte[] key) {
                    return (Jedis)ShardedRedisOperation.this.shardedJedis.getShard(key);
                }

                @Override
                public BinaryJedisCommands insertionJedis() {
                    return ShardedRedisOperation.this.shardedJedis;
                }
            }, dataScript);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void deleteAll() {
        ((Jedis)Lambda.forEach((Iterable)this.shardedJedis.getAllShards())).flushAll();
    }

    public boolean databaseIs(InputStream expectedData) {
        return this.compareData(expectedData);
    }

    private boolean compareData(InputStream expectedData) throws NoSqlAssertionError {
        try {
            return this.executeComparison(new RedisConnectionCallback(){

                @Override
                public Collection<Jedis> getAllJedis() {
                    return ShardedRedisOperation.this.shardedJedis.getAllShards();
                }

                @Override
                public Jedis getActiveJedis(byte[] key) {
                    return (Jedis)ShardedRedisOperation.this.shardedJedis.getShard(key);
                }

                @Override
                public BinaryJedisCommands insertionJedis() {
                    return ShardedRedisOperation.this.shardedJedis;
                }
            }, expectedData);
        }
        catch (NoSqlAssertionError e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    public ShardedJedis connectionManager() {
        return this.shardedJedis;
    }
}

