/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.redis.replication;

import com.lordofthejars.nosqlunit.redis.ManagedRedisLifecycleManager;
import com.lordofthejars.nosqlunit.redis.replication.ReplicationGroup;
import java.util.List;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationManagedRedis
extends ExternalResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReplicationManagedRedis.class);
    private ReplicationGroup replicationGroup;

    protected ReplicationManagedRedis(ReplicationGroup replicationGroup) {
        this.replicationGroup = replicationGroup;
    }

    public void startupServer(int port) throws Throwable {
        ManagedRedisLifecycleManager stoppedServer = this.replicationGroup.getStoppedServer(port);
        if (stoppedServer != null) {
            stoppedServer.startEngine();
        }
    }

    public void stopServer(int port) throws Throwable {
        ManagedRedisLifecycleManager stoppedServer = this.replicationGroup.getStartedServer(port);
        if (stoppedServer != null) {
            stoppedServer.stopEngine();
        }
    }

    protected void before() throws Throwable {
        this.wakeUpServers();
    }

    private void wakeUpServers() throws Throwable {
        LOGGER.info("Starting Redis Master Server");
        this.startMaster();
        LOGGER.info("Started Redis Master Server");
        LOGGER.info("Starting Redis Slave Servers");
        this.startSlaves();
        LOGGER.info("Started Redis Slave Servers");
    }

    private void startSlaves() throws Throwable {
        List<ManagedRedisLifecycleManager> slaveServers = this.replicationGroup.getSlaveServers();
        for (ManagedRedisLifecycleManager slaveServer : slaveServers) {
            if (!this.isServerStopped(slaveServer)) continue;
            slaveServer.startEngine();
        }
    }

    private void startMaster() throws Throwable {
        ManagedRedisLifecycleManager master = this.replicationGroup.getMaster();
        if (this.isServerStopped(master)) {
            master.startEngine();
        }
    }

    private boolean isServerStopped(ManagedRedisLifecycleManager master) {
        return !master.isReady();
    }

    protected void after() {
        this.shutdownServers();
    }

    private void shutdownServers() {
        LOGGER.info("Stopping Redis Master Server");
        this.stopMaster();
        LOGGER.info("Stopped Redis Master Server");
        LOGGER.info("Stopping Redis Slave Servers");
        this.stopSlaves();
        LOGGER.info("Stopped Redis Slave Servers");
    }

    private void stopMaster() {
        ManagedRedisLifecycleManager master = this.replicationGroup.getMaster();
        if (this.isServerStarted(master)) {
            master.stopEngine();
        }
    }

    private void stopSlaves() {
        List<ManagedRedisLifecycleManager> slaveServers = this.replicationGroup.getSlaveServers();
        for (ManagedRedisLifecycleManager slaveServer : slaveServers) {
            if (!this.isServerStarted(slaveServer)) continue;
            slaveServer.stopEngine();
        }
    }

    private boolean isServerStarted(ManagedRedisLifecycleManager master) {
        return master.isReady();
    }
}

