/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.pdf.PRTokeniser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;

public class Utilities {
    private static String[] excUriEsc = new String[]{"%20", "%3C", "%3E", "%23", "%25", "%22", "%7B", "%7D", "%5B", "%5D", "%7C", "%5C", "%5E", "%60"};
    private static String excUri = " <>#%\"{}[]|\\^`";

    public static Set getKeySet(Hashtable hashtable) {
        return hashtable == null ? Collections.EMPTY_SET : hashtable.keySet();
    }

    public static Object[][] addToArray(Object[][] objectArray, Object[] objectArray2) {
        if (objectArray == null) {
            objectArray = new Object[][]{objectArray2};
            return objectArray;
        }
        Object[][] objectArray3 = new Object[objectArray.length + 1][];
        System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length);
        objectArray3[objectArray.length] = objectArray2;
        return objectArray3;
    }

    public static boolean checkTrueOrFalse(Properties properties, String string) {
        return "true".equalsIgnoreCase(properties.getProperty(string));
    }

    public static String unEscapeURL(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c == '%') {
                if (i + 2 >= cArray.length) {
                    stringBuffer.append(c);
                    continue;
                }
                int n = PRTokeniser.getHex(cArray[i + 1]);
                int n2 = PRTokeniser.getHex(cArray[i + 2]);
                if (n < 0 || n2 < 0) {
                    stringBuffer.append(c);
                    continue;
                }
                stringBuffer.append((char)(n * 16 + n2));
                i += 2;
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static URL toURL(String string) throws MalformedURLException {
        if (string.startsWith("file:/") || string.startsWith("http://") || string.startsWith("https://") || string.startsWith("jar:")) {
            return new URL(string);
        }
        File file = new File(string);
        String string2 = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            string2 = string2.replace(File.separatorChar, '/');
        }
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        if (!string2.endsWith("/") && file.isDirectory()) {
            string2 = string2 + "/";
        }
        char[] cArray = string2.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            int n = excUri.indexOf(c);
            if (n >= 0) {
                stringBuffer.append(excUriEsc[n]);
                continue;
            }
            stringBuffer.append(c);
        }
        return new URL("file", "", stringBuffer.toString());
    }

    public static void skip(InputStream inputStream, int n) throws IOException {
        long l;
        while (n > 0 && (l = inputStream.skip(n)) > 0L) {
            n = (int)((long)n - l);
        }
    }
}

