/*
 * Decompiled with CFR 0.152.
 */
package com.lunatech.doclets.jax.jpa;

import com.lunatech.doclets.jax.JAXDoclet;
import com.lunatech.doclets.jax.Utils;
import com.lunatech.doclets.jax.jpa.JPAConfiguration;
import com.lunatech.doclets.jax.jpa.model.JPAClass;
import com.lunatech.doclets.jax.jpa.model.JPAMember;
import com.lunatech.doclets.jax.jpa.model.Registry;
import com.lunatech.doclets.jax.jpa.writers.GraphDataWriter;
import com.lunatech.doclets.jax.jpa.writers.GraphWriter;
import com.lunatech.doclets.jax.jpa.writers.PackageListWriter;
import com.lunatech.doclets.jax.jpa.writers.SummaryWriter;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.LanguageVersion;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Type;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import com.sun.tools.doclets.formats.html.HtmlDoclet;
import com.sun.tools.doclets.internal.toolkit.AbstractDoclet;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.Entity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPADoclet
extends JAXDoclet<JPAConfiguration> {
    public static final boolean isHibernatePresent;
    private static final Class<?>[] jpaAnnotations;
    private List<JPAClass> jpaClasses = new LinkedList<JPAClass>();
    private Registry registry = new Registry();

    public static int optionLength(String option) {
        return HtmlDoclet.optionLength((String)option);
    }

    public static boolean validOptions(String[][] options, DocErrorReporter reporter) {
        return HtmlDoclet.validOptions((String[][])options, (DocErrorReporter)reporter);
    }

    public static LanguageVersion languageVersion() {
        return AbstractDoclet.languageVersion();
    }

    public JPADoclet(RootDoc rootDoc) {
        super(rootDoc);
    }

    @Override
    protected JPAConfiguration makeConfiguration(ConfigurationImpl configuration) {
        return new JPAConfiguration(configuration);
    }

    public static boolean start(RootDoc rootDoc) {
        new JPADoclet(rootDoc).start();
        return true;
    }

    private void start() {
        ClassDoc[] classes;
        for (ClassDoc klass : classes = ((JPAConfiguration)this.conf).parentConfiguration.root.classes()) {
            if (Utils.findAnnotatedClass(klass, jpaAnnotations) == null) continue;
            this.handleJPAClass(klass);
        }
        for (JPAClass klass : this.jpaClasses) {
            klass.write(this.conf);
        }
        new PackageListWriter(this.conf, this.registry).write();
        new SummaryWriter(this.conf, this.registry).write();
        new GraphWriter(this.conf, this.registry).write();
        new GraphDataWriter(this.conf, this.registry).write();
        Utils.copyResources(this.conf);
        Utils.copyJPAResources(this.conf);
    }

    private void handleJPAClass(ClassDoc klass) {
        if (!(this.registry.isJPAClass(klass.qualifiedTypeName()) || klass.isPrimitive() || klass.qualifiedTypeName().startsWith("java.") || klass.isEnum())) {
            JPAClass jpaClass = new JPAClass(klass, this.registry, this);
            this.jpaClasses.add(jpaClass);
            this.registry.addJPAClass(jpaClass);
            List<JPAMember> members = jpaClass.getMembers();
            for (JPAMember member : members) {
                Type type = member.getJavaType();
                ClassDoc doc = type.asClassDoc();
                if (doc == null || Utils.findAnnotatedClass(doc, jpaAnnotations) == null) continue;
                this.handleJPAClass(doc);
            }
        }
    }

    static {
        boolean test = false;
        try {
            Class.forName("org.hibernate.annotations.GenericGenerator");
            test = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        isHibernatePresent = test;
        jpaAnnotations = new Class[]{Entity.class};
    }
}

