/*
 * Decompiled with CFR 0.152.
 */
package com.lunatech.doclets.jax.jpa.model;

import com.lunatech.doclets.jax.Utils;
import com.lunatech.doclets.jax.jpa.JPADoclet;
import com.lunatech.doclets.jax.jpa.model.JPAClass;
import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.AnnotationValue;
import com.sun.javadoc.Doc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Type;
import java.util.List;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAMember
implements Comparable<JPAMember> {
    protected AnnotationDesc columnAnnotation;
    protected ProgramElementDoc property;
    protected String name;
    protected JPAClass klass;
    private boolean isID;
    private String sequence;

    public JPAMember(JPAClass klass, ProgramElementDoc property, String name, AnnotationDesc columnAnnotation) {
        this.columnAnnotation = columnAnnotation;
        this.property = property;
        this.name = name;
        this.klass = klass;
        boolean bl = this.isID = Utils.findAnnotation(property, Id.class) != null;
        if (JPADoclet.isHibernatePresent) {
            this.lookupSequence();
        }
    }

    private void lookupSequence() {
        Class<?> genericGeneratorClass;
        AnnotationDesc generatedValue = Utils.findAnnotation(this.property, GeneratedValue.class);
        if (generatedValue == null) {
            return;
        }
        String generator = (String)Utils.getAnnotationValue(generatedValue, "generator");
        if (generator == null) {
            return;
        }
        try {
            genericGeneratorClass = Class.forName("org.hibernate.annotations.GenericGenerator");
        }
        catch (ClassNotFoundException e) {
            return;
        }
        List<AnnotationDesc> genericGenerators = Utils.findAnnotations((ProgramElementDoc)this.property.containingClass(), genericGeneratorClass);
        AnnotationDesc genericGenerator = null;
        for (AnnotationDesc gen : genericGenerators) {
            String name = (String)Utils.getAnnotationValue(gen, "name");
            if (name == null || !name.equals(generator)) continue;
            genericGenerator = gen;
        }
        if (genericGenerator == null) {
            return;
        }
        AnnotationValue[] parameters = (AnnotationValue[])Utils.getAnnotationValue(genericGenerator, "parameters");
        if (parameters == null) {
            return;
        }
        for (AnnotationValue parameter : parameters) {
            String name = (String)Utils.getAnnotationValue((AnnotationDesc)parameter.value(), "name");
            if (name == null || !name.equals("sequence")) continue;
            this.sequence = (String)Utils.getAnnotationValue((AnnotationDesc)parameter.value(), "value");
            return;
        }
    }

    public String getSequence() {
        return this.sequence;
    }

    public String getName() {
        return this.name;
    }

    public Doc getJavaDoc() {
        return this.property;
    }

    private Type getType() {
        if (this.property.isMethod()) {
            return ((MethodDoc)this.property).returnType();
        }
        return ((FieldDoc)this.property).type();
    }

    public boolean isCollectionOrArray() {
        return Utils.isCollection(this.getType()) || this.isArray();
    }

    public boolean isCollection() {
        if (Utils.isCollection(this.getType())) {
            return true;
        }
        return this.isArray();
    }

    public boolean isArray() {
        return Utils.isArray(this.getType());
    }

    public Type getJavaType() {
        return Utils.getCollectionType(this.getType(), this.klass.getDoclet());
    }

    public String getJavaTypeName() {
        return this.getJavaType().qualifiedTypeName();
    }

    public String getSQLType() {
        String typeName = this.getJavaTypeName();
        if (typeName.equals("java.lang.String")) {
            if (Utils.findAnnotation(this.property, Lob.class) != null) {
                return "text";
            }
            Integer length = this.columnAnnotation == null ? null : (Integer)Utils.getAnnotationValue(this.columnAnnotation, "length");
            String size = length != null ? "[" + length + "]" : "";
            return "varchar" + size;
        }
        if (typeName.equals("java.lang.Character") || typeName.equals("char")) {
            return "char";
        }
        if (typeName.equals("java.util.Date") || typeName.equals("java.sql.Date")) {
            return "date";
        }
        if (typeName.equals("java.sql.Timestamp")) {
            return "timestamp";
        }
        if (typeName.equals("java.lang.Integer") || typeName.equals("int")) {
            return "int";
        }
        if (typeName.equals("java.lang.Long") || typeName.equals("long")) {
            return "long";
        }
        if (typeName.equals("java.lang.Short") || typeName.equals("short")) {
            return "short";
        }
        if (typeName.equals("java.lang.Byte") || typeName.equals("byte")) {
            return "byte";
        }
        if (typeName.equals("java.math.BigDecimal")) {
            if (this.columnAnnotation == null) {
                return "decimal";
            }
            Integer precision = (Integer)Utils.getAnnotationValue(this.columnAnnotation, "precision");
            Integer scale = (Integer)Utils.getAnnotationValue(this.columnAnnotation, "scale");
            StringBuffer name = new StringBuffer("decimal[");
            name.append(precision != null ? precision : "?").append(",");
            name.append(scale != null ? scale : "?");
            return name.append("]").toString();
        }
        if (typeName.equals("java.lang.Float") || typeName.equals("float")) {
            return "float";
        }
        if (typeName.equals("java.lang.Double") || typeName.equals("double")) {
            return "double";
        }
        if (typeName.equals("java.lang.Boolean") || typeName.equals("boolean")) {
            return "boolean";
        }
        return typeName;
    }

    public boolean isJPAType() {
        Type type = this.getJavaType();
        return !type.isPrimitive() && this.klass.getRegistry().isJPAClass(type.qualifiedTypeName());
    }

    public boolean isID() {
        return this.isID;
    }

    @Override
    public int compareTo(JPAMember other) {
        return this.name.compareToIgnoreCase(other.name);
    }
}

