/*
 * Decompiled with CFR 0.152.
 */
package com.lunatech.doclets.jax.jpa.writers;

import com.lunatech.doclets.jax.JAXConfiguration;
import com.lunatech.doclets.jax.Utils;
import com.lunatech.doclets.jax.jpa.model.JPAClass;
import com.lunatech.doclets.jax.jpa.model.JPAMember;
import com.lunatech.doclets.jax.jpa.model.MemberType;
import com.lunatech.doclets.jax.jpa.model.Relation;
import com.lunatech.doclets.jax.jpa.writers.DocletWriter;
import com.sun.javadoc.Doc;
import com.sun.tools.doclets.formats.html.HtmlDocletWriter;
import java.io.IOException;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAClassWriter
extends DocletWriter {
    public JPAClassWriter(JAXConfiguration configuration, JPAClass jpaClass) {
        super(configuration, JPAClassWriter.getWriter(configuration, jpaClass), jpaClass);
    }

    private static HtmlDocletWriter getWriter(JAXConfiguration configuration, JPAClass jpaClass) {
        try {
            return new HtmlDocletWriter(configuration.parentConfiguration, Utils.classToPath(jpaClass), jpaClass.getShortClassName() + ".html", Utils.classToRoot(jpaClass));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void write() {
        this.printHeader();
        this.printMenu("");
        this.printSummary();
        this.printColumns();
        this.tag("hr");
        this.printMenu("");
        this.printFooter();
        this.writer.flush();
        this.writer.close();
    }

    private void printColumns() {
        this.printMembers(this.jpaClass.getMembers(), "IDs", MemberType.ID);
        this.printMembers(this.jpaClass.getColumns(), "Columns", MemberType.Column);
        this.printMembers(this.jpaClass.getRelations(), "Relations", MemberType.Relation);
    }

    private void printMembers(Collection<? extends JPAMember> members, String title, MemberType type) {
        if (members.isEmpty()) {
            return;
        }
        this.tag("hr");
        this.open("table class='info' id='" + title + "'");
        boolean isRelation = type == MemberType.Relation;
        boolean isID = type == MemberType.ID;
        this.around("caption class='TableCaption'", title);
        this.open("tbody");
        this.open("tr");
        this.around("th class='TableHeader'", "Name");
        this.around("th class='TableHeader'", "Type");
        if (isRelation) {
            this.around("th class='TableHeader'", "Relation");
        }
        this.around("th class='TableHeader'", "Description");
        this.close("tr");
        for (JPAMember jPAMember : members) {
            if (isID && !jPAMember.isID()) continue;
            this.open("tr");
            if (!isID) {
                this.open("td id='m_" + jPAMember.getName() + "'");
                this.print(jPAMember.getName());
            } else {
                this.open("td");
                this.around("a href='#m_" + jPAMember.getName() + "'", jPAMember.getName());
            }
            this.close("td");
            this.open("td");
            this.printMemberType(jPAMember, true);
            if (!isID && jPAMember.isID()) {
                this.around("b", "[ID]");
            }
            if (jPAMember.getSequence() != null) {
                this.tag("br");
                this.print("sequence: " + jPAMember.getSequence());
            }
            this.close("td");
            if (isRelation) {
                this.open("td");
                Relation rel = (Relation)jPAMember;
                this.print(rel.getRelationFrom().name());
                this.print("..");
                this.print(rel.getRelationTo().name());
                this.close("td");
            }
            this.open("td");
            Doc javaDoc = jPAMember.getJavaDoc();
            if (javaDoc != null && javaDoc.firstSentenceTags() != null) {
                this.writer.printSummaryComment(javaDoc);
            }
            this.close("td");
            this.close("tr");
        }
        this.close("tbody");
        this.close("table");
    }

    private void printMemberType(JPAMember member, boolean markCollections) {
        if (markCollections && member.isCollection()) {
            this.print("[");
        }
        if (member.isJPAType()) {
            String name = member.getJavaTypeName();
            JPAClass typeClass = this.jpaClass.getRegistry().getJPAClass(name);
            this.around("a href='" + Utils.urlToClass(this.jpaClass, typeClass) + "'", typeClass.getName());
        } else {
            this.print(member.getSQLType());
        }
        if (markCollections && member.isCollection()) {
            this.print("]");
        }
    }

    private void printSummary() {
        this.open("h2 class='classname'");
        this.around("span class='name'", "Name: " + this.jpaClass.getName());
        this.close("h2");
        Doc javaDoc = this.jpaClass.getJavaDoc();
        if (javaDoc != null && javaDoc.tags() != null) {
            this.writer.printInlineComment(javaDoc);
        }
        this.open("dl");
        JPAMember idMember = this.jpaClass.getID();
        if (idMember != null) {
            this.open("dt");
            this.around("b", "ID");
            this.close("dt");
            this.open("dd");
            this.around("a href='#m_" + idMember.getName() + "'", idMember.getName());
            this.close("dd");
        }
        this.close("dl");
    }

    protected void printHeader() {
        this.printHeader("Table " + this.jpaClass.getName());
    }

    @Override
    protected void printTopMenu(String selected) {
        this.open("table", "tbody", "tr");
        this.printMenuItem("Overview", this.writer.relativePath + "index.html", selected);
        this.printOtherMenuItems(selected);
        this.close("tr", "tbody", "table");
    }

    @Override
    protected void printThirdMenu() {
        this.open("tr");
        this.open("td class='NavBarCell3' colspan='2'");
        this.print("detail: ");
        this.printLink(true, "#IDs", "id");
        this.print(" ");
        this.printLink(!this.jpaClass.getColumns().isEmpty(), "#Columns", "column");
        this.print(" ");
        this.printLink(!this.jpaClass.getRelations().isEmpty(), "#Relations", "relation");
        this.close("td", "tr");
    }

    @Override
    protected void printOtherMenuItems(String selected) {
        this.printMenuItem("Graph", this.writer.relativePath + "graph.html", selected);
    }
}

