/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model.impl;

import com.thoughtworks.qdox.library.ClassLibrary;
import com.thoughtworks.qdox.model.BeanProperty;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaConstructor;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaGenericDeclaration;
import com.thoughtworks.qdox.model.JavaInitializer;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaPackage;
import com.thoughtworks.qdox.model.JavaParameterizedType;
import com.thoughtworks.qdox.model.JavaSource;
import com.thoughtworks.qdox.model.JavaType;
import com.thoughtworks.qdox.model.JavaTypeVariable;
import com.thoughtworks.qdox.model.impl.DefaultJavaClass;
import com.thoughtworks.qdox.model.impl.DefaultJavaParameterizedType;
import com.thoughtworks.qdox.type.TypeResolver;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DefaultJavaType
implements JavaClass,
JavaType,
Serializable {
    protected final String name;
    protected String fullName;
    private int dimensions;
    private TypeResolver typeResolver;

    DefaultJavaType(String name, TypeResolver typeResolver) {
        this.name = name;
        this.typeResolver = typeResolver;
    }

    DefaultJavaType(String fullName, String name, int dimensions, TypeResolver typeResolver) {
        this.fullName = fullName;
        this.name = name;
        this.dimensions = dimensions;
        this.typeResolver = typeResolver;
    }

    DefaultJavaType(String fullName, int dimensions) {
        this.name = fullName;
        this.fullName = fullName;
        this.dimensions = dimensions;
    }

    DefaultJavaType(String fullName) {
        this(fullName, 0);
    }

    @Override
    public String getBinaryName() {
        return this.resolveRealClass().getBinaryName();
    }

    @Override
    public String getSimpleName() {
        StringBuilder result = new StringBuilder(this.resolveRealClass().getSimpleName());
        for (int i = 0; i < this.dimensions; ++i) {
            result.append("[]");
        }
        return result.toString();
    }

    @Override
    public String getFullyQualifiedName() {
        StringBuilder result = new StringBuilder(this.resolveRealClass().getFullyQualifiedName());
        for (int i = 0; i < this.dimensions; ++i) {
            result.append("[]");
        }
        return result.toString();
    }

    @Override
    public JavaClass getComponentType() {
        return this.isArray() ? this.resolveRealClass() : null;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder(this.name);
        for (int i = 0; i < this.dimensions; ++i) {
            result.append("[]");
        }
        return result.toString();
    }

    @Override
    public String getGenericValue() {
        StringBuilder result = new StringBuilder(this.getValue());
        for (int i = 0; i < this.dimensions; ++i) {
            result.append("[]");
        }
        return result.toString();
    }

    protected static <D extends JavaGenericDeclaration> String getGenericValue(JavaType base, List<JavaTypeVariable<D>> typeVariableList) {
        StringBuilder result = new StringBuilder(DefaultJavaType.getResolvedValue(base, typeVariableList));
        Iterator<JavaType> iter = DefaultJavaType.getActualTypeArguments(base).iterator();
        while (iter.hasNext()) {
            result.append(DefaultJavaType.resolve(base, typeVariableList));
            if (!iter.hasNext()) continue;
            result.append(",");
        }
        return result.toString();
    }

    private static List<JavaType> getActualTypeArguments(JavaType base) {
        List<JavaType> result = base instanceof JavaParameterizedType ? ((JavaParameterizedType)base).getActualTypeArguments() : Collections.emptyList();
        return result;
    }

    protected static <D extends JavaGenericDeclaration> String getResolvedValue(JavaType base, List<JavaTypeVariable<D>> typeParameters) {
        String result = base.getValue();
        for (JavaTypeVariable<D> typeParameter : typeParameters) {
            if (!typeParameter.getName().equals(base.getValue())) continue;
            result = typeParameter.getBounds().get(0).getValue();
            break;
        }
        return result;
    }

    protected static <D extends JavaGenericDeclaration> JavaTypeVariable<D> resolve(JavaType base, List<JavaTypeVariable<D>> typeParameters) {
        JavaTypeVariable<D> result = null;
        for (JavaTypeVariable<D> typeParameter : typeParameters) {
            if (!typeParameter.getName().equals(base.getValue())) continue;
            result = typeParameter;
            break;
        }
        return result;
    }

    protected boolean isResolved() {
        if (this.fullName == null && this.typeResolver != null) {
            this.fullName = this.typeResolver.resolveType(this.name);
        }
        return this.fullName != null;
    }

    @Override
    public boolean isArray() {
        return this.dimensions > 0;
    }

    @Override
    public int getDimensions() {
        return this.dimensions;
    }

    @Override
    public String toString() {
        return this.getFullyQualifiedName();
    }

    @Override
    public String toGenericString() {
        return this.getGenericFullyQualifiedName();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JavaType)) {
            return false;
        }
        JavaType t = (JavaType)obj;
        return this.getFullyQualifiedName().equals(t.getFullyQualifiedName());
    }

    public int hashCode() {
        return this.getFullyQualifiedName().hashCode();
    }

    private JavaClass resolveRealClass() {
        JavaClass result = null;
        String qualifiedName = this.isResolved() ? this.fullName : this.name;
        result = DefaultJavaType.isPrimitive(qualifiedName) ? new DefaultJavaClass(qualifiedName) : this.typeResolver.getJavaClass(qualifiedName);
        return result;
    }

    public boolean isA(JavaType type) {
        if (this == type) {
            return true;
        }
        return this.isA(type);
    }

    @Override
    public boolean isPrimitive() {
        return DefaultJavaType.isPrimitive(this.getValue());
    }

    private static boolean isPrimitive(String value) {
        return "void".equals(value) || "boolean".equals(value) || "byte".equals(value) || "char".equals(value) || "short".equals(value) || "int".equals(value) || "long".equals(value) || "float".equals(value) || "double".equals(value);
    }

    @Override
    public boolean isVoid() {
        return "void".equals(this.getValue());
    }

    protected static JavaType resolve(JavaType base, JavaClass declaringClass, JavaClass callingClass) {
        List<JavaType> actualTypeArguments;
        JavaClass baseClass;
        JavaType result = base;
        String concreteClassName = base instanceof JavaClass ? ((baseClass = (JavaClass)base).isArray() ? baseClass.getComponentType().getFullyQualifiedName() : baseClass.getFullyQualifiedName()) : base.getFullyQualifiedName();
        int typeIndex = DefaultJavaType.getTypeVariableIndex(declaringClass, concreteClassName);
        if (typeIndex >= 0) {
            String fqn = declaringClass.getFullyQualifiedName();
            if (callingClass.getSuperClass() != null && fqn.equals(callingClass.getSuperClass().getFullyQualifiedName())) {
                result = DefaultJavaType.getActualTypeArguments(callingClass.getSuperClass()).get(typeIndex);
            } else {
                for (JavaClass implement : callingClass.getInterfaces()) {
                    if (fqn.equals(implement.getFullyQualifiedName())) {
                        JavaType actualType = DefaultJavaType.getActualTypeArguments(implement).get(typeIndex);
                        TypeResolver typeResolver = TypeResolver.byPackageName(implement.getSource().getPackageName(), implement.getSource().getJavaClassLibrary(), implement.getSource().getImports());
                        DefaultJavaType resolvedType = new DefaultJavaType(actualType.getFullyQualifiedName(), actualType.getValue(), DefaultJavaType.getDimensions(base), typeResolver);
                        result = DefaultJavaType.resolve(resolvedType, implement, implement);
                        break;
                    }
                    result = DefaultJavaType.resolve(base, implement, callingClass);
                }
            }
        }
        if (!(actualTypeArguments = DefaultJavaType.getActualTypeArguments(base)).isEmpty()) {
            String value = base.getValue();
            if (value.indexOf(91) > 0) {
                value = value.substring(0, value.indexOf(91));
            }
            TypeResolver typeResolver = TypeResolver.byPackageName(null, declaringClass.getJavaClassLibrary(), null);
            DefaultJavaParameterizedType typeResult = new DefaultJavaParameterizedType(concreteClassName, value, DefaultJavaType.getDimensions(base), typeResolver);
            LinkedList<JavaType> actualTypes = new LinkedList<JavaType>();
            for (JavaType actualArgType : actualTypeArguments) {
                actualTypes.add(DefaultJavaType.resolve(actualArgType, declaringClass, callingClass));
            }
            typeResult.setActualArgumentTypes(actualTypes);
            result = typeResult;
        }
        return result;
    }

    private static int getDimensions(JavaType type) {
        return type instanceof JavaClass ? ((JavaClass)type).getDimensions() : 0;
    }

    private static int getTypeVariableIndex(JavaClass declaringClass, String fqn) {
        int typeIndex = -1;
        for (JavaTypeVariable typeVariable : declaringClass.getTypeParameters()) {
            ++typeIndex;
            if (!typeVariable.getFullyQualifiedName().equals(fqn)) continue;
            return typeIndex;
        }
        return -1;
    }

    @Override
    public String getGenericFullyQualifiedName() {
        StringBuilder result = new StringBuilder(this.isResolved() ? this.fullName : this.name);
        for (int i = 0; i < this.dimensions; ++i) {
            result.append("[]");
        }
        return result.toString();
    }

    @Override
    public String getGenericCanonicalName() {
        StringBuilder result = new StringBuilder(this.getCanonicalName());
        for (int i = 0; i < this.dimensions; ++i) {
            result.append("[]");
        }
        return result.toString();
    }

    protected static <D extends JavaGenericDeclaration> String getResolvedGenericValue(JavaType base, List<JavaTypeVariable<D>> typeParameters) {
        StringBuilder result = new StringBuilder();
        JavaTypeVariable<D> variable = DefaultJavaType.resolve(base, typeParameters);
        result.append(variable == null ? base.getValue() : variable.getBounds().get(0).getValue());
        List<JavaType> actualTypeArguments = DefaultJavaType.getActualTypeArguments(base);
        if (!actualTypeArguments.isEmpty()) {
            result.append("<");
            Iterator<JavaType> iter = actualTypeArguments.iterator();
            while (iter.hasNext()) {
                result.append(DefaultJavaType.getGenericValue(iter.next(), typeParameters));
                if (!iter.hasNext()) continue;
                result.append(",");
            }
            result.append(">");
        }
        if (base instanceof JavaClass) {
            for (int i = 0; i < ((JavaClass)base).getDimensions(); ++i) {
                result.append("[]");
            }
        }
        return result.toString();
    }

    protected static <D extends JavaGenericDeclaration> String getResolvedGenericFullyQualifiedName(JavaType base, List<JavaTypeVariable<D>> typeParameters) {
        StringBuilder result = new StringBuilder();
        JavaTypeVariable<D> variable = DefaultJavaType.resolve(base, typeParameters);
        result.append(variable == null ? base.getFullyQualifiedName() : variable.getBounds().get(0).getFullyQualifiedName());
        List<JavaType> actualTypeArguments = DefaultJavaType.getActualTypeArguments(base);
        if (!actualTypeArguments.isEmpty()) {
            result.append("<");
            Iterator<JavaType> iter = actualTypeArguments.iterator();
            while (iter.hasNext()) {
                result.append(DefaultJavaType.getResolvedFullyQualifiedName(iter.next(), typeParameters));
                if (!iter.hasNext()) continue;
                result.append(",");
            }
            result.append(">");
        }
        if (base instanceof JavaClass) {
            for (int i = 0; i < ((JavaClass)base).getDimensions(); ++i) {
                result.append("[]");
            }
        }
        return result.toString();
    }

    protected static <D extends JavaGenericDeclaration> String getResolvedFullyQualifiedName(JavaType base, List<JavaTypeVariable<D>> typeParameters) {
        JavaTypeVariable<D> variable = DefaultJavaType.resolve(base, typeParameters);
        return variable == null ? base.getFullyQualifiedName() : variable.getBounds().get(0).getFullyQualifiedName();
    }

    @Override
    public JavaSource getSource() {
        return this.resolveRealClass().getSource();
    }

    @Override
    public int getLineNumber() {
        return this.resolveRealClass().getLineNumber();
    }

    @Override
    public boolean isInterface() {
        return this.resolveRealClass().isInterface();
    }

    @Override
    public List<JavaAnnotation> getAnnotations() {
        return this.resolveRealClass().getAnnotations();
    }

    @Override
    public boolean isEnum() {
        return this.resolveRealClass().isEnum();
    }

    @Override
    public boolean isRecord() {
        return this.resolveRealClass().isRecord();
    }

    @Override
    public String getComment() {
        return this.resolveRealClass().getComment();
    }

    @Override
    public List<DocletTag> getTags() {
        return this.resolveRealClass().getTags();
    }

    @Override
    public boolean isAnnotation() {
        return this.resolveRealClass().isAnnotation();
    }

    @Override
    public List<DocletTag> getTagsByName(String name) {
        return this.resolveRealClass().getTagsByName(name);
    }

    @Override
    public DocletTag getTagByName(String name) {
        return this.resolveRealClass().getTagByName(name);
    }

    @Override
    public JavaType getSuperClass() {
        return this.resolveRealClass().getSuperClass();
    }

    @Override
    public JavaClass getSuperJavaClass() {
        return this.resolveRealClass().getSuperJavaClass();
    }

    @Override
    public List<JavaType> getImplements() {
        return this.resolveRealClass().getImplements();
    }

    @Override
    public List<JavaClass> getInterfaces() {
        return this.resolveRealClass().getInterfaces();
    }

    @Override
    public String getNamedParameter(String tagName, String parameterName) {
        return this.resolveRealClass().getNamedParameter(tagName, parameterName);
    }

    @Override
    public String getCodeBlock() {
        return this.resolveRealClass().getCodeBlock();
    }

    @Override
    public <D extends JavaGenericDeclaration> List<JavaTypeVariable<D>> getTypeParameters() {
        return this.resolveRealClass().getTypeParameters();
    }

    @Override
    public JavaSource getParentSource() {
        return this.resolveRealClass().getParentSource();
    }

    @Override
    public JavaPackage getPackage() {
        return this.resolveRealClass().getPackage();
    }

    @Override
    public String getPackageName() {
        return this.resolveRealClass().getPackageName();
    }

    @Override
    public boolean isInner() {
        return this.resolveRealClass().isInner();
    }

    @Override
    public List<JavaInitializer> getInitializers() {
        return this.resolveRealClass().getInitializers();
    }

    @Override
    public List<JavaMethod> getMethods() {
        return this.resolveRealClass().getMethods();
    }

    @Override
    public List<JavaConstructor> getConstructors() {
        return this.resolveRealClass().getConstructors();
    }

    @Override
    public JavaConstructor getConstructor(List<JavaType> parameterTypes) {
        return this.resolveRealClass().getConstructor(parameterTypes);
    }

    @Override
    public JavaConstructor getConstructor(List<JavaType> parameterTypes, boolean varArg) {
        return this.resolveRealClass().getConstructor(parameterTypes, varArg);
    }

    @Override
    public List<JavaMethod> getMethods(boolean superclasses) {
        return this.resolveRealClass().getMethods(superclasses);
    }

    @Override
    public JavaMethod getMethodBySignature(String name, List<JavaType> parameterTypes) {
        return this.resolveRealClass().getMethodBySignature(name, parameterTypes);
    }

    @Override
    public JavaMethod getMethod(String name, List<JavaType> parameterTypes, boolean varArgs) {
        return this.resolveRealClass().getMethod(name, parameterTypes, varArgs);
    }

    @Override
    public JavaMethod getMethodBySignature(String name, List<JavaType> parameterTypes, boolean superclasses) {
        return this.resolveRealClass().getMethodBySignature(name, parameterTypes, superclasses);
    }

    @Override
    public JavaMethod getMethodBySignature(String name, List<JavaType> parameterTypes, boolean superclasses, boolean varArg) {
        return this.resolveRealClass().getMethodBySignature(name, parameterTypes, superclasses, varArg);
    }

    @Override
    public List<JavaMethod> getMethodsBySignature(String name, List<JavaType> parameterTypes, boolean superclasses) {
        return this.resolveRealClass().getMethodsBySignature(name, parameterTypes, superclasses);
    }

    @Override
    public List<JavaMethod> getMethodsBySignature(String name, List<JavaType> parameterTypes, boolean superclasses, boolean varArg) {
        return this.resolveRealClass().getMethodsBySignature(name, parameterTypes, superclasses, varArg);
    }

    @Override
    public List<JavaField> getFields() {
        return this.resolveRealClass().getFields();
    }

    @Override
    public List<JavaField> getFields(boolean publicOnly, boolean supperClass) {
        return this.resolveRealClass().getFields(publicOnly, supperClass);
    }

    @Override
    public JavaField getFieldByName(String name, boolean publicOnly, boolean supperClass) {
        return this.resolveRealClass().getFieldByName(name, publicOnly, supperClass);
    }

    @Override
    public JavaField getFieldByName(String name) {
        return this.resolveRealClass().getFieldByName(name);
    }

    @Override
    public List<JavaField> getEnumConstants() {
        return this.resolveRealClass().getEnumConstants();
    }

    @Override
    public JavaField getEnumConstantByName(String name) {
        return this.resolveRealClass().getEnumConstantByName(name);
    }

    @Override
    public List<JavaClass> getNestedClasses() {
        return this.resolveRealClass().getNestedClasses();
    }

    @Override
    public JavaClass getNestedClassByName(String name) {
        return this.resolveRealClass().getNestedClassByName(name);
    }

    @Override
    public boolean isA(String fullClassName) {
        return this.resolveRealClass().isA(fullClassName);
    }

    @Override
    public boolean isA(JavaClass javaClass) {
        return this.resolveRealClass().isA(javaClass);
    }

    @Override
    public List<BeanProperty> getBeanProperties() {
        return this.resolveRealClass().getBeanProperties();
    }

    @Override
    public List<BeanProperty> getBeanProperties(boolean superclasses) {
        return this.resolveRealClass().getBeanProperties(superclasses);
    }

    @Override
    public BeanProperty getBeanProperty(String propertyName) {
        return this.resolveRealClass().getBeanProperty(propertyName);
    }

    @Override
    public BeanProperty getBeanProperty(String propertyName, boolean superclasses) {
        return this.resolveRealClass().getBeanProperty(propertyName, superclasses);
    }

    @Override
    public List<JavaClass> getDerivedClasses() {
        return this.resolveRealClass().getDerivedClasses();
    }

    @Override
    public List<DocletTag> getTagsByName(String name, boolean superclasses) {
        return this.resolveRealClass().getTagsByName(name, superclasses);
    }

    @Override
    public ClassLibrary getJavaClassLibrary() {
        return this.resolveRealClass().getJavaClassLibrary();
    }

    @Override
    public String getName() {
        return this.resolveRealClass().getName();
    }

    @Override
    public String getCanonicalName() {
        StringBuilder result = new StringBuilder(this.resolveRealClass().getCanonicalName());
        for (int i = 0; i < this.dimensions; ++i) {
            result.append("[]");
        }
        return result.toString();
    }

    @Override
    public List<String> getModifiers() {
        return this.resolveRealClass().getModifiers();
    }

    @Override
    public boolean isPublic() {
        return this.resolveRealClass().isPublic();
    }

    @Override
    public boolean isProtected() {
        return this.resolveRealClass().isProtected();
    }

    @Override
    public boolean isPrivate() {
        return this.resolveRealClass().isPrivate();
    }

    @Override
    public boolean isFinal() {
        return this.resolveRealClass().isFinal();
    }

    @Override
    public boolean isStatic() {
        return this.resolveRealClass().isStatic();
    }

    @Override
    public boolean isAbstract() {
        return this.resolveRealClass().isAbstract();
    }

    @Override
    public JavaClass getDeclaringClass() {
        return this.resolveRealClass().getDeclaringClass();
    }
}

