/*
 * Decompiled with CFR 0.152.
 */
package com.maciejwalkowiak.wiremock.spring;

import com.maciejwalkowiak.wiremock.spring.ConfigureWireMock;
import com.maciejwalkowiak.wiremock.spring.EnableWireMock;
import com.maciejwalkowiak.wiremock.spring.WireMockContextCustomizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextCustomizerFactory;
import org.springframework.test.context.TestContextAnnotationUtils;

public class WireMockContextCustomizerFactory
implements ContextCustomizerFactory {
    public ContextCustomizer createContextCustomizer(Class<?> testClass, List<ContextConfigurationAttributes> configAttributes) {
        ConfigureWiremockHolder holder = new ConfigureWiremockHolder();
        this.parseDefinitions(testClass, holder);
        if (holder.isEmpty()) {
            return null;
        }
        return new WireMockContextCustomizer(holder.asArray());
    }

    private void parseDefinitions(Class<?> testClass, ConfigureWiremockHolder parser) {
        parser.parse(testClass);
        if (TestContextAnnotationUtils.searchEnclosingClass(testClass)) {
            this.parseDefinitions(testClass.getEnclosingClass(), parser);
        }
    }

    private static class ConfigureWiremockHolder {
        private final List<ConfigureWireMock> annotations = new ArrayList<ConfigureWireMock>();

        private ConfigureWiremockHolder() {
        }

        void add(ConfigureWireMock[] annotations) {
            this.annotations.addAll(Arrays.asList(annotations));
        }

        void parse(Class<?> clazz) {
            EnableWireMock annotation = (EnableWireMock)AnnotationUtils.findAnnotation(clazz, EnableWireMock.class);
            if (annotation != null) {
                this.add(annotation.value());
            }
        }

        boolean isEmpty() {
            return this.annotations.isEmpty();
        }

        ConfigureWireMock[] asArray() {
            return this.annotations.toArray(new ConfigureWireMock[0]);
        }
    }
}

