/*
 * Decompiled with CFR 0.152.
 */
package com.martensigwart.fakeload;

import com.martensigwart.fakeload.FakeLoad;
import com.martensigwart.fakeload.FakeLoadBuilder;
import com.martensigwart.fakeload.MemoryUnit;
import com.martensigwart.fakeload.Preconditions;
import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

abstract class AbstractFakeLoad
implements FakeLoad {
    private static final long serialVersionUID = 7279757183068731801L;
    private final int repetitions;

    AbstractFakeLoad(int repetitions) {
        Preconditions.checkArgument(repetitions >= 1, "Number of repetitions must be at least 1 but was %s", repetitions);
        this.repetitions = repetitions;
    }

    @Override
    public int getRepetitions() {
        return this.repetitions;
    }

    static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 6633428955227710412L;
        private final long duration;
        private final TimeUnit unit;
        private final int repetitions;
        private final int cpu;
        private final long memory;
        private final long diskInput;
        private final long diskOutput;
        private final Collection<FakeLoad> loads;

        SerializationProxy(FakeLoad fakeLoad) {
            this.duration = fakeLoad.getDuration();
            this.unit = fakeLoad.getTimeUnit();
            this.repetitions = fakeLoad.getRepetitions();
            this.cpu = fakeLoad.getCpu();
            this.memory = fakeLoad.getMemory();
            this.diskInput = fakeLoad.getDiskInput();
            this.diskOutput = fakeLoad.getDiskInput();
            this.loads = fakeLoad.getInnerLoads();
        }

        private Object readResolve() {
            return new FakeLoadBuilder(this.duration, this.unit).repeat(this.repetitions).withCpu(this.cpu).withMemory(this.memory, MemoryUnit.BYTES).withDiskInput(this.diskInput, MemoryUnit.BYTES).withDiskOutput(this.diskOutput, MemoryUnit.BYTES).addLoads(this.loads).build();
        }
    }
}

