/*
 * Decompiled with CFR 0.152.
 */
package com.martensigwart.fakeload;

import com.martensigwart.fakeload.LoadSimulator;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLoadSimulator
implements LoadSimulator {
    private static final Logger log = LoggerFactory.getLogger(AbstractLoadSimulator.class);
    @GuardedBy(value="this")
    private long load = 0L;
    private final long maximumLoad;
    private final String name;
    private final Object lock = new Object();

    public AbstractLoadSimulator(long maximumLoad, String name) {
        this.maximumLoad = maximumLoad <= 0L ? Long.MAX_VALUE : maximumLoad;
        this.name = name;
    }

    protected abstract void simulateLoad(long var1) throws InterruptedException;

    protected abstract boolean waitConditionFulfilled();

    protected abstract void cleanUp();

    protected abstract String prettyFormat(long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        log.debug("{} - Started", (Object)this.name);
        boolean running = true;
        while (running) {
            try {
                Object object = this.lock;
                synchronized (object) {
                    while (this.waitConditionFulfilled()) {
                        log.debug("{} - Waiting for something to do...", (Object)this.name);
                        this.lock.wait();
                        log.debug("{} - Woke up.", (Object)this.name);
                    }
                }
                this.simulateLoad(this.getLoad());
            }
            catch (InterruptedException e) {
                log.debug("{} - Interrupted", (Object)this.name);
                this.cleanUp();
                running = false;
            }
        }
        log.debug("{} - Exited", (Object)this.name);
    }

    @Override
    public synchronized long getLoad() {
        return this.load;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLoad(long desiredLoad) {
        Object object = this;
        synchronized (object) {
            this.load = desiredLoad < 0L ? 0L : (desiredLoad > this.maximumLoad ? this.maximumLoad : desiredLoad);
            log.trace("{} - Set load to {}", (Object)this.name, (Object)this.prettyFormat(this.load));
        }
        object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
    }

    @Override
    public void increaseLoad(long delta) {
        this.setLoad(this.getLoad() + delta);
    }

    @Override
    public void decreaseLoad(long delta) {
        this.setLoad(this.getLoad() - delta);
    }

    @Override
    public long getMaximumLoad() {
        return this.maximumLoad;
    }

    @Override
    public boolean isMaximumLoad() {
        return this.getLoad() == this.maximumLoad;
    }

    @Override
    public boolean isZeroLoad() {
        return this.getLoad() == 0L;
    }
}

