/*
 * Decompiled with CFR 0.152.
 */
package com.martensigwart.fakeload;

import com.martensigwart.fakeload.AbstractLoadSimulator;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CpuSimulator
extends AbstractLoadSimulator {
    private static final Logger log = LoggerFactory.getLogger(CpuSimulator.class);
    private static final AtomicInteger cpuIDs = new AtomicInteger(0);

    CpuSimulator() {
        super(100L, "CpuSim " + cpuIDs.getAndIncrement());
    }

    protected abstract void simulateCpu();

    @Override
    protected void simulateLoad(long load) throws InterruptedException {
        long time = System.currentTimeMillis() + load;
        while (System.currentTimeMillis() < time) {
            this.simulateCpu();
        }
        Thread.sleep(100L - load);
    }

    @Override
    protected boolean waitConditionFulfilled() {
        return this.getLoad() == 0L;
    }

    @Override
    protected String prettyFormat(long load) {
        return String.format("%d%%", load);
    }

    @Override
    protected void cleanUp() {
    }
}

