/*
 * Decompiled with CFR 0.152.
 */
package com.martensigwart.fakeload;

import com.martensigwart.fakeload.AbstractLoadSimulator;
import com.martensigwart.fakeload.MemoryUnit;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DiskOutputSimulator
extends AbstractLoadSimulator {
    private static final Logger log = LoggerFactory.getLogger(DiskOutputSimulator.class);

    protected DiskOutputSimulator() {
        this("DiskOutputSim");
    }

    protected DiskOutputSimulator(String name) {
        super(-1L, name);
    }

    protected abstract void write(byte[] var1) throws IOException;

    @Override
    protected void simulateLoad(long load) throws InterruptedException {
        try {
            long startWrite = System.nanoTime();
            int bytesPerSeconds = load > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)load;
            byte[] bytes = new byte[bytesPerSeconds];
            this.write(bytes);
            long endWrite = System.nanoTime();
            long duration = endWrite - startWrite;
            log.trace("Wrote {} bytes in {} ms", (Object)bytes.length, (Object)TimeUnit.NANOSECONDS.toMillis(duration));
            long toSleep = TimeUnit.SECONDS.toMillis(1L) - TimeUnit.NANOSECONDS.toMillis(duration);
            if (toSleep > 0L) {
                log.trace("Sleeping " + toSleep + "ms");
                Thread.sleep(toSleep);
            }
        }
        catch (IOException e) {
            log.error(e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    protected boolean waitConditionFulfilled() {
        return this.isZeroLoad();
    }

    @Override
    protected String prettyFormat(long load) {
        return MemoryUnit.mbString(load) + " per second";
    }
}

