/*
 * Decompiled with CFR 0.152.
 */
package com.martensigwart.fakeload;

import com.martensigwart.fakeload.AbstractLoadSimulator;
import com.martensigwart.fakeload.MemoryUnit;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MemorySimulator
extends AbstractLoadSimulator {
    private static final Logger log = LoggerFactory.getLogger(MemorySimulator.class);
    private long actualLoad = 0L;
    private final List<byte[]> allocatedMemory = new ArrayList<byte[]>();

    public MemorySimulator() {
        super(-1L, "MemorySim");
    }

    @Override
    protected void simulateLoad(long loadToAllocate) throws InterruptedException {
        this.allocatedMemory.clear();
        if (loadToAllocate < Integer.MAX_VALUE) {
            this.allocatedMemory.add(new byte[(int)loadToAllocate]);
        } else {
            int modulo = Math.toIntExact(loadToAllocate % Integer.MAX_VALUE);
            int times = Math.toIntExact((loadToAllocate - (long)modulo) / Integer.MAX_VALUE);
            log.trace("Modulo: {}, times: {}", (Object)modulo, (Object)times);
            for (int i = 0; i < times; ++i) {
                log.trace("Round {} start", (Object)i);
                this.allocatedMemory.add(new byte[Integer.MAX_VALUE]);
                log.trace("Round {} end", (Object)i);
            }
            log.debug("Now adding {} bytes", (Object)modulo);
            this.allocatedMemory.add(new byte[modulo]);
        }
        this.actualLoad = loadToAllocate;
    }

    @Override
    protected boolean waitConditionFulfilled() {
        return this.getLoad() == this.actualLoad;
    }

    @Override
    protected String prettyFormat(long load) {
        return MemoryUnit.mbString(load);
    }

    @Override
    protected void cleanUp() {
        this.allocatedMemory.clear();
    }
}

