/*
 * Decompiled with CFR 0.152.
 */
package com.martensigwart.fakeload;

public enum MemoryUnit {
    BYTES(1L),
    KB(MemoryUnit.BYTES.multiplier * 1024L),
    MB(MemoryUnit.KB.multiplier * 1024L),
    GB(MemoryUnit.MB.multiplier * 1024L);

    private final long multiplier;

    private MemoryUnit(long multiplier) {
        this.multiplier = multiplier;
    }

    public long toBytes(long amount) {
        return amount * this.multiplier;
    }

    public double toKB(long amount) {
        return this.convert(amount, KB);
    }

    public double toMB(long amount) {
        return this.convert(amount, MB);
    }

    public double toGB(long amount) {
        return this.convert(amount, GB);
    }

    private double convert(long amount, MemoryUnit toUnit) {
        return (double)amount * ((double)this.multiplier / (double)toUnit.multiplier);
    }

    public static String mbString(long bytes) {
        return String.format("%d bytes (%.2f MB)", bytes, (double)bytes / (double)MemoryUnit.MB.multiplier);
    }
}

