/*
 * Decompiled with CFR 0.152.
 */
package com.martensigwart.fakeload;

import com.martensigwart.fakeload.DiskInputSimulator;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RandomAccessDiskInputSimulator
extends DiskInputSimulator {
    private static final Logger log = LoggerFactory.getLogger(RandomAccessDiskInputSimulator.class);
    private final String filePath;
    private RandomAccessFile file;

    public RandomAccessDiskInputSimulator(String filePath) {
        this.filePath = filePath;
    }

    @Override
    protected int read(byte[] bytes) throws IOException {
        try {
            int bytesRead;
            if (this.file == null) {
                this.file = new RandomAccessFile(this.filePath, "r");
                log.trace("Opened file {}", (Object)this.filePath);
            }
            if ((bytesRead = this.file.read(bytes)) == bytes.length) {
                return bytesRead;
            }
            if (bytesRead < bytes.length) {
                log.debug("End of file reached: Resetting file pointer");
                this.file.seek(0L);
                this.file.read(bytes, bytesRead, bytes.length - bytesRead);
            }
            return bytes.length;
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundException(String.format("File %s used for simulating disk input does not exist. (The file should be at least twice as big as available RAM to prevent caching)", this.filePath));
        }
    }

    @Override
    protected void cleanUp() {
        try {
            if (this.file != null) {
                this.file.close();
            }
        }
        catch (IOException e) {
            log.error("Failed to close file: {}", (Object)e.getMessage());
            e.printStackTrace();
        }
    }
}

