/*
 * Decompiled with CFR 0.152.
 */
package com.martensigwart.fakeload;

import com.martensigwart.fakeload.AbstractFakeLoad;
import com.martensigwart.fakeload.CompositeFakeLoad;
import com.martensigwart.fakeload.FakeLoad;
import com.martensigwart.fakeload.MemoryUnit;
import com.martensigwart.fakeload.Preconditions;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.Immutable;

@Immutable
final class SimpleFakeLoad
extends AbstractFakeLoad {
    private final long duration;
    private final TimeUnit unit;
    private final int cpu;
    private final long memory;
    private final long diskInput;
    private final long diskOutput;

    SimpleFakeLoad(long duration, TimeUnit unit, int repetitions, int cpu, long memory, long diskInput, long diskOutput) {
        super(repetitions);
        Preconditions.checkArgument(duration >= 0L, "Duration must be nonnegative but was %s", duration);
        Preconditions.checkArgument(cpu >= 0, "CPU load must be nonnegative but was %s", cpu);
        Preconditions.checkArgument(cpu <= 100, "CPU load must be less than 100 percent but was %s", cpu);
        Preconditions.checkArgument(memory >= 0L, "memory load must be nonnegative but was %s", memory);
        Preconditions.checkArgument(diskInput >= 0L, "Disk Input load must be nonnegative but was %s", diskInput);
        Preconditions.checkArgument(diskOutput >= 0L, "Disk Output load must be nonnegative but was %s", diskOutput);
        this.duration = duration;
        this.unit = Preconditions.checkNotNull(unit);
        this.cpu = cpu;
        this.memory = memory;
        this.diskInput = diskInput;
        this.diskOutput = diskOutput;
    }

    SimpleFakeLoad() {
        this(0L, TimeUnit.MILLISECONDS, 1, 0, 0L, 0L, 0L);
    }

    SimpleFakeLoad(long duration, TimeUnit unit) {
        this(duration, unit, 1, 0, 0L, 0L, 0L);
    }

    @Override
    public FakeLoad lasting(long duration, TimeUnit unit) {
        return new SimpleFakeLoad(duration, unit, this.getRepetitions(), this.cpu, this.memory, this.diskInput, this.diskOutput);
    }

    @Override
    public FakeLoad repeat(int repetitions) {
        return new SimpleFakeLoad(this.duration, this.unit, repetitions, this.cpu, this.memory, this.diskInput, this.diskOutput);
    }

    @Override
    public FakeLoad withCpu(int cpuLoad) {
        return new SimpleFakeLoad(this.duration, this.unit, this.getRepetitions(), cpuLoad, this.memory, this.diskInput, this.diskOutput);
    }

    @Override
    public FakeLoad withMemory(long amount, MemoryUnit unit) {
        long memoryLoad = unit.toBytes(amount);
        return new SimpleFakeLoad(this.duration, this.unit, this.getRepetitions(), this.cpu, memoryLoad, this.diskInput, this.diskOutput);
    }

    @Override
    public FakeLoad withDiskInput(long load, MemoryUnit unit) {
        long diskInputLoad = unit.toBytes(load);
        return new SimpleFakeLoad(this.duration, this.unit, this.getRepetitions(), this.cpu, this.memory, diskInputLoad, this.diskOutput);
    }

    @Override
    public FakeLoad withDiskOutput(long load, MemoryUnit unit) {
        long diskOutputLoad = unit.toBytes(load);
        return new SimpleFakeLoad(this.duration, this.unit, this.getRepetitions(), this.cpu, this.memory, this.diskInput, diskOutputLoad);
    }

    @Override
    public FakeLoad addLoad(FakeLoad load) {
        Preconditions.checkNotNull(load);
        ArrayList<FakeLoad> newLoads = new ArrayList<FakeLoad>();
        newLoads.add(load);
        return new CompositeFakeLoad(this, newLoads, this.getRepetitions());
    }

    @Override
    public FakeLoad addLoads(Collection<FakeLoad> loads) {
        Preconditions.checkNotNull(loads);
        ArrayList<FakeLoad> newLoads = new ArrayList<FakeLoad>(loads);
        return new CompositeFakeLoad(this, newLoads, this.getRepetitions());
    }

    @Override
    public Collection<FakeLoad> getInnerLoads() {
        return new ArrayList<FakeLoad>();
    }

    @Override
    public int getCpu() {
        return this.cpu;
    }

    @Override
    public long getMemory() {
        return this.memory;
    }

    @Override
    public long getDiskInput() {
        return this.diskInput;
    }

    @Override
    public long getDiskOutput() {
        return this.diskOutput;
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public TimeUnit getTimeUnit() {
        return this.unit;
    }

    @Override
    public boolean contains(FakeLoad load) {
        return this.equals(load);
    }

    @Override
    public Iterator<FakeLoad> iterator() {
        return new Iterator<FakeLoad>(){
            private int repetitions = 0;

            @Override
            public boolean hasNext() {
                return this.repetitions < SimpleFakeLoad.this.getRepetitions();
            }

            @Override
            public FakeLoad next() {
                if (this.hasNext()) {
                    ++this.repetitions;
                    return SimpleFakeLoad.this;
                }
                throw new NoSuchElementException();
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleFakeLoad)) {
            return false;
        }
        SimpleFakeLoad fakeLoad = (SimpleFakeLoad)o;
        if (this.duration != fakeLoad.duration) {
            return false;
        }
        if (this.cpu != fakeLoad.cpu) {
            return false;
        }
        if (this.memory != fakeLoad.memory) {
            return false;
        }
        if (this.diskInput != fakeLoad.diskInput) {
            return false;
        }
        if (this.getRepetitions() != fakeLoad.getRepetitions()) {
            return false;
        }
        return this.unit == fakeLoad.unit;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.duration, this.getRepetitions(), this.cpu, this.memory, this.diskInput, this.unit});
    }

    public String toString() {
        return "SimpleFakeLoad{duration=" + this.duration + ", unit=" + (Object)((Object)this.unit) + ", cpu=" + this.cpu + ", memory=" + this.memory + ", diskInput=" + this.diskInput + ", diskOutput=" + this.diskOutput + ", repetitions=" + this.getRepetitions() + '}';
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    private Object writeReplace() {
        return new AbstractFakeLoad.SerializationProxy(this);
    }
}

