/*
 * Decompiled with CFR 0.152.
 */
package com.martensigwart.fakeload;

import com.martensigwart.fakeload.FakeLoad;
import com.martensigwart.fakeload.MaximumLoadExceededException;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class SystemLoad {
    @GuardedBy(value="this")
    private long cpu = 0L;
    @GuardedBy(value="this")
    private long memory = 0L;
    @GuardedBy(value="this")
    private long diskInput = 0L;
    @GuardedBy(value="this")
    private long diskOutput = 0L;

    public synchronized long getCpu() {
        return this.cpu;
    }

    public synchronized long getMemory() {
        return this.memory;
    }

    public synchronized long getDiskInput() {
        return this.diskInput;
    }

    public synchronized long getDiskOutput() {
        return this.diskOutput;
    }

    public synchronized void increaseBy(FakeLoad load) throws MaximumLoadExceededException {
        this.checkMaximumLoadNotExceeded(load);
        this.cpu += (long)load.getCpu();
        this.memory += load.getMemory();
        this.diskInput += load.getDiskInput();
        this.diskOutput += load.getDiskOutput();
    }

    public synchronized void decreaseBy(FakeLoad load) {
        this.checkNotBelowMinimumLoad(load);
        this.cpu -= (long)load.getCpu();
        this.memory -= load.getMemory();
        this.diskInput -= load.getDiskInput();
        this.diskOutput -= load.getDiskOutput();
    }

    private synchronized void checkMaximumLoadNotExceeded(FakeLoad load) throws MaximumLoadExceededException {
        if (this.cpu + (long)load.getCpu() > 100L) {
            throw new MaximumLoadExceededException(String.format("Increase of %d would cause a CPU load of over 100%%", load.getCpu()));
        }
    }

    private synchronized void checkNotBelowMinimumLoad(FakeLoad load) {
        if (this.cpu - (long)load.getCpu() < 0L) {
            throw new RuntimeException(String.format("Decrease of %d would cause a negative CPU load", load.getCpu()));
        }
        if (this.memory - load.getMemory() < 0L) {
            throw new RuntimeException(String.format("Decrease of %d would cause a negative memory load", load.getMemory()));
        }
        if (this.diskInput - load.getDiskInput() < 0L) {
            throw new RuntimeException(String.format("Decrease of %d would cause a negative disk input load", load.getDiskInput()));
        }
        if (this.diskOutput - load.getDiskOutput() < 0L) {
            throw new RuntimeException(String.format("Decrease of %d would cause a negative disk output load", load.getDiskOutput()));
        }
    }
}

