/*
 * Decompiled with CFR 0.152.
 */
package dnl.utils.text.tree;

import java.io.PrintStream;
import javax.swing.tree.TreeModel;

public class TextTree {
    private TreeModel model;
    private boolean showRoot = true;
    private StringBuilder sb;

    public TextTree(TreeModel model) {
        this.model = model;
    }

    public boolean isShowRoot() {
        return this.showRoot;
    }

    public void setShowRoot(boolean showRoot) {
        this.showRoot = showRoot;
    }

    public void printTree() {
        System.out.println(this.toString());
    }

    public void printTree(PrintStream printStream) {
        printStream.println(this.toString());
    }

    public String toString() {
        this.sb = new StringBuilder();
        Object root = this.model.getRoot();
        this.printNode(root, "", "", this.showRoot);
        return this.sb.toString();
    }

    private void printNode(Object node, String pref, String bud, boolean render) {
        if (render) {
            this.sb.append(pref);
            this.sb.append(bud);
            this.sb.append("-- ");
            this.sb.append(node.toString());
            this.sb.append("\n");
        }
        String pref1 = pref + "   ";
        String pref2 = pref + "   |";
        String pref3 = pref + "";
        int childCount = this.model.getChildCount(node);
        if (childCount > 0) {
            for (int i = 0; i < childCount; ++i) {
                String bud2;
                String ind;
                boolean lastElement;
                boolean bl = lastElement = i == childCount - 1;
                if (lastElement) {
                    ind = pref1;
                    bud2 = "`";
                } else {
                    ind = pref2;
                    bud2 = "";
                }
                this.printNode(this.model.getChild(node, i), !render ? pref3 : ind, !render ? "" : bud2, true);
            }
        }
    }
}

