/*
 * Decompiled with CFR 0.152.
 */
package com.moesif.api.controllers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.moesif.api.APIHelper;
import com.moesif.api.Base64;
import com.moesif.api.Configuration;
import com.moesif.api.IAPIController;
import com.moesif.api.controllers.BaseController;
import com.moesif.api.controllers.syncwrapper.APICallBackCatcher;
import com.moesif.api.exceptions.APIException;
import com.moesif.api.http.client.APICallBack;
import com.moesif.api.http.client.HttpContext;
import com.moesif.api.http.request.HttpBodyRequest;
import com.moesif.api.http.request.HttpRequest;
import com.moesif.api.http.response.HttpResponse;
import com.moesif.api.models.AppConfigBuilder;
import com.moesif.api.models.AppConfigModel;
import com.moesif.api.models.CompanyModel;
import com.moesif.api.models.EntityRuleModel;
import com.moesif.api.models.EventBuilder;
import com.moesif.api.models.EventModel;
import com.moesif.api.models.EventRequestModel;
import com.moesif.api.models.EventResponseModel;
import com.moesif.api.models.GovernanceRuleRegexConditionModel;
import com.moesif.api.models.GovernanceRuleRegexRuleModel;
import com.moesif.api.models.GovernanceRulesModel;
import com.moesif.api.models.GovernanceRulesResponseModel;
import com.moesif.api.models.GovernanceRulesVariableModel;
import com.moesif.api.models.RegexConfigModel;
import com.moesif.api.models.UserModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class APIController
extends BaseController
implements IAPIController {
    private static final Logger logger = Logger.getLogger(APIController.class.toString());
    private static final String APP_CONFIG_ETAG_HEADER = "x-moesif-config-etag";
    private static final String RULES_ETAG_HEADER = "x-moesif-rules-tag";
    private static final int APP_CONFIG_DEBOUNCE = 300000;
    private volatile long lastAppConfigFetch;
    private boolean shouldSyncAppConfig = true;
    private volatile AppConfigModel appConfigModel;
    private volatile String appConfigEtag;
    private volatile List<GovernanceRulesModel> governanceRules;
    private volatile String rulesEtag;
    private Configuration config;
    private ObjectMapper objectMapper = new ObjectMapper();

    public APIController(Configuration config) {
        this.config = config;
        this.getInitAppConfigModel();
        this.getGovernanceRulesModel();
    }

    @Override
    public Map<String, String> createEvent(EventModel body) throws Throwable {
        QueryInfo qInfo = this.getQueryInfo("/v1/events");
        HttpBodyRequest _request = APIController.getClientInstance().postBody(qInfo._queryUrl, qInfo._headers, APIHelper.serialize(body));
        if (this.getHttpCallBack() != null) {
            this.getHttpCallBack().OnBeforeRequest(_request);
        }
        return this.executeRequest(_request);
    }

    @Override
    public void createEventAsync(EventModel body, APICallBack<HttpResponse> callBack) throws JsonProcessingException {
        QueryInfo qInfo = this.getQueryInfo("/v1/events");
        HttpBodyRequest _request = APIController.getClientInstance().postBody(qInfo._queryUrl, qInfo._headers, APIHelper.serialize(body));
        this.executeRequestAsync(_request, callBack);
    }

    @Override
    public Map<String, String> createEventsBatch(List<EventModel> body) throws Throwable {
        QueryInfo qInfo = this.getQueryInfo("/v1/events/batch");
        HttpBodyRequest _request = APIController.getClientInstance().postBody(qInfo._queryUrl, qInfo._headers, APIHelper.serialize(body));
        return this.executeRequest(_request);
    }

    @Override
    public void createEventsBatchAsync(List<EventModel> body, APICallBack<HttpResponse> callBack) throws JsonProcessingException {
        QueryInfo qInfo = this.getQueryInfo("/v1/events/batch");
        HttpBodyRequest _request = APIController.getClientInstance().postBody(qInfo._queryUrl, qInfo._headers, APIHelper.serialize(body));
        this.executeRequestAsync(_request, callBack);
    }

    @Override
    public void updateUser(UserModel body) throws Throwable {
        APICallBackCatcher<HttpResponse> callback = new APICallBackCatcher<HttpResponse>();
        this.updateUserAsync(body, callback);
        if (!callback.isSuccess()) {
            throw callback.getError();
        }
        callback.getResult();
    }

    @Override
    public void updateUserAsync(UserModel body, APICallBack<HttpResponse> callBack) throws JsonProcessingException {
        QueryInfo qInfo = this.getQueryInfo("/v1/users");
        HttpBodyRequest _request = APIController.getClientInstance().postBody(qInfo._queryUrl, qInfo._headers, APIHelper.serialize(body));
        this.executeRequestAsync(_request, callBack);
    }

    @Override
    public void updateUsersBatch(List<UserModel> body) throws Throwable {
        APICallBackCatcher<HttpResponse> callback = new APICallBackCatcher<HttpResponse>();
        this.updateUsersBatchAsync(body, callback);
        if (!callback.isSuccess()) {
            throw callback.getError();
        }
        callback.getResult();
    }

    @Override
    public void updateUsersBatchAsync(List<UserModel> body, APICallBack<HttpResponse> callBack) throws JsonProcessingException {
        QueryInfo qInfo = this.getQueryInfo("/v1/users/batch");
        HttpBodyRequest _request = APIController.getClientInstance().postBody(qInfo._queryUrl, qInfo._headers, APIHelper.serialize(body));
        this.executeRequestAsync(_request, callBack);
    }

    @Override
    public void updateCompany(CompanyModel body) throws Throwable {
        APICallBackCatcher<HttpResponse> callback = new APICallBackCatcher<HttpResponse>();
        this.updateCompanyAsync(body, callback);
        if (!callback.isSuccess()) {
            throw callback.getError();
        }
        callback.getResult();
    }

    @Override
    public void updateCompanyAsync(CompanyModel body, APICallBack<HttpResponse> callBack) throws JsonProcessingException {
        QueryInfo qInfo = this.getQueryInfo("/v1/companies");
        HttpBodyRequest _request = APIController.getClientInstance().postBody(qInfo._queryUrl, qInfo._headers, APIHelper.serialize(body));
        this.executeRequestAsync(_request, callBack);
    }

    @Override
    public void updateCompaniesBatch(List<CompanyModel> body) throws Throwable {
        APICallBackCatcher<HttpResponse> callback = new APICallBackCatcher<HttpResponse>();
        this.updateCompaniesBatchAsync(body, callback);
        if (!callback.isSuccess()) {
            throw callback.getError();
        }
        callback.getResult();
    }

    @Override
    public void updateCompaniesBatchAsync(List<CompanyModel> body, APICallBack<HttpResponse> callBack) throws JsonProcessingException {
        QueryInfo qInfo = this.getQueryInfo("/v1/companies/batch");
        HttpBodyRequest _request = APIController.getClientInstance().postBody(qInfo._queryUrl, qInfo._headers, APIHelper.serialize(body));
        this.executeRequestAsync(_request, callBack);
    }

    @Override
    public HttpResponse getAppConfig() throws Throwable {
        QueryInfo qInfo = this.getQueryInfo("/v1/config");
        HttpRequest _request = APIController.getClientInstance().get(qInfo._queryUrl, qInfo._headers, null);
        if (this.getHttpCallBack() != null) {
            this.getHttpCallBack().OnBeforeRequest(_request);
        }
        HttpResponse _response = APIController.getClientInstance().executeAsString(_request);
        HttpContext _context = new HttpContext(_request, _response);
        if (this.getHttpCallBack() != null) {
            this.getHttpCallBack().OnAfterResponse(_context);
        }
        this.validateResponse(_response, _context);
        return _response;
    }

    private void getInitAppConfigModel() {
        try {
            HttpResponse response = this.getAppConfig();
            String newAppConfigEtag = response.getHeaders().get(APP_CONFIG_ETAG_HEADER);
            InputStream respBodyIs = response.getRawBody();
            this.appConfigModel = this.parseAppConfigModel(respBodyIs);
            respBodyIs.close();
            logger.info("App Config Model returned is " + this.appConfigModel);
            this.appConfigEtag = newAppConfigEtag;
            this.lastAppConfigFetch = new Date().getTime();
        }
        catch (Throwable e) {
            e.printStackTrace();
            logger.warning("Error getting AppConfig: " + e.getMessage());
            this.appConfigModel = this.getDefaultAppConfig();
            this.lastAppConfigFetch = new Date().getTime();
        }
    }

    private void getGovernanceRulesModel() {
        try {
            HttpResponse response = this.getGovernanceRules();
            this.rulesEtag = response.getHeaders().get(RULES_ETAG_HEADER);
            InputStream respBodyIs = response.getRawBody();
            this.governanceRules = this.parseGovernanceRulesModel(respBodyIs);
            respBodyIs.close();
            logger.info("Governance model returned is  " + this.governanceRules);
        }
        catch (Throwable e) {
            logger.warning("Error getting GovernanceRules: " + e.getMessage());
            this.governanceRules = new ArrayList<GovernanceRulesModel>();
        }
    }

    @Override
    public void getAppConfigAsync(APICallBack<HttpResponse> callBack) throws JsonProcessingException {
        QueryInfo qInfo = this.getQueryInfo("/v1/config");
        HttpRequest _request = APIController.getClientInstance().get(qInfo._queryUrl, qInfo._headers, null);
        this.executeRequestAsync(_request, callBack);
    }

    @Override
    public HttpResponse getGovernanceRules() throws Throwable {
        QueryInfo qInfo = this.getQueryInfo("/v1/rules");
        HttpRequest _request = APIController.getClientInstance().get(qInfo._queryUrl, qInfo._headers, null);
        if (this.getHttpCallBack() != null) {
            this.getHttpCallBack().OnBeforeRequest(_request);
        }
        HttpResponse _response = APIController.getClientInstance().executeAsString(_request);
        HttpContext _context = new HttpContext(_request, _response);
        if (this.getHttpCallBack() != null) {
            this.getHttpCallBack().OnAfterResponse(_context);
        }
        this.validateResponse(_response, _context);
        return _response;
    }

    @Override
    public void getGovernanceRulesAsync(APICallBack<HttpResponse> callBack) throws JsonProcessingException {
        QueryInfo qInfo = this.getQueryInfo("/v1/rules");
        HttpRequest _request = APIController.getClientInstance().get(qInfo._queryUrl, qInfo._headers, null);
        this.executeRequestAsync(_request, callBack);
    }

    private QueryInfo getQueryInfo(String url) {
        if (this.config.applicationId == null || this.config.applicationId.equals("")) {
            throw new IllegalArgumentException("A Moesif Application Id is required. Please obtain it through your settings at www.moesif.com");
        }
        if (this.config.baseUri == null || this.config.baseUri.equals("")) {
            throw new IllegalArgumentException("The API BaseUri is required.");
        }
        String _baseUri = this.config.baseUri;
        StringBuilder _queryBuilder = new StringBuilder(_baseUri);
        _queryBuilder.append(url);
        String _queryUrl = APIHelper.cleanUrl(_queryBuilder);
        HashMap<String, String> _headers = new HashMap<String, String>(){
            {
                this.put("X-Moesif-Application-Id", ((APIController)APIController.this).config.applicationId);
            }
        };
        return new QueryInfo(_queryUrl, (Map<String, String>)_headers);
    }

    private Map<String, String> executeRequest(HttpRequest _request) throws Throwable {
        HttpResponse _response = APIController.getClientInstance().executeAsString(_request);
        Map<String, String> headers = _response.getHeaders();
        HttpContext _context = new HttpContext(_request, _response);
        if (this.getHttpCallBack() != null) {
            this.getHttpCallBack().OnAfterResponse(_context);
        }
        this.validateResponse(_response, _context);
        this.checkAppConfigEtag(headers.get(APP_CONFIG_ETAG_HEADER));
        this.checkRulesEtag(_response.getHeaders().get(RULES_ETAG_HEADER));
        return headers;
    }

    private void executeRequestAsync(final HttpRequest _request, final APICallBack<HttpResponse> callBack) {
        if (this.getHttpCallBack() != null) {
            this.getHttpCallBack().OnBeforeRequest(_request);
        }
        Runnable _responseTask = new Runnable(){

            @Override
            public void run() {
                BaseController.getClientInstance().executeAsStringAsync(_request, APIController.this.createHttpResponseCallback(callBack));
            }
        };
        APIHelper.getScheduler().execute(_responseTask);
    }

    private AppConfigModel getCachedAppConfig() {
        this.trySyncAppConfig(true);
        return this.appConfigModel;
    }

    private void checkAppConfigEtag(String newAppConfigEtag) {
        if (newAppConfigEtag != null && !newAppConfigEtag.equals(this.appConfigEtag)) {
            this.trySyncAppConfig(false);
        }
    }

    private void checkRulesEtag(String newRulesEtag) {
        if (newRulesEtag != null && !newRulesEtag.equals(this.rulesEtag)) {
            this.getGovernanceRulesModel();
        }
    }

    private void trySyncAppConfig(Boolean timeCheck) {
        long now = new Date().getTime();
        if (timeCheck.booleanValue()) {
            boolean willFetch;
            boolean bl = willFetch = this.lastAppConfigFetch + 300000L < now;
            if (willFetch) {
                this.syncAppConfig(timeCheck);
            }
        } else {
            this.syncAppConfig(timeCheck);
        }
    }

    public List<GovernanceRulesModel> parseGovernanceRulesModel(InputStream jsonTxt) throws IOException {
        return (List)this.objectMapper.readValue(jsonTxt, (TypeReference)new TypeReference<List<GovernanceRulesModel>>(){});
    }

    public AppConfigModel parseAppConfigModel(InputStream jsonTxt) throws IOException {
        return (AppConfigModel)this.objectMapper.readValue(jsonTxt, AppConfigModel.class);
    }

    private void syncAppConfig(final Boolean etagCheck) {
        if (this.shouldSyncAppConfig) {
            APICallBack<HttpResponse> callback = new APICallBack<HttpResponse>(){

                @Override
                public void onSuccess(HttpContext context, HttpResponse response) {
                    if (etagCheck.booleanValue()) {
                        String newAppConfigEtag = response.getHeaders().get(APIController.APP_CONFIG_ETAG_HEADER);
                        if (newAppConfigEtag != null && !newAppConfigEtag.equals(APIController.this.appConfigEtag)) {
                            try {
                                InputStream respBodyIs = response.getRawBody();
                                APIController.this.appConfigModel = APIController.this.parseAppConfigModel(respBodyIs);
                                respBodyIs.close();
                            }
                            catch (Exception e) {
                                logger.warning("Invalid AppConfig JSON: " + e.getMessage());
                            }
                            logger.info("App Config Model returned is " + APIController.this.appConfigModel);
                            APIController.this.appConfigEtag = newAppConfigEtag;
                            APIController.this.lastAppConfigFetch = new Date().getTime();
                        }
                    } else {
                        try {
                            InputStream respBodyIs = response.getRawBody();
                            APIController.this.appConfigModel = APIController.this.parseAppConfigModel(respBodyIs);
                            respBodyIs.close();
                        }
                        catch (Exception e) {
                            logger.warning("Invalid AppConfig JSON: " + e.getMessage());
                        }
                        logger.info("App Config Model returned is " + APIController.this.appConfigModel);
                        APIController.this.appConfigEtag = response.getHeaders().get(APIController.APP_CONFIG_ETAG_HEADER);
                        APIController.this.lastAppConfigFetch = new Date().getTime();
                    }
                }

                @Override
                public void onFailure(HttpContext context, Throwable error) {
                }
            };
            try {
                this.getAppConfigAsync(callback);
            }
            catch (Exception e) {
                logger.warning("Error performing async operation");
            }
        }
    }

    public AppConfigModel getDefaultAppConfig() {
        return new AppConfigBuilder().sampleRate(100).build();
    }

    public int calculateWeight(int sampleRate) {
        return (int)(sampleRate == 0 ? 1.0 : Math.floor(100.0 / (double)sampleRate));
    }

    public EventModel buildEventModel(EventRequestModel eventRequestModel, EventResponseModel eventResponseModel, String userId, String companyId, String sessionToken, String apiVersion, Object metadata, String direction) {
        EventBuilder eb = new EventBuilder();
        eb.request(eventRequestModel);
        eb.response(eventResponseModel);
        if (userId != null) {
            eb.userId(userId);
        }
        if (companyId != null) {
            eb.companyId(companyId);
        }
        if (sessionToken != null) {
            eb.sessionToken(sessionToken);
        }
        if (apiVersion != null) {
            eb.tags(apiVersion);
        }
        if (metadata != null) {
            eb.metadata(metadata);
        }
        eb.direction(direction);
        return eb.build();
    }

    public boolean isBlockedByGovernanceRules(EventModel eventModel) {
        return this.isBlockedByGovernanceRules(eventModel, this.governanceRules, this.getCachedAppConfig());
    }

    public boolean isBlockedByGovernanceRules(EventModel eventModel, List<GovernanceRulesModel> rules, AppConfigModel appConfig) {
        if (rules.isEmpty()) {
            return false;
        }
        Map<String, String> regexMap = eventModel.getRegexMap();
        List<Tuple2<GovernanceRulesModel, EntityRuleModel>> users = this.getMatchingEntityRules(eventModel.getUserId(), "user", appConfig, rules);
        Tuple2 userTuple = users.stream().filter(tuple -> this.isRegexMatch((GovernanceRulesModel)tuple.a, regexMap)).findFirst().orElse(null);
        if (userTuple != null) {
            this.updateEventModel(eventModel, userTuple);
            return true;
        }
        List<Tuple2<GovernanceRulesModel, EntityRuleModel>> companies = this.getMatchingEntityRules(eventModel.getCompanyId(), "company", appConfig, rules);
        Tuple2 companyTuple = companies.stream().filter(tuple -> this.isRegexMatch((GovernanceRulesModel)tuple.a, regexMap)).findFirst().orElse(null);
        if (companyTuple != null) {
            this.updateEventModel(eventModel, companyTuple);
            return true;
        }
        List regexRules = rules.stream().filter(r -> r.getType().equals("regex")).collect(Collectors.toList());
        GovernanceRulesModel regexRule = regexRules.stream().filter(r -> this.isRegexMatch((GovernanceRulesModel)r, regexMap)).findFirst().orElse(null);
        if (regexRule != null) {
            this.updateEventModel(eventModel, new Tuple2<GovernanceRulesModel, Object>(regexRule, null));
            return true;
        }
        return false;
    }

    private List<Tuple2<GovernanceRulesModel, EntityRuleModel>> getMatchingEntityRules(String entityId, String type, AppConfigModel appConfig, List<GovernanceRulesModel> rules) {
        Map<String, List<EntityRuleModel>> entityRules;
        ArrayList<Tuple2<GovernanceRulesModel, EntityRuleModel>> matching = new ArrayList<Tuple2<GovernanceRulesModel, EntityRuleModel>>();
        Map<String, List<EntityRuleModel>> map = entityRules = type.equals("user") ? appConfig.getUserRules() : appConfig.getCompanyRules();
        if (entityId == null) {
            for (GovernanceRulesModel m : rules) {
                if (!m.isAppliedToUnidentified() || !m.getType().equals(type)) continue;
                matching.add(new Tuple2<GovernanceRulesModel, Object>(m, null));
            }
            return matching;
        }
        if (entityRules.containsKey(entityId)) {
            for (EntityRuleModel e : entityRules.get(entityId)) {
                for (GovernanceRulesModel m : rules) {
                    if (!m.getId().equals(e.getRules()) || !m.getType().equals(type) || !m.getAppliedTo().equals("matching")) continue;
                    matching.add(new Tuple2<GovernanceRulesModel, EntityRuleModel>(m, e));
                }
            }
            return matching;
        }
        for (GovernanceRulesModel m : rules) {
            if (!m.getAppliedTo().equals("not_matching") || !m.getType().equals(type)) continue;
            matching.add(new Tuple2<GovernanceRulesModel, Object>(m, null));
        }
        return matching;
    }

    private boolean isRegexMatch(GovernanceRulesModel m, Map<String, String> regexMap) {
        List<GovernanceRuleRegexRuleModel> regexModels = m.getRegexConfig();
        if (regexModels == null || regexModels.isEmpty()) {
            return true;
        }
        for (GovernanceRuleRegexRuleModel r : regexModels) {
            Boolean match = false;
            for (GovernanceRuleRegexConditionModel con : r.getConditions()) {
                if (regexMap.containsKey(con.getPath())) {
                    Pattern pattern = Pattern.compile(con.getValue(), 2);
                    Matcher matcher = pattern.matcher(regexMap.get(con.getPath()));
                    if (matcher.find()) {
                        match = true;
                        continue;
                    }
                    match = false;
                    break;
                }
                match = false;
                break;
            }
            if (!match.booleanValue()) continue;
            return true;
        }
        return false;
    }

    private void updateEventModel(EventModel eventModel, Tuple2<GovernanceRulesModel, EntityRuleModel> tuple) {
        if (tuple.b == null) {
            this.updateEventModel(eventModel, ((GovernanceRulesModel)tuple.a).getId(), ((GovernanceRulesModel)tuple.a).getResponse());
        } else {
            String body = ((GovernanceRulesModel)tuple.a).getResponse().getBody().toString();
            List variableModels = ((GovernanceRulesModel)tuple.a).getVariables().stream().map(m -> {
                GovernanceRulesVariableModel v = new GovernanceRulesVariableModel();
                v.setName(String.format("{{{{{%s}}}}}", m.getName()));
                v.setPath(m.getPath());
                return v;
            }).collect(Collectors.toList());
            for (GovernanceRulesVariableModel v : variableModels) {
                body = body.replace(v.getName(), v.getPath());
            }
            ((GovernanceRulesModel)tuple.a).getResponse().setBody(body);
            Map<String, String> headers = ((GovernanceRulesModel)tuple.a).getResponse().getHeaders().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
                String value = (String)e.getValue();
                for (GovernanceRulesVariableModel v : variableModels) {
                    value = value.replace(v.getName(), v.getPath());
                }
                return value;
            }));
            ((GovernanceRulesModel)tuple.a).getResponse().setHeaders(headers);
            this.updateEventModel(eventModel, ((GovernanceRulesModel)tuple.a).getId(), ((GovernanceRulesModel)tuple.a).getResponse());
        }
    }

    private void updateEventModel(EventModel eventModel, String ruleId, GovernanceRulesResponseModel response) {
        eventModel.setBlockedBy(ruleId);
        EventResponseModel eventResponseModel = new EventResponseModel();
        eventResponseModel.setTime(new Date());
        eventResponseModel.setStatus(response.getStatus());
        eventResponseModel.setHeaders(response.getHeaders());
        try {
            Object body = APIHelper.deserialize(response.getBody().toString(), new TypeReference<Object>(){});
            eventResponseModel.setBody(body);
            eventResponseModel.setTransferEncoding("json");
        }
        catch (Exception e) {
            byte[] encodedBytes = Base64.encode(response.getBody().toString().getBytes(), 0);
            eventResponseModel.setBody(new String(encodedBytes));
            eventResponseModel.setTransferEncoding("base64");
        }
        eventModel.setResponse(eventResponseModel);
    }

    public boolean shouldSendSampledEvent(EventModel eventModel) {
        double randomPercentage;
        int sampleRate = this.getSampleRateToUse(eventModel);
        return (double)sampleRate >= (randomPercentage = Math.random() * 100.0);
    }

    public int getSampleRateToUse(EventModel eventModel) {
        return this.getSampleRateToUse(eventModel, this.getCachedAppConfig());
    }

    public int getSampleRateToUse(EventModel eventModel, AppConfigModel appConfigModel) {
        ArrayList<Integer> sampleRates = new ArrayList<Integer>();
        if (eventModel.getUserId() != null && appConfigModel.getUserSampleRate().containsKey(eventModel.getUserId())) {
            sampleRates.add(appConfigModel.getUserSampleRate().get(eventModel.getUserId()));
        } else if (eventModel.getCompanyId() != null && appConfigModel.getCompanySampleRate().containsKey(eventModel.getCompanyId())) {
            sampleRates.add(appConfigModel.getCompanySampleRate().get(eventModel.getCompanyId()));
        }
        if (!appConfigModel.getRegex_config().isEmpty()) {
            Map<String, String> regexMap = eventModel.getRegexMap();
            for (RegexConfigModel regexConfigModel : appConfigModel.getRegex_config()) {
                Boolean match = false;
                for (GovernanceRuleRegexConditionModel con : regexConfigModel.conditions) {
                    if (!regexMap.containsKey(con.getPath())) continue;
                    Pattern pattern = Pattern.compile(con.getValue(), 2);
                    Matcher matcher = pattern.matcher(regexMap.get(con.getPath()));
                    if (matcher.find()) {
                        match = true;
                        continue;
                    }
                    match = false;
                }
                if (!match.booleanValue()) continue;
                sampleRates.add(regexConfigModel.sampeleRate);
                break;
            }
        }
        return sampleRates.isEmpty() ? appConfigModel.getSampleRate() : ((Integer)Collections.min(sampleRates)).intValue();
    }

    private APICallBack<HttpResponse> createHttpResponseCallback(final APICallBack<HttpResponse> callBack) {
        return new APICallBack<HttpResponse>(){

            @Override
            public void onSuccess(HttpContext _context, HttpResponse _response) {
                try {
                    if (APIController.this.getHttpCallBack() != null) {
                        APIController.this.getHttpCallBack().OnAfterResponse(_context);
                    }
                    APIController.this.validateResponse(_response, _context);
                    APIController.this.checkAppConfigEtag(_response.getHeaders().get(APIController.APP_CONFIG_ETAG_HEADER));
                    APIController.this.checkRulesEtag(_response.getHeaders().get(APIController.RULES_ETAG_HEADER));
                    callBack.onSuccess(_context, _response);
                }
                catch (APIException error) {
                    callBack.onFailure(_context, error);
                }
                catch (Exception exception) {
                    callBack.onFailure(_context, exception);
                }
            }

            @Override
            public void onFailure(HttpContext _context, Throwable _error) {
                if (APIController.this.getHttpCallBack() != null) {
                    APIController.this.getHttpCallBack().OnAfterResponse(_context);
                }
                callBack.onFailure(_context, _error);
            }
        };
    }

    static final class Tuple2<A, B> {
        final A a;
        final B b;

        public Tuple2(A a, B b) {
            this.a = a;
            this.b = b;
        }
    }

    private static class QueryInfo {
        String _queryUrl;
        Map<String, String> _headers;

        public QueryInfo(String url, Map<String, String> headers) {
            this._queryUrl = url;
            this._headers = headers;
        }
    }
}

