/*
 * Decompiled with CFR 0.152.
 */
package com.moesif.api.controllers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.moesif.api.APIHelper;
import com.moesif.api.Configuration;
import com.moesif.api.IHealthController;
import com.moesif.api.controllers.BaseController;
import com.moesif.api.controllers.syncwrapper.APICallBackCatcher;
import com.moesif.api.exceptions.APIException;
import com.moesif.api.http.client.APICallBack;
import com.moesif.api.http.client.HttpContext;
import com.moesif.api.http.request.HttpRequest;
import com.moesif.api.http.response.HttpResponse;
import com.moesif.api.http.response.HttpStringResponse;
import com.moesif.api.models.StatusModel;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class HealthController
extends BaseController
implements IHealthController {
    private Configuration config;

    public HealthController(Configuration config) {
        this.config = config;
    }

    @Override
    public StatusModel getHealthProbe() throws Throwable {
        APICallBackCatcher<StatusModel> callback = new APICallBackCatcher<StatusModel>();
        this.getHealthProbeAsync(callback);
        if (!callback.isSuccess()) {
            throw callback.getError();
        }
        return callback.getResult();
    }

    @Override
    public void getHealthProbeAsync(final APICallBack<StatusModel> callBack) {
        String _baseUri = this.config.baseUri;
        StringBuilder _queryBuilder = new StringBuilder(_baseUri);
        _queryBuilder.append("/health/probe");
        String _queryUrl = APIHelper.cleanUrl(_queryBuilder);
        HashMap<String, String> _headers = new HashMap<String, String>(){
            private static final long serialVersionUID = 5262405786134955276L;
            {
                this.put("accept", "application/json");
                this.put("X-Moesif-Application-Id", ((HealthController)HealthController.this).config.applicationId);
            }
        };
        final HttpRequest _request = HealthController.getClientInstance().get(_queryUrl, (Map<String, String>)_headers, null);
        if (this.getHttpCallBack() != null) {
            this.getHttpCallBack().OnBeforeRequest(_request);
        }
        Runnable _responseTask = new Runnable(){

            @Override
            public void run() {
                BaseController.getClientInstance().executeAsStringAsync(_request, new APICallBack<HttpResponse>(){

                    @Override
                    public void onSuccess(HttpContext _context, HttpResponse _response) {
                        try {
                            if (HealthController.this.getHttpCallBack() != null) {
                                HealthController.this.getHttpCallBack().OnAfterResponse(_context);
                            }
                            HealthController.this.validateResponse(_response, _context);
                            String _responseBody = ((HttpStringResponse)_response).getBody();
                            StatusModel _result = APIHelper.deserialize(_responseBody, new TypeReference<StatusModel>(){});
                            callBack.onSuccess(_context, _result);
                        }
                        catch (APIException error) {
                            callBack.onFailure(_context, error);
                        }
                        catch (IOException ioException) {
                            callBack.onFailure(_context, ioException);
                        }
                        catch (Exception exception) {
                            callBack.onFailure(_context, exception);
                        }
                    }

                    @Override
                    public void onFailure(HttpContext _context, Throwable _error) {
                        if (HealthController.this.getHttpCallBack() != null) {
                            HealthController.this.getHttpCallBack().OnAfterResponse(_context);
                        }
                        callBack.onFailure(_context, _error);
                    }
                });
            }
        };
        APIHelper.getScheduler().execute(_responseTask);
    }

    public void setConfig(Configuration config) {
        this.config = config;
    }
}

