/*
 * Decompiled with CFR 0.152.
 */
package com.mohiva.play.silhouette.impl.authenticators;

import com.mohiva.play.silhouette.api.Logger;
import com.mohiva.play.silhouette.api.LoginInfo;
import com.mohiva.play.silhouette.api.LoginInfo$;
import com.mohiva.play.silhouette.api.crypto.AuthenticatorEncoder;
import com.mohiva.play.silhouette.api.crypto.Signer;
import com.mohiva.play.silhouette.api.exceptions.AuthenticatorException;
import com.mohiva.play.silhouette.api.exceptions.AuthenticatorException$;
import com.mohiva.play.silhouette.api.util.JsonFormats$FiniteDurationFormat$;
import com.mohiva.play.silhouette.impl.authenticators.CookieAuthenticator;
import com.mohiva.play.silhouette.impl.authenticators.CookieAuthenticatorService$;
import java.io.Serializable;
import org.joda.time.DateTime;
import play.api.libs.functional.FunctionalCanBuild$;
import play.api.libs.functional.syntax.package$;
import play.api.libs.json.Format;
import play.api.libs.json.Format$;
import play.api.libs.json.JodaReads$;
import play.api.libs.json.JodaWrites$;
import play.api.libs.json.JsError;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsResult$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json;
import play.api.libs.json.Json$;
import play.api.libs.json.JsonConfiguration$;
import play.api.libs.json.OFormat;
import play.api.libs.json.OFormat$;
import play.api.libs.json.OWrites$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.Function0;
import scala.Function1;
import scala.Function7;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple7;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class CookieAuthenticator$
implements Logger,
Serializable {
    public static final CookieAuthenticator$ MODULE$ = new CookieAuthenticator$();
    private static final OFormat<CookieAuthenticator> jsonFormat;
    private static play.api.Logger logger;

    static {
        Logger.$init$(MODULE$);
        OFormat underlying = (OFormat)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash(JsonConfiguration$.MODULE$.default((Json.MacroOptions$.Default)Json.MacroOptions$.Default$.macroOptionsDefault$.MODULE$).naming().apply("id")).format(Format$.MODULE$.GenericFormat((Reads)Reads$.MODULE$.StringReads(), (Writes)Writes$.MODULE$.StringWrites())), OFormat$.MODULE$.functionalCanBuildFormats(FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult())), OWrites$.MODULE$.functionalCanBuildOWrites())).and((Object)JsPath$.MODULE$.$bslash(JsonConfiguration$.MODULE$.default((Json.MacroOptions$.Default)Json.MacroOptions$.Default$.macroOptionsDefault$.MODULE$).naming().apply("loginInfo")).format(LoginInfo$.MODULE$.jsonFormat())).and((Object)JsPath$.MODULE$.$bslash(JsonConfiguration$.MODULE$.default((Json.MacroOptions$.Default)Json.MacroOptions$.Default$.macroOptionsDefault$.MODULE$).naming().apply("lastUsedDateTime")).format(Format$.MODULE$.GenericFormat(JodaReads$.MODULE$.DefaultJodaDateTimeReads(), (Writes)JodaWrites$.MODULE$.JodaDateTimeWrites()))).and((Object)JsPath$.MODULE$.$bslash(JsonConfiguration$.MODULE$.default((Json.MacroOptions$.Default)Json.MacroOptions$.Default$.macroOptionsDefault$.MODULE$).naming().apply("expirationDateTime")).format(Format$.MODULE$.GenericFormat(JodaReads$.MODULE$.DefaultJodaDateTimeReads(), (Writes)JodaWrites$.MODULE$.JodaDateTimeWrites()))).and((Object)JsonConfiguration$.MODULE$.default((Json.MacroOptions$.Default)Json.MacroOptions$.Default$.macroOptionsDefault$.MODULE$).optionHandlers().formatHandler(JsPath$.MODULE$.$bslash(JsonConfiguration$.MODULE$.default((Json.MacroOptions$.Default)Json.MacroOptions$.Default$.macroOptionsDefault$.MODULE$).naming().apply("idleTimeout")), (Format)JsonFormats$FiniteDurationFormat$.MODULE$)).and((Object)JsonConfiguration$.MODULE$.default((Json.MacroOptions$.Default)Json.MacroOptions$.Default$.macroOptionsDefault$.MODULE$).optionHandlers().formatHandler(JsPath$.MODULE$.$bslash(JsonConfiguration$.MODULE$.default((Json.MacroOptions$.Default)Json.MacroOptions$.Default$.macroOptionsDefault$.MODULE$).naming().apply("cookieMaxAge")), (Format)JsonFormats$FiniteDurationFormat$.MODULE$)).and((Object)JsonConfiguration$.MODULE$.default((Json.MacroOptions$.Default)Json.MacroOptions$.Default$.macroOptionsDefault$.MODULE$).optionHandlers().formatHandler(JsPath$.MODULE$.$bslash(JsonConfiguration$.MODULE$.default((Json.MacroOptions$.Default)Json.MacroOptions$.Default$.macroOptionsDefault$.MODULE$).naming().apply("fingerprint")), Format$.MODULE$.GenericFormat((Reads)Reads$.MODULE$.StringReads(), (Writes)Writes$.MODULE$.StringWrites()))).apply((Function7 & Serializable)(id, loginInfo, lastUsedDateTime, expirationDateTime, idleTimeout, cookieMaxAge, fingerprint) -> new CookieAuthenticator((String)id, (LoginInfo)loginInfo, (DateTime)lastUsedDateTime, (DateTime)expirationDateTime, (Option<FiniteDuration>)idleTimeout, (Option<FiniteDuration>)cookieMaxAge, (Option<String>)fingerprint), package$.MODULE$.unlift((Function1 & Serializable)x$0 -> MODULE$.unapply((CookieAuthenticator)x$0)), OFormat$.MODULE$.invariantFunctorOFormat());
        Function1 & Serializable rfn = (Function1 & Serializable)x0$1 -> {
            JsError jsError;
            JsValue jsValue = x0$1;
            if (jsValue instanceof JsObject) {
                JsObject jsObject = (JsObject)jsValue;
                jsError = underlying.reads((JsValue)jsObject);
            } else {
                jsError = JsError$.MODULE$.apply("error.expected.jsobject");
            }
            return jsError;
        };
        jsonFormat = OFormat$.MODULE$.apply((Function1)rfn, (Function1 & Serializable)o -> underlying.writes(o));
    }

    @Override
    public play.api.Logger logger() {
        return logger;
    }

    @Override
    public void com$mohiva$play$silhouette$api$Logger$_setter_$logger_$eq(play.api.Logger x$1) {
        logger = x$1;
    }

    public OFormat<CookieAuthenticator> jsonFormat() {
        return jsonFormat;
    }

    public String serialize(CookieAuthenticator authenticator, Signer signer, AuthenticatorEncoder authenticatorEncoder) {
        return signer.sign(authenticatorEncoder.encode(Json$.MODULE$.toJson((Object)authenticator, this.jsonFormat()).toString()));
    }

    public Try<CookieAuthenticator> unserialize(String str, Signer signer, AuthenticatorEncoder authenticatorEncoder) {
        Failure failure;
        Try<String> try_ = signer.extract(str);
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            String data = (String)success.value();
            failure = this.buildAuthenticator(authenticatorEncoder.decode(data));
        } else if (try_ instanceof Failure) {
            Failure failure2 = (Failure)try_;
            Throwable e = failure2.exception();
            failure = new Failure((Throwable)new AuthenticatorException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(CookieAuthenticatorService$.MODULE$.InvalidCookieSignature()), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{CookieAuthenticatorService$.MODULE$.ID()})), e));
        } else {
            throw new MatchError(try_);
        }
        return failure;
    }

    private Try<CookieAuthenticator> buildAuthenticator(String str) {
        Success success;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> Json$.MODULE$.parse(str));
        if (try_ instanceof Success) {
            Success success2;
            Success success3 = (Success)try_;
            JsValue json = (JsValue)success3.value();
            Either either = json.validate(this.jsonFormat()).asEither();
            if (either instanceof Left) {
                Left left = (Left)either;
                Seq error = (Seq)left.value();
                success2 = new Failure((Throwable)new AuthenticatorException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(CookieAuthenticatorService$.MODULE$.InvalidJsonFormat()), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{CookieAuthenticatorService$.MODULE$.ID(), error})), AuthenticatorException$.MODULE$.$lessinit$greater$default$2()));
            } else if (either instanceof Right) {
                Right right = (Right)either;
                CookieAuthenticator authenticator = (CookieAuthenticator)right.value();
                success2 = new Success((Object)authenticator);
            } else {
                throw new MatchError((Object)either);
            }
            success = success2;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable error = failure.exception();
            success = new Failure((Throwable)new AuthenticatorException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(CookieAuthenticatorService$.MODULE$.InvalidJson()), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{CookieAuthenticatorService$.MODULE$.ID(), str})), error));
        } else {
            throw new MatchError((Object)try_);
        }
        return success;
    }

    public CookieAuthenticator apply(String id, LoginInfo loginInfo, DateTime lastUsedDateTime, DateTime expirationDateTime, Option<FiniteDuration> idleTimeout, Option<FiniteDuration> cookieMaxAge, Option<String> fingerprint) {
        return new CookieAuthenticator(id, loginInfo, lastUsedDateTime, expirationDateTime, idleTimeout, cookieMaxAge, fingerprint);
    }

    public Option<Tuple7<String, LoginInfo, DateTime, DateTime, Option<FiniteDuration>, Option<FiniteDuration>, Option<String>>> unapply(CookieAuthenticator x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple7((Object)x$0.id(), (Object)x$0.loginInfo(), (Object)x$0.lastUsedDateTime(), (Object)x$0.expirationDateTime(), x$0.idleTimeout(), x$0.cookieMaxAge(), x$0.fingerprint()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CookieAuthenticator$.class);
    }

    private CookieAuthenticator$() {
    }
}

