/*
 * Decompiled with CFR 0.152.
 */
package com.mohiva.play.silhouette.impl.authenticators;

import com.atlassian.jwt.SigningAlgorithm;
import com.atlassian.jwt.core.writer.JsonSmartJwtJsonBuilder;
import com.atlassian.jwt.core.writer.NimbusJwtWriterFactory;
import com.atlassian.jwt.writer.JwtJsonBuilder;
import com.mohiva.play.silhouette.ScalaCompat$;
import com.mohiva.play.silhouette.api.LoginInfo;
import com.mohiva.play.silhouette.api.LoginInfo$;
import com.mohiva.play.silhouette.api.crypto.AuthenticatorEncoder;
import com.mohiva.play.silhouette.api.exceptions.AuthenticatorException;
import com.mohiva.play.silhouette.api.exceptions.AuthenticatorException$;
import com.mohiva.play.silhouette.impl.authenticators.JWTAuthenticator;
import com.mohiva.play.silhouette.impl.authenticators.JWTAuthenticatorService$;
import com.mohiva.play.silhouette.impl.authenticators.JWTAuthenticatorSettings;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jwt.JWTClaimsSet;
import java.io.Serializable;
import java.util.List;
import net.minidev.json.JSONObject;
import org.joda.time.DateTime;
import play.api.libs.json.JsArray;
import play.api.libs.json.JsArray$;
import play.api.libs.json.JsBoolean;
import play.api.libs.json.JsBoolean$;
import play.api.libs.json.JsNumber;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsObject$;
import play.api.libs.json.JsString;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class JWTAuthenticator$
implements Serializable {
    public static final JWTAuthenticator$ MODULE$ = new JWTAuthenticator$();

    public Option<JsObject> $lessinit$greater$default$6() {
        return None$.MODULE$;
    }

    public String serialize(JWTAuthenticator authenticator, AuthenticatorEncoder authenticatorEncoder, JWTAuthenticatorSettings settings) {
        String subject = Json$.MODULE$.toJson((Object)authenticator.loginInfo(), LoginInfo$.MODULE$.jsonFormat()).toString();
        JwtJsonBuilder jwtBuilder = new JsonSmartJwtJsonBuilder().jwtId(authenticator.id()).issuer(settings.issuerClaim()).subject(authenticatorEncoder.encode(subject)).issuedAt(authenticator.lastUsedDateTime().getMillis() / 1000L).expirationTime(authenticator.expirationDateTime().getMillis() / 1000L);
        authenticator.customClaims().foreach((Function1 & Serializable)data -> {
            JWTAuthenticator$.$anonfun$serialize$1(jwtBuilder, data);
            return BoxedUnit.UNIT;
        });
        return new NimbusJwtWriterFactory().macSigningWriter(SigningAlgorithm.HS256, settings.sharedSecret()).jsonToJwt(jwtBuilder.build());
    }

    public Try<JWTAuthenticator> unserialize(String str, AuthenticatorEncoder authenticatorEncoder, JWTAuthenticatorSettings settings) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            MACVerifier verifier = new MACVerifier(settings.sharedSecret());
            JWSObject jwsObject = JWSObject.parse((String)str);
            if (!jwsObject.verify((JWSVerifier)verifier)) {
                throw new IllegalArgumentException(new StringBuilder(22).append("Fraudulent JWT token: ").append(str).toString());
            }
            return JWTClaimsSet.parse((JSONObject)jwsObject.getPayload().toJSONObject());
        }).flatMap((Function1 & Serializable)c -> {
            String subject = authenticatorEncoder.decode(c.getSubject());
            return MODULE$.buildLoginInfo(subject).map((Function1 & Serializable)loginInfo -> {
                scala.collection.mutable.Map filteredClaims = (scala.collection.mutable.Map)ScalaCompat$.MODULE$.JavaConverters().MapHasAsScala(c.getClaims()).asScala().filterNot((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)JWTAuthenticator$.$anonfun$unserialize$4(x0$1)));
                JsObject customClaims = MODULE$.unserializeCustomClaims(ScalaCompat$.MODULE$.JavaConverters().MutableMapHasAsJava(filteredClaims).asJava());
                return new JWTAuthenticator(c.getJWTID(), (LoginInfo)loginInfo, new DateTime((Object)c.getIssueTime()), new DateTime((Object)c.getExpirationTime()), settings.authenticatorIdleTimeout(), (Option<JsObject>)(customClaims.keys().isEmpty() ? None$.MODULE$ : new Some((Object)customClaims)));
            });
        }).recover((PartialFunction)new Serializable(str){
            private static final long serialVersionUID = 0L;
            private final String str$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                throw new AuthenticatorException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(JWTAuthenticatorService$.MODULE$.InvalidJWTToken()), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{JWTAuthenticatorService$.MODULE$.ID(), this.str$1})), A1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                this.str$1 = str$1;
            }
        });
    }

    private java.util.Map<String, Object> serializeCustomClaims(JsObject claims) {
        return ScalaCompat$.MODULE$.JavaConverters().MapHasAsJava((Map)((IterableOnceOps)claims.fieldSet().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._1();
            JsValue value = (JsValue)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), this.toJava$1(value));
            return tuple22;
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
    }

    private JsObject unserializeCustomClaims(java.util.Map<String, Object> claims) {
        return JsObject$.MODULE$.apply((Seq)ScalaCompat$.MODULE$.JavaConverters().MapHasAsScala(claims).asScala().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._1();
            Object value = tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)this.toJson$1(value));
            return tuple22;
        }).toSeq());
    }

    private Try<LoginInfo> buildLoginInfo(String str) {
        Success success;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> Json$.MODULE$.parse(str));
        if (try_ instanceof Success) {
            Success success2 = (Success)try_;
            JsValue json = (JsValue)success2.value();
            success = new Success(json.as(LoginInfo$.MODULE$.jsonFormat()));
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable error = failure.exception();
            success = new Failure((Throwable)new AuthenticatorException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(JWTAuthenticatorService$.MODULE$.JsonParseError()), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{JWTAuthenticatorService$.MODULE$.ID(), str})), error));
        } else {
            throw new MatchError((Object)try_);
        }
        return success;
    }

    public JWTAuthenticator apply(String id, LoginInfo loginInfo, DateTime lastUsedDateTime, DateTime expirationDateTime, Option<FiniteDuration> idleTimeout, Option<JsObject> customClaims) {
        return new JWTAuthenticator(id, loginInfo, lastUsedDateTime, expirationDateTime, idleTimeout, customClaims);
    }

    public Option<JsObject> apply$default$6() {
        return None$.MODULE$;
    }

    public Option<Tuple6<String, LoginInfo, DateTime, DateTime, Option<FiniteDuration>, Option<JsObject>>> unapply(JWTAuthenticator x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple6((Object)x$0.id(), (Object)x$0.loginInfo(), (Object)x$0.lastUsedDateTime(), (Object)x$0.expirationDateTime(), x$0.idleTimeout(), x$0.customClaims()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JWTAuthenticator$.class);
    }

    public static final /* synthetic */ void $anonfun$serialize$1(JwtJsonBuilder jwtBuilder$1, JsObject data) {
        ScalaCompat$.MODULE$.JavaConverters().MapHasAsScala(MODULE$.serializeCustomClaims(data)).asScala().foreach((Function1 & Serializable)x0$1 -> {
            Object value;
            String key;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                key = (String)tuple2._1();
                value = tuple2._2();
                if (JWTAuthenticatorService$.MODULE$.ReservedClaims().contains((Object)key)) {
                    throw new AuthenticatorException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(JWTAuthenticatorService$.MODULE$.OverrideReservedClaim()), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{JWTAuthenticatorService$.MODULE$.ID(), key, JWTAuthenticatorService$.MODULE$.ReservedClaims().mkString(", ")})), AuthenticatorException$.MODULE$.$lessinit$greater$default$2());
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            JwtJsonBuilder jwtJsonBuilder = jwtBuilder$1.claim(key, value);
            return jwtJsonBuilder;
        });
    }

    public static final /* synthetic */ boolean $anonfun$unserialize$4(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        Object v = tuple2._2();
        boolean bl = JWTAuthenticatorService$.MODULE$.ReservedClaims().contains((Object)k) || v == null;
        return bl;
    }

    private final Object toJava$1(JsValue value2) {
        Object object;
        JsValue jsValue = value2;
        if (jsValue instanceof JsString) {
            JsString jsString = (JsString)jsValue;
            object = jsString.value();
        } else if (jsValue instanceof JsNumber) {
            JsNumber jsNumber = (JsNumber)jsValue;
            object = jsNumber.value();
        } else if (jsValue instanceof JsBoolean) {
            JsBoolean jsBoolean = (JsBoolean)jsValue;
            object = BoxesRunTime.boxToBoolean((boolean)jsBoolean.value());
        } else if (jsValue instanceof JsObject) {
            JsObject jsObject = (JsObject)jsValue;
            object = this.serializeCustomClaims(jsObject);
        } else if (jsValue instanceof JsArray) {
            JsArray jsArray = (JsArray)jsValue;
            object = ScalaCompat$.MODULE$.JavaConverters().SeqHasAsJava((Seq)jsArray.value().map((Function1 & Serializable)value -> this.toJava$1((JsValue)value))).asJava();
        } else {
            throw new AuthenticatorException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(JWTAuthenticatorService$.MODULE$.UnexpectedJsonValue()), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{JWTAuthenticatorService$.MODULE$.ID(), jsValue})), AuthenticatorException$.MODULE$.$lessinit$greater$default$2());
        }
        return object;
    }

    private final JsValue toJson$1(Object value2) {
        JsString jsString;
        Object object = value2;
        if (object instanceof String) {
            String string = (String)object;
            jsString = new JsString(string);
        } else if (object instanceof Number) {
            Number number = (Number)object;
            jsString = new JsNumber(package$.MODULE$.BigDecimal().apply(number.toString()));
        } else if (object instanceof Boolean) {
            Boolean bl = (Boolean)object;
            jsString = JsBoolean$.MODULE$.apply(Predef$.MODULE$.Boolean2boolean(bl));
        } else if (object instanceof java.util.Map) {
            java.util.Map map = (java.util.Map)object;
            jsString = this.unserializeCustomClaims(map);
        } else if (object instanceof List) {
            List list = (List)object;
            jsString = JsArray$.MODULE$.apply((Seq)ScalaCompat$.MODULE$.JavaConverters().ListHasAsScala(list).asScala().map((Function1 & Serializable)value -> this.toJson$1(value)));
        } else {
            throw new AuthenticatorException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(JWTAuthenticatorService$.MODULE$.UnexpectedJsonValue()), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{JWTAuthenticatorService$.MODULE$.ID(), object})), AuthenticatorException$.MODULE$.$lessinit$greater$default$2());
        }
        return jsString;
    }

    private JWTAuthenticator$() {
    }
}

