/*
 * Decompiled with CFR 0.152.
 */
package com.mohiva.play.silhouette.impl.authenticators;

import com.mohiva.play.silhouette.api.Authenticator$Implicits$;
import com.mohiva.play.silhouette.api.Logger;
import com.mohiva.play.silhouette.api.LoginInfo;
import com.mohiva.play.silhouette.api.crypto.AuthenticatorEncoder;
import com.mohiva.play.silhouette.api.exceptions.AuthenticatorCreationException;
import com.mohiva.play.silhouette.api.exceptions.AuthenticatorDiscardingException;
import com.mohiva.play.silhouette.api.exceptions.AuthenticatorInitializationException;
import com.mohiva.play.silhouette.api.exceptions.AuthenticatorRenewalException;
import com.mohiva.play.silhouette.api.exceptions.AuthenticatorRetrievalException;
import com.mohiva.play.silhouette.api.exceptions.AuthenticatorUpdateException;
import com.mohiva.play.silhouette.api.repositories.AuthenticatorRepository;
import com.mohiva.play.silhouette.api.services.AuthenticatorResult;
import com.mohiva.play.silhouette.api.services.AuthenticatorResult$;
import com.mohiva.play.silhouette.api.services.AuthenticatorService;
import com.mohiva.play.silhouette.api.services.AuthenticatorService$;
import com.mohiva.play.silhouette.api.util.Clock;
import com.mohiva.play.silhouette.api.util.ExtractableRequest;
import com.mohiva.play.silhouette.api.util.IDGenerator;
import com.mohiva.play.silhouette.impl.authenticators.JWTAuthenticator;
import com.mohiva.play.silhouette.impl.authenticators.JWTAuthenticator$;
import com.mohiva.play.silhouette.impl.authenticators.JWTAuthenticatorService$;
import com.mohiva.play.silhouette.impl.authenticators.JWTAuthenticatorSettings;
import java.io.Serializable;
import org.joda.time.DateTime;
import play.api.MarkerContext$;
import play.api.libs.json.JsObject;
import play.api.mvc.RequestHeader;
import play.api.mvc.Result;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\tUa\u0001\u0002\u0012$\u0001AB\u0001b\u0012\u0001\u0003\u0002\u0003\u0006I\u0001\u0013\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u0019\"AQ\u000b\u0001B\u0001B\u0003%a\u000b\u0003\u0005]\u0001\t\u0005\t\u0015!\u0003^\u0011!\u0019\u0007A!A!\u0002\u0013!\u0007\u0002C4\u0001\u0005\u000b\u0007I1\u00015\t\u0011=\u0004!\u0011!Q\u0001\n%DQ\u0001\u001d\u0001\u0005\u0002EDQA\u001f\u0001\u0005BmDq!a\b\u0001\t\u0003\n\t\u0003C\u0004\u0002H\u0001!\t%!\u0013\t\u000f\u0005-\u0004\u0001\"\u0011\u0002n!9\u00111\u000e\u0001\u0005B\u0005%\u0005bBAH\u0001\u0011\u0005\u0013\u0011\u0013\u0005\b\u0003O\u0003A\u0011IAU\u0011\u001d\t\u0019\f\u0001C!\u0003kCq!a-\u0001\t\u0003\ni\fC\u0004\u0002H\u0002!\t%!3\b\u000f\u0005M7\u0005#\u0001\u0002V\u001a1!e\tE\u0001\u0003/Da\u0001\u001d\u000b\u0005\u0002\u0005e\u0007\"CAn)\t\u0007I\u0011AAo\u0011!\ti\u000f\u0006Q\u0001\n\u0005}\u0007\"CAx)\t\u0007I\u0011AAo\u0011!\t\t\u0010\u0006Q\u0001\n\u0005}\u0007\"CAz)\t\u0007I\u0011AAo\u0011!\t)\u0010\u0006Q\u0001\n\u0005}\u0007\"CA|)\t\u0007I\u0011AAo\u0011!\tI\u0010\u0006Q\u0001\n\u0005}\u0007\"CA~)\t\u0007I\u0011AAo\u0011!\ti\u0010\u0006Q\u0001\n\u0005}\u0007\"CA\u0000)\t\u0007I\u0011\u0001B\u0001\u0011!\u0011\u0019\u0002\u0006Q\u0001\n\t\r!a\u0006&X)\u0006+H\u000f[3oi&\u001c\u0017\r^8s'\u0016\u0014h/[2f\u0015\t!S%\u0001\bbkRDWM\u001c;jG\u0006$xN]:\u000b\u0005\u0019:\u0013\u0001B5na2T!\u0001K\u0015\u0002\u0015MLG\u000e[8vKR$XM\u0003\u0002+W\u0005!\u0001\u000f\\1z\u0015\taS&\u0001\u0004n_\"Lg/\u0019\u0006\u0002]\u0005\u00191m\\7\u0004\u0001M!\u0001!M\u001cD!\t\u0011T'D\u00014\u0015\u0005!\u0014!B:dC2\f\u0017B\u0001\u001c4\u0005\u0019\te.\u001f*fMB\u0019\u0001(P \u000e\u0003eR!AO\u001e\u0002\u0011M,'O^5dKNT!\u0001P\u0014\u0002\u0007\u0005\u0004\u0018.\u0003\u0002?s\t!\u0012)\u001e;iK:$\u0018nY1u_J\u001cVM\u001d<jG\u0016\u0004\"\u0001Q!\u000e\u0003\rJ!AQ\u0012\u0003!);F+Q;uQ\u0016tG/[2bi>\u0014\bC\u0001#F\u001b\u0005Y\u0014B\u0001$<\u0005\u0019aunZ4fe\u0006A1/\u001a;uS:<7\u000f\u0005\u0002A\u0013&\u0011!j\t\u0002\u0019\u0015^#\u0016)\u001e;iK:$\u0018nY1u_J\u001cV\r\u001e;j]\u001e\u001c\u0018A\u0003:fa>\u001c\u0018\u000e^8ssB\u0019!'T(\n\u00059\u001b$AB(qi&|g\u000eE\u0002Q'~j\u0011!\u0015\u0006\u0003%n\nAB]3q_NLGo\u001c:jKNL!\u0001V)\u0003/\u0005+H\u000f[3oi&\u001c\u0017\r^8s%\u0016\u0004xn]5u_JL\u0018\u0001F1vi\",g\u000e^5dCR|'/\u00128d_\u0012,'\u000f\u0005\u0002X56\t\u0001L\u0003\u0002Zw\u000511M]=qi>L!a\u0017-\u0003)\u0005+H\u000f[3oi&\u001c\u0017\r^8s\u000b:\u001cw\u000eZ3s\u0003-IGmR3oKJ\fGo\u001c:\u0011\u0005y\u000bW\"A0\u000b\u0005\u0001\\\u0014\u0001B;uS2L!AY0\u0003\u0017%#u)\u001a8fe\u0006$xN]\u0001\u0006G2|7m\u001b\t\u0003=\u0016L!AZ0\u0003\u000b\rcwnY6\u0002!\u0015DXmY;uS>t7i\u001c8uKb$X#A5\u0011\u0005)lW\"A6\u000b\u00051\u001c\u0014AC2p]\u000e,(O]3oi&\u0011an\u001b\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\f\u0011#\u001a=fGV$\u0018n\u001c8D_:$X\r\u001f;!\u0003\u0019a\u0014N\\5u}Q1!/\u001e<xqf$\"a\u001d;\u0011\u0005\u0001\u0003\u0001\"B4\t\u0001\bI\u0007\"B$\t\u0001\u0004A\u0005\"B&\t\u0001\u0004a\u0005\"B+\t\u0001\u00041\u0006\"\u0002/\t\u0001\u0004i\u0006\"B2\t\u0001\u0004!\u0017AB2sK\u0006$X\rF\u0002}\u0003+!2!`A\u0001!\rQgpP\u0005\u0003\u007f.\u0014aAR;ukJ,\u0007bBA\u0002\u0013\u0001\u000f\u0011QA\u0001\be\u0016\fX/Z:u!\u0011\t9!!\u0005\u000e\u0005\u0005%!\u0002BA\u0006\u0003\u001b\t1!\u001c<d\u0015\ra\u0014q\u0002\u0006\u0002U%!\u00111CA\u0005\u00055\u0011V-];fgRDU-\u00193fe\"9\u0011qC\u0005A\u0002\u0005e\u0011!\u00037pO&t\u0017J\u001c4p!\r!\u00151D\u0005\u0004\u0003;Y$!\u0003'pO&t\u0017J\u001c4p\u0003!\u0011X\r\u001e:jKZ,W\u0003BA\u0012\u0003k!B!!\n\u0002*A!!N`A\u0014!\r\u0011Tj\u0010\u0005\b\u0003\u0007Q\u00019AA\u0016!\u0015q\u0016QFA\u0019\u0013\r\tyc\u0018\u0002\u0013\u000bb$(/Y2uC\ndWMU3rk\u0016\u001cH\u000f\u0005\u0003\u00024\u0005UB\u0002\u0001\u0003\b\u0003oQ!\u0019AA\u001d\u0005\u0005\u0011\u0015\u0003BA\u001e\u0003\u0003\u00022AMA\u001f\u0013\r\tyd\r\u0002\b\u001d>$\b.\u001b8h!\r\u0011\u00141I\u0005\u0004\u0003\u000b\u001a$aA!os\u0006!\u0011N\\5u)\u0011\tY%a\u001a\u0015\t\u00055\u0013Q\r\t\u0005Uz\fy\u0005\u0005\u0003\u0002R\u0005}c\u0002BA*\u00037\u00022!!\u00164\u001b\t\t9FC\u0002\u0002Z=\na\u0001\u0010:p_Rt\u0014bAA/g\u00051\u0001K]3eK\u001aLA!!\u0019\u0002d\t11\u000b\u001e:j]\u001eT1!!\u00184\u0011\u001d\t\u0019a\u0003a\u0002\u0003\u000bAa!!\u001b\f\u0001\u0004y\u0014!D1vi\",g\u000e^5dCR|'/A\u0003f[\n,G\r\u0006\u0004\u0002p\u0005m\u0014q\u0010\u000b\u0005\u0003c\nI\b\u0005\u0003k}\u0006M\u0004c\u0001\u001d\u0002v%\u0019\u0011qO\u001d\u0003'\u0005+H\u000f[3oi&\u001c\u0017\r^8s%\u0016\u001cX\u000f\u001c;\t\u000f\u0005\rA\u0002q\u0001\u0002\u0006!9\u0011Q\u0010\u0007A\u0002\u0005=\u0013!\u0002;pW\u0016t\u0007bBAA\u0019\u0001\u0007\u00111Q\u0001\u0007e\u0016\u001cX\u000f\u001c;\u0011\t\u0005\u001d\u0011QQ\u0005\u0005\u0003\u000f\u000bIA\u0001\u0004SKN,H\u000e\u001e\u000b\u0007\u0003\u000b\tY)!$\t\u000f\u0005uT\u00021\u0001\u0002P!9\u00111A\u0007A\u0002\u0005\u0015\u0011!\u0002;pk\u000eDG\u0003BAJ\u0003K\u0003b!!&\u0002 ~zd\u0002BAL\u00037sA!!\u0016\u0002\u001a&\tA'C\u0002\u0002\u001eN\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\"\u0006\r&AB#ji\",'OC\u0002\u0002\u001eNBa!!\u001b\u000f\u0001\u0004y\u0014AB;qI\u0006$X\r\u0006\u0004\u0002,\u0006=\u0016\u0011\u0017\u000b\u0005\u0003c\ni\u000bC\u0004\u0002\u0004=\u0001\u001d!!\u0002\t\r\u0005%t\u00021\u0001@\u0011\u001d\t\ti\u0004a\u0001\u0003\u0007\u000bQA]3oK^$B!a.\u0002<R!\u0011QJA]\u0011\u001d\t\u0019\u0001\u0005a\u0002\u0003\u000bAa!!\u001b\u0011\u0001\u0004yDCBA`\u0003\u0007\f)\r\u0006\u0003\u0002r\u0005\u0005\u0007bBA\u0002#\u0001\u000f\u0011Q\u0001\u0005\u0007\u0003S\n\u0002\u0019A \t\u000f\u0005\u0005\u0015\u00031\u0001\u0002\u0004\u00069A-[:dCJ$GCBAf\u0003\u001f\f\t\u000e\u0006\u0003\u0002r\u00055\u0007bBA\u0002%\u0001\u000f\u0011Q\u0001\u0005\u0007\u0003S\u0012\u0002\u0019A \t\u000f\u0005\u0005%\u00031\u0001\u0002\u0004\u00069\"j\u0016+BkRDWM\u001c;jG\u0006$xN]*feZL7-\u001a\t\u0003\u0001R\u0019\"\u0001F\u0019\u0015\u0005\u0005U\u0017AA%E+\t\ty\u000e\u0005\u0003\u0002b\u0006-XBAAr\u0015\u0011\t)/a:\u0002\t1\fgn\u001a\u0006\u0003\u0003S\fAA[1wC&!\u0011\u0011MAr\u0003\rIE\tI\u0001\u0010\u0013:4\u0018\r\\5e\u0015^#Fk\\6f]\u0006\u0001\u0012J\u001c<bY&$'j\u0016+U_.,g\u000eI\u0001\u000f\u0015N|g\u000eU1sg\u0016,%O]8s\u0003=Q5o\u001c8QCJ\u001cX-\u0012:s_J\u0004\u0013aE+oKb\u0004Xm\u0019;fI*\u001bxN\u001c,bYV,\u0017\u0001F+oKb\u0004Xm\u0019;fI*\u001bxN\u001c,bYV,\u0007%A\u000bPm\u0016\u0014(/\u001b3f%\u0016\u001cXM\u001d<fI\u000ec\u0017-[7\u0002-=3XM\u001d:jI\u0016\u0014Vm]3sm\u0016$7\t\\1j[\u0002\naBU3tKJ4X\rZ\"mC&l7/\u0006\u0002\u0003\u0004A1!Q\u0001B\b\u0003?l!Aa\u0002\u000b\t\t%!1B\u0001\nS6lW\u000f^1cY\u0016T1A!\u00044\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005#\u00119AA\u0002TKF\fqBU3tKJ4X\rZ\"mC&l7\u000f\t")
public class JWTAuthenticatorService
implements AuthenticatorService<JWTAuthenticator>,
Logger {
    private final JWTAuthenticatorSettings settings;
    private final Option<AuthenticatorRepository<JWTAuthenticator>> repository;
    private final AuthenticatorEncoder authenticatorEncoder;
    private final IDGenerator idGenerator;
    private final Clock clock;
    private final ExecutionContext executionContext;
    private play.api.Logger logger;

    public static Seq<String> ReservedClaims() {
        return JWTAuthenticatorService$.MODULE$.ReservedClaims();
    }

    public static String OverrideReservedClaim() {
        return JWTAuthenticatorService$.MODULE$.OverrideReservedClaim();
    }

    public static String UnexpectedJsonValue() {
        return JWTAuthenticatorService$.MODULE$.UnexpectedJsonValue();
    }

    public static String JsonParseError() {
        return JWTAuthenticatorService$.MODULE$.JsonParseError();
    }

    public static String InvalidJWTToken() {
        return JWTAuthenticatorService$.MODULE$.InvalidJWTToken();
    }

    public static String ID() {
        return JWTAuthenticatorService$.MODULE$.ID();
    }

    @Override
    public play.api.Logger logger() {
        return this.logger;
    }

    @Override
    public void com$mohiva$play$silhouette$api$Logger$_setter_$logger_$eq(play.api.Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    @Override
    public Future<JWTAuthenticator> create(LoginInfo loginInfo, RequestHeader request) {
        return this.idGenerator.generate().map((Function1 & Serializable)id -> {
            DateTime now = $this.clock.now();
            return new JWTAuthenticator((String)id, loginInfo, now, Authenticator$Implicits$.MODULE$.RichDateTime(now).$plus($this.settings.authenticatorExpiry()), $this.settings.authenticatorIdleTimeout(), JWTAuthenticator$.MODULE$.apply$default$6());
        }, this.executionContext()).recover((PartialFunction)new Serializable(null, loginInfo){
            private static final long serialVersionUID = 0L;
            private final LoginInfo loginInfo$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                throw new AuthenticatorCreationException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(AuthenticatorService$.MODULE$.CreateError()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{JWTAuthenticatorService$.MODULE$.ID(), this.loginInfo$1})), A1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                this.loginInfo$1 = loginInfo$1;
            }
        }, this.executionContext());
    }

    @Override
    public <B> Future<Option<JWTAuthenticator>> retrieve(ExtractableRequest<B> request) {
        return Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0 & Serializable)() -> request.extractString($this.settings.fieldName(), $this.settings.requestParts()))).flatMap((Function1 & Serializable)x0$1 -> {
            Future future;
            Option option = x0$1;
            if (option instanceof Some) {
                Future future2;
                Some some = (Some)option;
                String token = (String)some.value();
                Try<JWTAuthenticator> try_ = JWTAuthenticator$.MODULE$.unserialize(token, $this.authenticatorEncoder, $this.settings);
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    JWTAuthenticator authenticator = (JWTAuthenticator)success.value();
                    future2 = (Future)$this.repository.fold((Function0 & Serializable)() -> Future$.MODULE$.successful((Object)Option$.MODULE$.apply((Object)authenticator)), (Function1 & Serializable)x$1 -> x$1.find(authenticator.id()));
                } else if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    this.logger().info((Function0 & Serializable)() -> e.getMessage(), (Function0 & Serializable)() -> e, MarkerContext$.MODULE$.NoMarker());
                    future2 = Future$.MODULE$.successful((Object)None$.MODULE$);
                } else {
                    throw new MatchError(try_);
                }
                future = future2;
            } else if (None$.MODULE$.equals(option)) {
                future = Future$.MODULE$.successful((Object)None$.MODULE$);
            } else {
                throw new MatchError((Object)option);
            }
            return future;
        }, this.executionContext()).recover((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                throw new AuthenticatorRetrievalException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(AuthenticatorService$.MODULE$.RetrieveError()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{JWTAuthenticatorService$.MODULE$.ID()})), A1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
        }, this.executionContext());
    }

    @Override
    public Future<String> init(JWTAuthenticator authenticator, RequestHeader request) {
        return ((Future)this.repository.fold((Function0 & Serializable)() -> Future$.MODULE$.successful((Object)authenticator), (Function1 & Serializable)x$2 -> x$2.add(authenticator))).map((Function1 & Serializable)a -> JWTAuthenticator$.MODULE$.serialize((JWTAuthenticator)a, $this.authenticatorEncoder, $this.settings), this.executionContext()).recover((PartialFunction)new Serializable(null, authenticator){
            private static final long serialVersionUID = 0L;
            private final JWTAuthenticator authenticator$2;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                throw new AuthenticatorInitializationException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(AuthenticatorService$.MODULE$.InitError()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{JWTAuthenticatorService$.MODULE$.ID(), this.authenticator$2})), A1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                this.authenticator$2 = authenticator$2;
            }
        }, this.executionContext());
    }

    public Future<AuthenticatorResult> embed(String token, Result result, RequestHeader request) {
        return Future$.MODULE$.successful((Object)AuthenticatorResult$.MODULE$.apply(result.withHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.settings.fieldName()), (Object)token)}))));
    }

    public RequestHeader embed(String token, RequestHeader request) {
        Seq additional = (Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.settings.fieldName()), (Object)token)}));
        return request.withHeaders(request.headers().replace(additional));
    }

    @Override
    public Either<JWTAuthenticator, JWTAuthenticator> touch(JWTAuthenticator authenticator) {
        Right right;
        if (authenticator.idleTimeout().isDefined()) {
            DateTime x$1 = this.clock.now();
            String x$2 = authenticator.copy$default$1();
            LoginInfo x$3 = authenticator.copy$default$2();
            DateTime x$4 = authenticator.copy$default$4();
            Option<FiniteDuration> x$5 = authenticator.copy$default$5();
            Option<JsObject> x$6 = authenticator.copy$default$6();
            right = package$.MODULE$.Left().apply((Object)authenticator.copy(x$2, x$3, x$1, x$4, x$5, x$6));
        } else {
            right = package$.MODULE$.Right().apply((Object)authenticator);
        }
        return right;
    }

    @Override
    public Future<AuthenticatorResult> update(JWTAuthenticator authenticator, Result result, RequestHeader request) {
        return ((Future)this.repository.fold((Function0 & Serializable)() -> Future$.MODULE$.successful((Object)authenticator), (Function1 & Serializable)x$3 -> x$3.update(authenticator))).map((Function1 & Serializable)a -> AuthenticatorResult$.MODULE$.apply(result.withHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.settings.fieldName()), (Object)JWTAuthenticator$.MODULE$.serialize((JWTAuthenticator)a, $this.authenticatorEncoder, $this.settings))}))), this.executionContext()).recover((PartialFunction)new Serializable(null, authenticator){
            private static final long serialVersionUID = 0L;
            private final JWTAuthenticator authenticator$3;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                throw new AuthenticatorUpdateException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(AuthenticatorService$.MODULE$.UpdateError()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{JWTAuthenticatorService$.MODULE$.ID(), this.authenticator$3})), A1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                this.authenticator$3 = authenticator$3;
            }
        }, this.executionContext());
    }

    @Override
    public Future<String> renew(JWTAuthenticator authenticator, RequestHeader request) {
        return ((Future)this.repository.fold((Function0 & Serializable)() -> Future$.MODULE$.successful((Object)BoxedUnit.UNIT), (Function1 & Serializable)x$4 -> x$4.remove(authenticator.id()))).flatMap((Function1 & Serializable)x$5 -> this.create(authenticator.loginInfo(), request).map((Function1 & Serializable)x$6 -> {
            Option<JsObject> x$1 = authenticator.customClaims();
            String x$2 = x$6.copy$default$1();
            LoginInfo x$3 = x$6.copy$default$2();
            DateTime x$4 = x$6.copy$default$3();
            DateTime x$5 = x$6.copy$default$4();
            Option<FiniteDuration> x$62 = x$6.copy$default$5();
            return x$6.copy(x$2, x$3, x$4, x$5, x$62, x$1);
        }, this.executionContext()).flatMap((Function1 & Serializable)authenticator -> this.init((JWTAuthenticator)authenticator, request), this.executionContext()), this.executionContext()).recover((PartialFunction)new Serializable(null, authenticator){
            private static final long serialVersionUID = 0L;
            private final JWTAuthenticator authenticator$4;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                throw new AuthenticatorRenewalException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(AuthenticatorService$.MODULE$.RenewError()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{JWTAuthenticatorService$.MODULE$.ID(), this.authenticator$4})), A1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                this.authenticator$4 = authenticator$4;
            }
        }, this.executionContext());
    }

    @Override
    public Future<AuthenticatorResult> renew(JWTAuthenticator authenticator, Result result, RequestHeader request) {
        return this.renew(authenticator, request).flatMap((Function1 & Serializable)v -> this.embed((String)v, result, request), this.executionContext()).recover((PartialFunction)new Serializable(null, authenticator){
            private static final long serialVersionUID = 0L;
            private final JWTAuthenticator authenticator$5;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                throw new AuthenticatorRenewalException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(AuthenticatorService$.MODULE$.RenewError()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{JWTAuthenticatorService$.MODULE$.ID(), this.authenticator$5})), A1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                this.authenticator$5 = authenticator$5;
            }
        }, this.executionContext());
    }

    @Override
    public Future<AuthenticatorResult> discard(JWTAuthenticator authenticator, Result result, RequestHeader request) {
        return ((Future)this.repository.fold((Function0 & Serializable)() -> Future$.MODULE$.successful((Object)BoxedUnit.UNIT), (Function1 & Serializable)x$7 -> x$7.remove(authenticator.id()))).map((Function1 & Serializable)x$8 -> AuthenticatorResult$.MODULE$.apply(result), this.executionContext()).recover((PartialFunction)new Serializable(null, authenticator){
            private static final long serialVersionUID = 0L;
            private final JWTAuthenticator authenticator$6;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                throw new AuthenticatorDiscardingException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(AuthenticatorService$.MODULE$.DiscardError()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{JWTAuthenticatorService$.MODULE$.ID(), this.authenticator$6})), A1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                this.authenticator$6 = authenticator$6;
            }
        }, this.executionContext());
    }

    public JWTAuthenticatorService(JWTAuthenticatorSettings settings, Option<AuthenticatorRepository<JWTAuthenticator>> repository, AuthenticatorEncoder authenticatorEncoder, IDGenerator idGenerator, Clock clock, ExecutionContext executionContext) {
        this.settings = settings;
        this.repository = repository;
        this.authenticatorEncoder = authenticatorEncoder;
        this.idGenerator = idGenerator;
        this.clock = clock;
        this.executionContext = executionContext;
        Logger.$init$(this);
        Statics.releaseFence();
    }
}

