/*
 * Copyright (c) 2015, 2024, Oracle and/or its affiliates.
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License, version 2.0, as published by
 * the Free Software Foundation.
 *
 * This program is designed to work with certain software that is licensed under separate terms, as designated in a particular file or component or in
 * included license documentation. The authors of MySQL hereby grant you an additional permission to link the program and your derivative works with the
 * separately licensed software that they have either included with the program or referenced in the documentation.
 *
 * Without limiting anything contained in the foregoing, this file, which is part of MySQL Connector/J, is also subject to the Universal FOSS Exception,
 * version 1.0, a copy of which can be found at http://oss.oracle.com/licenses/universal-foss-exception.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License, version 2.0, for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

package com.mysql.cj.x.protobuf;

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: mysqlx_resultset.proto

// Protobuf Java Version: 3.25.1

public final class MysqlxResultset {
  private MysqlxResultset() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistryLite registry) {
  }

  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions(
        (com.google.protobuf.ExtensionRegistryLite) registry);
  }
  /**
   * <pre>
   **
   *A hint about the higher-level encoding of a BYTES field
   *
   *|type  | value  | description             |
   *|------| -------|-------------------------|
   *|BYTES | 0x0001 | GEOMETRY (WKB encoding) |
   *|BYTES | 0x0002 | JSON (text encoding)    |
   *|BYTES | 0x0003 | XML (text encoding)     |
   *
   *&#64;note
   *this list isn't comprehensive. As a guideline: the field's value is expected
   *to pass a validator check on client and server if this field is set.
   *If the server adds more internal datatypes that rely on BLOB storage
   *like image manipulation, seeking into complex types in BLOBs, ... more
   *types will be added.
   * </pre>
   *
   * Protobuf enum {@code Mysqlx.Resultset.ContentType_BYTES}
   */
  public enum ContentType_BYTES
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>GEOMETRY = 1;</code>
     */
    GEOMETRY(1),
    /**
     * <code>JSON = 2;</code>
     */
    JSON(2),
    /**
     * <code>XML = 3;</code>
     */
    XML(3),
    ;

    /**
     * <code>GEOMETRY = 1;</code>
     */
    public static final int GEOMETRY_VALUE = 1;
    /**
     * <code>JSON = 2;</code>
     */
    public static final int JSON_VALUE = 2;
    /**
     * <code>XML = 3;</code>
     */
    public static final int XML_VALUE = 3;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ContentType_BYTES valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ContentType_BYTES forNumber(int value) {
      switch (value) {
        case 1: return GEOMETRY;
        case 2: return JSON;
        case 3: return XML;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ContentType_BYTES>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        ContentType_BYTES> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<ContentType_BYTES>() {
            public ContentType_BYTES findValueByNumber(int number) {
              return ContentType_BYTES.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxResultset.getDescriptor().getEnumTypes().get(0);
    }

    private static final ContentType_BYTES[] VALUES = values();

    public static ContentType_BYTES valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ContentType_BYTES(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:Mysqlx.Resultset.ContentType_BYTES)
  }

  /**
   * <pre>
   **
   *A hint about the higher-level encoding of a DATETIME field
   *
   *|type     |value  |description                                |
   *|---------|-------|-------------------------------------------|
   *|DATE     |0x0001 |DATETIME contains only date part           |
   *|DATETIME |0x0002 |DATETIME contains both date and time parts |
   * </pre>
   *
   * Protobuf enum {@code Mysqlx.Resultset.ContentType_DATETIME}
   */
  public enum ContentType_DATETIME
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>DATE = 1;</code>
     */
    DATE(1),
    /**
     * <code>DATETIME = 2;</code>
     */
    DATETIME(2),
    ;

    /**
     * <code>DATE = 1;</code>
     */
    public static final int DATE_VALUE = 1;
    /**
     * <code>DATETIME = 2;</code>
     */
    public static final int DATETIME_VALUE = 2;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ContentType_DATETIME valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ContentType_DATETIME forNumber(int value) {
      switch (value) {
        case 1: return DATE;
        case 2: return DATETIME;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ContentType_DATETIME>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        ContentType_DATETIME> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<ContentType_DATETIME>() {
            public ContentType_DATETIME findValueByNumber(int number) {
              return ContentType_DATETIME.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxResultset.getDescriptor().getEnumTypes().get(1);
    }

    private static final ContentType_DATETIME[] VALUES = values();

    public static ContentType_DATETIME valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ContentType_DATETIME(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:Mysqlx.Resultset.ContentType_DATETIME)
  }

  public interface FetchDoneMoreOutParamsOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Resultset.FetchDoneMoreOutParams)
      com.google.protobuf.MessageOrBuilder {
  }
  /**
   * <pre>
   **
   *Resultsets are finished, OUT paramset is next:
   * </pre>
   *
   * Protobuf type {@code Mysqlx.Resultset.FetchDoneMoreOutParams}
   */
  public static final class FetchDoneMoreOutParams extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Resultset.FetchDoneMoreOutParams)
      FetchDoneMoreOutParamsOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use FetchDoneMoreOutParams.newBuilder() to construct.
    private FetchDoneMoreOutParams(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private FetchDoneMoreOutParams() {
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new FetchDoneMoreOutParams();
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_FetchDoneMoreOutParams_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_FetchDoneMoreOutParams_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams.class, com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams.Builder.class);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams)) {
        return super.equals(obj);
      }
      com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams other = (com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     **
     *Resultsets are finished, OUT paramset is next:
     * </pre>
     *
     * Protobuf type {@code Mysqlx.Resultset.FetchDoneMoreOutParams}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Resultset.FetchDoneMoreOutParams)
        com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParamsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_FetchDoneMoreOutParams_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_FetchDoneMoreOutParams_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams.class, com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_FetchDoneMoreOutParams_descriptor;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams.getDefaultInstance();
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams build() {
        com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams result = new com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams.getDefaultInstance()) return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:Mysqlx.Resultset.FetchDoneMoreOutParams)
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Resultset.FetchDoneMoreOutParams)
    private static final com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams();
    }

    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<FetchDoneMoreOutParams>
        PARSER = new com.google.protobuf.AbstractParser<FetchDoneMoreOutParams>() {
      @java.lang.Override
      public FetchDoneMoreOutParams parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<FetchDoneMoreOutParams> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<FetchDoneMoreOutParams> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface FetchDoneMoreResultsetsOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Resultset.FetchDoneMoreResultsets)
      com.google.protobuf.MessageOrBuilder {
  }
  /**
   * <pre>
   **
   *Resultset and out-params are finished, but more resultsets available
   * </pre>
   *
   * Protobuf type {@code Mysqlx.Resultset.FetchDoneMoreResultsets}
   */
  public static final class FetchDoneMoreResultsets extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Resultset.FetchDoneMoreResultsets)
      FetchDoneMoreResultsetsOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use FetchDoneMoreResultsets.newBuilder() to construct.
    private FetchDoneMoreResultsets(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private FetchDoneMoreResultsets() {
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new FetchDoneMoreResultsets();
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_FetchDoneMoreResultsets_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_FetchDoneMoreResultsets_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets.class, com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets.Builder.class);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets)) {
        return super.equals(obj);
      }
      com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets other = (com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     **
     *Resultset and out-params are finished, but more resultsets available
     * </pre>
     *
     * Protobuf type {@code Mysqlx.Resultset.FetchDoneMoreResultsets}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Resultset.FetchDoneMoreResultsets)
        com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsetsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_FetchDoneMoreResultsets_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_FetchDoneMoreResultsets_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets.class, com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_FetchDoneMoreResultsets_descriptor;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets.getDefaultInstance();
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets build() {
        com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets result = new com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets.getDefaultInstance()) return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:Mysqlx.Resultset.FetchDoneMoreResultsets)
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Resultset.FetchDoneMoreResultsets)
    private static final com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets();
    }

    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<FetchDoneMoreResultsets>
        PARSER = new com.google.protobuf.AbstractParser<FetchDoneMoreResultsets>() {
      @java.lang.Override
      public FetchDoneMoreResultsets parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<FetchDoneMoreResultsets> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<FetchDoneMoreResultsets> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface FetchDoneOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Resultset.FetchDone)
      com.google.protobuf.MessageOrBuilder {
  }
  /**
   * <pre>
   **
   *All resultsets are finished
   * </pre>
   *
   * Protobuf type {@code Mysqlx.Resultset.FetchDone}
   */
  public static final class FetchDone extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Resultset.FetchDone)
      FetchDoneOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use FetchDone.newBuilder() to construct.
    private FetchDone(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private FetchDone() {
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new FetchDone();
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_FetchDone_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_FetchDone_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone.class, com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone.Builder.class);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone)) {
        return super.equals(obj);
      }
      com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone other = (com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     **
     *All resultsets are finished
     * </pre>
     *
     * Protobuf type {@code Mysqlx.Resultset.FetchDone}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Resultset.FetchDone)
        com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_FetchDone_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_FetchDone_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone.class, com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_FetchDone_descriptor;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone.getDefaultInstance();
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone build() {
        com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone result = new com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone.getDefaultInstance()) return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:Mysqlx.Resultset.FetchDone)
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Resultset.FetchDone)
    private static final com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone();
    }

    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<FetchDone>
        PARSER = new com.google.protobuf.AbstractParser<FetchDone>() {
      @java.lang.Override
      public FetchDone parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<FetchDone> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<FetchDone> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface FetchSuspendedOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Resultset.FetchSuspended)
      com.google.protobuf.MessageOrBuilder {
  }
  /**
   * <pre>
   **
   *Cursor is opened; still, the execution of PrepFetch or PrepExecute ended
   * </pre>
   *
   * Protobuf type {@code Mysqlx.Resultset.FetchSuspended}
   */
  public static final class FetchSuspended extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Resultset.FetchSuspended)
      FetchSuspendedOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use FetchSuspended.newBuilder() to construct.
    private FetchSuspended(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private FetchSuspended() {
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new FetchSuspended();
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_FetchSuspended_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_FetchSuspended_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxResultset.FetchSuspended.class, com.mysql.cj.x.protobuf.MysqlxResultset.FetchSuspended.Builder.class);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.mysql.cj.x.protobuf.MysqlxResultset.FetchSuspended)) {
        return super.equals(obj);
      }
      com.mysql.cj.x.protobuf.MysqlxResultset.FetchSuspended other = (com.mysql.cj.x.protobuf.MysqlxResultset.FetchSuspended) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchSuspended parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchSuspended parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchSuspended parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchSuspended parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchSuspended parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchSuspended parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchSuspended parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchSuspended parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchSuspended parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchSuspended parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchSuspended parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchSuspended parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxResultset.FetchSuspended prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     **
     *Cursor is opened; still, the execution of PrepFetch or PrepExecute ended
     * </pre>
     *
     * Protobuf type {@code Mysqlx.Resultset.FetchSuspended}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Resultset.FetchSuspended)
        com.mysql.cj.x.protobuf.MysqlxResultset.FetchSuspendedOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_FetchSuspended_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_FetchSuspended_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxResultset.FetchSuspended.class, com.mysql.cj.x.protobuf.MysqlxResultset.FetchSuspended.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxResultset.FetchSuspended.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_FetchSuspended_descriptor;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxResultset.FetchSuspended getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxResultset.FetchSuspended.getDefaultInstance();
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxResultset.FetchSuspended build() {
        com.mysql.cj.x.protobuf.MysqlxResultset.FetchSuspended result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxResultset.FetchSuspended buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxResultset.FetchSuspended result = new com.mysql.cj.x.protobuf.MysqlxResultset.FetchSuspended(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxResultset.FetchSuspended) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxResultset.FetchSuspended)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxResultset.FetchSuspended other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxResultset.FetchSuspended.getDefaultInstance()) return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:Mysqlx.Resultset.FetchSuspended)
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Resultset.FetchSuspended)
    private static final com.mysql.cj.x.protobuf.MysqlxResultset.FetchSuspended DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.mysql.cj.x.protobuf.MysqlxResultset.FetchSuspended();
    }

    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchSuspended getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<FetchSuspended>
        PARSER = new com.google.protobuf.AbstractParser<FetchSuspended>() {
      @java.lang.Override
      public FetchSuspended parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<FetchSuspended> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<FetchSuspended> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxResultset.FetchSuspended getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ColumnMetaDataOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Resultset.ColumnMetaData)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     ** datatype of the field in a row 
     * </pre>
     *
     * <code>required .Mysqlx.Resultset.ColumnMetaData.FieldType type = 1;</code>
     * @return Whether the type field is set.
     */
    boolean hasType();
    /**
     * <pre>
     ** datatype of the field in a row 
     * </pre>
     *
     * <code>required .Mysqlx.Resultset.ColumnMetaData.FieldType type = 1;</code>
     * @return The type.
     */
    com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData.FieldType getType();

    /**
     * <pre>
     ** name of the column 
     * </pre>
     *
     * <code>optional bytes name = 2;</code>
     * @return Whether the name field is set.
     */
    boolean hasName();
    /**
     * <pre>
     ** name of the column 
     * </pre>
     *
     * <code>optional bytes name = 2;</code>
     * @return The name.
     */
    com.google.protobuf.ByteString getName();

    /**
     * <pre>
     ** name of the column before an alias was applied 
     * </pre>
     *
     * <code>optional bytes original_name = 3;</code>
     * @return Whether the originalName field is set.
     */
    boolean hasOriginalName();
    /**
     * <pre>
     ** name of the column before an alias was applied 
     * </pre>
     *
     * <code>optional bytes original_name = 3;</code>
     * @return The originalName.
     */
    com.google.protobuf.ByteString getOriginalName();

    /**
     * <pre>
     ** name of the table the column originates from 
     * </pre>
     *
     * <code>optional bytes table = 4;</code>
     * @return Whether the table field is set.
     */
    boolean hasTable();
    /**
     * <pre>
     ** name of the table the column originates from 
     * </pre>
     *
     * <code>optional bytes table = 4;</code>
     * @return The table.
     */
    com.google.protobuf.ByteString getTable();

    /**
     * <pre>
     ** name of the table the column originates from before an alias was applied 
     * </pre>
     *
     * <code>optional bytes original_table = 5;</code>
     * @return Whether the originalTable field is set.
     */
    boolean hasOriginalTable();
    /**
     * <pre>
     ** name of the table the column originates from before an alias was applied 
     * </pre>
     *
     * <code>optional bytes original_table = 5;</code>
     * @return The originalTable.
     */
    com.google.protobuf.ByteString getOriginalTable();

    /**
     * <pre>
     ** schema the column originates from 
     * </pre>
     *
     * <code>optional bytes schema = 6;</code>
     * @return Whether the schema field is set.
     */
    boolean hasSchema();
    /**
     * <pre>
     ** schema the column originates from 
     * </pre>
     *
     * <code>optional bytes schema = 6;</code>
     * @return The schema.
     */
    com.google.protobuf.ByteString getSchema();

    /**
     * <pre>
     ** catalog the schema originates from
     *&#64;note
     *As there is currently no support for catalogs in MySQL,
     *don't expect this field to be set. In the MySQL C/S
     *protocol the field had the value ``def`` all the time 
     * </pre>
     *
     * <code>optional bytes catalog = 7;</code>
     * @return Whether the catalog field is set.
     */
    boolean hasCatalog();
    /**
     * <pre>
     ** catalog the schema originates from
     *&#64;note
     *As there is currently no support for catalogs in MySQL,
     *don't expect this field to be set. In the MySQL C/S
     *protocol the field had the value ``def`` all the time 
     * </pre>
     *
     * <code>optional bytes catalog = 7;</code>
     * @return The catalog.
     */
    com.google.protobuf.ByteString getCatalog();

    /**
     * <code>optional uint64 collation = 8;</code>
     * @return Whether the collation field is set.
     */
    boolean hasCollation();
    /**
     * <code>optional uint64 collation = 8;</code>
     * @return The collation.
     */
    long getCollation();

    /**
     * <pre>
     ** displayed factional decimal digits for floating point and
     *fixed point numbers 
     * </pre>
     *
     * <code>optional uint32 fractional_digits = 9;</code>
     * @return Whether the fractionalDigits field is set.
     */
    boolean hasFractionalDigits();
    /**
     * <pre>
     ** displayed factional decimal digits for floating point and
     *fixed point numbers 
     * </pre>
     *
     * <code>optional uint32 fractional_digits = 9;</code>
     * @return The fractionalDigits.
     */
    int getFractionalDigits();

    /**
     * <pre>
     ** maximum count of displayable characters of .type 
     * </pre>
     *
     * <code>optional uint32 length = 10;</code>
     * @return Whether the length field is set.
     */
    boolean hasLength();
    /**
     * <pre>
     ** maximum count of displayable characters of .type 
     * </pre>
     *
     * <code>optional uint32 length = 10;</code>
     * @return The length.
     */
    int getLength();

    /**
     * <pre>
     ** ``.type`` specific flags
     *| Type    | Value  | Description  |
     *|---------|--------|--------------|
     *| UINT    | 0x0001 | zerofill     |
     *| DOUBLE  | 0x0001 | unsigned     |
     *| FLOAT   | 0x0001 | unsigned     |
     *| DECIMAL | 0x0001 | unsigned     |
     *| BYTES   | 0x0001 | rightpad     |
     *
     *| Value  | Description     |
     *|--------|-----------------|
     *| 0x0010 | NOT&#92;_NULL       |
     *| 0x0020 | PRIMARY&#92;_KEY    |
     *| 0x0040 | UNIQUE&#92;_KEY     |
     *| 0x0080 | MULTIPLE&#92;_KEY   |
     *| 0x0100 | AUTO&#92;_INCREMENT |
     *
     *default: 0 
     * </pre>
     *
     * <code>optional uint32 flags = 11;</code>
     * @return Whether the flags field is set.
     */
    boolean hasFlags();
    /**
     * <pre>
     ** ``.type`` specific flags
     *| Type    | Value  | Description  |
     *|---------|--------|--------------|
     *| UINT    | 0x0001 | zerofill     |
     *| DOUBLE  | 0x0001 | unsigned     |
     *| FLOAT   | 0x0001 | unsigned     |
     *| DECIMAL | 0x0001 | unsigned     |
     *| BYTES   | 0x0001 | rightpad     |
     *
     *| Value  | Description     |
     *|--------|-----------------|
     *| 0x0010 | NOT&#92;_NULL       |
     *| 0x0020 | PRIMARY&#92;_KEY    |
     *| 0x0040 | UNIQUE&#92;_KEY     |
     *| 0x0080 | MULTIPLE&#92;_KEY   |
     *| 0x0100 | AUTO&#92;_INCREMENT |
     *
     *default: 0 
     * </pre>
     *
     * <code>optional uint32 flags = 11;</code>
     * @return The flags.
     */
    int getFlags();

    /**
     * <pre>
     ** a hint about the higher-level encoding of a BYTES field
     *| Type   | Value  | Description             |
     *|--------|--------|-------------------------|
     *| BYTES  | 0x0001 | GEOMETRY (WKB encoding) |
     *| BYTES  | 0x0002 | JSON (text encoding)    |
     *| BYTES  | 0x0003 | XML (text encoding)     |
     *&#64;note
     *This list isn't comprehensive. As a guideline: the field's
     *value is expected to pass a validator check on client
     *and server if this field is set. If the server adds more
     *internal data types that rely on BLOB storage like image
     *manipulation, seeking into complex types in BLOBs, and
     *more types will be added 
     * </pre>
     *
     * <code>optional uint32 content_type = 12;</code>
     * @return Whether the contentType field is set.
     */
    boolean hasContentType();
    /**
     * <pre>
     ** a hint about the higher-level encoding of a BYTES field
     *| Type   | Value  | Description             |
     *|--------|--------|-------------------------|
     *| BYTES  | 0x0001 | GEOMETRY (WKB encoding) |
     *| BYTES  | 0x0002 | JSON (text encoding)    |
     *| BYTES  | 0x0003 | XML (text encoding)     |
     *&#64;note
     *This list isn't comprehensive. As a guideline: the field's
     *value is expected to pass a validator check on client
     *and server if this field is set. If the server adds more
     *internal data types that rely on BLOB storage like image
     *manipulation, seeking into complex types in BLOBs, and
     *more types will be added 
     * </pre>
     *
     * <code>optional uint32 content_type = 12;</code>
     * @return The contentType.
     */
    int getContentType();
  }
  /**
   * <pre>
   **
   *Meta data of a column
   *
   *&#64;note
   *The encoding used for the different ``bytes`` fields in the
   *meta data is externally controlled. See also:
   *https://dev.mysql.com/doc/refman/5.0/en/charset-connection.html
   *
   *&#64;par
   *&#64;note
   *The server may not set the ``original_{table|name}`` fields
   *if they are equal to the plain ``{table|name}`` field.
   *
   *&#64;par
   *&#64;note
   *A client has to reconstruct it like:
   *&#64;code{py}
   *if .original_name is empty and .name is not empty:
   *.original_name = .name
   *
   *if .original_table is empty and .table is not empty:
   *.original_table = .table
   *&#64;endcode
   *
   *&#64;par
   *&#64;note
   *``Compact metadata format`` can be requested by the client.
   *In that case, only ``.type`` is set and all other fields are  empty.
   *
   *
   *Expected data type of Mysqlx.Resultset.Row per SQL Type for
   *non-NULL values:
   *
   *| SQL Type          | .type     | .length | .frac&#92;_dig | .flags | .charset |
   *|-------------------|-----------|---------|------------|--------|----------|
   *| TINY              | SINT      | x       |            |        |          |
   *| TINY UNSIGNED     | UINT      | x       |            | x      |          |
   *| SHORT             | SINT      | x       |            |        |          |
   *| SHORT UNSIGNED    | UINT      | x       |            | x      |          |
   *| INT24             | SINT      | x       |            |        |          |
   *| INT24 UNSIGNED    | UINT      | x       |            | x      |          |
   *| INT               | SINT      | x       |            |        |          |
   *| INT UNSIGNED      | UINT      | x       |            | x      |          |
   *| LONGLONG          | SINT      | x       |            |        |          |
   *| LONGLONG UNSIGNED | UINT      | x       |            | x      |          |
   *| DOUBLE            | DOUBLE    | x       | x          | x      |          |
   *| FLOAT             | FLOAT     | x       | x          | x      |          |
   *| DECIMAL           | DECIMAL   | x       | x          | x      |          |
   *| VARCHAR,CHAR,...  | BYTES     | x       |            | x      | x        |
   *| GEOMETRY          | BYTES     |         |            |        |          |
   *| TIME              | TIME      | x       |            |        |          |
   *| DATE              | DATETIME  | x       |            |        |          |
   *| DATETIME          | DATETIME  | x       |            |        |          |
   *| YEAR              | UINT      | x       |            | x      |          |
   *| TIMESTAMP         | DATETIME  | x       |            |        |          |
   *| SET               | SET       |         |            |        | x        |
   *| ENUM              | ENUM      |         |            |        | x        |
   *| NULL              | BYTES     |         |            |        |          |
   *| BIT               | BIT       | x       |            |        |          |
   *
   *&#64;note
   *The SQL "NULL" value is sent as an empty field value in
   *&#64;ref Mysqlx::Resultset::Row.
   *
   *&#64;par Tip
   *The protobuf encoding of primitive data types is described in
   *https://developers.google.com/protocol-buffers/docs/encoding
   *
   *+ SINT
   *
   *- ``.length`` &#64;n
   *Maximum number of displayable decimal digits (including
   *minus sign) of the type.
   *&#64;note
   *The valid range is 0-255, but usually you'll see 1-20.
   *
   *| SQL Type         | Maximum Digits per Type |
   *|------------------|-------------------------|
   *| TINY SIGNED      | 4                       |
   *| SHORT SIGNED     | 6                       |
   *| INT24 SIGNED     | 8                       |
   *| INT SIGNED       | 11                      |
   *| LONGLONG SIGNED  | 20                      |
   *
   *&#64;par Tip
   *Definition of ``M`` are in
   *https://dev.mysql.com/doc/refman/5.5/en/numeric-type-overview.html.
   *
   *- ``value``&#64;n
   *Variable length encoded signed 64 integer.
   *
   *+ UINT
   *
   *- ``.flags &amp; 1`` (zerofill) &#64;n
   *The client has to left pad with 0's up to .length.
   *
   *- ``.length`` &#64;n
   *Maximum number of displayable decimal digits of the
   *type.
   *&#64;note
   *The valid range is 0-255, but usually you'll see
   *1-20.
   *
   *| SQL Type             | max digits per type |
   *|----------------------|---------------------|
   *| TINY UNSIGNED        | 3                   |
   *| SHORT UNSIGNED       | 5                   |
   *| INT24 UNSIGNED       | 8                   |
   *| INT UNSIGNED         | 10                  |
   *| LONGLONG UNSIGNED    | 20                  |
   *
   *&#64;par Tip
   *Definition of ``M`` are in
   *https://dev.mysql.com/doc/refman/5.5/en/numeric-type-overview.html.
   *
   *- ``value`` &#64;n
   *Variable length encoded unsigned 64 integer.
   *
   *+ BIT
   *
   *- ``.length`` &#64;n
   *Maximum number of displayable binary digits.
   *&#64;note
   *The valid range for M of the ``BIT`` type is 1 - 64.
   *
   *&#64;par Tip
   *https://dev.mysql.com/doc/refman/5.5/en/numeric-type-overview.html
   *
   *- ``value`` &#64;n
   *Variable length encoded unsigned 64 integer.
   *
   *+ DOUBLE
   *
   *- ``.length`` &#64;n
   *Maximum number of displayable decimal digits (including
   *the decimal point and ``.fractional_digits``).
   *
   *- ``.fractional_digits`` &#64;n
   *Maximum number of displayable decimal digits following
   *the decimal point.
   *
   *- ``value``&#64;n
   *Encoded as protobuf's 'double'.
   *
   *+ FLOAT
   *
   *- ``.length``&#64;n
   *Maximum number of displayable decimal digits (including
   *the decimal point and ``.fractional_digits``).
   *
   *- ``.fractional_digits``&#64;n
   *Maximum number of displayable decimal digits following
   *the decimal point.
   *
   *- ``value``&#64;n
   *Encoded as protobuf's 'float'.
   *
   *+ BYTES, ENUM
   *&#64;note
   *BYTES is used for all opaque byte strings that may have a charset:
   *-  TINYBLOB, BLOB, MEDIUMBLOB, LONGBLOB
   *-  TINYTEXT, TEXT, MEDIUMTEXT, LONGTEXT
   *-  VARCHAR, VARBINARY
   *-  CHAR, BINARY
   *-  ENUM
   *
   *- ``.length``&#64;n
   *Maximum length of characters of the underlying type.
   *
   *- ``.flags &amp; 1`` (rightpad) &#64;n
   *If the length of the field is less than ``.length``, the
   *receiver is supposed to add padding characters to the
   *right end of the string. If the ``.charset`` is
   *"binary", the padding character is ``0x00``, otherwise
   *it is a space character as defined by that character
   *set.
   *| SQL Type      | .length  | .charset  | .flags   |
   *|---------------|----------|-----------|----------|
   *| TINYBLOB      | 256      | binary    |          |
   *| BLOB          | 65535    | binary    |          |
   *| VARCHAR(32)   | 32       | utf8      |          |
   *| VARBINARY(32) | 32       | utf8&#92;_bin |          |
   *| BINARY(32)    | 32       | binary    | rightpad |
   *| CHAR(32)      | 32       | utf8      | rightpad |
   *
   *- ``value``
   *Sequence of bytes with added one extra ``0x00`` byte at
   *the end. To obtain the original string, the extra
   *``0x00`` should be removed. The length of the string can
   *be acquired with protobuf's field ``length()`` method:
   *
   *``length of sequence-of-bytes = length-of-field - 1``
   *&#64;note
   *The extra byte allows to distinguish between a NULL
   *and empty byte sequence.
   *
   *+ TIME
   *
   *A time value.
   *
   *- ``value``&#64;n
   *The following bytes sequence:
   *
   *``negate [ hour [ minutes [ seconds [ useconds ]]]]``
   *
   *-  negate - one byte, should be one of: 0x00 for "+",
   *0x01 for "-"
   *
   *-  hour - optional variable length encoded unsigned64
   *value for the hour
   *
   *-  minutes - optional variable length encoded unsigned64
   *value for the minutes
   *
   *-  seconds - optional variable length encoded unsigned64
   *value for the seconds
   *
   *-  useconds - optional variable length encoded
   *unsigned64 value for the microseconds
   *
   *&#64;par Tip
   *The protobuf encoding in
   *https://developers.google.com/protocol-buffers/docs/encoding.
   *
   *&#64;note
   *Hour, minutes, seconds, and useconds are optional if
   *all the values to the right are 0.
   *
   *Example: ``0x00 -&gt; +00:00:00.000000``
   *
   *+ DATETIME
   *
   *A date or date and time value.
   *
   *- ``value`` &#64;n
   *A sequence of variants, arranged as follows:
   *
   *``| year | month | day | [ | hour | [ | minutes | [ | seconds | [ | useconds | ]]]]``
   *
   *-  year - variable length encoded unsigned64 value for
   *the year
   *
   *-  month - variable length encoded unsigned64 value for
   *the month
   *
   *-  day - variable length encoded unsigned64 value for
   *the day
   *
   *-  hour - optional variable length encoded unsigned64
   *value for the hour
   *
   *-  minutes - optional variable length encoded unsigned64
   *value for the minutes
   *
   *-  seconds - optional variable length encoded unsigned64
   *value for the seconds
   *
   *-  useconds - optional variable length encoded
   *unsigned64 value for the microseconds
   *&#64;note
   *Hour, minutes, seconds, useconds are optional if all
   *the values to the right are 0.
   *
   *- ``.flags``&#64;n
   *| Name          | Position |
   *|---------------|----------|
   *| is&#92;_timestamp | 1        |
   *
   *+ DECIMAL
   *
   *An arbitrary length number. The number is encoded as a
   *single byte indicating the position of the decimal point
   *followed by the Packed BCD encoded number. Packed BCD is
   *used to simplify conversion to and from strings and other
   *native arbitrary precision math data types. See also: packed
   *BCD in https://en.wikipedia.org/wiki/Binary-coded_decimal
   *
   *- ``.length``
   *Maximum number of displayable decimal digits
   *(*excluding* the decimal point and sign, but including
   *``.fractional_digits``).
   *&#64;note
   *Should be in the range of 1 - 65.
   *
   *- ``.fractional_digits``
   *The decimal digits to display out of length.
   *&#64;note
   *Should be in the range of 0 - 30.
   *
   *``value``
   *The following bytes sequence:
   *
   *``scale | BCD+ sign [0x00]?``
   *
   *-  scale - 8bit scale value (number of decimal digit after the '.')
   *
   *-  BCD - BCD encoded digits (4 bits for each digit)
   *
   *-  sign - sign encoded on 4 bits (0xc = "+", 0xd = "-")
   *
   *-  0x0 - last 4bits if length(digits) % 2 == 0
   *
   *Example: ``x04 0x12 0x34 0x01
   *0xd0 -&gt; -12.3401``
   *
   *+ SET
   *
   *A list of strings representing a SET of values.
   *
   *- ``value``&#64;n
   *A sequence of 0 or more of protobuf's bytes (length
   *prepended octets) or one of the special sequences with a
   *predefined meaning listed below.
   *
   *Example (length of the bytes array shown in brackets):
   *-  ``[0]`` - the NULL value
   *
   *-  ``[1] 0x00`` - a set containing a blank string ''
   *
   *-  ``[1] 0x01`` - this would be an invalid value,
   *but is to be treated as the empty set
   *
   *-  ``[2] 0x01 0x00`` - a set with a single item, which is the '0'
   *character
   *
   *-  ``[8] 0x03 F O O 0x03 B A R`` - a set with 2 items: FOO,BAR
   * </pre>
   *
   * Protobuf type {@code Mysqlx.Resultset.ColumnMetaData}
   */
  public static final class ColumnMetaData extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Resultset.ColumnMetaData)
      ColumnMetaDataOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use ColumnMetaData.newBuilder() to construct.
    private ColumnMetaData(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private ColumnMetaData() {
      type_ = 1;
      name_ = com.google.protobuf.ByteString.EMPTY;
      originalName_ = com.google.protobuf.ByteString.EMPTY;
      table_ = com.google.protobuf.ByteString.EMPTY;
      originalTable_ = com.google.protobuf.ByteString.EMPTY;
      schema_ = com.google.protobuf.ByteString.EMPTY;
      catalog_ = com.google.protobuf.ByteString.EMPTY;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new ColumnMetaData();
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_ColumnMetaData_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_ColumnMetaData_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData.class, com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData.Builder.class);
    }

    /**
     * Protobuf enum {@code Mysqlx.Resultset.ColumnMetaData.FieldType}
     */
    public enum FieldType
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <code>SINT = 1;</code>
       */
      SINT(1),
      /**
       * <code>UINT = 2;</code>
       */
      UINT(2),
      /**
       * <code>DOUBLE = 5;</code>
       */
      DOUBLE(5),
      /**
       * <code>FLOAT = 6;</code>
       */
      FLOAT(6),
      /**
       * <code>BYTES = 7;</code>
       */
      BYTES(7),
      /**
       * <code>TIME = 10;</code>
       */
      TIME(10),
      /**
       * <code>DATETIME = 12;</code>
       */
      DATETIME(12),
      /**
       * <code>SET = 15;</code>
       */
      SET(15),
      /**
       * <code>ENUM = 16;</code>
       */
      ENUM(16),
      /**
       * <code>BIT = 17;</code>
       */
      BIT(17),
      /**
       * <code>DECIMAL = 18;</code>
       */
      DECIMAL(18),
      ;

      /**
       * <code>SINT = 1;</code>
       */
      public static final int SINT_VALUE = 1;
      /**
       * <code>UINT = 2;</code>
       */
      public static final int UINT_VALUE = 2;
      /**
       * <code>DOUBLE = 5;</code>
       */
      public static final int DOUBLE_VALUE = 5;
      /**
       * <code>FLOAT = 6;</code>
       */
      public static final int FLOAT_VALUE = 6;
      /**
       * <code>BYTES = 7;</code>
       */
      public static final int BYTES_VALUE = 7;
      /**
       * <code>TIME = 10;</code>
       */
      public static final int TIME_VALUE = 10;
      /**
       * <code>DATETIME = 12;</code>
       */
      public static final int DATETIME_VALUE = 12;
      /**
       * <code>SET = 15;</code>
       */
      public static final int SET_VALUE = 15;
      /**
       * <code>ENUM = 16;</code>
       */
      public static final int ENUM_VALUE = 16;
      /**
       * <code>BIT = 17;</code>
       */
      public static final int BIT_VALUE = 17;
      /**
       * <code>DECIMAL = 18;</code>
       */
      public static final int DECIMAL_VALUE = 18;


      public final int getNumber() {
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static FieldType valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static FieldType forNumber(int value) {
        switch (value) {
          case 1: return SINT;
          case 2: return UINT;
          case 5: return DOUBLE;
          case 6: return FLOAT;
          case 7: return BYTES;
          case 10: return TIME;
          case 12: return DATETIME;
          case 15: return SET;
          case 16: return ENUM;
          case 17: return BIT;
          case 18: return DECIMAL;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<FieldType>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static final com.google.protobuf.Internal.EnumLiteMap<
          FieldType> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<FieldType>() {
              public FieldType findValueByNumber(int number) {
                return FieldType.forNumber(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        return getDescriptor().getValues().get(ordinal());
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData.getDescriptor().getEnumTypes().get(0);
      }

      private static final FieldType[] VALUES = values();

      public static FieldType valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private FieldType(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:Mysqlx.Resultset.ColumnMetaData.FieldType)
    }

    private int bitField0_;
    public static final int TYPE_FIELD_NUMBER = 1;
    private int type_ = 1;
    /**
     * <pre>
     ** datatype of the field in a row 
     * </pre>
     *
     * <code>required .Mysqlx.Resultset.ColumnMetaData.FieldType type = 1;</code>
     * @return Whether the type field is set.
     */
    @java.lang.Override public boolean hasType() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     ** datatype of the field in a row 
     * </pre>
     *
     * <code>required .Mysqlx.Resultset.ColumnMetaData.FieldType type = 1;</code>
     * @return The type.
     */
    @java.lang.Override public com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData.FieldType getType() {
      com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData.FieldType result = com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData.FieldType.forNumber(type_);
      return result == null ? com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData.FieldType.SINT : result;
    }

    public static final int NAME_FIELD_NUMBER = 2;
    private com.google.protobuf.ByteString name_ = com.google.protobuf.ByteString.EMPTY;
    /**
     * <pre>
     ** name of the column 
     * </pre>
     *
     * <code>optional bytes name = 2;</code>
     * @return Whether the name field is set.
     */
    @java.lang.Override
    public boolean hasName() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     ** name of the column 
     * </pre>
     *
     * <code>optional bytes name = 2;</code>
     * @return The name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getName() {
      return name_;
    }

    public static final int ORIGINAL_NAME_FIELD_NUMBER = 3;
    private com.google.protobuf.ByteString originalName_ = com.google.protobuf.ByteString.EMPTY;
    /**
     * <pre>
     ** name of the column before an alias was applied 
     * </pre>
     *
     * <code>optional bytes original_name = 3;</code>
     * @return Whether the originalName field is set.
     */
    @java.lang.Override
    public boolean hasOriginalName() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <pre>
     ** name of the column before an alias was applied 
     * </pre>
     *
     * <code>optional bytes original_name = 3;</code>
     * @return The originalName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getOriginalName() {
      return originalName_;
    }

    public static final int TABLE_FIELD_NUMBER = 4;
    private com.google.protobuf.ByteString table_ = com.google.protobuf.ByteString.EMPTY;
    /**
     * <pre>
     ** name of the table the column originates from 
     * </pre>
     *
     * <code>optional bytes table = 4;</code>
     * @return Whether the table field is set.
     */
    @java.lang.Override
    public boolean hasTable() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     * <pre>
     ** name of the table the column originates from 
     * </pre>
     *
     * <code>optional bytes table = 4;</code>
     * @return The table.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTable() {
      return table_;
    }

    public static final int ORIGINAL_TABLE_FIELD_NUMBER = 5;
    private com.google.protobuf.ByteString originalTable_ = com.google.protobuf.ByteString.EMPTY;
    /**
     * <pre>
     ** name of the table the column originates from before an alias was applied 
     * </pre>
     *
     * <code>optional bytes original_table = 5;</code>
     * @return Whether the originalTable field is set.
     */
    @java.lang.Override
    public boolean hasOriginalTable() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     * <pre>
     ** name of the table the column originates from before an alias was applied 
     * </pre>
     *
     * <code>optional bytes original_table = 5;</code>
     * @return The originalTable.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getOriginalTable() {
      return originalTable_;
    }

    public static final int SCHEMA_FIELD_NUMBER = 6;
    private com.google.protobuf.ByteString schema_ = com.google.protobuf.ByteString.EMPTY;
    /**
     * <pre>
     ** schema the column originates from 
     * </pre>
     *
     * <code>optional bytes schema = 6;</code>
     * @return Whether the schema field is set.
     */
    @java.lang.Override
    public boolean hasSchema() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     * <pre>
     ** schema the column originates from 
     * </pre>
     *
     * <code>optional bytes schema = 6;</code>
     * @return The schema.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSchema() {
      return schema_;
    }

    public static final int CATALOG_FIELD_NUMBER = 7;
    private com.google.protobuf.ByteString catalog_ = com.google.protobuf.ByteString.EMPTY;
    /**
     * <pre>
     ** catalog the schema originates from
     *&#64;note
     *As there is currently no support for catalogs in MySQL,
     *don't expect this field to be set. In the MySQL C/S
     *protocol the field had the value ``def`` all the time 
     * </pre>
     *
     * <code>optional bytes catalog = 7;</code>
     * @return Whether the catalog field is set.
     */
    @java.lang.Override
    public boolean hasCatalog() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     * <pre>
     ** catalog the schema originates from
     *&#64;note
     *As there is currently no support for catalogs in MySQL,
     *don't expect this field to be set. In the MySQL C/S
     *protocol the field had the value ``def`` all the time 
     * </pre>
     *
     * <code>optional bytes catalog = 7;</code>
     * @return The catalog.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getCatalog() {
      return catalog_;
    }

    public static final int COLLATION_FIELD_NUMBER = 8;
    private long collation_ = 0L;
    /**
     * <code>optional uint64 collation = 8;</code>
     * @return Whether the collation field is set.
     */
    @java.lang.Override
    public boolean hasCollation() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     * <code>optional uint64 collation = 8;</code>
     * @return The collation.
     */
    @java.lang.Override
    public long getCollation() {
      return collation_;
    }

    public static final int FRACTIONAL_DIGITS_FIELD_NUMBER = 9;
    private int fractionalDigits_ = 0;
    /**
     * <pre>
     ** displayed factional decimal digits for floating point and
     *fixed point numbers 
     * </pre>
     *
     * <code>optional uint32 fractional_digits = 9;</code>
     * @return Whether the fractionalDigits field is set.
     */
    @java.lang.Override
    public boolean hasFractionalDigits() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     * <pre>
     ** displayed factional decimal digits for floating point and
     *fixed point numbers 
     * </pre>
     *
     * <code>optional uint32 fractional_digits = 9;</code>
     * @return The fractionalDigits.
     */
    @java.lang.Override
    public int getFractionalDigits() {
      return fractionalDigits_;
    }

    public static final int LENGTH_FIELD_NUMBER = 10;
    private int length_ = 0;
    /**
     * <pre>
     ** maximum count of displayable characters of .type 
     * </pre>
     *
     * <code>optional uint32 length = 10;</code>
     * @return Whether the length field is set.
     */
    @java.lang.Override
    public boolean hasLength() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     * <pre>
     ** maximum count of displayable characters of .type 
     * </pre>
     *
     * <code>optional uint32 length = 10;</code>
     * @return The length.
     */
    @java.lang.Override
    public int getLength() {
      return length_;
    }

    public static final int FLAGS_FIELD_NUMBER = 11;
    private int flags_ = 0;
    /**
     * <pre>
     ** ``.type`` specific flags
     *| Type    | Value  | Description  |
     *|---------|--------|--------------|
     *| UINT    | 0x0001 | zerofill     |
     *| DOUBLE  | 0x0001 | unsigned     |
     *| FLOAT   | 0x0001 | unsigned     |
     *| DECIMAL | 0x0001 | unsigned     |
     *| BYTES   | 0x0001 | rightpad     |
     *
     *| Value  | Description     |
     *|--------|-----------------|
     *| 0x0010 | NOT&#92;_NULL       |
     *| 0x0020 | PRIMARY&#92;_KEY    |
     *| 0x0040 | UNIQUE&#92;_KEY     |
     *| 0x0080 | MULTIPLE&#92;_KEY   |
     *| 0x0100 | AUTO&#92;_INCREMENT |
     *
     *default: 0 
     * </pre>
     *
     * <code>optional uint32 flags = 11;</code>
     * @return Whether the flags field is set.
     */
    @java.lang.Override
    public boolean hasFlags() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     * <pre>
     ** ``.type`` specific flags
     *| Type    | Value  | Description  |
     *|---------|--------|--------------|
     *| UINT    | 0x0001 | zerofill     |
     *| DOUBLE  | 0x0001 | unsigned     |
     *| FLOAT   | 0x0001 | unsigned     |
     *| DECIMAL | 0x0001 | unsigned     |
     *| BYTES   | 0x0001 | rightpad     |
     *
     *| Value  | Description     |
     *|--------|-----------------|
     *| 0x0010 | NOT&#92;_NULL       |
     *| 0x0020 | PRIMARY&#92;_KEY    |
     *| 0x0040 | UNIQUE&#92;_KEY     |
     *| 0x0080 | MULTIPLE&#92;_KEY   |
     *| 0x0100 | AUTO&#92;_INCREMENT |
     *
     *default: 0 
     * </pre>
     *
     * <code>optional uint32 flags = 11;</code>
     * @return The flags.
     */
    @java.lang.Override
    public int getFlags() {
      return flags_;
    }

    public static final int CONTENT_TYPE_FIELD_NUMBER = 12;
    private int contentType_ = 0;
    /**
     * <pre>
     ** a hint about the higher-level encoding of a BYTES field
     *| Type   | Value  | Description             |
     *|--------|--------|-------------------------|
     *| BYTES  | 0x0001 | GEOMETRY (WKB encoding) |
     *| BYTES  | 0x0002 | JSON (text encoding)    |
     *| BYTES  | 0x0003 | XML (text encoding)     |
     *&#64;note
     *This list isn't comprehensive. As a guideline: the field's
     *value is expected to pass a validator check on client
     *and server if this field is set. If the server adds more
     *internal data types that rely on BLOB storage like image
     *manipulation, seeking into complex types in BLOBs, and
     *more types will be added 
     * </pre>
     *
     * <code>optional uint32 content_type = 12;</code>
     * @return Whether the contentType field is set.
     */
    @java.lang.Override
    public boolean hasContentType() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     * <pre>
     ** a hint about the higher-level encoding of a BYTES field
     *| Type   | Value  | Description             |
     *|--------|--------|-------------------------|
     *| BYTES  | 0x0001 | GEOMETRY (WKB encoding) |
     *| BYTES  | 0x0002 | JSON (text encoding)    |
     *| BYTES  | 0x0003 | XML (text encoding)     |
     *&#64;note
     *This list isn't comprehensive. As a guideline: the field's
     *value is expected to pass a validator check on client
     *and server if this field is set. If the server adds more
     *internal data types that rely on BLOB storage like image
     *manipulation, seeking into complex types in BLOBs, and
     *more types will be added 
     * </pre>
     *
     * <code>optional uint32 content_type = 12;</code>
     * @return The contentType.
     */
    @java.lang.Override
    public int getContentType() {
      return contentType_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasType()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeEnum(1, type_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeBytes(2, name_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeBytes(3, originalName_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        output.writeBytes(4, table_);
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        output.writeBytes(5, originalTable_);
      }
      if (((bitField0_ & 0x00000020) != 0)) {
        output.writeBytes(6, schema_);
      }
      if (((bitField0_ & 0x00000040) != 0)) {
        output.writeBytes(7, catalog_);
      }
      if (((bitField0_ & 0x00000080) != 0)) {
        output.writeUInt64(8, collation_);
      }
      if (((bitField0_ & 0x00000100) != 0)) {
        output.writeUInt32(9, fractionalDigits_);
      }
      if (((bitField0_ & 0x00000200) != 0)) {
        output.writeUInt32(10, length_);
      }
      if (((bitField0_ & 0x00000400) != 0)) {
        output.writeUInt32(11, flags_);
      }
      if (((bitField0_ & 0x00000800) != 0)) {
        output.writeUInt32(12, contentType_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, type_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(2, name_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(3, originalName_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(4, table_);
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(5, originalTable_);
      }
      if (((bitField0_ & 0x00000020) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(6, schema_);
      }
      if (((bitField0_ & 0x00000040) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(7, catalog_);
      }
      if (((bitField0_ & 0x00000080) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(8, collation_);
      }
      if (((bitField0_ & 0x00000100) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(9, fractionalDigits_);
      }
      if (((bitField0_ & 0x00000200) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(10, length_);
      }
      if (((bitField0_ & 0x00000400) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(11, flags_);
      }
      if (((bitField0_ & 0x00000800) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(12, contentType_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData)) {
        return super.equals(obj);
      }
      com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData other = (com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData) obj;

      if (hasType() != other.hasType()) return false;
      if (hasType()) {
        if (type_ != other.type_) return false;
      }
      if (hasName() != other.hasName()) return false;
      if (hasName()) {
        if (!getName()
            .equals(other.getName())) return false;
      }
      if (hasOriginalName() != other.hasOriginalName()) return false;
      if (hasOriginalName()) {
        if (!getOriginalName()
            .equals(other.getOriginalName())) return false;
      }
      if (hasTable() != other.hasTable()) return false;
      if (hasTable()) {
        if (!getTable()
            .equals(other.getTable())) return false;
      }
      if (hasOriginalTable() != other.hasOriginalTable()) return false;
      if (hasOriginalTable()) {
        if (!getOriginalTable()
            .equals(other.getOriginalTable())) return false;
      }
      if (hasSchema() != other.hasSchema()) return false;
      if (hasSchema()) {
        if (!getSchema()
            .equals(other.getSchema())) return false;
      }
      if (hasCatalog() != other.hasCatalog()) return false;
      if (hasCatalog()) {
        if (!getCatalog()
            .equals(other.getCatalog())) return false;
      }
      if (hasCollation() != other.hasCollation()) return false;
      if (hasCollation()) {
        if (getCollation()
            != other.getCollation()) return false;
      }
      if (hasFractionalDigits() != other.hasFractionalDigits()) return false;
      if (hasFractionalDigits()) {
        if (getFractionalDigits()
            != other.getFractionalDigits()) return false;
      }
      if (hasLength() != other.hasLength()) return false;
      if (hasLength()) {
        if (getLength()
            != other.getLength()) return false;
      }
      if (hasFlags() != other.hasFlags()) return false;
      if (hasFlags()) {
        if (getFlags()
            != other.getFlags()) return false;
      }
      if (hasContentType() != other.hasContentType()) return false;
      if (hasContentType()) {
        if (getContentType()
            != other.getContentType()) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasType()) {
        hash = (37 * hash) + TYPE_FIELD_NUMBER;
        hash = (53 * hash) + type_;
      }
      if (hasName()) {
        hash = (37 * hash) + NAME_FIELD_NUMBER;
        hash = (53 * hash) + getName().hashCode();
      }
      if (hasOriginalName()) {
        hash = (37 * hash) + ORIGINAL_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getOriginalName().hashCode();
      }
      if (hasTable()) {
        hash = (37 * hash) + TABLE_FIELD_NUMBER;
        hash = (53 * hash) + getTable().hashCode();
      }
      if (hasOriginalTable()) {
        hash = (37 * hash) + ORIGINAL_TABLE_FIELD_NUMBER;
        hash = (53 * hash) + getOriginalTable().hashCode();
      }
      if (hasSchema()) {
        hash = (37 * hash) + SCHEMA_FIELD_NUMBER;
        hash = (53 * hash) + getSchema().hashCode();
      }
      if (hasCatalog()) {
        hash = (37 * hash) + CATALOG_FIELD_NUMBER;
        hash = (53 * hash) + getCatalog().hashCode();
      }
      if (hasCollation()) {
        hash = (37 * hash) + COLLATION_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
            getCollation());
      }
      if (hasFractionalDigits()) {
        hash = (37 * hash) + FRACTIONAL_DIGITS_FIELD_NUMBER;
        hash = (53 * hash) + getFractionalDigits();
      }
      if (hasLength()) {
        hash = (37 * hash) + LENGTH_FIELD_NUMBER;
        hash = (53 * hash) + getLength();
      }
      if (hasFlags()) {
        hash = (37 * hash) + FLAGS_FIELD_NUMBER;
        hash = (53 * hash) + getFlags();
      }
      if (hasContentType()) {
        hash = (37 * hash) + CONTENT_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getContentType();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     **
     *Meta data of a column
     *
     *&#64;note
     *The encoding used for the different ``bytes`` fields in the
     *meta data is externally controlled. See also:
     *https://dev.mysql.com/doc/refman/5.0/en/charset-connection.html
     *
     *&#64;par
     *&#64;note
     *The server may not set the ``original_{table|name}`` fields
     *if they are equal to the plain ``{table|name}`` field.
     *
     *&#64;par
     *&#64;note
     *A client has to reconstruct it like:
     *&#64;code{py}
     *if .original_name is empty and .name is not empty:
     *.original_name = .name
     *
     *if .original_table is empty and .table is not empty:
     *.original_table = .table
     *&#64;endcode
     *
     *&#64;par
     *&#64;note
     *``Compact metadata format`` can be requested by the client.
     *In that case, only ``.type`` is set and all other fields are  empty.
     *
     *
     *Expected data type of Mysqlx.Resultset.Row per SQL Type for
     *non-NULL values:
     *
     *| SQL Type          | .type     | .length | .frac&#92;_dig | .flags | .charset |
     *|-------------------|-----------|---------|------------|--------|----------|
     *| TINY              | SINT      | x       |            |        |          |
     *| TINY UNSIGNED     | UINT      | x       |            | x      |          |
     *| SHORT             | SINT      | x       |            |        |          |
     *| SHORT UNSIGNED    | UINT      | x       |            | x      |          |
     *| INT24             | SINT      | x       |            |        |          |
     *| INT24 UNSIGNED    | UINT      | x       |            | x      |          |
     *| INT               | SINT      | x       |            |        |          |
     *| INT UNSIGNED      | UINT      | x       |            | x      |          |
     *| LONGLONG          | SINT      | x       |            |        |          |
     *| LONGLONG UNSIGNED | UINT      | x       |            | x      |          |
     *| DOUBLE            | DOUBLE    | x       | x          | x      |          |
     *| FLOAT             | FLOAT     | x       | x          | x      |          |
     *| DECIMAL           | DECIMAL   | x       | x          | x      |          |
     *| VARCHAR,CHAR,...  | BYTES     | x       |            | x      | x        |
     *| GEOMETRY          | BYTES     |         |            |        |          |
     *| TIME              | TIME      | x       |            |        |          |
     *| DATE              | DATETIME  | x       |            |        |          |
     *| DATETIME          | DATETIME  | x       |            |        |          |
     *| YEAR              | UINT      | x       |            | x      |          |
     *| TIMESTAMP         | DATETIME  | x       |            |        |          |
     *| SET               | SET       |         |            |        | x        |
     *| ENUM              | ENUM      |         |            |        | x        |
     *| NULL              | BYTES     |         |            |        |          |
     *| BIT               | BIT       | x       |            |        |          |
     *
     *&#64;note
     *The SQL "NULL" value is sent as an empty field value in
     *&#64;ref Mysqlx::Resultset::Row.
     *
     *&#64;par Tip
     *The protobuf encoding of primitive data types is described in
     *https://developers.google.com/protocol-buffers/docs/encoding
     *
     *+ SINT
     *
     *- ``.length`` &#64;n
     *Maximum number of displayable decimal digits (including
     *minus sign) of the type.
     *&#64;note
     *The valid range is 0-255, but usually you'll see 1-20.
     *
     *| SQL Type         | Maximum Digits per Type |
     *|------------------|-------------------------|
     *| TINY SIGNED      | 4                       |
     *| SHORT SIGNED     | 6                       |
     *| INT24 SIGNED     | 8                       |
     *| INT SIGNED       | 11                      |
     *| LONGLONG SIGNED  | 20                      |
     *
     *&#64;par Tip
     *Definition of ``M`` are in
     *https://dev.mysql.com/doc/refman/5.5/en/numeric-type-overview.html.
     *
     *- ``value``&#64;n
     *Variable length encoded signed 64 integer.
     *
     *+ UINT
     *
     *- ``.flags &amp; 1`` (zerofill) &#64;n
     *The client has to left pad with 0's up to .length.
     *
     *- ``.length`` &#64;n
     *Maximum number of displayable decimal digits of the
     *type.
     *&#64;note
     *The valid range is 0-255, but usually you'll see
     *1-20.
     *
     *| SQL Type             | max digits per type |
     *|----------------------|---------------------|
     *| TINY UNSIGNED        | 3                   |
     *| SHORT UNSIGNED       | 5                   |
     *| INT24 UNSIGNED       | 8                   |
     *| INT UNSIGNED         | 10                  |
     *| LONGLONG UNSIGNED    | 20                  |
     *
     *&#64;par Tip
     *Definition of ``M`` are in
     *https://dev.mysql.com/doc/refman/5.5/en/numeric-type-overview.html.
     *
     *- ``value`` &#64;n
     *Variable length encoded unsigned 64 integer.
     *
     *+ BIT
     *
     *- ``.length`` &#64;n
     *Maximum number of displayable binary digits.
     *&#64;note
     *The valid range for M of the ``BIT`` type is 1 - 64.
     *
     *&#64;par Tip
     *https://dev.mysql.com/doc/refman/5.5/en/numeric-type-overview.html
     *
     *- ``value`` &#64;n
     *Variable length encoded unsigned 64 integer.
     *
     *+ DOUBLE
     *
     *- ``.length`` &#64;n
     *Maximum number of displayable decimal digits (including
     *the decimal point and ``.fractional_digits``).
     *
     *- ``.fractional_digits`` &#64;n
     *Maximum number of displayable decimal digits following
     *the decimal point.
     *
     *- ``value``&#64;n
     *Encoded as protobuf's 'double'.
     *
     *+ FLOAT
     *
     *- ``.length``&#64;n
     *Maximum number of displayable decimal digits (including
     *the decimal point and ``.fractional_digits``).
     *
     *- ``.fractional_digits``&#64;n
     *Maximum number of displayable decimal digits following
     *the decimal point.
     *
     *- ``value``&#64;n
     *Encoded as protobuf's 'float'.
     *
     *+ BYTES, ENUM
     *&#64;note
     *BYTES is used for all opaque byte strings that may have a charset:
     *-  TINYBLOB, BLOB, MEDIUMBLOB, LONGBLOB
     *-  TINYTEXT, TEXT, MEDIUMTEXT, LONGTEXT
     *-  VARCHAR, VARBINARY
     *-  CHAR, BINARY
     *-  ENUM
     *
     *- ``.length``&#64;n
     *Maximum length of characters of the underlying type.
     *
     *- ``.flags &amp; 1`` (rightpad) &#64;n
     *If the length of the field is less than ``.length``, the
     *receiver is supposed to add padding characters to the
     *right end of the string. If the ``.charset`` is
     *"binary", the padding character is ``0x00``, otherwise
     *it is a space character as defined by that character
     *set.
     *| SQL Type      | .length  | .charset  | .flags   |
     *|---------------|----------|-----------|----------|
     *| TINYBLOB      | 256      | binary    |          |
     *| BLOB          | 65535    | binary    |          |
     *| VARCHAR(32)   | 32       | utf8      |          |
     *| VARBINARY(32) | 32       | utf8&#92;_bin |          |
     *| BINARY(32)    | 32       | binary    | rightpad |
     *| CHAR(32)      | 32       | utf8      | rightpad |
     *
     *- ``value``
     *Sequence of bytes with added one extra ``0x00`` byte at
     *the end. To obtain the original string, the extra
     *``0x00`` should be removed. The length of the string can
     *be acquired with protobuf's field ``length()`` method:
     *
     *``length of sequence-of-bytes = length-of-field - 1``
     *&#64;note
     *The extra byte allows to distinguish between a NULL
     *and empty byte sequence.
     *
     *+ TIME
     *
     *A time value.
     *
     *- ``value``&#64;n
     *The following bytes sequence:
     *
     *``negate [ hour [ minutes [ seconds [ useconds ]]]]``
     *
     *-  negate - one byte, should be one of: 0x00 for "+",
     *0x01 for "-"
     *
     *-  hour - optional variable length encoded unsigned64
     *value for the hour
     *
     *-  minutes - optional variable length encoded unsigned64
     *value for the minutes
     *
     *-  seconds - optional variable length encoded unsigned64
     *value for the seconds
     *
     *-  useconds - optional variable length encoded
     *unsigned64 value for the microseconds
     *
     *&#64;par Tip
     *The protobuf encoding in
     *https://developers.google.com/protocol-buffers/docs/encoding.
     *
     *&#64;note
     *Hour, minutes, seconds, and useconds are optional if
     *all the values to the right are 0.
     *
     *Example: ``0x00 -&gt; +00:00:00.000000``
     *
     *+ DATETIME
     *
     *A date or date and time value.
     *
     *- ``value`` &#64;n
     *A sequence of variants, arranged as follows:
     *
     *``| year | month | day | [ | hour | [ | minutes | [ | seconds | [ | useconds | ]]]]``
     *
     *-  year - variable length encoded unsigned64 value for
     *the year
     *
     *-  month - variable length encoded unsigned64 value for
     *the month
     *
     *-  day - variable length encoded unsigned64 value for
     *the day
     *
     *-  hour - optional variable length encoded unsigned64
     *value for the hour
     *
     *-  minutes - optional variable length encoded unsigned64
     *value for the minutes
     *
     *-  seconds - optional variable length encoded unsigned64
     *value for the seconds
     *
     *-  useconds - optional variable length encoded
     *unsigned64 value for the microseconds
     *&#64;note
     *Hour, minutes, seconds, useconds are optional if all
     *the values to the right are 0.
     *
     *- ``.flags``&#64;n
     *| Name          | Position |
     *|---------------|----------|
     *| is&#92;_timestamp | 1        |
     *
     *+ DECIMAL
     *
     *An arbitrary length number. The number is encoded as a
     *single byte indicating the position of the decimal point
     *followed by the Packed BCD encoded number. Packed BCD is
     *used to simplify conversion to and from strings and other
     *native arbitrary precision math data types. See also: packed
     *BCD in https://en.wikipedia.org/wiki/Binary-coded_decimal
     *
     *- ``.length``
     *Maximum number of displayable decimal digits
     *(*excluding* the decimal point and sign, but including
     *``.fractional_digits``).
     *&#64;note
     *Should be in the range of 1 - 65.
     *
     *- ``.fractional_digits``
     *The decimal digits to display out of length.
     *&#64;note
     *Should be in the range of 0 - 30.
     *
     *``value``
     *The following bytes sequence:
     *
     *``scale | BCD+ sign [0x00]?``
     *
     *-  scale - 8bit scale value (number of decimal digit after the '.')
     *
     *-  BCD - BCD encoded digits (4 bits for each digit)
     *
     *-  sign - sign encoded on 4 bits (0xc = "+", 0xd = "-")
     *
     *-  0x0 - last 4bits if length(digits) % 2 == 0
     *
     *Example: ``x04 0x12 0x34 0x01
     *0xd0 -&gt; -12.3401``
     *
     *+ SET
     *
     *A list of strings representing a SET of values.
     *
     *- ``value``&#64;n
     *A sequence of 0 or more of protobuf's bytes (length
     *prepended octets) or one of the special sequences with a
     *predefined meaning listed below.
     *
     *Example (length of the bytes array shown in brackets):
     *-  ``[0]`` - the NULL value
     *
     *-  ``[1] 0x00`` - a set containing a blank string ''
     *
     *-  ``[1] 0x01`` - this would be an invalid value,
     *but is to be treated as the empty set
     *
     *-  ``[2] 0x01 0x00`` - a set with a single item, which is the '0'
     *character
     *
     *-  ``[8] 0x03 F O O 0x03 B A R`` - a set with 2 items: FOO,BAR
     * </pre>
     *
     * Protobuf type {@code Mysqlx.Resultset.ColumnMetaData}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Resultset.ColumnMetaData)
        com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaDataOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_ColumnMetaData_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_ColumnMetaData_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData.class, com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        type_ = 1;
        name_ = com.google.protobuf.ByteString.EMPTY;
        originalName_ = com.google.protobuf.ByteString.EMPTY;
        table_ = com.google.protobuf.ByteString.EMPTY;
        originalTable_ = com.google.protobuf.ByteString.EMPTY;
        schema_ = com.google.protobuf.ByteString.EMPTY;
        catalog_ = com.google.protobuf.ByteString.EMPTY;
        collation_ = 0L;
        fractionalDigits_ = 0;
        length_ = 0;
        flags_ = 0;
        contentType_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_ColumnMetaData_descriptor;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData.getDefaultInstance();
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData build() {
        com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData result = new com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.type_ = type_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.name_ = name_;
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.originalName_ = originalName_;
          to_bitField0_ |= 0x00000004;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.table_ = table_;
          to_bitField0_ |= 0x00000008;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.originalTable_ = originalTable_;
          to_bitField0_ |= 0x00000010;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.schema_ = schema_;
          to_bitField0_ |= 0x00000020;
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.catalog_ = catalog_;
          to_bitField0_ |= 0x00000040;
        }
        if (((from_bitField0_ & 0x00000080) != 0)) {
          result.collation_ = collation_;
          to_bitField0_ |= 0x00000080;
        }
        if (((from_bitField0_ & 0x00000100) != 0)) {
          result.fractionalDigits_ = fractionalDigits_;
          to_bitField0_ |= 0x00000100;
        }
        if (((from_bitField0_ & 0x00000200) != 0)) {
          result.length_ = length_;
          to_bitField0_ |= 0x00000200;
        }
        if (((from_bitField0_ & 0x00000400) != 0)) {
          result.flags_ = flags_;
          to_bitField0_ |= 0x00000400;
        }
        if (((from_bitField0_ & 0x00000800) != 0)) {
          result.contentType_ = contentType_;
          to_bitField0_ |= 0x00000800;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData.getDefaultInstance()) return this;
        if (other.hasType()) {
          setType(other.getType());
        }
        if (other.hasName()) {
          setName(other.getName());
        }
        if (other.hasOriginalName()) {
          setOriginalName(other.getOriginalName());
        }
        if (other.hasTable()) {
          setTable(other.getTable());
        }
        if (other.hasOriginalTable()) {
          setOriginalTable(other.getOriginalTable());
        }
        if (other.hasSchema()) {
          setSchema(other.getSchema());
        }
        if (other.hasCatalog()) {
          setCatalog(other.getCatalog());
        }
        if (other.hasCollation()) {
          setCollation(other.getCollation());
        }
        if (other.hasFractionalDigits()) {
          setFractionalDigits(other.getFractionalDigits());
        }
        if (other.hasLength()) {
          setLength(other.getLength());
        }
        if (other.hasFlags()) {
          setFlags(other.getFlags());
        }
        if (other.hasContentType()) {
          setContentType(other.getContentType());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasType()) {
          return false;
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                int tmpRaw = input.readEnum();
                com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData.FieldType tmpValue =
                    com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData.FieldType.forNumber(tmpRaw);
                if (tmpValue == null) {
                  mergeUnknownVarintField(1, tmpRaw);
                } else {
                  type_ = tmpRaw;
                  bitField0_ |= 0x00000001;
                }
                break;
              } // case 8
              case 18: {
                name_ = input.readBytes();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
              case 26: {
                originalName_ = input.readBytes();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
              case 34: {
                table_ = input.readBytes();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
              case 42: {
                originalTable_ = input.readBytes();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
              case 50: {
                schema_ = input.readBytes();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
              case 58: {
                catalog_ = input.readBytes();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
              case 64: {
                collation_ = input.readUInt64();
                bitField0_ |= 0x00000080;
                break;
              } // case 64
              case 72: {
                fractionalDigits_ = input.readUInt32();
                bitField0_ |= 0x00000100;
                break;
              } // case 72
              case 80: {
                length_ = input.readUInt32();
                bitField0_ |= 0x00000200;
                break;
              } // case 80
              case 88: {
                flags_ = input.readUInt32();
                bitField0_ |= 0x00000400;
                break;
              } // case 88
              case 96: {
                contentType_ = input.readUInt32();
                bitField0_ |= 0x00000800;
                break;
              } // case 96
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private int type_ = 1;
      /**
       * <pre>
       ** datatype of the field in a row 
       * </pre>
       *
       * <code>required .Mysqlx.Resultset.ColumnMetaData.FieldType type = 1;</code>
       * @return Whether the type field is set.
       */
      @java.lang.Override public boolean hasType() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       ** datatype of the field in a row 
       * </pre>
       *
       * <code>required .Mysqlx.Resultset.ColumnMetaData.FieldType type = 1;</code>
       * @return The type.
       */
      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData.FieldType getType() {
        com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData.FieldType result = com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData.FieldType.forNumber(type_);
        return result == null ? com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData.FieldType.SINT : result;
      }
      /**
       * <pre>
       ** datatype of the field in a row 
       * </pre>
       *
       * <code>required .Mysqlx.Resultset.ColumnMetaData.FieldType type = 1;</code>
       * @param value The type to set.
       * @return This builder for chaining.
       */
      public Builder setType(com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData.FieldType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        type_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       ** datatype of the field in a row 
       * </pre>
       *
       * <code>required .Mysqlx.Resultset.ColumnMetaData.FieldType type = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000001);
        type_ = 1;
        onChanged();
        return this;
      }

      private com.google.protobuf.ByteString name_ = com.google.protobuf.ByteString.EMPTY;
      /**
       * <pre>
       ** name of the column 
       * </pre>
       *
       * <code>optional bytes name = 2;</code>
       * @return Whether the name field is set.
       */
      @java.lang.Override
      public boolean hasName() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <pre>
       ** name of the column 
       * </pre>
       *
       * <code>optional bytes name = 2;</code>
       * @return The name.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getName() {
        return name_;
      }
      /**
       * <pre>
       ** name of the column 
       * </pre>
       *
       * <code>optional bytes name = 2;</code>
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        name_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <pre>
       ** name of the column 
       * </pre>
       *
       * <code>optional bytes name = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearName() {
        bitField0_ = (bitField0_ & ~0x00000002);
        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }

      private com.google.protobuf.ByteString originalName_ = com.google.protobuf.ByteString.EMPTY;
      /**
       * <pre>
       ** name of the column before an alias was applied 
       * </pre>
       *
       * <code>optional bytes original_name = 3;</code>
       * @return Whether the originalName field is set.
       */
      @java.lang.Override
      public boolean hasOriginalName() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <pre>
       ** name of the column before an alias was applied 
       * </pre>
       *
       * <code>optional bytes original_name = 3;</code>
       * @return The originalName.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getOriginalName() {
        return originalName_;
      }
      /**
       * <pre>
       ** name of the column before an alias was applied 
       * </pre>
       *
       * <code>optional bytes original_name = 3;</code>
       * @param value The originalName to set.
       * @return This builder for chaining.
       */
      public Builder setOriginalName(com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        originalName_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <pre>
       ** name of the column before an alias was applied 
       * </pre>
       *
       * <code>optional bytes original_name = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearOriginalName() {
        bitField0_ = (bitField0_ & ~0x00000004);
        originalName_ = getDefaultInstance().getOriginalName();
        onChanged();
        return this;
      }

      private com.google.protobuf.ByteString table_ = com.google.protobuf.ByteString.EMPTY;
      /**
       * <pre>
       ** name of the table the column originates from 
       * </pre>
       *
       * <code>optional bytes table = 4;</code>
       * @return Whether the table field is set.
       */
      @java.lang.Override
      public boolean hasTable() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       * <pre>
       ** name of the table the column originates from 
       * </pre>
       *
       * <code>optional bytes table = 4;</code>
       * @return The table.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getTable() {
        return table_;
      }
      /**
       * <pre>
       ** name of the table the column originates from 
       * </pre>
       *
       * <code>optional bytes table = 4;</code>
       * @param value The table to set.
       * @return This builder for chaining.
       */
      public Builder setTable(com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        table_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       * <pre>
       ** name of the table the column originates from 
       * </pre>
       *
       * <code>optional bytes table = 4;</code>
       * @return This builder for chaining.
       */
      public Builder clearTable() {
        bitField0_ = (bitField0_ & ~0x00000008);
        table_ = getDefaultInstance().getTable();
        onChanged();
        return this;
      }

      private com.google.protobuf.ByteString originalTable_ = com.google.protobuf.ByteString.EMPTY;
      /**
       * <pre>
       ** name of the table the column originates from before an alias was applied 
       * </pre>
       *
       * <code>optional bytes original_table = 5;</code>
       * @return Whether the originalTable field is set.
       */
      @java.lang.Override
      public boolean hasOriginalTable() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       * <pre>
       ** name of the table the column originates from before an alias was applied 
       * </pre>
       *
       * <code>optional bytes original_table = 5;</code>
       * @return The originalTable.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getOriginalTable() {
        return originalTable_;
      }
      /**
       * <pre>
       ** name of the table the column originates from before an alias was applied 
       * </pre>
       *
       * <code>optional bytes original_table = 5;</code>
       * @param value The originalTable to set.
       * @return This builder for chaining.
       */
      public Builder setOriginalTable(com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        originalTable_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       * <pre>
       ** name of the table the column originates from before an alias was applied 
       * </pre>
       *
       * <code>optional bytes original_table = 5;</code>
       * @return This builder for chaining.
       */
      public Builder clearOriginalTable() {
        bitField0_ = (bitField0_ & ~0x00000010);
        originalTable_ = getDefaultInstance().getOriginalTable();
        onChanged();
        return this;
      }

      private com.google.protobuf.ByteString schema_ = com.google.protobuf.ByteString.EMPTY;
      /**
       * <pre>
       ** schema the column originates from 
       * </pre>
       *
       * <code>optional bytes schema = 6;</code>
       * @return Whether the schema field is set.
       */
      @java.lang.Override
      public boolean hasSchema() {
        return ((bitField0_ & 0x00000020) != 0);
      }
      /**
       * <pre>
       ** schema the column originates from 
       * </pre>
       *
       * <code>optional bytes schema = 6;</code>
       * @return The schema.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getSchema() {
        return schema_;
      }
      /**
       * <pre>
       ** schema the column originates from 
       * </pre>
       *
       * <code>optional bytes schema = 6;</code>
       * @param value The schema to set.
       * @return This builder for chaining.
       */
      public Builder setSchema(com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        schema_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       * <pre>
       ** schema the column originates from 
       * </pre>
       *
       * <code>optional bytes schema = 6;</code>
       * @return This builder for chaining.
       */
      public Builder clearSchema() {
        bitField0_ = (bitField0_ & ~0x00000020);
        schema_ = getDefaultInstance().getSchema();
        onChanged();
        return this;
      }

      private com.google.protobuf.ByteString catalog_ = com.google.protobuf.ByteString.EMPTY;
      /**
       * <pre>
       ** catalog the schema originates from
       *&#64;note
       *As there is currently no support for catalogs in MySQL,
       *don't expect this field to be set. In the MySQL C/S
       *protocol the field had the value ``def`` all the time 
       * </pre>
       *
       * <code>optional bytes catalog = 7;</code>
       * @return Whether the catalog field is set.
       */
      @java.lang.Override
      public boolean hasCatalog() {
        return ((bitField0_ & 0x00000040) != 0);
      }
      /**
       * <pre>
       ** catalog the schema originates from
       *&#64;note
       *As there is currently no support for catalogs in MySQL,
       *don't expect this field to be set. In the MySQL C/S
       *protocol the field had the value ``def`` all the time 
       * </pre>
       *
       * <code>optional bytes catalog = 7;</code>
       * @return The catalog.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getCatalog() {
        return catalog_;
      }
      /**
       * <pre>
       ** catalog the schema originates from
       *&#64;note
       *As there is currently no support for catalogs in MySQL,
       *don't expect this field to be set. In the MySQL C/S
       *protocol the field had the value ``def`` all the time 
       * </pre>
       *
       * <code>optional bytes catalog = 7;</code>
       * @param value The catalog to set.
       * @return This builder for chaining.
       */
      public Builder setCatalog(com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        catalog_ = value;
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       * <pre>
       ** catalog the schema originates from
       *&#64;note
       *As there is currently no support for catalogs in MySQL,
       *don't expect this field to be set. In the MySQL C/S
       *protocol the field had the value ``def`` all the time 
       * </pre>
       *
       * <code>optional bytes catalog = 7;</code>
       * @return This builder for chaining.
       */
      public Builder clearCatalog() {
        bitField0_ = (bitField0_ & ~0x00000040);
        catalog_ = getDefaultInstance().getCatalog();
        onChanged();
        return this;
      }

      private long collation_ ;
      /**
       * <code>optional uint64 collation = 8;</code>
       * @return Whether the collation field is set.
       */
      @java.lang.Override
      public boolean hasCollation() {
        return ((bitField0_ & 0x00000080) != 0);
      }
      /**
       * <code>optional uint64 collation = 8;</code>
       * @return The collation.
       */
      @java.lang.Override
      public long getCollation() {
        return collation_;
      }
      /**
       * <code>optional uint64 collation = 8;</code>
       * @param value The collation to set.
       * @return This builder for chaining.
       */
      public Builder setCollation(long value) {

        collation_ = value;
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 collation = 8;</code>
       * @return This builder for chaining.
       */
      public Builder clearCollation() {
        bitField0_ = (bitField0_ & ~0x00000080);
        collation_ = 0L;
        onChanged();
        return this;
      }

      private int fractionalDigits_ ;
      /**
       * <pre>
       ** displayed factional decimal digits for floating point and
       *fixed point numbers 
       * </pre>
       *
       * <code>optional uint32 fractional_digits = 9;</code>
       * @return Whether the fractionalDigits field is set.
       */
      @java.lang.Override
      public boolean hasFractionalDigits() {
        return ((bitField0_ & 0x00000100) != 0);
      }
      /**
       * <pre>
       ** displayed factional decimal digits for floating point and
       *fixed point numbers 
       * </pre>
       *
       * <code>optional uint32 fractional_digits = 9;</code>
       * @return The fractionalDigits.
       */
      @java.lang.Override
      public int getFractionalDigits() {
        return fractionalDigits_;
      }
      /**
       * <pre>
       ** displayed factional decimal digits for floating point and
       *fixed point numbers 
       * </pre>
       *
       * <code>optional uint32 fractional_digits = 9;</code>
       * @param value The fractionalDigits to set.
       * @return This builder for chaining.
       */
      public Builder setFractionalDigits(int value) {

        fractionalDigits_ = value;
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }
      /**
       * <pre>
       ** displayed factional decimal digits for floating point and
       *fixed point numbers 
       * </pre>
       *
       * <code>optional uint32 fractional_digits = 9;</code>
       * @return This builder for chaining.
       */
      public Builder clearFractionalDigits() {
        bitField0_ = (bitField0_ & ~0x00000100);
        fractionalDigits_ = 0;
        onChanged();
        return this;
      }

      private int length_ ;
      /**
       * <pre>
       ** maximum count of displayable characters of .type 
       * </pre>
       *
       * <code>optional uint32 length = 10;</code>
       * @return Whether the length field is set.
       */
      @java.lang.Override
      public boolean hasLength() {
        return ((bitField0_ & 0x00000200) != 0);
      }
      /**
       * <pre>
       ** maximum count of displayable characters of .type 
       * </pre>
       *
       * <code>optional uint32 length = 10;</code>
       * @return The length.
       */
      @java.lang.Override
      public int getLength() {
        return length_;
      }
      /**
       * <pre>
       ** maximum count of displayable characters of .type 
       * </pre>
       *
       * <code>optional uint32 length = 10;</code>
       * @param value The length to set.
       * @return This builder for chaining.
       */
      public Builder setLength(int value) {

        length_ = value;
        bitField0_ |= 0x00000200;
        onChanged();
        return this;
      }
      /**
       * <pre>
       ** maximum count of displayable characters of .type 
       * </pre>
       *
       * <code>optional uint32 length = 10;</code>
       * @return This builder for chaining.
       */
      public Builder clearLength() {
        bitField0_ = (bitField0_ & ~0x00000200);
        length_ = 0;
        onChanged();
        return this;
      }

      private int flags_ ;
      /**
       * <pre>
       ** ``.type`` specific flags
       *| Type    | Value  | Description  |
       *|---------|--------|--------------|
       *| UINT    | 0x0001 | zerofill     |
       *| DOUBLE  | 0x0001 | unsigned     |
       *| FLOAT   | 0x0001 | unsigned     |
       *| DECIMAL | 0x0001 | unsigned     |
       *| BYTES   | 0x0001 | rightpad     |
       *
       *| Value  | Description     |
       *|--------|-----------------|
       *| 0x0010 | NOT&#92;_NULL       |
       *| 0x0020 | PRIMARY&#92;_KEY    |
       *| 0x0040 | UNIQUE&#92;_KEY     |
       *| 0x0080 | MULTIPLE&#92;_KEY   |
       *| 0x0100 | AUTO&#92;_INCREMENT |
       *
       *default: 0 
       * </pre>
       *
       * <code>optional uint32 flags = 11;</code>
       * @return Whether the flags field is set.
       */
      @java.lang.Override
      public boolean hasFlags() {
        return ((bitField0_ & 0x00000400) != 0);
      }
      /**
       * <pre>
       ** ``.type`` specific flags
       *| Type    | Value  | Description  |
       *|---------|--------|--------------|
       *| UINT    | 0x0001 | zerofill     |
       *| DOUBLE  | 0x0001 | unsigned     |
       *| FLOAT   | 0x0001 | unsigned     |
       *| DECIMAL | 0x0001 | unsigned     |
       *| BYTES   | 0x0001 | rightpad     |
       *
       *| Value  | Description     |
       *|--------|-----------------|
       *| 0x0010 | NOT&#92;_NULL       |
       *| 0x0020 | PRIMARY&#92;_KEY    |
       *| 0x0040 | UNIQUE&#92;_KEY     |
       *| 0x0080 | MULTIPLE&#92;_KEY   |
       *| 0x0100 | AUTO&#92;_INCREMENT |
       *
       *default: 0 
       * </pre>
       *
       * <code>optional uint32 flags = 11;</code>
       * @return The flags.
       */
      @java.lang.Override
      public int getFlags() {
        return flags_;
      }
      /**
       * <pre>
       ** ``.type`` specific flags
       *| Type    | Value  | Description  |
       *|---------|--------|--------------|
       *| UINT    | 0x0001 | zerofill     |
       *| DOUBLE  | 0x0001 | unsigned     |
       *| FLOAT   | 0x0001 | unsigned     |
       *| DECIMAL | 0x0001 | unsigned     |
       *| BYTES   | 0x0001 | rightpad     |
       *
       *| Value  | Description     |
       *|--------|-----------------|
       *| 0x0010 | NOT&#92;_NULL       |
       *| 0x0020 | PRIMARY&#92;_KEY    |
       *| 0x0040 | UNIQUE&#92;_KEY     |
       *| 0x0080 | MULTIPLE&#92;_KEY   |
       *| 0x0100 | AUTO&#92;_INCREMENT |
       *
       *default: 0 
       * </pre>
       *
       * <code>optional uint32 flags = 11;</code>
       * @param value The flags to set.
       * @return This builder for chaining.
       */
      public Builder setFlags(int value) {

        flags_ = value;
        bitField0_ |= 0x00000400;
        onChanged();
        return this;
      }
      /**
       * <pre>
       ** ``.type`` specific flags
       *| Type    | Value  | Description  |
       *|---------|--------|--------------|
       *| UINT    | 0x0001 | zerofill     |
       *| DOUBLE  | 0x0001 | unsigned     |
       *| FLOAT   | 0x0001 | unsigned     |
       *| DECIMAL | 0x0001 | unsigned     |
       *| BYTES   | 0x0001 | rightpad     |
       *
       *| Value  | Description     |
       *|--------|-----------------|
       *| 0x0010 | NOT&#92;_NULL       |
       *| 0x0020 | PRIMARY&#92;_KEY    |
       *| 0x0040 | UNIQUE&#92;_KEY     |
       *| 0x0080 | MULTIPLE&#92;_KEY   |
       *| 0x0100 | AUTO&#92;_INCREMENT |
       *
       *default: 0 
       * </pre>
       *
       * <code>optional uint32 flags = 11;</code>
       * @return This builder for chaining.
       */
      public Builder clearFlags() {
        bitField0_ = (bitField0_ & ~0x00000400);
        flags_ = 0;
        onChanged();
        return this;
      }

      private int contentType_ ;
      /**
       * <pre>
       ** a hint about the higher-level encoding of a BYTES field
       *| Type   | Value  | Description             |
       *|--------|--------|-------------------------|
       *| BYTES  | 0x0001 | GEOMETRY (WKB encoding) |
       *| BYTES  | 0x0002 | JSON (text encoding)    |
       *| BYTES  | 0x0003 | XML (text encoding)     |
       *&#64;note
       *This list isn't comprehensive. As a guideline: the field's
       *value is expected to pass a validator check on client
       *and server if this field is set. If the server adds more
       *internal data types that rely on BLOB storage like image
       *manipulation, seeking into complex types in BLOBs, and
       *more types will be added 
       * </pre>
       *
       * <code>optional uint32 content_type = 12;</code>
       * @return Whether the contentType field is set.
       */
      @java.lang.Override
      public boolean hasContentType() {
        return ((bitField0_ & 0x00000800) != 0);
      }
      /**
       * <pre>
       ** a hint about the higher-level encoding of a BYTES field
       *| Type   | Value  | Description             |
       *|--------|--------|-------------------------|
       *| BYTES  | 0x0001 | GEOMETRY (WKB encoding) |
       *| BYTES  | 0x0002 | JSON (text encoding)    |
       *| BYTES  | 0x0003 | XML (text encoding)     |
       *&#64;note
       *This list isn't comprehensive. As a guideline: the field's
       *value is expected to pass a validator check on client
       *and server if this field is set. If the server adds more
       *internal data types that rely on BLOB storage like image
       *manipulation, seeking into complex types in BLOBs, and
       *more types will be added 
       * </pre>
       *
       * <code>optional uint32 content_type = 12;</code>
       * @return The contentType.
       */
      @java.lang.Override
      public int getContentType() {
        return contentType_;
      }
      /**
       * <pre>
       ** a hint about the higher-level encoding of a BYTES field
       *| Type   | Value  | Description             |
       *|--------|--------|-------------------------|
       *| BYTES  | 0x0001 | GEOMETRY (WKB encoding) |
       *| BYTES  | 0x0002 | JSON (text encoding)    |
       *| BYTES  | 0x0003 | XML (text encoding)     |
       *&#64;note
       *This list isn't comprehensive. As a guideline: the field's
       *value is expected to pass a validator check on client
       *and server if this field is set. If the server adds more
       *internal data types that rely on BLOB storage like image
       *manipulation, seeking into complex types in BLOBs, and
       *more types will be added 
       * </pre>
       *
       * <code>optional uint32 content_type = 12;</code>
       * @param value The contentType to set.
       * @return This builder for chaining.
       */
      public Builder setContentType(int value) {

        contentType_ = value;
        bitField0_ |= 0x00000800;
        onChanged();
        return this;
      }
      /**
       * <pre>
       ** a hint about the higher-level encoding of a BYTES field
       *| Type   | Value  | Description             |
       *|--------|--------|-------------------------|
       *| BYTES  | 0x0001 | GEOMETRY (WKB encoding) |
       *| BYTES  | 0x0002 | JSON (text encoding)    |
       *| BYTES  | 0x0003 | XML (text encoding)     |
       *&#64;note
       *This list isn't comprehensive. As a guideline: the field's
       *value is expected to pass a validator check on client
       *and server if this field is set. If the server adds more
       *internal data types that rely on BLOB storage like image
       *manipulation, seeking into complex types in BLOBs, and
       *more types will be added 
       * </pre>
       *
       * <code>optional uint32 content_type = 12;</code>
       * @return This builder for chaining.
       */
      public Builder clearContentType() {
        bitField0_ = (bitField0_ & ~0x00000800);
        contentType_ = 0;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:Mysqlx.Resultset.ColumnMetaData)
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Resultset.ColumnMetaData)
    private static final com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData();
    }

    public static com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<ColumnMetaData>
        PARSER = new com.google.protobuf.AbstractParser<ColumnMetaData>() {
      @java.lang.Override
      public ColumnMetaData parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<ColumnMetaData> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ColumnMetaData> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface RowOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Resultset.Row)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>repeated bytes field = 1;</code>
     * @return A list containing the field.
     */
    java.util.List<com.google.protobuf.ByteString> getFieldList();
    /**
     * <code>repeated bytes field = 1;</code>
     * @return The count of field.
     */
    int getFieldCount();
    /**
     * <code>repeated bytes field = 1;</code>
     * @param index The index of the element to return.
     * @return The field at the given index.
     */
    com.google.protobuf.ByteString getField(int index);
  }
  /**
   * <pre>
   **
   *Row in a Resultset.
   *
   *A row is represented as a list of fields encoded as byte blobs.
   *Value of each field is encoded as sequence of bytes using
   *encoding appropriate for the type of the value given by
   *``ColumnMetadata``, as specified in the &#64;ref Mysqlx::Resultset::ColumnMetaData
   *description.
   * </pre>
   *
   * Protobuf type {@code Mysqlx.Resultset.Row}
   */
  public static final class Row extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Resultset.Row)
      RowOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Row.newBuilder() to construct.
    private Row(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Row() {
      field_ = emptyList(com.google.protobuf.ByteString.class);
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new Row();
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_Row_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_Row_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxResultset.Row.class, com.mysql.cj.x.protobuf.MysqlxResultset.Row.Builder.class);
    }

    public static final int FIELD_FIELD_NUMBER = 1;
    @SuppressWarnings("serial")
    private com.google.protobuf.Internal.ProtobufList<com.google.protobuf.ByteString> field_ =
        emptyList(com.google.protobuf.ByteString.class);
    /**
     * <code>repeated bytes field = 1;</code>
     * @return A list containing the field.
     */
    @java.lang.Override
    public java.util.List<com.google.protobuf.ByteString>
        getFieldList() {
      return field_;
    }
    /**
     * <code>repeated bytes field = 1;</code>
     * @return The count of field.
     */
    public int getFieldCount() {
      return field_.size();
    }
    /**
     * <code>repeated bytes field = 1;</code>
     * @param index The index of the element to return.
     * @return The field at the given index.
     */
    public com.google.protobuf.ByteString getField(int index) {
      return field_.get(index);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      for (int i = 0; i < field_.size(); i++) {
        output.writeBytes(1, field_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < field_.size(); i++) {
          dataSize += com.google.protobuf.CodedOutputStream
            .computeBytesSizeNoTag(field_.get(i));
        }
        size += dataSize;
        size += 1 * getFieldList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.mysql.cj.x.protobuf.MysqlxResultset.Row)) {
        return super.equals(obj);
      }
      com.mysql.cj.x.protobuf.MysqlxResultset.Row other = (com.mysql.cj.x.protobuf.MysqlxResultset.Row) obj;

      if (!getFieldList()
          .equals(other.getFieldList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getFieldCount() > 0) {
        hash = (37 * hash) + FIELD_FIELD_NUMBER;
        hash = (53 * hash) + getFieldList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.mysql.cj.x.protobuf.MysqlxResultset.Row parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.Row parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.Row parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.Row parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.Row parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.Row parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.Row parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.Row parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static com.mysql.cj.x.protobuf.MysqlxResultset.Row parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static com.mysql.cj.x.protobuf.MysqlxResultset.Row parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.Row parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.Row parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxResultset.Row prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     **
     *Row in a Resultset.
     *
     *A row is represented as a list of fields encoded as byte blobs.
     *Value of each field is encoded as sequence of bytes using
     *encoding appropriate for the type of the value given by
     *``ColumnMetadata``, as specified in the &#64;ref Mysqlx::Resultset::ColumnMetaData
     *description.
     * </pre>
     *
     * Protobuf type {@code Mysqlx.Resultset.Row}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Resultset.Row)
        com.mysql.cj.x.protobuf.MysqlxResultset.RowOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_Row_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_Row_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxResultset.Row.class, com.mysql.cj.x.protobuf.MysqlxResultset.Row.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxResultset.Row.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        field_ = emptyList(com.google.protobuf.ByteString.class);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_Row_descriptor;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxResultset.Row getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxResultset.Row.getDefaultInstance();
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxResultset.Row build() {
        com.mysql.cj.x.protobuf.MysqlxResultset.Row result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxResultset.Row buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxResultset.Row result = new com.mysql.cj.x.protobuf.MysqlxResultset.Row(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.mysql.cj.x.protobuf.MysqlxResultset.Row result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          field_.makeImmutable();
          result.field_ = field_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxResultset.Row) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxResultset.Row)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxResultset.Row other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxResultset.Row.getDefaultInstance()) return this;
        if (!other.field_.isEmpty()) {
          if (field_.isEmpty()) {
            field_ = other.field_;
            field_.makeImmutable();
            bitField0_ |= 0x00000001;
          } else {
            ensureFieldIsMutable();
            field_.addAll(other.field_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                com.google.protobuf.ByteString v = input.readBytes();
                ensureFieldIsMutable();
                field_.add(v);
                break;
              } // case 10
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private com.google.protobuf.Internal.ProtobufList<com.google.protobuf.ByteString> field_ = emptyList(com.google.protobuf.ByteString.class);
      private void ensureFieldIsMutable() {
        if (!field_.isModifiable()) {
          field_ = makeMutableCopy(field_);
        }
        bitField0_ |= 0x00000001;
      }
      /**
       * <code>repeated bytes field = 1;</code>
       * @return A list containing the field.
       */
      public java.util.List<com.google.protobuf.ByteString>
          getFieldList() {
        field_.makeImmutable();
        return field_;
      }
      /**
       * <code>repeated bytes field = 1;</code>
       * @return The count of field.
       */
      public int getFieldCount() {
        return field_.size();
      }
      /**
       * <code>repeated bytes field = 1;</code>
       * @param index The index of the element to return.
       * @return The field at the given index.
       */
      public com.google.protobuf.ByteString getField(int index) {
        return field_.get(index);
      }
      /**
       * <code>repeated bytes field = 1;</code>
       * @param index The index to set the value at.
       * @param value The field to set.
       * @return This builder for chaining.
       */
      public Builder setField(
          int index, com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        ensureFieldIsMutable();
        field_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>repeated bytes field = 1;</code>
       * @param value The field to add.
       * @return This builder for chaining.
       */
      public Builder addField(com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        ensureFieldIsMutable();
        field_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>repeated bytes field = 1;</code>
       * @param values The field to add.
       * @return This builder for chaining.
       */
      public Builder addAllField(
          java.lang.Iterable<? extends com.google.protobuf.ByteString> values) {
        ensureFieldIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, field_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>repeated bytes field = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearField() {
        field_ = emptyList(com.google.protobuf.ByteString.class);
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:Mysqlx.Resultset.Row)
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Resultset.Row)
    private static final com.mysql.cj.x.protobuf.MysqlxResultset.Row DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.mysql.cj.x.protobuf.MysqlxResultset.Row();
    }

    public static com.mysql.cj.x.protobuf.MysqlxResultset.Row getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<Row>
        PARSER = new com.google.protobuf.AbstractParser<Row>() {
      @java.lang.Override
      public Row parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<Row> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Row> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxResultset.Row getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Resultset_FetchDoneMoreOutParams_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_Mysqlx_Resultset_FetchDoneMoreOutParams_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Resultset_FetchDoneMoreResultsets_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_Mysqlx_Resultset_FetchDoneMoreResultsets_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Resultset_FetchDone_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_Mysqlx_Resultset_FetchDone_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Resultset_FetchSuspended_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_Mysqlx_Resultset_FetchSuspended_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Resultset_ColumnMetaData_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_Mysqlx_Resultset_ColumnMetaData_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Resultset_Row_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_Mysqlx_Resultset_Row_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static  com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\026mysqlx_resultset.proto\022\020Mysqlx.Results" +
      "et\032\014mysqlx.proto\"\036\n\026FetchDoneMoreOutPara" +
      "ms:\004\220\3520\022\"\037\n\027FetchDoneMoreResultsets:\004\220\3520" +
      "\020\"\021\n\tFetchDone:\004\220\3520\016\"\026\n\016FetchSuspended:\004" +
      "\220\3520\017\"\245\003\n\016ColumnMetaData\0228\n\004type\030\001 \002(\0162*." +
      "Mysqlx.Resultset.ColumnMetaData.FieldTyp" +
      "e\022\014\n\004name\030\002 \001(\014\022\025\n\roriginal_name\030\003 \001(\014\022\r" +
      "\n\005table\030\004 \001(\014\022\026\n\016original_table\030\005 \001(\014\022\016\n" +
      "\006schema\030\006 \001(\014\022\017\n\007catalog\030\007 \001(\014\022\021\n\tcollat" +
      "ion\030\010 \001(\004\022\031\n\021fractional_digits\030\t \001(\r\022\016\n\006" +
      "length\030\n \001(\r\022\r\n\005flags\030\013 \001(\r\022\024\n\014content_t" +
      "ype\030\014 \001(\r\"\202\001\n\tFieldType\022\010\n\004SINT\020\001\022\010\n\004UIN" +
      "T\020\002\022\n\n\006DOUBLE\020\005\022\t\n\005FLOAT\020\006\022\t\n\005BYTES\020\007\022\010\n" +
      "\004TIME\020\n\022\014\n\010DATETIME\020\014\022\007\n\003SET\020\017\022\010\n\004ENUM\020\020" +
      "\022\007\n\003BIT\020\021\022\013\n\007DECIMAL\020\022:\004\220\3520\014\"\032\n\003Row\022\r\n\005f" +
      "ield\030\001 \003(\014:\004\220\3520\r*4\n\021ContentType_BYTES\022\014\n" +
      "\010GEOMETRY\020\001\022\010\n\004JSON\020\002\022\007\n\003XML\020\003*.\n\024Conten" +
      "tType_DATETIME\022\010\n\004DATE\020\001\022\014\n\010DATETIME\020\002B\031" +
      "\n\027com.mysql.cj.x.protobuf"
    };
    descriptor = com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          com.mysql.cj.x.protobuf.Mysqlx.getDescriptor(),
        });
    internal_static_Mysqlx_Resultset_FetchDoneMoreOutParams_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_Mysqlx_Resultset_FetchDoneMoreOutParams_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_Mysqlx_Resultset_FetchDoneMoreOutParams_descriptor,
        new java.lang.String[] { });
    internal_static_Mysqlx_Resultset_FetchDoneMoreResultsets_descriptor =
      getDescriptor().getMessageTypes().get(1);
    internal_static_Mysqlx_Resultset_FetchDoneMoreResultsets_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_Mysqlx_Resultset_FetchDoneMoreResultsets_descriptor,
        new java.lang.String[] { });
    internal_static_Mysqlx_Resultset_FetchDone_descriptor =
      getDescriptor().getMessageTypes().get(2);
    internal_static_Mysqlx_Resultset_FetchDone_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_Mysqlx_Resultset_FetchDone_descriptor,
        new java.lang.String[] { });
    internal_static_Mysqlx_Resultset_FetchSuspended_descriptor =
      getDescriptor().getMessageTypes().get(3);
    internal_static_Mysqlx_Resultset_FetchSuspended_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_Mysqlx_Resultset_FetchSuspended_descriptor,
        new java.lang.String[] { });
    internal_static_Mysqlx_Resultset_ColumnMetaData_descriptor =
      getDescriptor().getMessageTypes().get(4);
    internal_static_Mysqlx_Resultset_ColumnMetaData_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_Mysqlx_Resultset_ColumnMetaData_descriptor,
        new java.lang.String[] { "Type", "Name", "OriginalName", "Table", "OriginalTable", "Schema", "Catalog", "Collation", "FractionalDigits", "Length", "Flags", "ContentType", });
    internal_static_Mysqlx_Resultset_Row_descriptor =
      getDescriptor().getMessageTypes().get(5);
    internal_static_Mysqlx_Resultset_Row_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_Mysqlx_Resultset_Row_descriptor,
        new java.lang.String[] { "Field", });
    com.google.protobuf.ExtensionRegistry registry =
        com.google.protobuf.ExtensionRegistry.newInstance();
    registry.add(com.mysql.cj.x.protobuf.Mysqlx.serverMessageId);
    com.google.protobuf.Descriptors.FileDescriptor
        .internalUpdateFileDescriptor(descriptor, registry);
    com.mysql.cj.x.protobuf.Mysqlx.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
