/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared.transport.jersey3;

import com.netflix.discovery.converters.wrappers.CodecWrappers;
import com.netflix.discovery.converters.wrappers.DecoderWrapper;
import com.netflix.discovery.converters.wrappers.EncoderWrapper;
import com.netflix.discovery.provider.DiscoveryJerseyProvider;
import com.netflix.discovery.shared.transport.jersey3.EurekaJersey3Client;
import com.netflix.discovery.util.DiscoveryBuildInfo;
import com.netflix.discovery.util.SpectatorUtil;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Timer;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.core.Configuration;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EurekaJersey3ClientImpl
implements EurekaJersey3Client {
    private static final Logger s_logger = LoggerFactory.getLogger(EurekaJersey3ClientImpl.class);
    private static final int HTTP_CONNECTION_CLEANER_INTERVAL_MS = 30000;
    private static final String PROTOCOL = "https";
    private static final String PROTOCOL_SCHEME = "SSL";
    private static final String KEYSTORE_TYPE = "JKS";
    private final Client jerseyClient;
    private final ConnectionCleanerTask connectionCleanerTask;
    ClientConfig jerseyClientConfig;
    private final ScheduledExecutorService eurekaConnCleaner = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){
        private final AtomicInteger threadNumber = new AtomicInteger(1);

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "Eureka-Jersey3Client-Conn-Cleaner" + this.threadNumber.incrementAndGet());
            thread.setDaemon(true);
            return thread;
        }
    });

    public EurekaJersey3ClientImpl(int connectionTimeout, int readTimeout, int connectionIdleTimeout, ClientConfig clientConfig) {
        try {
            this.jerseyClientConfig = clientConfig;
            this.jerseyClientConfig.register(DiscoveryJerseyProvider.class);
            this.jerseyClientConfig.property("jersey.config.client.disableJsonProcessing", (Object)Boolean.TRUE);
            this.jerseyClientConfig.property("jersey.config.client.disableMoxyJson", (Object)Boolean.TRUE);
            this.jerseyClientConfig.connectorProvider((ConnectorProvider)new ApacheConnectorProvider());
            this.jerseyClientConfig.property("jersey.config.client.connectTimeout", (Object)connectionTimeout);
            this.jerseyClientConfig.property("jersey.config.client.readTimeout", (Object)readTimeout);
            this.jerseyClient = ClientBuilder.newClient((Configuration)this.jerseyClientConfig);
            this.connectionCleanerTask = new ConnectionCleanerTask(connectionIdleTimeout);
            this.eurekaConnCleaner.scheduleWithFixedDelay(this.connectionCleanerTask, 30000L, 30000L, TimeUnit.MILLISECONDS);
        }
        catch (Throwable e) {
            throw new RuntimeException("Cannot create Jersey3 client", e);
        }
    }

    @Override
    public Client getClient() {
        return this.jerseyClient;
    }

    @Override
    public void destroyResources() {
        if (this.eurekaConnCleaner != null) {
            this.eurekaConnCleaner.execute(this.connectionCleanerTask);
            this.eurekaConnCleaner.shutdown();
        }
        if (this.jerseyClient != null) {
            this.jerseyClient.close();
        }
    }

    private class ConnectionCleanerTask
    implements Runnable {
        private final int connectionIdleTimeout;
        private final Timer executionTimeStats;
        private final Counter cleanupFailed;

        private ConnectionCleanerTask(int connectionIdleTimeout) {
            this.connectionIdleTimeout = connectionIdleTimeout;
            this.executionTimeStats = SpectatorUtil.timer((String)"Eureka-Connection-Cleaner-Time", null, ConnectionCleanerTask.class);
            this.cleanupFailed = SpectatorUtil.counter((String)"Eureka-Connection-Cleaner-Failure", null, ConnectionCleanerTask.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long monotonicTime = SpectatorUtil.time((Timer)this.executionTimeStats);
            try {
                HttpClientConnectionManager cm = (HttpClientConnectionManager)EurekaJersey3ClientImpl.this.jerseyClient.getConfiguration().getProperty("jersey.config.apache.client.connectionManager");
                cm.closeIdleConnections((long)this.connectionIdleTimeout, TimeUnit.SECONDS);
            }
            catch (Throwable e) {
                s_logger.error("Cannot clean connections", e);
                this.cleanupFailed.increment();
            }
            finally {
                SpectatorUtil.record((Timer)this.executionTimeStats, (long)monotonicTime);
            }
        }
    }

    public static class EurekaJersey3ClientBuilder {
        private boolean systemSSL;
        private String clientName;
        private int maxConnectionsPerHost;
        private int maxTotalConnections;
        private String trustStoreFileName;
        private String trustStorePassword;
        private String userAgent;
        private String proxyUserName;
        private String proxyPassword;
        private String proxyHost;
        private String proxyPort;
        private int connectionTimeout;
        private int readTimeout;
        private int connectionIdleTimeout;
        private EncoderWrapper encoderWrapper;
        private DecoderWrapper decoderWrapper;

        public EurekaJersey3ClientBuilder withClientName(String clientName) {
            this.clientName = clientName;
            return this;
        }

        public EurekaJersey3ClientBuilder withUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public EurekaJersey3ClientBuilder withConnectionTimeout(int connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public EurekaJersey3ClientBuilder withReadTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public EurekaJersey3ClientBuilder withConnectionIdleTimeout(int connectionIdleTimeout) {
            this.connectionIdleTimeout = connectionIdleTimeout;
            return this;
        }

        public EurekaJersey3ClientBuilder withMaxConnectionsPerHost(int maxConnectionsPerHost) {
            this.maxConnectionsPerHost = maxConnectionsPerHost;
            return this;
        }

        public EurekaJersey3ClientBuilder withMaxTotalConnections(int maxTotalConnections) {
            this.maxTotalConnections = maxTotalConnections;
            return this;
        }

        public EurekaJersey3ClientBuilder withProxy(String proxyHost, String proxyPort, String user, String password) {
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
            this.proxyUserName = user;
            this.proxyPassword = password;
            return this;
        }

        public EurekaJersey3ClientBuilder withSystemSSLConfiguration() {
            this.systemSSL = true;
            return this;
        }

        public EurekaJersey3ClientBuilder withTrustStoreFile(String trustStoreFileName, String trustStorePassword) {
            this.trustStoreFileName = trustStoreFileName;
            this.trustStorePassword = trustStorePassword;
            return this;
        }

        public EurekaJersey3ClientBuilder withEncoder(String encoderName) {
            return this.withEncoderWrapper(CodecWrappers.getEncoder((String)encoderName));
        }

        public EurekaJersey3ClientBuilder withEncoderWrapper(EncoderWrapper encoderWrapper) {
            this.encoderWrapper = encoderWrapper;
            return this;
        }

        public EurekaJersey3ClientBuilder withDecoder(String decoderName, String clientDataAccept) {
            return this.withDecoderWrapper(CodecWrappers.resolveDecoder((String)decoderName, (String)clientDataAccept));
        }

        public EurekaJersey3ClientBuilder withDecoderWrapper(DecoderWrapper decoderWrapper) {
            this.decoderWrapper = decoderWrapper;
            return this;
        }

        public EurekaJersey3Client build() {
            MyDefaultApacheHttpClient4Config config = new MyDefaultApacheHttpClient4Config();
            try {
                return new EurekaJersey3ClientImpl(this.connectionTimeout, this.readTimeout, this.connectionIdleTimeout, config);
            }
            catch (Throwable e) {
                throw new RuntimeException("Cannot create Jersey client ", e);
            }
        }

        class MyDefaultApacheHttpClient4Config
        extends ClientConfig {
            MyDefaultApacheHttpClient4Config() {
                PoolingHttpClientConnectionManager cm = EurekaJersey3ClientBuilder.this.systemSSL ? this.createSystemSslCM() : (EurekaJersey3ClientBuilder.this.trustStoreFileName != null && !EurekaJersey3ClientBuilder.this.trustStoreFileName.trim().isEmpty() ? this.createCustomSslCM() : new PoolingHttpClientConnectionManager());
                if (EurekaJersey3ClientBuilder.this.proxyHost != null) {
                    this.addProxyConfiguration();
                }
                DiscoveryJerseyProvider discoveryJerseyProvider = new DiscoveryJerseyProvider(EurekaJersey3ClientBuilder.this.encoderWrapper, EurekaJersey3ClientBuilder.this.decoderWrapper);
                this.register(discoveryJerseyProvider);
                cm.setDefaultMaxPerRoute(EurekaJersey3ClientBuilder.this.maxConnectionsPerHost);
                cm.setMaxTotal(EurekaJersey3ClientBuilder.this.maxTotalConnections);
                this.property("jersey.config.apache.client.connectionManager", cm);
                String fullUserAgentName = (EurekaJersey3ClientBuilder.this.userAgent == null ? EurekaJersey3ClientBuilder.this.clientName : EurekaJersey3ClientBuilder.this.userAgent) + "/v" + DiscoveryBuildInfo.buildVersion();
                this.property("http.useragent", fullUserAgentName);
                this.property("jersey.config.client.followRedirects", Boolean.FALSE);
                this.property("http.protocol.handle-redirects", Boolean.FALSE);
            }

            private void addProxyConfiguration() {
                if (EurekaJersey3ClientBuilder.this.proxyUserName != null && EurekaJersey3ClientBuilder.this.proxyPassword != null) {
                    this.property("jersey.config.client.proxy.username", EurekaJersey3ClientBuilder.this.proxyUserName);
                    this.property("jersey.config.client.proxy.password", EurekaJersey3ClientBuilder.this.proxyPassword);
                } else {
                    this.property("jersey.config.client.proxy.username", "guest");
                    this.property("jersey.config.client.proxy.password", "guest");
                }
                this.property("jersey.config.client.proxy.uri", "http://" + EurekaJersey3ClientBuilder.this.proxyHost + ":" + EurekaJersey3ClientBuilder.this.proxyPort);
            }

            private PoolingHttpClientConnectionManager createSystemSslCM() {
                SSLConnectionSocketFactory socketFactory = SSLConnectionSocketFactory.getSystemSocketFactory();
                Registry registry = RegistryBuilder.create().register(EurekaJersey3ClientImpl.PROTOCOL, (Object)socketFactory).build();
                return new PoolingHttpClientConnectionManager(registry);
            }

            private PoolingHttpClientConnectionManager createCustomSslCM() {
                FileInputStream fin = null;
                try {
                    SSLContext sslContext = SSLContext.getInstance(EurekaJersey3ClientImpl.PROTOCOL_SCHEME);
                    KeyStore sslKeyStore = KeyStore.getInstance(EurekaJersey3ClientImpl.KEYSTORE_TYPE);
                    fin = new FileInputStream(EurekaJersey3ClientBuilder.this.trustStoreFileName);
                    sslKeyStore.load(fin, EurekaJersey3ClientBuilder.this.trustStorePassword.toCharArray());
                    TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    factory.init(sslKeyStore);
                    TrustManager[] trustManagers = factory.getTrustManagers();
                    sslContext.init(null, trustManagers, null);
                    SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(sslContext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
                    Registry registry = RegistryBuilder.create().register(EurekaJersey3ClientImpl.PROTOCOL, (Object)socketFactory).build();
                    PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = new PoolingHttpClientConnectionManager(registry);
                    return poolingHttpClientConnectionManager;
                }
                catch (Exception ex) {
                    throw new IllegalStateException("SSL configuration issue", ex);
                }
                finally {
                    if (fin != null) {
                        try {
                            fin.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
    }
}

