/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.mvc;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.netflix.graphql.dgs.internal.DgsSchemaProvider;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.schema.GraphQLSchema;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/netflix/graphql/dgs/mvc/DgsRestSchemaJsonController;", "", "schemaProvider", "Lcom/netflix/graphql/dgs/internal/DgsSchemaProvider;", "(Lcom/netflix/graphql/dgs/internal/DgsSchemaProvider;)V", "schema", "", "graphql-dgs-spring-webmvc"})
public class DgsRestSchemaJsonController {
    private final DgsSchemaProvider schemaProvider;

    @RequestMapping(value={"#{@'dgs.graphql-com.netflix.graphql.dgs.webmvc.autoconfigure.DgsWebMvcConfigurationProperties'.schemaJson.path}"}, produces={"application/json"})
    @NotNull
    public final String schema() {
        ObjectMapper mapper = ExtensionsKt.jacksonObjectMapper();
        GraphQLSchema graphQLSchema = DgsSchemaProvider.schema$default((DgsSchemaProvider)this.schemaProvider, null, (int)1, null);
        GraphQL graphQL = GraphQL.newGraphQL((GraphQLSchema)graphQLSchema).build();
        ExecutionInput executionInput = ExecutionInput.newExecutionInput().query("\n  query IntrospectionQuery {\n    __schema {\n      queryType { name }\n      mutationType { name }\n      subscriptionType { name }\n      types {\n        ...FullType\n      }\n      directives {\n        name\n        description\n        locations\n        args {\n          ...InputValue\n        }\n        isRepeatable\n      }\n    }\n  }\n\n  fragment FullType on __Type {\n    kind\n    name\n    description\n    fields(includeDeprecated: true) {\n      name\n      description\n      args {\n        ...InputValue\n      }\n      type {\n        ...TypeRef\n      }\n      isDeprecated\n      deprecationReason\n    }\n    inputFields {\n      ...InputValue\n    }\n    interfaces {\n      ...TypeRef\n    }\n    enumValues(includeDeprecated: true) {\n      name\n      description\n      isDeprecated\n      deprecationReason\n    }\n    possibleTypes {\n      ...TypeRef\n    }\n  }\n\n  fragment InputValue on __InputValue {\n    name\n    description\n    type { ...TypeRef }\n    defaultValue\n  }\n\nfragment TypeRef on __Type {\n    kind\n    name\n    ofType {\n      kind\n      name\n      ofType {\n        kind\n        name\n        ofType {\n          kind\n          name\n          ofType {\n            kind\n            name\n            ofType {\n              kind\n              name\n              ofType {\n                kind\n                name\n                ofType {\n                  kind\n                  name\n                }\n              }\n            }\n          }\n        }\n      }\n    }\n  }\n\n").build();
        Intrinsics.checkNotNullExpressionValue((Object)executionInput, (String)"ExecutionInput.newExecut\u2026ERY)\n            .build()");
        ExecutionInput executionInput2 = executionInput;
        ExecutionResult executionResult2 = graphQL.execute(executionInput2);
        Intrinsics.checkNotNullExpressionValue((Object)executionResult2, (String)"graphQL.execute(executionInput)");
        ExecutionResult execute = executionResult2;
        String string = mapper.writeValueAsString((Object)execute.toSpecification());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mapper.writeValueAsStrin\u2026xecute.toSpecification())");
        return string;
    }

    public DgsRestSchemaJsonController(@NotNull DgsSchemaProvider schemaProvider) {
        Intrinsics.checkNotNullParameter((Object)schemaProvider, (String)"schemaProvider");
        this.schemaProvider = schemaProvider;
    }
}

