/*
 * Decompiled with CFR 0.152.
 */
package iep.com.netflix.iep.http;

import iep.com.netflix.iep.http.NetflixJsonObjectDecoder;
import iep.com.netflix.iep.http.ServerSentEvent;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.LineBasedFrameDecoder;
import io.netty.handler.codec.compression.JdkZlibDecoder;
import io.netty.handler.codec.compression.JdkZlibEncoder;
import io.netty.handler.codec.compression.ZlibWrapper;
import java.io.UnsupportedEncodingException;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Func1;
import rx.functions.Func2;

public final class ByteBufs {
    private ByteBufs() {
    }

    private static Observable<ByteBuf> encode(final Observable<ByteBuf> observable, final EmbeddedChannel embeddedChannel) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<ByteBuf>(){

            public void call(Subscriber<? super ByteBuf> subscriber) {
                observable.subscribe((Subscriber)new EncoderSubscriber(subscriber, embeddedChannel));
            }
        });
    }

    private static <T> Observable<T> decode(final Observable<ByteBuf> observable, final EmbeddedChannel embeddedChannel) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<T>(){

            public void call(Subscriber<? super T> subscriber) {
                observable.subscribe(new DecoderSubscriber(subscriber, embeddedChannel));
            }
        });
    }

    public static Observable.Transformer<ByteBuf, ByteBuf> gzip() {
        return observable -> ByteBufs.encode((Observable<ByteBuf>)observable, new EmbeddedChannel(new ChannelHandler[]{new JdkZlibEncoder(ZlibWrapper.GZIP)}));
    }

    public static Observable.Transformer<ByteBuf, ByteBuf> gunzip() {
        return observable -> ByteBufs.decode((Observable<ByteBuf>)observable, new EmbeddedChannel(new ChannelHandler[]{new JdkZlibDecoder(ZlibWrapper.GZIP)}));
    }

    public static Observable.Transformer<ByteBuf, ByteBuf> json() {
        return ByteBufs.json(0x100000);
    }

    public static Observable.Transformer<ByteBuf, ByteBuf> json(int n) {
        return observable -> ByteBufs.decode(ByteBufs.autoReleaseCopy((Observable<ByteBuf>)observable), new EmbeddedChannel(new ChannelHandler[]{new NetflixJsonObjectDecoder(n, true)}));
    }

    public static Observable<ByteBuf> autoReleaseCopy(Observable<ByteBuf> observable) {
        return observable.map(byteBuf -> {
            ByteBuf byteBuf2 = ByteBufAllocator.DEFAULT.buffer(byteBuf.readableBytes());
            byteBuf2.writeBytes(byteBuf);
            return byteBuf2;
        });
    }

    public static Observable.Transformer<ByteBuf, ByteBuf> lines(int n) {
        return observable -> {
            LineBasedFrameDecoder lineBasedFrameDecoder = new LineBasedFrameDecoder(n, true, true);
            return ByteBufs.decode((Observable<ByteBuf>)observable, new EmbeddedChannel(new ChannelHandler[]{lineBasedFrameDecoder}));
        };
    }

    public static Observable.Transformer<ByteBuf, ServerSentEvent> sse(int n) {
        return observable -> observable.compose(ByteBufs.lines(n)).map(ServerSentEvent::parse).filter(serverSentEvent -> serverSentEvent != null);
    }

    public static Func1<ByteBuf, byte[]> toByteArray() {
        return byteBuf -> {
            byte[] byArray = new byte[byteBuf.readableBytes()];
            byteBuf.readBytes(byArray, 0, byteBuf.readableBytes());
            return byArray;
        };
    }

    private static Func2<CompositeByteBuf, ByteBuf, CompositeByteBuf> append() {
        return (compositeByteBuf, byteBuf) -> {
            compositeByteBuf.addComponent(byteBuf);
            compositeByteBuf.writerIndex(compositeByteBuf.writerIndex() + byteBuf.readableBytes());
            return compositeByteBuf;
        };
    }

    public static Observable.Transformer<ByteBuf, byte[]> aggrByteArray() {
        return observable -> observable.reduce((Object)Unpooled.compositeBuffer(), ByteBufs.append()).map(ByteBufs.toByteArray());
    }

    private static String newString(byte[] byArray, String string) {
        try {
            return new String(byArray, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(unsupportedEncodingException);
        }
    }

    public static Observable.Transformer<ByteBuf, String> toString(String string) {
        return observable -> observable.compose(ByteBufs.aggrByteArray()).map(byArray -> ByteBufs.newString(byArray, string));
    }

    private static class DecoderSubscriber<T>
    extends Subscriber<ByteBuf> {
        private final Subscriber<? super T> consumer;
        private final EmbeddedChannel channel;

        public DecoderSubscriber(Subscriber<? super T> subscriber, EmbeddedChannel embeddedChannel) {
            this.consumer = subscriber;
            this.channel = embeddedChannel;
        }

        public void onNext(ByteBuf byteBuf) {
            Object object;
            this.channel.writeInbound(new Object[]{byteBuf});
            while ((object = this.channel.readInbound()) != null) {
                this.consumer.onNext(object);
            }
        }

        public void onCompleted() {
            Object object;
            this.channel.finish();
            while ((object = this.channel.readInbound()) != null) {
                this.consumer.onNext(object);
            }
            this.consumer.onCompleted();
        }

        public void onError(Throwable throwable) {
            this.consumer.onError(throwable);
        }
    }

    private static class EncoderSubscriber
    extends Subscriber<ByteBuf> {
        private final Subscriber<? super ByteBuf> consumer;
        private final EmbeddedChannel channel;

        public EncoderSubscriber(Subscriber<? super ByteBuf> subscriber, EmbeddedChannel embeddedChannel) {
            this.consumer = subscriber;
            this.channel = embeddedChannel;
        }

        public void onNext(ByteBuf byteBuf) {
            ByteBuf byteBuf2;
            this.channel.writeOutbound(new Object[]{byteBuf});
            while ((byteBuf2 = (ByteBuf)this.channel.readOutbound()) != null) {
                this.consumer.onNext((Object)byteBuf2);
            }
        }

        public void onCompleted() {
            ByteBuf byteBuf;
            this.channel.finish();
            while ((byteBuf = (ByteBuf)this.channel.readOutbound()) != null) {
                this.consumer.onNext((Object)byteBuf);
            }
            this.consumer.onCompleted();
        }

        public void onError(Throwable throwable) {
            this.consumer.onError(throwable);
        }
    }
}

