/*
 * Decompiled with CFR 0.152.
 */
package iep.com.netflix.iep.http;

import com.netflix.archaius.api.Config;
import com.netflix.spectator.impl.Preconditions;
import com.netflix.spectator.sandbox.HttpLogEntry;
import iep.com.netflix.iep.http.ClientConfig;
import iep.com.netflix.iep.http.ErrorRetryHandler;
import iep.com.netflix.iep.http.RedirectHandler;
import iep.com.netflix.iep.http.RequestContext;
import iep.com.netflix.iep.http.Server;
import iep.com.netflix.iep.http.ServerRegistry;
import iep.com.netflix.iep.http.StatusRetryHandler;
import iep.io.reactivex.netty.RxNetty;
import iep.io.reactivex.netty.client.CompositePoolLimitDeterminationStrategy;
import iep.io.reactivex.netty.client.MaxConnectionsBasedStrategy;
import iep.io.reactivex.netty.client.PoolLimitDeterminationStrategy;
import iep.io.reactivex.netty.client.PooledConnectionReleasedEvent;
import iep.io.reactivex.netty.client.RxClient;
import iep.io.reactivex.netty.pipeline.PipelineConfigurator;
import iep.io.reactivex.netty.pipeline.PipelineConfiguratorComposite;
import iep.io.reactivex.netty.pipeline.ssl.DefaultFactories;
import iep.io.reactivex.netty.protocol.http.client.ClientRequestResponseConverter;
import iep.io.reactivex.netty.protocol.http.client.HttpClient;
import iep.io.reactivex.netty.protocol.http.client.HttpClientBuilder;
import iep.io.reactivex.netty.protocol.http.client.HttpClientPipelineConfigurator;
import iep.io.reactivex.netty.protocol.http.client.HttpClientRequest;
import iep.io.reactivex.netty.protocol.http.client.HttpClientResponse;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.timeout.ReadTimeoutException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPOutputStream;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.functions.Action0;
import rx.functions.Actions;
import rx.functions.Func1;

@Singleton
public final class RxHttp {
    private static final Logger LOGGER = LoggerFactory.getLogger(RxHttp.class);
    private static final String APPLICATION_JSON = "application/json";
    private static final int MIN_COMPRESS_SIZE = 512;
    private static final AtomicInteger NEXT_THREAD_ID = new AtomicInteger(0);
    private final ConcurrentHashMap<String, PoolLimitDeterminationStrategy> poolLimits = new ConcurrentHashMap();
    private final ConcurrentHashMap<Server, HttpClient<ByteBuf, ByteBuf>> clients = new ConcurrentHashMap();
    private ScheduledExecutorService executor;
    private final Config config;
    private final ServerRegistry serverRegistry;

    @Inject
    public RxHttp(Config config, ServerRegistry serverRegistry) {
        this.config = config;
        this.serverRegistry = serverRegistry;
    }

    @PostConstruct
    public void start() {
        LOGGER.info("starting up backround cleanup threads");
        this.executor = Executors.newSingleThreadScheduledExecutor(runnable -> {
            Thread thread = new Thread(runnable, "spectator-rxhttp-" + NEXT_THREAD_ID.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        });
        Runnable runnable2 = () -> {
            try {
                LOGGER.debug("executing cleanup for {} clients", (Object)this.clients.size());
                for (Map.Entry<Server, HttpClient<ByteBuf, ByteBuf>> entry : this.clients.entrySet()) {
                    Server server = entry.getKey();
                    if (!server.isRegistered() || this.serverRegistry.isStillAvailable(server)) continue;
                    LOGGER.debug("cleaning up client for {}", (Object)server);
                    this.clients.remove(server);
                    entry.getValue().shutdown();
                }
                LOGGER.debug("cleanup complete with {} clients remaining", (Object)this.clients.size());
            }
            catch (Exception exception) {
                LOGGER.warn("connection cleanup task failed", (Throwable)exception);
            }
        };
        long l = this.config.getLong("netflix.iep.http.cleanupFrequency", Long.valueOf(60L));
        this.executor.scheduleWithFixedDelay(runnable2, 0L, l, TimeUnit.SECONDS);
    }

    @PreDestroy
    public void stop() {
        LOGGER.info("shutting down backround cleanup threads");
        this.executor.shutdown();
        this.clients.values().forEach(RxClient::shutdown);
    }

    private static HttpClientRequest<ByteBuf> compress(ClientConfig clientConfig, HttpClientRequest<ByteBuf> httpClientRequest, byte[] byArray) {
        if (byArray.length >= 512 && clientConfig.gzipEnabled()) {
            httpClientRequest.withHeader("Content-Encoding", "gzip");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try (GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);){
                gZIPOutputStream.write(byArray);
            }
            catch (IOException iOException) {
                throw new RuntimeException("failed to gzip request payload", iOException);
            }
            httpClientRequest.withContent(byteArrayOutputStream.toByteArray());
        } else {
            httpClientRequest.withContent(byArray);
        }
        return httpClientRequest;
    }

    public static HttpLogEntry create(HttpClientRequest<ByteBuf> httpClientRequest) {
        HttpLogEntry httpLogEntry = new HttpLogEntry().withMethod(httpClientRequest.getMethod().name()).withRequestUri(URI.create(httpClientRequest.getUri())).withRequestContentLength(httpClientRequest.getHeaders().getContentLength(-1L));
        for (Map.Entry entry : httpClientRequest.getHeaders().entries()) {
            httpLogEntry.withRequestHeader((String)entry.getKey(), (String)entry.getValue());
        }
        return httpLogEntry;
    }

    private static HttpLogEntry create(ClientConfig clientConfig, HttpClientRequest<ByteBuf> httpClientRequest) {
        return RxHttp.create(httpClientRequest).withClientName(clientConfig.name()).withOriginalUri(clientConfig.originalUri()).withMaxAttempts(clientConfig.numRetries() + 1);
    }

    private static void update(HttpLogEntry httpLogEntry, HttpClientResponse<ByteBuf> httpClientResponse) {
        int n = httpClientResponse.getStatus().code();
        boolean bl = n == 429 || n >= 500;
        httpLogEntry.mark("received-response").withStatusCode(n).withStatusReason(httpClientResponse.getStatus().reasonPhrase()).withResponseContentLength(httpClientResponse.getHeaders().getContentLength(-1L)).withCanRetry(bl);
        for (Map.Entry entry : httpClientResponse.getHeaders().entries()) {
            httpLogEntry.withResponseHeader((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private void update(HttpLogEntry httpLogEntry, Throwable throwable) {
        boolean bl = throwable instanceof ConnectException || throwable instanceof ReadTimeoutException;
        httpLogEntry.mark("received-error").withException(throwable).withCanRetry(bl);
    }

    public Observable<HttpClientResponse<ByteBuf>> get(String string) {
        return this.submit((HttpClientRequest<ByteBuf>)HttpClientRequest.createGet((String)string));
    }

    public Observable<HttpClientResponse<ByteBuf>> get(URI uRI) {
        return this.submit((HttpClientRequest<ByteBuf>)HttpClientRequest.createGet((String)uRI.toString()));
    }

    public Observable<HttpClientResponse<ByteBuf>> getJson(String string) {
        return this.getJson(URI.create(string));
    }

    public Observable<HttpClientResponse<ByteBuf>> getJson(URI uRI) {
        HttpClientRequest httpClientRequest = HttpClientRequest.createGet((String)uRI.toString()).withHeader("Accept", APPLICATION_JSON);
        return this.submit((HttpClientRequest<ByteBuf>)httpClientRequest);
    }

    public Observable<HttpClientResponse<ByteBuf>> post(URI uRI, String string, byte[] byArray) {
        HttpClientRequest httpClientRequest = HttpClientRequest.createPost((String)uRI.toString()).withHeader("Content-Type", string);
        return this.submit((HttpClientRequest<ByteBuf>)httpClientRequest, byArray);
    }

    public Observable<HttpClientResponse<ByteBuf>> postJson(URI uRI, byte[] byArray) {
        HttpClientRequest httpClientRequest = HttpClientRequest.createPost((String)uRI.toString()).withHeader("Content-Type", APPLICATION_JSON).withHeader("Accept", APPLICATION_JSON);
        return this.submit((HttpClientRequest<ByteBuf>)httpClientRequest, byArray);
    }

    public Observable<HttpClientResponse<ByteBuf>> postJson(URI uRI, String string) {
        return this.postJson(uRI, RxHttp.getBytes(string));
    }

    public Observable<HttpClientResponse<ByteBuf>> postForm(URI uRI) {
        Preconditions.checkNotNull((Object)uRI.getRawQuery(), (String)"uri.query");
        byte[] byArray = RxHttp.getBytes(uRI.getRawQuery());
        return this.post(uRI, "application/x-www-form-urlencoded", byArray);
    }

    public Observable<HttpClientResponse<ByteBuf>> put(URI uRI, String string, byte[] byArray) {
        HttpClientRequest httpClientRequest = HttpClientRequest.createPut((String)uRI.toString()).withHeader("Content-Type", string);
        return this.submit((HttpClientRequest<ByteBuf>)httpClientRequest, byArray);
    }

    public Observable<HttpClientResponse<ByteBuf>> putJson(URI uRI, byte[] byArray) {
        HttpClientRequest httpClientRequest = HttpClientRequest.createPut((String)uRI.toString()).withHeader("Content-Type", APPLICATION_JSON).withHeader("Accept", APPLICATION_JSON);
        return this.submit((HttpClientRequest<ByteBuf>)httpClientRequest, byArray);
    }

    public Observable<HttpClientResponse<ByteBuf>> putJson(URI uRI, String string) {
        return this.putJson(uRI, RxHttp.getBytes(string));
    }

    public Observable<HttpClientResponse<ByteBuf>> delete(String string) {
        return this.submit((HttpClientRequest<ByteBuf>)HttpClientRequest.createDelete((String)string));
    }

    public Observable<HttpClientResponse<ByteBuf>> delete(URI uRI) {
        return this.submit((HttpClientRequest<ByteBuf>)HttpClientRequest.createDelete((String)uRI.toString()));
    }

    public Observable<HttpClientResponse<ByteBuf>> deleteJson(String string) {
        return this.deleteJson(URI.create(string));
    }

    public Observable<HttpClientResponse<ByteBuf>> deleteJson(URI uRI) {
        HttpClientRequest httpClientRequest = HttpClientRequest.createDelete((String)uRI.toString()).withHeader("Accept", APPLICATION_JSON);
        return this.submit((HttpClientRequest<ByteBuf>)httpClientRequest);
    }

    public Observable<HttpClientResponse<ByteBuf>> submit(HttpClientRequest<ByteBuf> httpClientRequest) {
        return this.submit(httpClientRequest, (byte[])null);
    }

    public Observable<HttpClientResponse<ByteBuf>> submit(HttpClientRequest<ByteBuf> httpClientRequest, String string) {
        return this.submit(httpClientRequest, string == null ? null : RxHttp.getBytes(string));
    }

    public Observable<HttpClientResponse<ByteBuf>> submit(HttpClientRequest<ByteBuf> httpClientRequest, byte[] byArray) {
        URI uRI = URI.create(httpClientRequest.getUri());
        ClientConfig clientConfig = ClientConfig.fromUri(this.config, uRI);
        List<Server> list = this.getServers(clientConfig);
        String string = clientConfig.relativeUri();
        HttpClientRequest<ByteBuf> httpClientRequest2 = RxHttp.copy(httpClientRequest, string);
        HttpClientRequest<ByteBuf> httpClientRequest3 = byArray == null ? httpClientRequest2 : RxHttp.compress(clientConfig, httpClientRequest2, byArray);
        return this.execute(clientConfig, list, httpClientRequest3);
    }

    Observable<HttpClientResponse<ByteBuf>> execute(ClientConfig clientConfig, List<Server> list, HttpClientRequest<ByteBuf> httpClientRequest) {
        HttpLogEntry httpLogEntry = RxHttp.create(clientConfig, httpClientRequest);
        if (list.isEmpty()) {
            String string = "empty server list for client " + clientConfig.name();
            return Observable.error((Throwable)new IllegalStateException(string));
        }
        if (clientConfig.gzipEnabled()) {
            httpClientRequest.withHeader("Accept-Encoding", "gzip");
        }
        RequestContext requestContext = new RequestContext(this, httpLogEntry, httpClientRequest, clientConfig, list.get(0));
        long l = clientConfig.retryDelay();
        Observable observable = this.execute(requestContext).flatMap((Func1)new RedirectHandler(requestContext));
        for (int i = 1; i < list.size(); ++i) {
            RequestContext requestContext2 = requestContext.withServer(list.get(i));
            long l2 = l << i - 1;
            int n = i + 1;
            observable = observable.flatMap((Func1)new RedirectHandler(requestContext2)).flatMap((Func1)new StatusRetryHandler(requestContext2, n, l2)).onErrorResumeNext((Func1)new ErrorRetryHandler(requestContext2, n));
        }
        return observable;
    }

    Observable<HttpClientResponse<ByteBuf>> execute(RequestContext requestContext) {
        HttpLogEntry httpLogEntry = requestContext.entry();
        HttpClient<ByteBuf, ByteBuf> httpClient = this.getClient(requestContext);
        httpLogEntry.mark("start");
        httpLogEntry.withRemoteAddr(requestContext.server().host());
        httpLogEntry.withRemotePort(requestContext.server().port());
        return httpClient.submit(requestContext.request()).doOnNext(httpClientResponse -> {
            RxHttp.update(httpLogEntry, (HttpClientResponse<ByteBuf>)httpClientResponse);
            HttpLogEntry.logClientRequest((HttpLogEntry)httpLogEntry);
        }).doOnError(throwable -> {
            this.update(httpLogEntry, (Throwable)throwable);
            HttpLogEntry.logClientRequest((HttpLogEntry)httpLogEntry);
        }).doOnTerminate((Action0)Actions.empty());
    }

    private HttpClient<ByteBuf, ByteBuf> getClient(RequestContext requestContext) {
        HttpClient<ByteBuf, ByteBuf> httpClient = this.clients.get(requestContext.server());
        if (httpClient == null) {
            httpClient = this.newClient(requestContext);
            HttpClient<ByteBuf, ByteBuf> httpClient2 = this.clients.putIfAbsent(requestContext.server(), httpClient);
            if (httpClient2 != null) {
                httpClient.shutdown();
                httpClient = httpClient2;
            }
        }
        return httpClient;
    }

    private HttpClient<ByteBuf, ByteBuf> newClient(RequestContext requestContext) {
        int n;
        Server server = requestContext.server();
        final ClientConfig clientConfig = requestContext.config();
        HttpClient.HttpClientConfig.Builder builder = ((HttpClient.HttpClientConfig.Builder)new HttpClient.HttpClientConfig.Builder().readTimeout(clientConfig.readTimeout(), TimeUnit.MILLISECONDS)).userAgent(clientConfig.userAgent());
        int n2 = clientConfig.contentSubscribeTimeout();
        if (n2 > 0) {
            builder.responseSubscriptionTimeout((long)n2, TimeUnit.MILLISECONDS);
        }
        HttpClient.HttpClientConfig httpClientConfig = (HttpClient.HttpClientConfig)builder.build();
        PipelineConfiguratorComposite<HttpClientResponse<ByteBuf>, HttpClientRequest<ByteBuf>> pipelineConfiguratorComposite = new PipelineConfiguratorComposite<HttpClientResponse<ByteBuf>, HttpClientRequest<ByteBuf>>(new PipelineConfigurator[]{new HttpClientPipelineConfigurator(), new HttpDecompressionConfigurator()}){

            public void configureNewPipeline(ChannelPipeline channelPipeline) {
                super.configureNewPipeline(channelPipeline);
                int n = clientConfig.connectionActiveLifeAge();
                if (n > 0) {
                    channelPipeline.addLast(new ChannelHandler[]{new ActiveLifeTracker(n)});
                }
            }
        };
        HttpClientBuilder httpClientBuilder = (HttpClientBuilder)((HttpClientBuilder)((HttpClientBuilder)((HttpClientBuilder)RxNetty.newHttpClientBuilder((String)server.host(), (int)server.port()).pipelineConfigurator((PipelineConfigurator)pipelineConfiguratorComposite)).config((RxClient.ClientConfig)httpClientConfig)).withName(clientConfig.name())).channelOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)clientConfig.connectTimeout());
        if (clientConfig.wireLoggingEnabled()) {
            httpClientBuilder.enableWireLogging(clientConfig.wireLoggingLevel());
        }
        if ((n = clientConfig.idleConnectionsTimeoutMillis()) == 0) {
            httpClientBuilder.withNoConnectionPooling();
        } else {
            ((HttpClientBuilder)httpClientBuilder.withConnectionPoolLimitStrategy(this.getPoolLimitStrategy(clientConfig))).withIdleConnectionsTimeoutMillis((long)n);
        }
        if (server.isSecure()) {
            httpClientBuilder.withSslEngineFactory(DefaultFactories.trustAll());
        }
        if (!clientConfig.contentAutoRelease()) {
            httpClientBuilder.disableAutoReleaseBuffers();
        }
        return (HttpClient)httpClientBuilder.build();
    }

    private PoolLimitDeterminationStrategy getPoolLimitStrategy(ClientConfig clientConfig) {
        PoolLimitDeterminationStrategy poolLimitDeterminationStrategy = this.poolLimits.computeIfAbsent(clientConfig.name(), string -> new MaxConnectionsBasedStrategy(clientConfig.maxConnectionsTotal()));
        return new CompositePoolLimitDeterminationStrategy(new PoolLimitDeterminationStrategy[]{new MaxConnectionsBasedStrategy(clientConfig.maxConnectionsPerHost()), poolLimitDeterminationStrategy});
    }

    private List<Server> getServers(ClientConfig clientConfig) {
        List<Server> list = clientConfig.uri().isAbsolute() ? this.getServersForUri(clientConfig, clientConfig.uri()) : this.serverRegistry.getServers(clientConfig.vip(), clientConfig);
        return list;
    }

    private List<Server> getServersForUri(ClientConfig clientConfig, URI uRI) {
        int n = clientConfig.numRetries();
        boolean bl = "https".equals(uRI.getScheme());
        ArrayList<Server> arrayList = new ArrayList<Server>();
        arrayList.add(new Server(uRI.getHost(), RxHttp.getPort(uRI), bl));
        for (int i = 0; i < n; ++i) {
            arrayList.add(new Server(uRI.getHost(), RxHttp.getPort(uRI), bl));
        }
        return arrayList;
    }

    static HttpClientRequest<ByteBuf> copy(HttpClientRequest<ByteBuf> httpClientRequest, String string) {
        HttpClientRequest httpClientRequest2 = HttpClientRequest.create((HttpVersion)httpClientRequest.getHttpVersion(), (HttpMethod)httpClientRequest.getMethod(), (String)string);
        for (Map.Entry entry : httpClientRequest.getHeaders().entries()) {
            httpClientRequest2.withHeader((String)entry.getKey(), (String)entry.getValue());
        }
        return httpClientRequest2;
    }

    private static byte[] getBytes(String string) {
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    static int getPort(URI uRI) {
        int n = "https".equals(uRI.getScheme()) ? 443 : 80;
        return uRI.getPort() <= 0 ? n : uRI.getPort();
    }

    private static class ActiveLifeTracker
    extends ChannelDuplexHandler {
        private final long maxActiveDuration;
        private volatile long activationTime = 0L;

        ActiveLifeTracker(long l) {
            this.maxActiveDuration = l;
        }

        public void channelActive(ChannelHandlerContext channelHandlerContext) throws Exception {
            this.activationTime = System.currentTimeMillis();
            super.channelActive(channelHandlerContext);
        }

        public void userEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
            long l;
            if (object instanceof PooledConnectionReleasedEvent && (l = System.currentTimeMillis() - this.activationTime) > this.maxActiveDuration) {
                channelHandlerContext.channel().attr(ClientRequestResponseConverter.DISCARD_CONNECTION).set((Object)true);
            }
            super.userEventTriggered(channelHandlerContext, object);
        }
    }

    private static class HttpDecompressionConfigurator
    implements PipelineConfigurator<ByteBuf, ByteBuf> {
        private HttpDecompressionConfigurator() {
        }

        public void configureNewPipeline(ChannelPipeline channelPipeline) {
            channelPipeline.addLast("deflater", (ChannelHandler)new HttpContentDecompressor());
        }
    }
}

