/*
 * Decompiled with CFR 0.152.
 */
package iep.com.netflix.iep.http;

import iep.com.netflix.iep.http.RequestContext;
import iep.io.reactivex.netty.protocol.http.client.HttpClientResponse;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.functions.Func1;

class StatusRetryHandler
implements Func1<HttpClientResponse<ByteBuf>, Observable<HttpClientResponse<ByteBuf>>> {
    private final RequestContext context;
    private final int attempt;
    private final long delay;

    StatusRetryHandler(RequestContext requestContext, int n, long l) {
        this.context = requestContext;
        this.attempt = n;
        this.delay = l;
    }

    private static long getRetryDelay(HttpClientResponse<ByteBuf> httpClientResponse, long l) {
        try {
            if (httpClientResponse.getHeaders().contains((CharSequence)HttpHeaderNames.RETRY_AFTER)) {
                int n = httpClientResponse.getHeaders().getIntHeader((CharSequence)HttpHeaderNames.RETRY_AFTER);
                return TimeUnit.MILLISECONDS.convert(n, TimeUnit.SECONDS);
            }
        }
        catch (NumberFormatException numberFormatException) {
            return l;
        }
        return l;
    }

    public Observable<HttpClientResponse<ByteBuf>> call(HttpClientResponse<ByteBuf> httpClientResponse) {
        Observable observable;
        int n = httpClientResponse.getStatus().code();
        if (n == 429 || n == 503) {
            long l = StatusRetryHandler.getRetryDelay(httpClientResponse, this.delay);
            httpClientResponse.getContent().subscribe();
            this.context.entry().withAttempt(this.attempt);
            observable = this.context.rxHttp().execute(this.context);
            if (l > 0L) {
                observable = observable.delaySubscription(l, TimeUnit.MILLISECONDS);
            }
        } else if (n >= 500) {
            httpClientResponse.getContent().subscribe();
            this.context.entry().withAttempt(this.attempt);
            observable = this.context.rxHttp().execute(this.context);
        } else {
            observable = Observable.just(httpClientResponse);
        }
        return observable;
    }
}

