/*
 * Decompiled with CFR 0.152.
 */
package iep.io.reactivex.netty.client;

import iep.io.reactivex.netty.channel.ObservableConnection;
import iep.io.reactivex.netty.client.ClientMetricsEvent;
import iep.io.reactivex.netty.metrics.MetricEventsPublisher;
import java.util.concurrent.TimeUnit;
import rx.Observable;

public interface RxClient<I, O>
extends MetricEventsPublisher<ClientMetricsEvent<?>> {
    public Observable<ObservableConnection<O, I>> connect();

    public void shutdown();

    public String name();

    public static class ServerInfo {
        public static final String DEFAULT_HOST = "localhost";
        public static final int DEFAULT_PORT = 80;
        private final String host;
        private final int port;

        public ServerInfo() {
            this(DEFAULT_HOST, 80);
        }

        public ServerInfo(String host) {
            this(host, 80);
        }

        public ServerInfo(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
            result = 31 * result + this.port;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ServerInfo other = (ServerInfo)obj;
            if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
                return false;
            }
            return this.port == other.port;
        }

        public String toString() {
            return "ServerInfo{host='" + this.host + '\'' + ", port=" + this.port + '}';
        }
    }

    public static class ClientConfig
    implements Cloneable {
        public static final long NO_TIMEOUT = -1L;
        private long readTimeoutInMillis = -1L;

        protected ClientConfig() {
        }

        protected ClientConfig(ClientConfig config) {
            this.readTimeoutInMillis = config.readTimeoutInMillis;
        }

        public long getReadTimeoutInMillis() {
            return this.readTimeoutInMillis;
        }

        void setReadTimeoutInMillis(long readTimeoutInMillis) {
            this.readTimeoutInMillis = readTimeoutInMillis;
        }

        public boolean isReadTimeoutSet() {
            return -1L != this.readTimeoutInMillis;
        }

        public ClientConfig clone() throws CloneNotSupportedException {
            return (ClientConfig)super.clone();
        }

        public static class Builder
        extends AbstractBuilder<Builder, ClientConfig> {
            public Builder(ClientConfig defaultConfig) {
                super(null == defaultConfig ? new ClientConfig() : defaultConfig);
            }

            public Builder() {
                this(null);
            }

            public static ClientConfig newDefaultConfig() {
                return new Builder().build();
            }
        }

        protected static abstract class AbstractBuilder<B extends AbstractBuilder, C extends ClientConfig> {
            protected final C config;

            protected AbstractBuilder(C config) {
                this.config = config;
            }

            public B readTimeout(int timeout, TimeUnit timeUnit) {
                ((ClientConfig)this.config).setReadTimeoutInMillis(TimeUnit.MILLISECONDS.convert(timeout, timeUnit));
                return this.returnBuilder();
            }

            protected B returnBuilder() {
                return (B)this;
            }

            public C build() {
                return this.config;
            }
        }
    }
}

